/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.FramingType;
import cerent.cms.model.circuits.SpanRow;
import cerent.cms.ncp.ISpanProtectionOp;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.SdhAu4LoNum;
import cerent.util.SonetLoNum;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class SpanColumnRenderer
extends AbstractColumnRenderer {
    public static final int STS = 0;
    public static final int VT = 1;
    public static final int VT2 = 2;
    public static final int UPSR = 3;
    public static final int NAME = 4;
    public static final int SPANOP = 5;
    public static final int VC4 = 6;
    public static final int VC3 = 7;
    public static final int TUG2 = 8;
    public static final int VC11_12 = 9;
    public static final int SNCP = 10;
    static final int PER_SPAN = 0;
    int[][] columns = null;
    static final String[] spanOpStrings = EnumStrings.getStrings((Class)ISpanProtectionOp.class);
    private JLabel label;
    private static final String CK_IMG_PATH = "/images/check_blue.gif";
    private final ImageIcon CK_IMG = new ImageIcon(this.getClass().getResource("/images/check_blue.gif"), "true");
    private final JLabel checkedLabel = new JLabel(this.CK_IMG);
    private int mode;
    private static int EBW = 2;
    private static EmptyBorder emptyBorder = new EmptyBorder(0, EBW, 0, EBW);
    private static final SDebug db = new SDebug("SpanColumnRenderer");
    private static final int[] SonetColumns = new int[]{0, 1, 3, 4, 5};
    private static final int[] SdhColumns = new int[]{6, 7, 8, 9, 10, 4, 5};
    private static final int[] SonetColumnsNoUpsr = new int[]{0, 1, 4};
    private static final int[] SdhColumnsNoUpsr = new int[]{6, 7, 8, 9, 4};

    protected SpanColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n3);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.label.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = this.label;
        this.label.setText("");
        SpanRow spanRow = (SpanRow)object;
        if (spanRow == null) {
            return jLabel;
        }
        Color color = jTable.getForeground();
        Color color2 = jTable.getBackground();
        ILoNum iLoNum = null;
        switch (this.mode) {
            case 0: 
            case 6: {
                this.label.setText(this.getHoLabel(spanRow));
                break;
            }
            case 1: {
                this.label.setText(this.getLoLabel(spanRow));
                ILoNum iLoNum2 = iLoNum = spanRow.getFirstLo() != null ? spanRow.getFirstLo() : spanRow.getLastLo();
                if (iLoNum == null) break;
                SonetLoNum sonetLoNum = (SonetLoNum)iLoNum;
                String string = null;
                if (sonetLoNum.isVt1_5Num()) {
                    string = "VT1.5";
                } else if (sonetLoNum.isVt2Num()) {
                    string = "VT2";
                }
                if (string == null) break;
                this.label.setToolTipText(string);
                break;
            }
            case 7: {
                if (spanRow.getFirst().getFramingType() == 2) {
                    this.label.setText(this.getHoLabel(spanRow));
                    break;
                }
                this.label.setText(this.getVc3Label(spanRow));
                break;
            }
            case 8: {
                this.label.setText(this.getTug2Label(spanRow));
                break;
            }
            case 9: {
                this.label.setText(this.getVc11_12Label(spanRow));
                ILoNum iLoNum3 = iLoNum = spanRow.getFirstLo() != null ? spanRow.getFirstLo() : spanRow.getLastLo();
                if (iLoNum == null || iLoNum.getFramingType() != 1) break;
                SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)iLoNum;
                if (this.getTug2Label(spanRow).equals("--")) break;
                String string = null;
                if (sdhAu4LoNum.isVc11Num()) {
                    string = "VC11";
                } else if (sdhAu4LoNum.isVc12Num()) {
                    string = "VC12";
                }
                if (string == null) break;
                this.label.setToolTipText(string);
                break;
            }
            case 3: 
            case 10: {
                if (spanRow.span != null && spanRow.span.isUpsr()) {
                    jLabel = this.checkedLabel;
                    break;
                }
                this.label.setText("");
                break;
            }
            case 4: {
                if (spanRow.getCircuit() != null) {
                    this.label.setText(spanRow.getCircuit().getFullCircuitName());
                    if (spanRow.getSpan() == null) break;
                    if (spanRow.getSpan().active()) {
                        color2 = CircuitColumnRenderer.ACTIVE_BG;
                        color = CircuitColumnRenderer.ACTIVE_FG;
                        break;
                    }
                    color2 = CircuitColumnRenderer.STANDBY_BG;
                    color = CircuitColumnRenderer.STANDBY_FG;
                    break;
                }
                this.label.setText("--unused--");
                break;
            }
            case 5: {
                if (spanRow.getCircuit() != null && spanRow.getSpan() != null && spanRow.getSpan().isUpsr()) {
                    String string = spanOpStrings[spanRow.getSpan().getProtectionOp()];
                    this.label.setText(string);
                    break;
                }
                this.label.setText("");
            }
        }
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    private String getHoLabel(SpanRow spanRow) {
        StringBuffer stringBuffer = new StringBuffer();
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        if (hoLoComparator.compare(spanRow.getFirstHo(), spanRow.getLastHo()) == 0) {
            stringBuffer.append(spanRow.getFirstHo().toString());
        } else {
            stringBuffer.append(spanRow.getFirstHo().toString());
            stringBuffer.append("-");
            stringBuffer.append(spanRow.getLastHo().toString());
        }
        return stringBuffer.toString();
    }

    private String getLoLabel(SpanRow spanRow) {
        StringBuffer stringBuffer = new StringBuffer();
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        if (spanRow.getFirstLo() == null) {
            stringBuffer.append("--");
        } else if (hoLoComparator.compare(spanRow.getFirstLo(), spanRow.getLastLo()) == 0) {
            ILoNum iLoNum = spanRow.getFirstLo();
            stringBuffer.append(iLoNum.groupString());
        } else {
            ILoNum iLoNum = spanRow.getFirstLo();
            stringBuffer.append(iLoNum.groupString());
            stringBuffer.append(" to ");
            iLoNum = spanRow.getLastLo();
            stringBuffer.append(iLoNum.groupString());
        }
        return stringBuffer.toString();
    }

    private String getVc3Label(SpanRow spanRow) {
        StringBuffer stringBuffer = new StringBuffer();
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        if (spanRow.getFirstLo() == null) {
            stringBuffer.append("--");
        } else {
            SdhAu4LoNum sdhAu4LoNum;
            SdhAu4LoNum sdhAu4LoNum2 = (SdhAu4LoNum)spanRow.getFirstLo();
            if (hoLoComparator.compare(sdhAu4LoNum2, sdhAu4LoNum = (SdhAu4LoNum)spanRow.getLastLo()) == 0) {
                stringBuffer.append(sdhAu4LoNum2.getVc3());
            } else {
                stringBuffer.append(sdhAu4LoNum2.getVc3());
                if (sdhAu4LoNum.getVc3() != sdhAu4LoNum2.getVc3()) {
                    stringBuffer.append("-" + sdhAu4LoNum.getVc3());
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getTug2Label(SpanRow spanRow) {
        StringBuffer stringBuffer = new StringBuffer();
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)spanRow.getFirstLo();
        SdhAu4LoNum sdhAu4LoNum2 = (SdhAu4LoNum)spanRow.getLastLo();
        if (db.on()) {
            db.fine("spanRow=" + spanRow.prettyString() + "\n");
            db.fine("firstLoNum=" + (sdhAu4LoNum == null ? "null" : sdhAu4LoNum.prettyString()));
            db.fine("lastLoNum=" + (sdhAu4LoNum2 == null ? "null" : sdhAu4LoNum2.prettyString()));
        }
        if (sdhAu4LoNum != null) {
            if (sdhAu4LoNum.getTug2() == 0 || sdhAu4LoNum.getTug2() == 1 && sdhAu4LoNum2.getTug2() == 7 || sdhAu4LoNum.isVc3Num() && sdhAu4LoNum.getTug2() == 1 && sdhAu4LoNum2.isVc3Num() && sdhAu4LoNum2.getTug2() == 1) {
                stringBuffer.append("--");
            } else if (hoLoComparator.compare(sdhAu4LoNum, sdhAu4LoNum2) == 0) {
                stringBuffer.append(sdhAu4LoNum.getTug2());
            } else {
                stringBuffer.append(sdhAu4LoNum.getTug2());
                if (sdhAu4LoNum2.getTug2() != sdhAu4LoNum.getTug2()) {
                    stringBuffer.append("-" + sdhAu4LoNum2.getTug2());
                }
            }
        } else {
            stringBuffer.append("--");
        }
        return stringBuffer.toString();
    }

    private String getVc11_12Label(SpanRow spanRow) {
        StringBuffer stringBuffer = new StringBuffer();
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        SdhAu4LoNum sdhAu4LoNum = (SdhAu4LoNum)spanRow.getFirstLo();
        SdhAu4LoNum sdhAu4LoNum2 = (SdhAu4LoNum)spanRow.getLastLo();
        if (sdhAu4LoNum != null) {
            if (sdhAu4LoNum.isVc3Num() || sdhAu4LoNum.getVc11_12() == 1 && sdhAu4LoNum2.getVc11_12() == sdhAu4LoNum2.getMaxVc11_12NumInTug2()) {
                stringBuffer.append("--");
            } else if (hoLoComparator.compare(sdhAu4LoNum, sdhAu4LoNum2) == 0) {
                stringBuffer.append(sdhAu4LoNum.getVc11_12());
            } else {
                stringBuffer.append(sdhAu4LoNum.getVc11_12());
                stringBuffer.append("-");
                stringBuffer.append(sdhAu4LoNum2.getVc11_12());
            }
        } else {
            stringBuffer.append("--");
        }
        return stringBuffer.toString();
    }

    static int[] getColumns(int n, boolean bl) {
        return FramingType.isSonet((int)n) ? (bl ? SonetColumns : SonetColumnsNoUpsr) : (bl ? SdhColumns : SdhColumnsNoUpsr);
    }

    static ColumnRenderer[] createTableRenderers(int n, int n2, boolean bl) {
        int[] nArray = SpanColumnRenderer.getColumns(n2, bl);
        if (n < 0 || n >= nArray.length) {
            return null;
        }
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[nArray.length];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = SpanColumnRenderer.createSpanColumnRenderer(nArray[i]);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createSpanColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "STS";
                n3 = 60;
                bl = true;
                n2 = 0;
                break;
            }
            case 1: {
                string = "VT";
                n3 = 40;
                bl = true;
                n2 = 0;
                break;
            }
            case 6: {
                string = "VC4";
                n3 = 40;
                bl = true;
                n2 = 0;
                break;
            }
            case 7: {
                string = "VC3/TUG3";
                n3 = 70;
                bl = true;
                n2 = 0;
                break;
            }
            case 8: {
                string = "TUG2";
                n3 = 40;
                bl = true;
                n2 = 0;
                break;
            }
            case 9: {
                string = "VC11/VC12";
                n3 = 70;
                bl = true;
                n2 = 0;
                break;
            }
            case 3: {
                string = "UPSR";
                n3 = 40;
                bl = false;
                n2 = 0;
                break;
            }
            case 10: {
                string = "SNCP";
                n3 = 40;
                bl = false;
                n2 = 0;
                break;
            }
            case 4: {
                string = "Circuit";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 5: {
                string = "Switch State";
                n3 = 100;
                bl = true;
                n2 = 0;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new SpanColumnRenderer(n, string, n3, bl, n2);
    }
}

