/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Attribute;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.WzStatusPanel;
import cerent.cms.ui.circuits.CcdOCHTrailAttrsPane;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.UpgradeOchncColumnRenderer;
import cerent.cms.ui.circuits.UpgradeOchncRowData;
import cerent.cms.ui.circuits.UpgradeOchncTableModel;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedProgressDialog;
import cerent.util.gui.IDetailedProgressController;
import cerent.util.gui.IDetailedProgressDialog;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class UpgradeOchncDialog
extends UDialog
implements ActionListener,
Observer,
ProgressDialogControl {
    public static final String TITLE = "Upgrade OCHNC";
    private static final int VIGN_WIDTH = 250;
    private static final int WIDTH = 900;
    private static final int HEIGHT = 450;
    private static final SDebug db = new SDebug("UpgradeOchncDialog");
    private IDetailedProgressDialog detailedLogDialog;
    private DetailedLog detailedLog;
    private WzStatusPanel statusPanel;
    private UpgradeOchncPane ochccPane;
    private OchncCircuit circuit;
    private OchncCircuit alternateCircuit;
    private OchTrailHelper.UpgradeOchncInfo srcInfo;
    private OchTrailHelper.UpgradeOchncInfo altSrcInfo;
    private OchTrailHelper.UpgradeOchncInfo dstInfo;
    private OchTrailHelper.UpgradeOchncInfo altDstInfo;
    private JButton okButton;
    private JButton cancelButton;
    private CSHelpButton helpButton;
    private int wlen = 0;
    private ProgressDialog progressDialog;
    private int expectedOTTNetLink = 0;
    private int netLinkCounter = 0;
    private static final int OCHNC_UPGRADE_STARTED = 0;
    private static final int OCHNC_UPGRADE_COMPLETED = 1;
    private static final int OCHCC_CREATION_STARTED = 2;
    private static final int OCHCC_CREATION_COMPLETED = 3;
    private static final int COMPLETED = 4;
    private int ochncUpgradePhase;
    private boolean stopped = false;

    public UpgradeOchncDialog(OchncCircuit ochncCircuit, JComponent jComponent, boolean bl) {
        super(JOptionPane.getFrameForComponent(jComponent), "Upgrade OCHNC - " + ochncCircuit.getCircuitName(), bl);
        this.circuit = ochncCircuit;
        this.detailedLog = new DetailedLog(1, "Initializing OCHCC upgrade of OCHNC circuit " + ochncCircuit.getCircuitName());
        IDetailedProgressController iDetailedProgressController = new IDetailedProgressController(){

            public void start(IDetailedProgressDialog iDetailedProgressDialog) {
                UpgradeOchncDialog.this.loadOchccs();
            }

            public boolean isCancelSupported() {
                return false;
            }

            public void cancel() {
            }
        };
        this.detailedLogDialog = new DetailedProgressDialog(JOptionPane.getFrameForComponent(this.getParent()), "Upgrade OCHNC Initialization", this.detailedLog, iDetailedProgressController);
        this.detailedLogDialog.start();
        Frame frame = JOptionPane.getFrameForComponent(jComponent);
        this.setSize(new Dimension(900, 450));
        this.setLocationRelativeTo(frame);
        Network.instance().getNetLinkCreationNotifier().addObserver(this);
    }

    public void show() {
        if (this.detailedLogDialog.isCompleted()) {
            super.show();
            try {
                this.ochccPane.setShowing(true);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.statusPanel = new WzStatusPanel(true);
        JScrollPane jScrollPane = new JScrollPane(this.statusPanel, 20, 30);
        this.ochccPane = new UpgradeOchncPane();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = this.getButtonPanel();
        jPanel2.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, (Component)((Object)this.ochccPane));
        jSplitPane.setDividerLocation(225);
        jPanel2.add((Component)jSplitPane, "Center");
        jPanel2.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel2);
        WindowListener[] windowListenerArray = this.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            this.removeWindowListener(windowListenerArray[i]);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UpgradeOchncDialog.this.cancel();
            }

            public void windowClosed(WindowEvent windowEvent) {
            }
        });
    }

    public void cancel() {
        if (this.cancelButton.isEnabled() && CerentDialog.yesNoDialog((Component)((Object)this), (String)"Really cancel OCHNC Upgrade?", (String)"Confirm Cancel")) {
            this.dispose();
        }
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton = new CSHelpButton();
        this.helpButton.addActionListener(this);
        jPanel.add(Box.createHorizontalStrut(50));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.okButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.cancelButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.helpButton);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    private String getString(INetCircuitEnd iNetCircuitEnd) {
        return iNetCircuitEnd.getNetElement().getName() + "/" + CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd);
    }

    private String getString(IEntityModel iEntityModel) {
        return iEntityModel.getNodeModel().getName() + "/" + CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel, null, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: netLinkCounter = " + this.netLinkCounter);
        }
        if (this.ochncUpgradePhase == 4) {
            return;
        }
        if (this.netLinkCounter != 0 && observable instanceof Network.NetLinkCreationNotifier && object instanceof INetLink) {
            INetElement iNetElement;
            INetElement iNetElement2;
            INetLink iNetLink;
            block18: {
                iNetLink = (INetLink)object;
                if (db.on()) {
                    db.println("update: received notification about new NL " + iNetLink.prettyString());
                }
                if (this.alternateCircuit != null) {
                    iNetElement2 = Network.instance().findNetElem(this.altSrcInfo.getTrunkPort().getNodeModel());
                    iNetElement = Network.instance().findNetElem(this.altDstInfo.getTrunkPort().getNodeModel());
                    try {
                        if (iNetLink.getSrc() == iNetElement2 && iNetLink.getDst() == iNetElement && iNetLink.getSrcEntityIndex() == this.altSrcInfo.getTrunkPort().getEntityIndex() && iNetLink.getDstEntityIndex() == this.altDstInfo.getTrunkPort().getEntityIndex()) {
                            --this.netLinkCounter;
                        } else if (iNetLink.getSrc() == iNetElement && iNetLink.getDst() == iNetElement2 && iNetLink.getSrcEntityIndex() == this.altDstInfo.getTrunkPort().getEntityIndex() && iNetLink.getDstEntityIndex() == this.altSrcInfo.getTrunkPort().getEntityIndex()) {
                            --this.netLinkCounter;
                        }
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block18;
                        db.println("update: Exception getting other Trk port " + exception);
                    }
                }
            }
            iNetElement2 = Network.instance().findNetElem(this.srcInfo.getTrunkPort().getNodeModel());
            iNetElement = Network.instance().findNetElem(this.dstInfo.getTrunkPort().getNodeModel());
            if (iNetLink.getSrc() == iNetElement2 && iNetLink.getDst() == iNetElement && iNetLink.getSrcEntityIndex() == this.srcInfo.getTrunkPort().getEntityIndex() && iNetLink.getDstEntityIndex() == this.dstInfo.getTrunkPort().getEntityIndex()) {
                --this.netLinkCounter;
            } else if (iNetLink.getSrc() == iNetElement && iNetLink.getDst() == iNetElement2 && iNetLink.getSrcEntityIndex() == this.dstInfo.getTrunkPort().getEntityIndex() && iNetLink.getDstEntityIndex() == this.srcInfo.getTrunkPort().getEntityIndex()) {
                --this.netLinkCounter;
            }
            this.progressDialog.update(null, "Waiting for OCH-TRAIL circuit discovery. Received " + (this.expectedOTTNetLink - this.netLinkCounter) + " of " + this.expectedOTTNetLink + " link notifications.");
            if (this.netLinkCounter == 0) {
                UpgradeOchncDialog upgradeOchncDialog = this;
                synchronized (upgradeOchncDialog) {
                    this.notifyAll();
                }
            }
        }
        if (db.on()) {
            db.println("Exiting update: netLinkCounter = " + this.netLinkCounter);
        }
    }

    private void loadOchccs() {
        this.detailedLogDialog.addLog("Retrieving Source", null);
        DetailedLog detailedLog = new DetailedLog(1);
        try {
            INetElement iNetElement = this.circuit.getSourceNE();
            List list = this.circuit.getSources();
            List list2 = this.circuit.getDrops();
            INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)list.get(0);
            INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)list2.get(1);
            if (iNetCircuitEnd.getNodeId() != iNetCircuitEnd2.getNodeId()) {
                if (db.on()) {
                    db.println("loadOchccs: cktsrc wrong sorce/drop order, swap cktends");
                }
                iNetCircuitEnd2 = (INetCircuitEnd)list2.get(0);
            }
            detailedLog.setDesc("Looking for common trunk for OCH ports on node " + iNetElement.getName());
            DetailedLog detailedLog2 = new DetailedLog(1, "RX: " + this.getString(iNetCircuitEnd));
            detailedLog.addChild(detailedLog2);
            detailedLog2 = new DetailedLog(1, "TX: " + this.getString(iNetCircuitEnd2));
            detailedLog.addChild(detailedLog2);
            this.detailedLogDialog.addLog(detailedLog);
            this.srcInfo = OchTrailHelper.getConnectedTrunk(iNetCircuitEnd, iNetCircuitEnd2);
            CircuitCreatInfo.TrunkInfo trunkInfo = null;
            boolean bl = false;
            if (this.srcInfo == null) {
                detailedLog2 = new DetailedLog(3, "Cannot find internal/external patchcords connecting the OCH ports to one trunk port.");
                this.detailedLogDialog.appendChild(detailedLog2);
                this.detailedLogDialog.setCompleted(false);
                return;
            }
            IEntityModel iEntityModel = this.srcInfo.getTrunkPort();
            bl = OchTrailHelper.isLineCard(iEntityModel.getModuleModel().getEqType());
            detailedLog2 = this.srcInfo.isColocated() ? new DetailedLog(1, "Found internal patchcords connecting the OCH ports trunk: " + this.getString(iEntityModel)) : new DetailedLog(1, "Found external patchcords connecting the OCH ports to trunk: " + this.getString(iEntityModel));
            this.detailedLogDialog.appendChild(detailedLog2);
            if (!bl) {
                detailedLog = new DetailedLog(1, "Retrieving Trunk Attributes for Source Trunk");
                this.detailedLogDialog.addLog("Retrieving Source Trunk Attributes", detailedLog);
                try {
                    trunkInfo = OchTrailHelper.getTrunkAttrs(iEntityModel);
                    detailedLog2 = new DetailedLog(1, "Found trunk attributes: " + trunkInfo);
                    this.detailedLogDialog.appendChild(detailedLog2);
                }
                catch (Exception exception) {
                    detailedLog2 = new DetailedLog(3, "Cannot find trunk attributes for tunk: " + exception.getMessage());
                    detailedLog2.setException(exception);
                    this.detailedLogDialog.appendChild(detailedLog2);
                    this.detailedLogDialog.setCompleted(false);
                    return;
                }
            }
            detailedLog = new DetailedLog(1);
            INetElement iNetElement2 = this.circuit.getDropNE();
            INetCircuitEnd iNetCircuitEnd3 = (INetCircuitEnd)list2.get(0);
            INetCircuitEnd iNetCircuitEnd4 = (INetCircuitEnd)list.get(1);
            if (iNetCircuitEnd3.getNodeId() != iNetCircuitEnd4.getNodeId()) {
                if (db.on()) {
                    db.println("loadOchccs: cktdst wrong sorce/drop order, swap cktends");
                }
                iNetCircuitEnd4 = (INetCircuitEnd)list.get(0);
            }
            detailedLog.setDesc("Looking for common trunk for OCH ports on node " + iNetElement2.getName());
            detailedLog2 = new DetailedLog(1, "RX: " + this.getString(iNetCircuitEnd3));
            detailedLog.addChild(detailedLog2);
            detailedLog2 = new DetailedLog(1, "TX: " + this.getString(iNetCircuitEnd4));
            detailedLog.addChild(detailedLog2);
            this.detailedLogDialog.addLog("Retrieving Drop", detailedLog);
            this.dstInfo = OchTrailHelper.getConnectedTrunk(iNetCircuitEnd3, iNetCircuitEnd4);
            boolean bl2 = false;
            CircuitCreatInfo.TrunkInfo trunkInfo2 = null;
            if (this.dstInfo == null) {
                detailedLog2 = new DetailedLog(3, "Cannot find internal/external patchcords connecting the OCH ports to one trunk port.");
                this.detailedLogDialog.appendChild(detailedLog2);
                this.detailedLogDialog.setCompleted(false);
                return;
            }
            IEntityModel iEntityModel2 = this.dstInfo.getTrunkPort();
            bl2 = OchTrailHelper.isLineCard(iEntityModel2.getModuleModel().getEqType());
            detailedLog2 = this.dstInfo.isColocated() ? new DetailedLog(1, "Found internal patchcords connecting the OCH ports trunk: " + this.getString(iEntityModel2)) : new DetailedLog(1, "Found external patchcords connecting the OCH ports to trunk: " + this.getString(iEntityModel2));
            this.detailedLogDialog.appendChild(detailedLog2);
            if (!bl2) {
                detailedLog = new DetailedLog(1, "Retrieving Trunk Attributes for Drop Trunk");
                this.detailedLogDialog.addLog("Retrieving Drop Trunk Attributes", detailedLog);
                try {
                    trunkInfo2 = OchTrailHelper.getTrunkAttrs(iEntityModel2);
                    detailedLog2 = new DetailedLog(1, "Found trunk attributes: " + trunkInfo2);
                    this.detailedLogDialog.appendChild(detailedLog2);
                }
                catch (Exception exception) {
                    detailedLog2 = new DetailedLog(3, "Cannot find trunk attributes for tunk: " + exception.getMessage());
                    detailedLog2.setException(exception);
                    this.detailedLogDialog.appendChild(detailedLog2);
                    this.detailedLogDialog.setCompleted(false);
                    return;
                }
            }
            if (!this.checkAndSetProtectionAttrs(iNetElement, iEntityModel, iNetElement2, iEntityModel2)) {
                this.detailedLogDialog.setCompleted(false);
                return;
            }
            if (!this.checkAndSetTrunkAttrs(iEntityModel, trunkInfo, bl, iEntityModel2, trunkInfo2, bl2)) {
                this.detailedLogDialog.setCompleted(false);
                return;
            }
            this.wlen = this.checkWlens(iEntityModel, iEntityModel2);
            if (this.wlen == -1) {
                this.detailedLogDialog.setCompleted(false);
                return;
            }
            if (bl && bl2) {
                if (!this.addTrunks(iNetElement, iEntityModel, iNetElement2, iEntityModel2)) {
                    this.detailedLogDialog.setCompleted(false);
                    return;
                }
            } else {
                this.addClients(iEntityModel, iEntityModel2);
            }
        }
        catch (Exception exception) {
            DetailedLog detailedLog3 = new DetailedLog(3, "Unexpected error: " + exception.getMessage());
            detailedLog3.setException(exception);
            this.detailedLogDialog.appendChild(detailedLog3);
            this.detailedLogDialog.setCompleted(false);
        }
        this.detailedLogDialog.setCompleted(true);
    }

    private boolean checkAndSetProtectionAttrs(INetElement iNetElement, IEntityModel iEntityModel, INetElement iNetElement2, IEntityModel iEntityModel2) {
        DetailedLog detailedLog = new DetailedLog(1, "Checking Protection Attributes");
        this.detailedLogDialog.addLog("Checking Protection", detailedLog);
        boolean bl = true;
        boolean bl2 = OchTrailHelper.isProtected(iEntityModel);
        boolean bl3 = OchTrailHelper.isProtected(iEntityModel2);
        if (bl2 && !bl3) {
            DetailedLog detailedLog2 = new DetailedLog(3, "Cannot create circuit between protected trunk " + this.getString(iEntityModel) + " and unprotected trunk " + this.getString(iEntityModel2) + ". Cannot proceed.");
            this.detailedLogDialog.appendChild(detailedLog2);
            bl = false;
        } else if (!bl2 && bl3) {
            DetailedLog detailedLog3 = new DetailedLog(3, "Cannot create circuit between unprotected trunk " + this.getString(iEntityModel) + " and protected trunk " + this.getString(iEntityModel2) + ". Cannot proceed.");
            this.detailedLogDialog.appendChild(detailedLog3);
            bl = false;
        } else if (!bl2 && !bl3) {
            DetailedLog detailedLog4 = new DetailedLog(1, "Both trunks are unprotected.");
            this.detailedLogDialog.appendChild(detailedLog4);
            bl = true;
        } else {
            IRevertiveBehavior iRevertiveBehavior;
            IRevertiveBehavior iRevertiveBehavior2;
            try {
                iRevertiveBehavior2 = OchTrailHelper.getReversion(iEntityModel);
            }
            catch (Exception exception) {
                DetailedLog detailedLog5 = new DetailedLog(3, "Cannot retrieve reversion mode for trunk " + this.getString(iEntityModel));
                detailedLog5.setException(exception);
                this.detailedLogDialog.appendChild(detailedLog5);
                return false;
            }
            try {
                iRevertiveBehavior = OchTrailHelper.getReversion(iEntityModel2);
            }
            catch (Exception exception) {
                DetailedLog detailedLog6 = new DetailedLog(3, "Cannot retrieve reversion mode for trunk " + this.getString(iEntityModel2));
                detailedLog6.setException(exception);
                this.detailedLogDialog.appendChild(detailedLog6);
                return false;
            }
            CircuitCreatInfo.ProtectionInfo protectionInfo = new CircuitCreatInfo.ProtectionInfo(true, iRevertiveBehavior2);
            CircuitCreatInfo.ProtectionInfo protectionInfo2 = new CircuitCreatInfo.ProtectionInfo(true, iRevertiveBehavior);
            DetailedLog detailedLog7 = new DetailedLog(1, "Reversion behavior of trunk " + this.getString(iEntityModel) + ": " + protectionInfo);
            this.detailedLogDialog.appendChild(detailedLog7);
            detailedLog7 = new DetailedLog(1, "Reversion behavior of trunk " + this.getString(iEntityModel) + ": " + protectionInfo2);
            this.detailedLogDialog.appendChild(detailedLog7);
            bl = OchTrailHelper.checkProtectionAttrs(protectionInfo, protectionInfo2);
            if (!bl) {
                detailedLog7 = new DetailedLog(3, "Reversion behaviors are different. Cannot proceed.");
                this.detailedLogDialog.appendChild(detailedLog7);
            } else {
                INetCircuitEnd iNetCircuitEnd;
                INetCircuitEnd iNetCircuitEnd2;
                INetCircuitEnd iNetCircuitEnd3;
                Object object;
                Object object2;
                IEntityModel iEntityModel3;
                IEntityModel iEntityModel4;
                detailedLog = new DetailedLog(1, "Looking for alternate OCHNC path for protected OCHCC.");
                this.detailedLogDialog.addLog("Alternate OCHNC", detailedLog);
                try {
                    iEntityModel4 = OchTrailHelper.getOtherTrunkPort(iEntityModel);
                    if (iEntityModel4 == null) {
                        detailedLog7 = new DetailedLog(3, "Cannot find other trunk for port " + this.getString(iEntityModel));
                        this.detailedLogDialog.appendChild(detailedLog7);
                        return false;
                    }
                }
                catch (Exception exception) {
                    detailedLog7 = new DetailedLog(3, "Cannot find other trunk for port " + this.getString(iEntityModel));
                    detailedLog7.setException(exception);
                    this.detailedLogDialog.appendChild(detailedLog7);
                    return false;
                }
                detailedLog7 = new DetailedLog(1, "Alternate trunk for source port is: " + this.getString(iEntityModel4));
                this.detailedLogDialog.appendChild(detailedLog7);
                try {
                    iEntityModel3 = OchTrailHelper.getOtherTrunkPort(iEntityModel2);
                    if (iEntityModel3 == null) {
                        detailedLog7 = new DetailedLog(3, "Cannot find other trunk for port " + this.getString(iEntityModel2));
                        this.detailedLogDialog.appendChild(detailedLog7);
                        return false;
                    }
                }
                catch (Exception exception) {
                    detailedLog7 = new DetailedLog(3, "Cannot find other trunk for port " + this.getString(iEntityModel2));
                    detailedLog7.setException(exception);
                    this.detailedLogDialog.appendChild(detailedLog7);
                    return false;
                }
                detailedLog7 = new DetailedLog(1, "Alternate trunk for drop port is: " + this.getString(iEntityModel3));
                this.detailedLogDialog.appendChild(detailedLog7);
                IEntityModel[] iEntityModelArray = OchTrailHelper.getConnectedOchPorts(iEntityModel4);
                if (iEntityModelArray == null) {
                    detailedLog7 = new DetailedLog(3, "Cannot find OCH ports connected to trunk " + this.getString(iEntityModel4));
                    this.detailedLogDialog.appendChild(detailedLog7);
                    return false;
                }
                detailedLog7 = new DetailedLog(1, "Found 2 OCH ports connected to trunk " + this.getString(iEntityModel4) + "\n" + this.getString(iEntityModelArray[0]) + ", " + this.getString(iEntityModelArray[1]));
                this.detailedLogDialog.appendChild(detailedLog7);
                IEntityModel[] iEntityModelArray2 = OchTrailHelper.getConnectedOchPorts(iEntityModel3);
                if (iEntityModelArray2 == null) {
                    detailedLog7 = new DetailedLog(3, "Cannot find OCH ports connected to trunk " + this.getString(iEntityModel3));
                    this.detailedLogDialog.appendChild(detailedLog7);
                    return false;
                }
                detailedLog7 = new DetailedLog(1, "Found 2 OCH ports connected to trunk " + this.getString(iEntityModel3) + "\n" + this.getString(iEntityModelArray2[0]) + ", " + this.getString(iEntityModelArray2[1]));
                this.detailedLogDialog.appendChild(detailedLog7);
                int n = iEntityModelArray[0].getEntityIndex();
                int n2 = iEntityModelArray2[1].getEntityIndex();
                int n3 = iEntityModelArray2[0].getEntityIndex();
                int n4 = iEntityModelArray[1].getEntityIndex();
                List list = NetCircuitManager.instance().getCircuits(iEntityModelArray[0].getNodeModel());
                Iterator iterator = list.iterator();
                this.alternateCircuit = null;
                if (db.on()) {
                    db.println("Looking for alternate OCHNC for " + this.circuit.getCircuitName());
                    this.circuit.prettyPrint(db);
                }
                while (iterator.hasNext()) {
                    object2 = (INetCircuit)iterator.next();
                    if (!(object2 instanceof OchncCircuit) || object2.getCircuitTypeObj().isOchTrailTunnelCircuitType() || object2.equals(this.circuit)) continue;
                    if (db.on()) {
                        db.println("Checking OCHNC circuit");
                        object2.prettyPrint(db);
                    }
                    object = (NetCircuitEnd)object2.getSources().get(0);
                    iNetCircuitEnd3 = (NetCircuitEnd)object2.getSources().get(1);
                    iNetCircuitEnd2 = (NetCircuitDropInfo)object2.getDrops().get(0);
                    iNetCircuitEnd = (NetCircuitDropInfo)object2.getDrops().get(1);
                    if (db.on()) {
                        db.println("src1 = " + ((NetCircuitEnd)object).prettyString());
                        db.println("src2 = " + ((NetCircuitEnd)iNetCircuitEnd3).prettyString());
                        db.println("drop1 = " + ((NetCircuitDropInfo)iNetCircuitEnd2).getNetCktEnd().prettyString());
                        db.println("drop2 = " + ((NetCircuitDropInfo)iNetCircuitEnd).getNetCktEnd().prettyString());
                        db.println("src1Idx = " + Integer.toHexString(n));
                        db.println("src2Idx = " + Integer.toHexString(n3));
                        db.println("drop1Idx = " + Integer.toHexString(n2));
                        db.println("drop2Idx = " + Integer.toHexString(n4));
                    }
                    if (((NetCircuitEnd)object).getNodeId() == iEntityModelArray[0].getNodeModel().getNodeId() && ((NetCircuitDropInfo)iNetCircuitEnd2).getNodeId() == iEntityModelArray2[0].getNodeModel().getNodeId() && ((NetCircuitEnd)object).getEntityIndex() == n && ((NetCircuitDropInfo)iNetCircuitEnd2).getEntityIndex() == n2 && ((NetCircuitEnd)iNetCircuitEnd3).getEntityIndex() == n3 && ((NetCircuitDropInfo)iNetCircuitEnd).getEntityIndex() == n4) {
                        this.alternateCircuit = (OchncCircuit)object2;
                        break;
                    }
                    if (((NetCircuitEnd)object).getNodeId() != iEntityModelArray2[0].getNodeModel().getNodeId() || ((NetCircuitDropInfo)iNetCircuitEnd2).getNodeId() != iEntityModelArray[0].getNodeModel().getNodeId() || ((NetCircuitEnd)object).getEntityIndex() != n3 || ((NetCircuitDropInfo)iNetCircuitEnd2).getEntityIndex() != n4 || ((NetCircuitEnd)iNetCircuitEnd3).getEntityIndex() != n || ((NetCircuitDropInfo)iNetCircuitEnd).getEntityIndex() != n2) continue;
                    this.alternateCircuit = (OchncCircuit)object2;
                    break;
                }
                if (this.alternateCircuit == null) {
                    detailedLog7 = new DetailedLog(3, "Cannot find alternate OCHNC circuit between these OCH ports. Cannot proceed.");
                    this.detailedLogDialog.appendChild(detailedLog7);
                    return false;
                }
                object2 = this.alternateCircuit.getSources();
                object = this.alternateCircuit.getDrops();
                iNetCircuitEnd3 = (INetCircuitEnd)object2.get(0);
                iNetCircuitEnd2 = (INetCircuitEnd)object.get(1);
                this.altSrcInfo = OchTrailHelper.getConnectedTrunk(iNetCircuitEnd3, iNetCircuitEnd2);
                iNetCircuitEnd = (INetCircuitEnd)object.get(0);
                INetCircuitEnd iNetCircuitEnd4 = (INetCircuitEnd)object2.get(1);
                this.altDstInfo = OchTrailHelper.getConnectedTrunk(iNetCircuitEnd, iNetCircuitEnd4);
                this.ochccPane.setProtectionAttrs(protectionInfo);
                detailedLog7 = new DetailedLog(1, "Found alternate OCHNC circuit: " + this.alternateCircuit.getCircuitName());
                this.detailedLogDialog.appendChild(detailedLog7);
            }
        }
        return bl;
    }

    private boolean checkAndSetTrunkAttrs(IEntityModel iEntityModel, CircuitCreatInfo.TrunkInfo trunkInfo, boolean bl, IEntityModel iEntityModel2, CircuitCreatInfo.TrunkInfo trunkInfo2, boolean bl2) {
        DetailedLog detailedLog;
        DetailedLog detailedLog2 = new DetailedLog(1, "Checking Trunk Attributes");
        this.detailedLogDialog.addLog("Checking Trunk Attrs", detailedLog2);
        boolean bl3 = true;
        if (!bl && !bl2) {
            IModuleModel iModuleModel;
            IModuleModel iModuleModel2 = iEntityModel.getModuleModel();
            if (OchTrailHelper.checkTrunkAttrs(iModuleModel2, trunkInfo, iModuleModel = iEntityModel2.getModuleModel(), trunkInfo2)) {
                this.ochccPane.setTrunkAttrs(trunkInfo);
            } else {
                detailedLog = new DetailedLog(3, "Trunk attributes must be compatible. Cannot proceed.");
                this.detailedLogDialog.appendChild(detailedLog);
                bl3 = false;
            }
        } else if (!bl || !bl2) {
            detailedLog = new DetailedLog(3, "Trying to connect ITU-T Trunk to TxP/MxP Trunk. Cannot proceed.");
            this.detailedLogDialog.appendChild(detailedLog);
            bl3 = false;
        }
        if (bl3) {
            detailedLog = new DetailedLog(1, "Check passed.");
            this.detailedLogDialog.appendChild(detailedLog);
        }
        return bl3;
    }

    private int checkWlens(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        int n;
        int n2;
        DetailedLog detailedLog = new DetailedLog(1, "Checking Trunk Wavelengths");
        this.detailedLogDialog.addLog("Checking Wavelengths", detailedLog);
        try {
            n2 = ((IOpticsChannelModel)((IPortModel)iEntityModel).getInterfaceModel()).getActualWaveLength();
        }
        catch (Exception exception) {
            DetailedLog detailedLog2 = new DetailedLog(3, "Cannot retrieve wavelength for trunk " + this.getString(iEntityModel));
            detailedLog2.setException(exception);
            this.detailedLogDialog.appendChild(detailedLog2);
            return -1;
        }
        DetailedLog detailedLog3 = new DetailedLog(1, "Wavelength for trunk " + this.getString(iEntityModel) + " is " + Wavelength.getWavelengthStringFromWavelength(n2));
        this.detailedLogDialog.appendChild(detailedLog3);
        try {
            n = ((IOpticsChannelModel)((IPortModel)iEntityModel2).getInterfaceModel()).getActualWaveLength();
        }
        catch (Exception exception) {
            detailedLog3 = new DetailedLog(3, "Cannot retrieve wavelength for trunk " + this.getString(iEntityModel2));
            detailedLog3.setException(exception);
            this.detailedLogDialog.appendChild(detailedLog3);
            return -1;
        }
        detailedLog3 = new DetailedLog(1, "Wavelength for trunk " + this.getString(iEntityModel2) + " is " + Wavelength.getWavelengthStringFromWavelength(n));
        this.detailedLogDialog.appendChild(detailedLog3);
        if (n2 != n) {
            detailedLog3 = new DetailedLog(1, "Wavelength must be compatible. Cannot proceed.");
            this.detailedLogDialog.appendChild(detailedLog3);
        }
        return n2;
    }

    private boolean checkInteroperability(OchTrailHelper.OchccCircuitSize ochccCircuitSize, IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        return OchTrailHelper.checkInteroperability(ochccCircuitSize, iEntityModel, iEntityModel2);
    }

    private void addClients(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        DetailedLog detailedLog = new DetailedLog(1, "Loading Client Ports");
        this.detailedLogDialog.addLog("Loading Clients", detailedLog);
        boolean bl = true;
        int n = 0;
        this.ochccPane.setClientsCaption();
        IEntityModel[] iEntityModelArray = OchTrailHelper.getClientPorts(iEntityModel);
        IEntityModel[] iEntityModelArray2 = OchTrailHelper.getClientPorts(iEntityModel2);
        if (iEntityModelArray.length == 0) {
            bl = false;
            DetailedLog detailedLog2 = new DetailedLog(3, "Found 0 client ports on source node. Cannot proceed.");
            this.detailedLogDialog.appendChild(detailedLog2);
        } else if (iEntityModelArray2.length == 0) {
            bl = false;
            DetailedLog detailedLog3 = new DetailedLog(3, "Found 0 client ports on drop node. Cannot proceed.");
            this.detailedLogDialog.appendChild(detailedLog3);
        } else {
            int n2;
            Object object;
            int n3;
            IEntityModel iEntityModel3;
            int[] nArray;
            IEntityModel iEntityModel4;
            int n4;
            DetailedLog detailedLog4 = new DetailedLog(1, "Found " + iEntityModelArray.length + " client ports on source node.");
            this.detailedLogDialog.appendChild(detailedLog4);
            detailedLog4 = new DetailedLog(1, "Found " + iEntityModelArray2.length + " client ports on drop node.");
            this.detailedLogDialog.appendChild(detailedLog4);
            int n5 = iEntityModelArray.length;
            for (n4 = 0; n4 < n5; ++n4) {
                iEntityModel4 = iEntityModelArray[n4];
                nArray = ((IPortModel)iEntityModel4).getPortNum();
                detailedLog = new DetailedLog(1, "Load Source client " + this.getString(iEntityModel4));
                this.detailedLogDialog.addLog(detailedLog);
                iEntityModel3 = null;
                for (n3 = 0; iEntityModel3 == null && n3 < iEntityModelArray2.length; ++n3) {
                    IEntityModel iEntityModel5 = iEntityModelArray2[n3];
                    object = ((IPortModel)iEntityModel5).getPortNum();
                    if (nArray.length != ((int[])object).length) continue;
                    boolean bl2 = true;
                    for (n2 = 0; bl2 && n2 < nArray.length; ++n2) {
                        bl2 = nArray[n2] == object[n2];
                    }
                    if (!bl2) continue;
                    iEntityModel3 = iEntityModel5;
                }
                n3 = OchTrailHelper.getPayloadEqType(iEntityModel4);
                if (iEntityModel3 != null) {
                    detailedLog4 = new DetailedLog(1, "Found Drop Client " + this.getString(iEntityModel3));
                    this.detailedLogDialog.appendChild(detailedLog4);
                    int n6 = OchTrailHelper.getPayloadEqType(iEntityModel3);
                    if (n3 != n6) {
                        detailedLog4 = new DetailedLog(2, "Source and Drop payloads differ: " + UpgradeOchncColumnRenderer.getString(iEntityModel.getNodeModel(), n3) + " != " + UpgradeOchncColumnRenderer.getString(iEntityModel2.getNodeModel(), n6) + "\nClient connection not allowed.");
                        this.detailedLogDialog.appendChild(detailedLog4);
                        this.ochccPane.addOchcc(nArray, null, iEntityModel4, iEntityModel3);
                        continue;
                    }
                    object = OchTrailHelper.OchccCircuitSize.fromInt(n3, iEntityModel.getNodeModel().getFramingType());
                    UpgradeOchncRowData upgradeOchncRowData = this.ochccPane.addOchcc(nArray, (OchTrailHelper.OchccCircuitSize)object, iEntityModel4, iEntityModel3);
                    if (!this.checkInteroperability((OchTrailHelper.OchccCircuitSize)object, iEntityModel, iEntityModel2)) {
                        detailedLog4 = new DetailedLog(2, "Source and Drop Client are not interoperable for size " + object);
                        this.detailedLogDialog.appendChild(detailedLog4);
                        upgradeOchncRowData.disable();
                        continue;
                    }
                    detailedLog4 = new DetailedLog(1, "Interoperability check passed for size " + object);
                    this.detailedLogDialog.appendChild(detailedLog4);
                    ++n;
                    continue;
                }
                detailedLog4 = new DetailedLog(2, "Cannot find associated Drop Client.");
                this.detailedLogDialog.appendChild(detailedLog4);
                this.ochccPane.addOchcc(nArray, OchTrailHelper.OchccCircuitSize.fromInt(n3, iEntityModel.getNodeModel().getFramingType()), iEntityModel4, null);
            }
            n5 = iEntityModelArray2.length;
            for (n4 = 0; n4 < n5; ++n4) {
                iEntityModel4 = iEntityModelArray2[n4];
                nArray = ((IPortModel)iEntityModel4).getPortNum();
                iEntityModel3 = null;
                for (n3 = 0; iEntityModel3 == null && n3 < iEntityModelArray.length; ++n3) {
                    IEntityModel iEntityModel6 = iEntityModelArray[n3];
                    object = ((IPortModel)iEntityModel6).getPortNum();
                    if (((int[])object).length != nArray.length) continue;
                    boolean bl3 = true;
                    for (n2 = 0; bl3 && n2 < ((int[])object).length; ++n2) {
                        bl3 = object[n2] == nArray[n2];
                    }
                    if (!bl3) continue;
                    iEntityModel3 = iEntityModel6;
                }
                n3 = OchTrailHelper.getPayloadEqType(iEntityModel4);
                if (iEntityModel3 != null) continue;
                detailedLog = new DetailedLog(1, "Loading Drop client " + this.getString(iEntityModel4));
                this.detailedLogDialog.addLog(detailedLog);
                detailedLog4 = new DetailedLog(2, "Cannot find associated Source Client.");
                this.detailedLogDialog.appendChild(detailedLog4);
                this.ochccPane.addOchcc(nArray, OchTrailHelper.OchccCircuitSize.fromInt(n3, iEntityModel2.getNodeModel().getFramingType()), null, iEntityModel4);
            }
        }
        this.okButton.setEnabled(bl && n > 0);
    }

    private boolean addTrunks(INetElement iNetElement, IEntityModel iEntityModel, INetElement iNetElement2, IEntityModel iEntityModel2) {
        DetailedLog detailedLog = new DetailedLog(1, "Checking Trunk Payloads");
        this.detailedLogDialog.addLog("Checking Payloads", detailedLog);
        OchTrailHelper.OchccCircuitSize ochccCircuitSize = OchTrailHelper.OchccCircuitSize.fromInt(iEntityModel.getEqType(), iNetElement.getFramingType());
        DetailedLog detailedLog2 = new DetailedLog(1, "Size of Trunk " + this.getString(iEntityModel) + " is " + ochccCircuitSize);
        this.detailedLogDialog.appendChild(detailedLog2);
        OchTrailHelper.OchccCircuitSize ochccCircuitSize2 = OchTrailHelper.OchccCircuitSize.fromInt(iEntityModel2.getEqType(), iNetElement2.getFramingType());
        detailedLog2 = new DetailedLog(1, "Size of Trunk " + this.getString(iEntityModel2) + " is " + ochccCircuitSize2);
        this.detailedLogDialog.appendChild(detailedLog2);
        boolean bl = ochccCircuitSize.equals(ochccCircuitSize2);
        if (!bl) {
            detailedLog2 = new DetailedLog(3, "Sizes are different. Cannot proceed.");
            this.detailedLogDialog.appendChild(detailedLog2);
        } else {
            boolean bl2 = bl = ochccCircuitSize != null;
            if (!bl) {
                detailedLog2 = new DetailedLog(3, "Circuit Size not retrieved. Cannot proceed.");
                this.detailedLogDialog.appendChild(detailedLog2);
            } else if (!this.checkInteroperability(ochccCircuitSize, iEntityModel, iEntityModel2)) {
                bl = false;
            } else {
                this.ochccPane.setTrunkCaption();
                this.ochccPane.addOchcc(1, ochccCircuitSize, iEntityModel, iEntityModel2);
            }
        }
        return bl;
    }

    private CircuitCreatInfo getCreatInfo(int n, int n2) {
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(14, 31, 1, n, -1);
        circuitCreatInfo.setSpecificSize(n2);
        return circuitCreatInfo;
    }

    public void dispose() {
        if (db.on()) {
            db.println("Dispose called");
        }
        if (db.on()) {
            db.println("dispose: stop observing NLCN");
        }
        Network.instance().getNetLinkCreationNotifier().deleteObserver(this);
        this.altSrcInfo = null;
        this.srcInfo = null;
        this.altDstInfo = null;
        this.dstInfo = null;
        super.dispose();
    }

    protected void ok() {
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        this.progressDialog = ProgressDialog.start((Component)((Object)this), TITLE, "Circuit is being upgraded.  Please wait...", this, 2000, 20, true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (db.on()) {
            db.println("User action/actionPerformed, o= " + object);
        }
        if (object == this.okButton) {
            this.ok();
        } else if (object == this.cancelButton) {
            this.cancel();
        } else if (object == this.helpButton) {
            this.helpButton.launchHelp(this.ochccPane.getHelpID());
        } else {
            db.println("unknown action source= " + object);
        }
    }

    private void doUpgradeOchnc(Observer observer) throws CircuitProvError {
        this.netLinkCounter = this.alternateCircuit != null ? 4 : 2;
        this.expectedOTTNetLink = this.netLinkCounter;
        observer.update(null, "Upgrading OCHNC circuit " + this.circuit.getCircuitName());
        this.circuit.toOchTrailTunnelCircuit(this.srcInfo, this.dstInfo);
        if (this.alternateCircuit != null) {
            observer.update(null, "Upgrading alternate OCHNC circuit " + this.alternateCircuit.getCircuitName());
            this.alternateCircuit.toOchTrailTunnelCircuit(this.altSrcInfo, this.altDstInfo);
        }
    }

    private synchronized void doCreateOchcc() throws Exception {
        if (this.stopRequired()) {
            return;
        }
        if (db.on()) {
            db.println("doCreateOchcc called");
        }
        UpgradeOchncTableModel upgradeOchncTableModel = this.ochccPane.getTableModel();
        for (int i = 0; i < upgradeOchncTableModel.getRowCount(); ++i) {
            UpgradeOchncRowData upgradeOchncRowData = upgradeOchncTableModel.getRowData(i);
            if (upgradeOchncRowData == null || !upgradeOchncRowData.isComplete()) continue;
            INodeModel iNodeModel = upgradeOchncRowData.getSrcPort().getNodeModel();
            INetElement iNetElement = Network.instance().findNetElem(iNodeModel);
            INodeModel iNodeModel2 = upgradeOchncRowData.getDstPort().getNodeModel();
            INetElement iNetElement2 = Network.instance().findNetElem(iNodeModel2);
            IEntityModel iEntityModel = upgradeOchncRowData.getSrcPort();
            IEntityModel iEntityModel2 = upgradeOchncRowData.getDstPort();
            CircuitCreatInfo circuitCreatInfo = this.getCreatInfo(this.wlen, upgradeOchncRowData.getCktSize());
            NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNodeModel.getNodeId(), iEntityModel.getEntityIndex(), null, null, false);
            INetCircuit iNetCircuit = NetCircuitFactory.newCircuit(circuitCreatInfo, netCircuitEnd);
            RoutePrefs routePrefs = new RoutePrefs();
            routePrefs.setCircuitType(iNetCircuit.getCircuitType());
            routePrefs.setSrc(iNetElement);
            routePrefs.setDst(iNetElement2);
            routePrefs.setcktOptChannel(iNetCircuit.getCircuitOptChannel());
            routePrefs.setcktSrcEntityIndex(iEntityModel.getEntityIndex());
            routePrefs.setcktDstEntityIndex(iEntityModel2.getEntityIndex());
            if (this.alternateCircuit != null) {
                routePrefs.setPathProt(1);
            }
            if (iEntityModel instanceof ITdmPortModel) {
                iNetCircuit.routeNetElement(iNetElement2, routePrefs);
            } else {
                NetCircuitEnd netCircuitEnd2 = new NetCircuitEnd(iNodeModel2.getNodeId(), iEntityModel2.getEntityIndex(), null, null, false);
                iNetCircuit.routeDrop(netCircuitEnd2, routePrefs);
            }
            iNetCircuit.provision();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(Observer observer) throws Exception {
        this.progressDialog = (ProgressDialog)observer;
        try {
            this.ochncUpgradePhase = 0;
            this.doUpgradeOchnc(observer);
            this.ochncUpgradePhase = 1;
            UpgradeOchncDialog upgradeOchncDialog = this;
            synchronized (upgradeOchncDialog) {
                this.wait();
            }
            this.ochncUpgradePhase = 2;
            observer.update(null, "Creating OCHCC circuit(s).");
            this.doCreateOchcc();
            this.ochncUpgradePhase = 3;
        }
        finally {
            this.ochncUpgradePhase = 4;
            this.dispose();
        }
    }

    public String getResultString(Exception exception) {
        throw new DeprecatedMethodCalled("ProgressDialogControl.getResultString(Exception)");
    }

    public ProgressDialogResult getResult(Exception exception) {
        String string;
        if (exception == null) {
            string = "OCHNC upgrade completed.";
        } else if (this.ochncUpgradePhase == 0) {
            if (db.on()) {
                db.println("Upgrade OCHNC failed during OCHNC upgrade" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            string = ErrorMsg.getString((EID)NEMC.EID_OCHNC_UPGRADE_FAILED);
        } else {
            if (db.on()) {
                db.println("Upgrade OCHNC failed during OCHCC routing/creation" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            string = ErrorMsg.getString((EID)NEMC.EID_OCHNC_UPGRADE_PARTIAL_FAIL);
        }
        return new ProgressDialogResult(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.ochncUpgradePhase == 1 && CerentDialog.yesNoDialog((Component)((Object)this), (String)"Do you really want to stop the OCHNC upgrade?\nIf you confirm, the OCHNC(s) will still be upgraded,\nbut you will have to create the OCHCC(s) manually.", (String)"Confirm Stop")) {
            this.stopped = true;
            UpgradeOchncDialog upgradeOchncDialog = this;
            synchronized (upgradeOchncDialog) {
                this.notifyAll();
            }
        }
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean stopRequired() {
        return this.stopped;
    }

    class UpgradeOchncPane
    extends AbstractPane {
        private static final String CLIENTS_CAPTION = "The following OCHCC(s) will be built basing on the selected OCHNC.\nRed rows indicate that the related client ports cannot be connected due to incompatibilities encountered during the setup process.";
        private static final String TRUNKS_CAPTION = "The following OCHCC will be built basing on the selected OCHNC.";
        private JTextField altCircuitTF;
        JTextArea captionTA;
        private JTextField wlenTF;
        private JCheckBox g709CB;
        private JTextField fecTF;
        private JTextField sfBerTF;
        private JTextField sdBerTF;
        private JTextField mappingTF;
        private JCheckBox protectionCB;
        private RevertiveBehaviorPanel revertiveBehaviorPanel;
        private CircuitCreatInfo.TrunkInfo trunkAttrs;
        private CircuitCreatInfo.ProtectionInfo protectionInfo;
        private UpgradeOchncColumnRenderer[] columnRenderers;
        private UpgradeOchncTableModel model;
        private boolean areTrunkAttrsApplicable;

        public UpgradeOchncPane() {
            super("UpgradeOchncPane");
            this.initPane();
        }

        protected void initPane() {
            this.setLayout(new BorderLayout());
            this.add(this.getTopPane(), "North");
            this.add(this.getCenterPane(), "Center");
            this.add(this.getBottomPane(), "South");
        }

        private JPanel getTopPane() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.captionTA = new JTextArea(TRUNKS_CAPTION);
            this.captionTA.setMargin(new Insets(5, 5, 5, 5));
            this.captionTA.setEditable(false);
            this.captionTA.setLineWrap(true);
            this.captionTA.setWrapStyleWord(true);
            this.captionTA.setOpaque(false);
            jPanel.add((Component)this.captionTA, "Center");
            jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, SystemColor.controlDkShadow));
            return jPanel;
        }

        private JComponent getCenterPane() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.model = new UpgradeOchncTableModel();
            this.table = new UTable((TableModel)this.model);
            this.table.setRowSelectionAllowed(true);
            this.table.setSelectionMode(0);
            int n = this.table.getColumnCount();
            this.columnRenderers = new UpgradeOchncColumnRenderer[n];
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
                this.columnRenderers[i] = this.model.getColumnRenderer(i);
                tableColumn.setCellRenderer((TableCellRenderer)((Object)this.columnRenderers[i]));
                tableColumn.setPreferredWidth(UpgradeOchncTableModel.widths[i]);
            }
            UScrollPane uScrollPane = new UScrollPane((Component)this.table);
            jPanel.add((Component)uScrollPane, "Center");
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
            return jPanel;
        }

        private JPanel getBottomPane() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0, 5, 5));
            jPanel2.add(new JLabel("OCHNC Wavelength: "));
            this.wlenTF = this.getTF("");
            jPanel2.add(this.wlenTF);
            jPanel.add((Component)jPanel2, "North");
            jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0, 5, 5));
            jPanel2.setBorder(BorderFactory.createTitledBorder("Trunk Attributes"));
            this.g709CB = new JCheckBox("G.709 OTN");
            jPanel2.add(this.g709CB);
            this.g709CB.setEnabled(false);
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(new JLabel("FEC: "));
            this.fecTF = this.getTF("");
            jPanel2.add(this.fecTF);
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(new JLabel("SF BER: "));
            this.sfBerTF = this.getTF("1E-5");
            jPanel2.add(this.sfBerTF);
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(new JLabel("SD BER: "));
            this.sdBerTF = this.getTF("");
            jPanel2.add(this.sdBerTF);
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(new JLabel(" Mapping: "));
            this.mappingTF = this.getTF("");
            jPanel2.add(this.mappingTF);
            jPanel.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.setBorder(BorderFactory.createTitledBorder("Protection"));
            jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0, 5, 5));
            this.protectionCB = new JCheckBox("Protection", false);
            jPanel2.add(this.protectionCB);
            this.protectionCB.setEnabled(false);
            this.revertiveBehaviorPanel = new RevertiveBehaviorPanel(null);
            jPanel2.add(this.revertiveBehaviorPanel);
            this.revertiveBehaviorPanel.setRevertiveEnabled(false);
            jPanel3.add((Component)jPanel2, "Center");
            jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0, 5, 5));
            jPanel2.add(new JLabel("Alternate OCHNC Circuit: "));
            this.altCircuitTF = this.getTF(200);
            jPanel2.add(this.altCircuitTF);
            jPanel3.add((Component)jPanel2, "South");
            jPanel.add((Component)jPanel3, "South");
            this.initBottomPane();
            return jPanel;
        }

        private void initBottomPane() {
            if (UpgradeOchncDialog.this.circuit != null) {
                this.wlenTF.setText(Wavelength.getWavelengthStringFromWavelength(UpgradeOchncDialog.this.circuit.getCircuitOptChannel()));
            }
            if (this.trunkAttrs != null) {
                this.g709CB.setSelected(this.trunkAttrs.isG709());
                if (this.trunkAttrs.isG709()) {
                    int n;
                    this.fecTF.setText(CcdOCHTrailAttrsPane.fecValues[this.trunkAttrs.getFecMode()].toString());
                    this.sfBerTF.setText("1E-5");
                    Attribute[] attributeArray = NetworkDefaults.getAttributeMap().getAttributeArray("declareSdBerLevel");
                    Attribute attribute = null;
                    for (n = 0; attribute == null && n < attributeArray.length; ++n) {
                        if (attributeArray[n].getIntValue() != this.trunkAttrs.getSdBer()) continue;
                        attribute = attributeArray[n];
                    }
                    this.sdBerTF.setText(attribute.toString());
                    n = this.trunkAttrs.getMappingType();
                    if (n == 3) {
                        n = 1;
                    }
                    CcdOCHTrailAttrsPane.MappingAttribute mappingAttribute = null;
                    for (int i = 0; i < CcdOCHTrailAttrsPane.mappingValues.length; ++i) {
                        if (CcdOCHTrailAttrsPane.mappingValues[i].getMappingType() != n) continue;
                        mappingAttribute = CcdOCHTrailAttrsPane.mappingValues[i];
                    }
                    this.mappingTF.setText(mappingAttribute != null ? mappingAttribute.toString() : "-");
                } else {
                    this.fecTF.setText("");
                    this.sfBerTF.setText("");
                    this.sdBerTF.setText("");
                    this.mappingTF.setText("");
                }
            } else {
                this.g709CB.setSelected(false);
                this.fecTF.setText("");
                this.sfBerTF.setText("");
                this.sdBerTF.setText("");
                this.mappingTF.setText("");
            }
            if (this.protectionInfo != null) {
                this.altCircuitTF.setText(UpgradeOchncDialog.this.alternateCircuit.getCircuitName());
                this.protectionCB.setSelected(true);
                this.revertiveBehaviorPanel.setRevertiveBehavior(this.protectionInfo.getRevertiveBehavior());
            } else {
                this.altCircuitTF.setText("");
                this.protectionCB.setSelected(false);
                this.revertiveBehaviorPanel.setRevertiveBehavior(null);
            }
        }

        public CSHelpID getHelpID() {
            return NetCSHelpConst.UpgradeOchncNodePane;
        }

        public UpgradeOchncTableModel getTableModel() {
            return this.model;
        }

        void addOchcc(int n, OchTrailHelper.OchccCircuitSize ochccCircuitSize, IEntityModel iEntityModel, IEntityModel iEntityModel2) {
            this.model.addOchcc(n, ochccCircuitSize, iEntityModel, iEntityModel2);
        }

        UpgradeOchncRowData addOchcc(int[] nArray, OchTrailHelper.OchccCircuitSize ochccCircuitSize, IEntityModel iEntityModel, IEntityModel iEntityModel2) {
            return this.model.addOchcc(nArray, ochccCircuitSize, iEntityModel, iEntityModel2);
        }

        void setTrunkCaption() {
            this.captionTA.setText(TRUNKS_CAPTION);
        }

        void setClientsCaption() {
            this.captionTA.setText(CLIENTS_CAPTION);
        }

        void setTrunkAttrs(CircuitCreatInfo.TrunkInfo trunkInfo) {
            this.trunkAttrs = trunkInfo;
            this.initBottomPane();
        }

        void setProtectionAttrs(CircuitCreatInfo.ProtectionInfo protectionInfo) {
            this.protectionInfo = protectionInfo;
            this.initBottomPane();
        }

        private JTextField getTF(String string) {
            JTextField jTextField = new JTextField(string);
            jTextField.setMargin(new Insets(0, 5, 0, 5));
            jTextField.setEnabled(false);
            jTextField.setEditable(false);
            return jTextField;
        }

        private JTextField getTF(int n) {
            JTextField jTextField = this.getTF("");
            int n2 = jTextField.getPreferredSize().height;
            Dimension dimension = new Dimension(n, n2);
            jTextField.setMinimumSize(dimension);
            jTextField.setMaximumSize(dimension);
            jTextField.setPreferredSize(dimension);
            return jTextField;
        }

        public void leavingPage() throws Exception {
        }

        public void enteringPage() throws Exception {
        }

        public void refresh() throws Exception {
        }
    }
}

