/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.download;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISecurityModel;
import cerent.cms.model.Operation;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeVersionInfo;
import cerent.cms.ui.SoftMaintDataSource;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.download.SoftMaintCancelDialog;
import cerent.cms.ui.download.SoftMaintSelDialog;
import cerent.cms.ui.download.SoftMaintTableModel;
import cerent.util.BuildInfo;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.StringHolder;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public abstract class AbstractSoftMaintPane
extends AbstractPane
implements ActionListener,
IJobListener {
    private static final String DOWNLOAD = "Download...";
    private static final String CANCEL = "Cancel...";
    private static final String ACTIVATE = "Activate...";
    private static final String REVERT = "Revert...";
    private static final String ACCEPT = "Accept...";
    private static final String FLASH_INFO = "Info...";
    private static final String DOWNLOAD_TIP = "Download package file as protect software";
    private static final String CANCEL_TIP = "Cancel the currently running download";
    private static final String ACTIVATE_TIP = "Mark newer protect software as working, and run it";
    private static final String REVERT_TIP = "Mark older protect software as working, and run it";
    private static final String ACCEPT_TIP = "Accept newer software for standby TSC as working";
    private static final String FLASH_INFO_TIP = "Current working and protect software flash info";
    protected static final String ACTIVATE_TITLE = "Activating";
    protected static final String REVERT_TITLE = "Reverting";
    protected static final String REVERT_WITH_WARNING_TITLE = "Reverting May Cause Traffic Loss";
    private String operationString = "";
    private static final String ACTIVATION_STRING = "Activation";
    private static final String REVERT_STRING = "Revert";
    private String activeVersion = "";
    private String protectVersion = "";
    private static final String OK_TO_CONTINUE = "OK to continue?";
    private static final String FPGA_UPGRADE = "Any FPGA upgrades that occur during this activation\nmight affect traffic.\n\n";
    private static final String FPGA_DOWNGRADE = "Any FPGA downgrades that occur while reverting\nmight affect traffic.\n\n";
    private static final String FPGA_DOWNGRADE_2 = "<br>Also, any FPGA downgrades that occur while reverting might affect<br>traffic.";
    protected static final String ACCEPT_ERROR_MSG = "NE has already accepted the new software";
    private static final String rebootMinutes15327 = "12";
    private static final String rebootMinutes15454 = "4";
    protected JButton downloadButton;
    protected JButton cancelButton;
    protected JButton activateButton;
    protected JButton revertButton;
    protected JButton acceptButton;
    protected JButton infoButton;
    protected SoftMaintDataSource dataSource;
    private String labelText = "";
    protected boolean buttonState = true;
    private JobProgressDialog progressDlg = null;
    private SoftMaintTableModel tableModel;
    protected INodeModel nodeModel;
    protected ISecurityModel secModel;
    protected static final SDebug db = new SDebug("SoftMaintPane");

    public AbstractSoftMaintPane(String string, INodeModel iNodeModel, TabbedView tabbedView) {
        super(string, (IModel)iNodeModel, tabbedView);
        this.nodeModel = iNodeModel;
        if (this.nodeModel != null) {
            this.secModel = this.nodeModel.getSecurityModel();
        }
        if (this.secModel != null) {
            this.secModel.addObserver((Observer)((Object)this));
        }
        this.dataSource = SoftMaintDataSource.instance();
        this.tableModel = new SoftMaintTableModel(this.dataSource);
        this.table = new UTable((TableModel)((Object)this.tableModel));
        ((SoftMaintTableModel)((Object)this.table.getModel())).initTable(this.table);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
        this.add(this.makeButtonPanel(), "South");
        this.add((Component)uScrollPane, "Center");
    }

    protected JPanel makeButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        this.downloadButton = this.makeActionButton(DOWNLOAD);
        this.downloadButton.setToolTipText(DOWNLOAD_TIP);
        this.cancelButton = this.makeActionButton(CANCEL);
        this.cancelButton.setToolTipText(CANCEL_TIP);
        jPanel2.add(this.downloadButton);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "West");
        CSHelpID cSHelpID = this.getHelpID();
        if (this.nodeModel != null) {
            this.activateButton = this.makeActionButton(ACTIVATE);
            this.activateButton.setToolTipText(ACTIVATE_TIP);
            this.revertButton = this.makeActionButton(REVERT);
            this.revertButton.setToolTipText(REVERT_TIP);
            jPanel3.add(this.activateButton);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel3.add(this.revertButton);
            if (((INodeModel)this.getUiModel()).provides(Feature.DETAILED_SW_UPGRADE)) {
                this.acceptButton = this.makeActionButton(ACCEPT);
                this.acceptButton.setToolTipText(ACCEPT_TIP);
                this.infoButton = this.makeActionButton(FLASH_INFO);
                this.infoButton.setToolTipText(FLASH_INFO_TIP);
                jPanel3.add(Box.createHorizontalGlue());
                jPanel3.add(this.acceptButton);
                jPanel3.add(Box.createHorizontalGlue());
                jPanel3.add(this.infoButton);
            }
            if (cSHelpID != null) {
                jPanel3.add(Box.createHorizontalGlue());
                jPanel3.add(new CSHelpButton(cSHelpID));
            }
            jPanel.add((Component)jPanel3, "East");
        } else if (cSHelpID != null) {
            jPanel3.add(new CSHelpButton(cSHelpID));
            jPanel.add((Component)jPanel3, "East");
        }
        return jPanel;
    }

    public CSHelpID getHelpID() {
        return null;
    }

    protected JButton makeActionButton(String string) {
        SecurityLevel securityLevel = SecurityLevel.SUPERUSER;
        JButton jButton = new JButton(string, null);
        if (string.equals(FLASH_INFO)) {
            securityLevel = SecurityLevel.RETRIEVE;
        }
        if (string.equals(DOWNLOAD) || string.equals(CANCEL)) {
            if (this.nodeModel != null) {
                if (this.nodeModel.provides(Feature.SUPPORTS_MAINTENANCE_DOWNLOAD)) {
                    securityLevel = SecurityLevel.MAINTENANCE;
                }
            } else {
                securityLevel = SecurityLevel.RETRIEVE;
            }
        }
        if (string.equals(ACTIVATE) || string.equals(REVERT) || string.equals(ACCEPT)) {
            this.enableOperationButton(jButton, Operation.ACTIVATE_REVERT_SW);
            jButton.addActionListener(this);
        } else if (this.isUserAuthorized(securityLevel)) {
            jButton.addActionListener(this);
        } else {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    protected void enableOperationButton(JComponent jComponent, Operation operation) {
        block7: {
            if (this.nodeModel.isInited() && this.secModel != null) {
                try {
                    if (!this.buttonState) {
                        jComponent.setEnabled(false);
                    } else if (this.nodeModel != null && this.nodeModel.provides(Feature.MULTISHELF)) {
                        SecurityLevel securityLevel = this.secModel.getOperationPrivilege(operation);
                        this.enableComponent(jComponent, (IModel)this.nodeModel, securityLevel);
                    } else {
                        this.enableComponent(jComponent, (IModel)this.nodeModel);
                    }
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    if (!db.on()) break block7;
                    SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
                }
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: start");
        }
        this.requestRefresh(this, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.downloadButton) {
            SoftMaintSelDialog softMaintSelDialog = new SoftMaintSelDialog(this, this.dataSource);
            if (softMaintSelDialog.getSelectedItems().length > 0) {
                this.dataSource.download(softMaintSelDialog.getSelectedFile(), softMaintSelDialog.getSelectedItems(), softMaintSelDialog.getNumThreads());
            }
        } else if (object == this.cancelButton) {
            if (this.getUiModel() instanceof INodeModel && ((INodeModel)this.getUiModel()).provides(Feature.DETAILED_SW_UPGRADE)) {
                this.handleCancelPressDetailed();
            } else {
                this.handleCancelPress();
            }
        } else if (object == this.activateButton) {
            this.swapVersion(4);
            this.operationString = ACTIVATION_STRING;
        } else if (object == this.revertButton) {
            if (this.getUiModel() instanceof INodeModel && ((INodeModel)this.getUiModel()).provides(Feature.DETAILED_SW_UPGRADE)) {
                this.handleRevertPressDetailed();
            } else {
                this.swapVersion(5);
            }
            this.operationString = REVERT_STRING;
        } else if (object == this.acceptButton) {
            this.acceptSw();
        } else if (object == this.infoButton) {
            this.displayFlashInfo();
        }
    }

    protected void handleCancelPress() {
        if (this.dataSource.isDownloadInProgress()) {
            SoftMaintCancelDialog softMaintCancelDialog = new SoftMaintCancelDialog(this, this.dataSource);
            if (softMaintCancelDialog.getSelectedItems().length > 0) {
                this.dataSource.cancelDownload(softMaintCancelDialog.getSelectedItems());
            }
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_DOWNLOAD_NOT_INITIATED);
        }
    }

    protected abstract void handleCancelPressDetailed();

    protected abstract void handleRevertPressDetailed();

    public abstract void cancelSwUpgrade();

    public abstract void acceptSw();

    protected abstract void displayFlashInfo();

    protected void swapVersion(int n) {
        if (this.nodeModel != null) {
            String string;
            String string2 = "";
            boolean bl = false;
            if (n == 4) {
                string = ACTIVATE_TITLE;
                string2 = this.getMessage(ErrorMsg.getString((EID)CEMC.WID_ACTIVATE_MESSAGE), FPGA_UPGRADE);
            } else if (this.nodeModel.getNeType().startsWith("15600")) {
                string = REVERT_TITLE;
                bl = true;
            } else {
                string = REVERT_WITH_WARNING_TITLE;
                string2 = this.getRevertMessage();
            }
            if (!bl && !CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)string2, (String)string)) {
                return;
            }
            try {
                this.dataReboot(this.nodeModel, n);
                String string3 = n == 4 ? ACTIVATE_TITLE : REVERT_TITLE;
                this.dataSource.setStatusString(this.nodeModel, string3);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_COMMUNICATION_ERROR_PARAM_1, abstractCmsIOException.getMessage());
            }
        }
    }

    private void dataReboot(INodeModel iNodeModel, int n) {
        IJobControl iJobControl;
        NodeVersionInfo nodeVersionInfo;
        String string = "";
        string = n == 4 ? ACTIVATE_TITLE : REVERT_TITLE;
        try {
            this.labelText = iNodeModel.getName() + ": " + string;
        }
        catch (Exception exception) {
            this.labelText = string;
        }
        if (this.getNeVersion()) {
            this.labelText = this.labelText + " to " + this.protectVersion;
        }
        if (!iNodeModel.getNeType().startsWith("15600")) {
            this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), string, this.labelText, false, false, 2000);
            nodeVersionInfo = this.progressDlg;
        } else {
            nodeVersionInfo = this.dataSource.getNodeVerInfo(iNodeModel);
        }
        JobController jobController = JobControllerFactory.createJC((int)1);
        try {
            iJobControl = iNodeModel.createDataRebootJob(n, (IJobProgressControl)nodeVersionInfo);
        }
        catch (Exception exception) {
            if (this.progressDlg != null) {
                this.progressDlg.dispose();
            }
            this.progressDlg = null;
            JobControllerFactory.disposeJC((JobController)jobController);
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_REBOOT_FAILED_PARAM_1, (Object)exception.getMessage());
            return;
        }
        jobController.submitJob(new JobGroup(iJobControl, (IJobListener)this, (Object)jobController));
        this.buttonState = false;
        this.runToggleButtons(false);
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, final JobStatus jobStatus, final Object object) {
        if (this.progressDlg != null) {
            this.progressDlg.dispose();
            this.progressDlg = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractSoftMaintPane.this.finishJob(jobStatus, (JobController)object);
            }
        });
    }

    private void finishJob(JobStatus jobStatus, JobController jobController) {
        String string = "???";
        try {
            string = this.nodeModel.getName();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        if (jobStatus.value() == 2) {
            Exception exception = (Exception)jobStatus.getResult();
            if (exception != null) {
                if (exception instanceof IOException) {
                    ErrorMsg.displayWarning((Component)((Object)this), (EID)CEMC.WID_UNKNOWN_DOWNLOAD_OP_STATUS_PARAM_2, this.operationString, string);
                } else {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_JOB_FAIL_MESSAGE_PARAM_1, (Object)exception.getMessage());
                }
            }
        } else if (jobStatus.value() == 4) {
            String string2 = rebootMinutes15454;
            if (this.nodeModel != null && this.nodeModel.getNeType().equals("15327")) {
                string2 = rebootMinutes15327;
            }
            String string3 = this.labelText + " successful, node will reboot.\n" + "This might take up to " + string2 + " minutes ...";
            CerentDialog.infoDialog((Component)((Object)this), (String)string3, (String)"Rebooting");
        }
        this.buttonState = true;
        this.toggleButtons();
        this.dataSource.setStatusString(this.nodeModel, "");
        if (jobController != null && jobController.isIdle()) {
            JobControllerFactory.disposeJC((JobController)jobController);
        }
    }

    private void runToggleButtons(boolean bl) {
        this.buttonState = bl;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractSoftMaintPane.this.toggleButtons();
            }
        });
    }

    protected void toggleButtons() {
        this.downloadButton.setEnabled(this.buttonState);
        this.cancelButton.setEnabled(this.buttonState);
        if (this.activateButton != null) {
            this.enableOperationButton(this.activateButton, Operation.ACTIVATE_REVERT_SW);
            this.enableOperationButton(this.revertButton, Operation.ACTIVATE_REVERT_SW);
        }
        if (this.acceptButton != null) {
            this.enableOperationButton(this.acceptButton, Operation.ACTIVATE_REVERT_SW);
        }
    }

    protected INodeModel getNodeModel() {
        IModel iModel = this.getUiModel();
        return iModel instanceof INodeModel ? (INodeModel)iModel : null;
    }

    public void enteringPage() {
        this.dataSource.setNodeModel(this.nodeModel);
        this.dataSource.update();
    }

    public void leavingPage() throws Exception {
        this.dataSource.setNodeModel(null);
    }

    public void refresh() {
        if (db.on()) {
            db.println("Refreshing pane");
        }
        if (this.activateButton != null) {
            this.enableOperationButton(this.activateButton, Operation.ACTIVATE_REVERT_SW);
            this.enableOperationButton(this.revertButton, Operation.ACTIVATE_REVERT_SW);
        }
        if (this.acceptButton != null) {
            this.enableOperationButton(this.acceptButton, Operation.ACTIVATE_REVERT_SW);
        }
    }

    private String getActiveVersion() {
        if (this.activeVersion.equals("DEV")) {
            return this.activeVersion;
        }
        return this.activeVersion.substring(0, 5);
    }

    private int getMajorVersion(String string) {
        try {
            String string2 = string.substring(0, 1);
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private int getMinorVersion(String string) {
        try {
            String string2 = string.substring(2, 3);
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private String getProtectVersion() {
        try {
            if (this.protectVersion.equals("DEV")) {
                return this.protectVersion;
            }
            return this.protectVersion.substring(0, 5);
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    private String getHtmlMessage(String string) {
        String string2 = "";
        if (this.nodeModel == null || !this.nodeModel.getNeType().startsWith("15600")) {
            string2 = FPGA_DOWNGRADE_2;
        }
        return ErrorMsg.getString((EID)CEMC.WID_REVERT_MESSAGE_3, (Object)string, (Object)string2, (Object)OK_TO_CONTINUE);
    }

    private String getMessage(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.nodeModel == null || !this.nodeModel.getNeType().startsWith("15600")) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(OK_TO_CONTINUE);
        return stringBuffer.toString();
    }

    public String getRevertMessage() {
        String string = null;
        if (this.getNeVersion()) {
            String string2 = this.getActiveVersion();
            String string3 = this.getProtectVersion();
            if (string2.length() > 3 && string3.length() > 3) {
                int n = this.getMajorVersion(string2);
                int n2 = this.getMinorVersion(string2);
                int n3 = this.getMajorVersion(string3);
                int n4 = this.getMinorVersion(string3);
                if (AbstractSoftMaintPane.db.on) {
                    db.println("Active[Major=" + n + " Minor=" + n2 + "] Prot[Major=" + n3 + " Minor=" + n4 + "]");
                }
                if (n != n3 || n2 != n4) {
                    string = this.getHtmlMessage(string3);
                }
            }
        }
        if (string == null) {
            string = this.getMessage(ErrorMsg.getString((EID)CEMC.WID_REVERT_MESSAGE_0), FPGA_DOWNGRADE);
        }
        return string;
    }

    public boolean getNeVersion() {
        StringHolder[] stringHolderArray = new StringHolder[]{new StringHolder(), new StringHolder()};
        int n = -1;
        if (this.nodeModel == null) {
            if (AbstractSoftMaintPane.db.on) {
                db.println("refresh: nodeModel is null");
            }
            return false;
        }
        try {
            if (this.nodeModel.provides(Feature.REMOTE_ELE_V1)) {
                n = this.nodeModel.queryCodeVol(stringHolderArray[0], stringHolderArray[1]);
            } else {
                org.omg.CORBA.StringHolder[] stringHolderArray2 = new org.omg.CORBA.StringHolder[]{new org.omg.CORBA.StringHolder(), new org.omg.CORBA.StringHolder()};
                n = this.nodeModel.queryCodeVol(stringHolderArray2[0], stringHolderArray2[1]);
                stringHolderArray[0].setValue(stringHolderArray2[0].value);
                stringHolderArray[1].setValue(stringHolderArray2[1].value);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return false;
        }
        if (AbstractSoftMaintPane.db.on) {
            db.println("Flash volume " + n + " is active" + "\nSoftware Version in partition flash0: " + BuildInfo.sanitize(stringHolderArray[0].toString()) + "\nSoftware Version in partition flash1: " + BuildInfo.sanitize(stringHolderArray[1].toString()));
        }
        if (n == 0 || n == 1) {
            if (stringHolderArray[n].toString() != null) {
                this.activeVersion = BuildInfo.sanitize(stringHolderArray[n].toString());
            }
            if (stringHolderArray[1 - n].toString() != null) {
                this.protectVersion = BuildInfo.sanitize(stringHolderArray[1 - n].toString());
            }
            if (AbstractSoftMaintPane.db.on) {
                db.println("Active Version is " + this.activeVersion);
                db.println("Protect Version is" + this.protectVersion);
            }
            return true;
        }
        return false;
    }

    public SecurityLevel getPrivilegeLevel() {
        return this.getDefaultPrivilegeLevel();
    }

    public void destroy() {
        this.tableModel.release();
        if (this.secModel != null) {
            this.secModel.deleteObserver((Observer)((Object)this));
            this.secModel = null;
        }
        if (this.activateButton != null) {
            this.activateButton.removeActionListener(this);
        }
        if (this.revertButton != null) {
            this.revertButton.removeActionListener(this);
        }
        if (this.acceptButton != null) {
            this.acceptButton.removeActionListener(this);
        }
        super.destroy();
    }
}

