/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.MissingLink;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.OscNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpMenuItem;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.circuits.CircuitMap;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.network.LinkClass;
import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.NetDomainNode;
import cerent.cms.ui.network.NetLinkBundle;
import cerent.cms.ui.network.NetMapLink;
import cerent.cms.ui.network.NetMapNode;
import cerent.cms.ui.network.NetworkMap;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UPopupMenu;
import cerent.util.job.JobProgressDialog;
import com.cisco.ctc.util.map.IMapFactory;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AbstractNetworkMap
extends MapToolkit
implements Observer {
    public static final int INIT_EMPTY = 0;
    public static final int INIT_NODES = 1;
    public static final int INIT_NODES_PHYLINKS = 2;
    public static final String CMD_SAVE_NODE_POSITION = "Save Node Position";
    public static final String CMD_NODE_RESET_POS = "Reset Node Position";
    public static final String CMD_LAYOUT = "Auto Layout";
    public static final String POSITION_XY = "PositionXY";
    protected Network netModel;
    protected SDebug dbg;
    protected NetworkViewController nvc;
    protected boolean loTopo;
    protected boolean pcaTopo;
    protected boolean showCompositeLink;
    protected boolean layoutInProgress = false;
    private JCheckBoxMenuItem cbShowTDM;
    private JCheckBoxMenuItem cbShowWDM;
    protected VirtualLinksDirector vld = VirtualLinksDirector.instance();
    private Hashtable localCache;

    public AbstractNetworkMap(SDebug sDebug, int n, IMapFactory iMapFactory) {
        this(sDebug, n, iMapFactory, false);
    }

    public AbstractNetworkMap(SDebug sDebug, int n, IMapFactory iMapFactory, boolean bl) {
        this(sDebug, n, iMapFactory, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNetworkMap(SDebug sDebug, int n, IMapFactory iMapFactory, boolean bl, boolean bl2) {
        super(sDebug, iMapFactory);
        if (bl) {
            this.reInitMapToDetailed();
        } else {
            this.reInitMap();
        }
        this.netModel = Network.instance();
        this.dbg = sDebug;
        this.nvc = NetworkViewController.instance();
        this.showCompositeLink = bl2;
        this.localCache = new Hashtable();
        AbstractNetworkMap abstractNetworkMap = this;
        synchronized (abstractNetworkMap) {
            this.netModel.getNetElementCreationNotifier().addObserver(this);
            this.netModel.getNetLinkCreationNotifier().addObserver(this);
            this.netModel.getTopologyCreationNotifier().addObserver(this);
            this.initializeMap(n);
        }
        if (sDebug.on()) {
            sDebug.println("AbstractNetworkMap.<init> finished");
        }
    }

    public void domainDisplayed(MapDomain mapDomain) {
        String string = null;
        if (mapDomain != null) {
            string = mapDomain.getName();
        }
        this.nvc.getVitalStatsPane().setTitle(string);
        this.displayDomain(mapDomain);
    }

    protected void initializeMap(int n) {
        if (n == 0) {
            return;
        }
        Collection collection = this.netModel.getAllElements();
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                INetElement iNetElement = (INetElement)iterator.next();
                if (this.dbg.on()) {
                    this.dbg.println("initializeMap: adding NE " + iNetElement.getHostName());
                }
                this.addNode(iNetElement.getNodeModel(), false, null);
                iNetElement.addObserver(this);
                if (this.dbg.on()) {
                    this.dbg.println("initializeMap: all nodes added");
                }
                if (n != 2) continue;
                if (this.dbg.on()) {
                    this.dbg.println("\tInitializing Links ...");
                }
                this.initializeMapLinks(this.netModel.getNetLinks());
            }
        }
        catch (Exception exception) {
            if (this.dbg.on()) {
                this.dbg.println("Error while Initializing NetworkView: " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected boolean updateCreatesNew() {
        return true;
    }

    protected synchronized MapNode addNode(INodeModel iNodeModel, boolean bl, Object object) {
        MapNode mapNode = this.getMapNode(iNodeModel);
        if (mapNode != null) {
            if (this.dbg.on) {
                this.dbg.println("addNode: node=" + iNodeModel.getName() + " exists, nodeId=" + iNodeModel.getNodeId());
            }
            return mapNode;
        }
        Point2D.Double double_ = NetMapNode.getPositionXY(this, iNodeModel);
        mapNode = super.addNode(iNodeModel, MapPersist.getNodeDomain(iNodeModel), double_.getX(), double_.getY(), object);
        if (mapNode == null) {
            if (this.dbg.on) {
                this.dbg.println("addNode: fail to add " + iNodeModel.getName());
            }
        } else if (this.dbg.on) {
            this.dbg.println("addNode: " + iNodeModel.getName() + " added to map");
        }
        return mapNode;
    }

    public void dispose() {
        if (this.dbg.on()) {
            this.dbg.println("dispose");
        }
        try {
            this.netModel.getNetElementCreationNotifier().deleteObserver(this);
            this.netModel.getNetLinkCreationNotifier().deleteObserver(this);
            this.netModel.getTopologyCreationNotifier().deleteObserver(this);
            this.deleteNetElementObservers();
            this.deleteNetLinkObservers();
            super.destroy();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void deleteNetElementObservers() {
        Collection collection = this.netModel.getAllElements();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                INetElement iNetElement = (INetElement)iterator.next();
                if (iNetElement == null) continue;
                iNetElement.deleteObserver(this);
            }
        }
    }

    public void deleteLink(Object object) {
        if (object instanceof INetLink) {
            this.stopObservingNetLinkAndItsReverse((INetLink)object);
        }
        super.deleteLink(object);
    }

    private void stopObservingNetLinkAndItsReverse(INetLink iNetLink) {
        if (iNetLink != null) {
            INetLink iNetLink2;
            iNetLink.deleteObserver(this);
            if (this.dbg.on()) {
                this.dbg.println("stopped observing " + iNetLink.prettyString());
            }
            if ((iNetLink2 = this.netModel.findReverseLink(iNetLink)) != null) {
                iNetLink2.deleteObserver(this);
                if (this.dbg.on()) {
                    this.dbg.println("stopped observing " + iNetLink2.prettyString());
                }
            }
        }
    }

    private void deleteNetLinkObservers() {
        Collection collection = this.netModel.getNetLinks();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                this.stopObservingNetLinkAndItsReverse(iNetLink);
            }
        }
    }

    protected boolean isProvisioningAllowed() {
        return AbstractPane.isUserAuthorized((IModel)NetworkModel.instance().getCmsHostModel(), SecurityLevel.PROVISIONING);
    }

    protected boolean isSuperuser() {
        return AbstractPane.isUserAuthorized((IModel)NetworkModel.instance().getCmsHostModel(), SecurityLevel.SUPERUSER);
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.isNetworkMap()) {
            super.initPopupMenu(uPopupMenu);
            if (this.isRootGraph()) {
                this.actOrg.setEnabled("Create New Domain...", this.isSuperuser() || MapPersist.storeDomainInPrefs());
                uPopupMenu.addSeparator();
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_SAVE_NODE_POSITION, 80);
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_NODE_RESET_POS, 82);
            }
            uPopupMenu.addSeparator();
            uPopupMenu.add((JMenuItem)new CSHelpMenuItem(NetCSHelpConst.NetworkMap));
        } else {
            if (!this.isRootGraph()) {
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Go To Parent View", 71);
                uPopupMenu.addSeparator();
            }
            this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_in16.gif", "Zoom In", 73);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_out16.gif", "Zoom Out", 79);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, "/images/icons/zoom_selected.gif", "Zoom Selected Area", 83);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Reset Zoom", 90);
            this.actOrg.getAbstractButton("Reset Zoom").setEnabled(this.getZoomCount() != 0);
            uPopupMenu.addSeparator();
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Center View", 67);
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Fit Content to View", 70);
            uPopupMenu.addSeparator();
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Auto Layout...", 76);
            if (!this.isDetailed()) {
                uPopupMenu.addSeparator();
                this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Collapse/Expand Links...", 76);
            }
        }
    }

    protected void initializeMapLinks(Collection collection) {
        if (this.dbg.on()) {
            this.dbg.println("initializeMapLinks NB links=" + collection.size() + " loTopo=" + this.loTopo);
        }
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (!this.isLinkAcceptable(iNetLink)) continue;
                this.addLink(iNetLink, null);
            }
        }
        catch (Exception exception) {
            if (this.dbg.on()) {
                this.dbg.println("Error while Initializing map links: " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public synchronized void addLink(INetLink iNetLink, Object object) {
        this.addLink(iNetLink, object, false);
    }

    public synchronized void addLink(INetLink iNetLink, Object object, boolean bl) {
        Object object2;
        INetLink[] iNetLinkArray;
        INetLink iNetLink2;
        if (iNetLink != null) {
            iNetLink.addObserver(this);
            if (this.dbg.on()) {
                this.dbg.println("Observing: " + iNetLink.prettyString());
            }
        }
        if (iNetLink instanceof DwdmNetLink || this.isDetailed() && iNetLink instanceof VirtualNetLink) {
            MapLink mapLink;
            ILinkModel iLinkModel = iNetLink.getLinkModel();
            if (this.getMapLink(iNetLink) == null && (mapLink = this.addLink(iNetLink, iLinkModel.src(), iLinkModel.dst(), this.getLinkClass(iNetLink), object)) != null) {
                if (this.dbg.on()) {
                    this.dbg.println("Link Model on src " + iLinkModel.src().getHostName());
                    this.dbg.println("Link Model on dst " + iLinkModel.dst().getHostName());
                }
                this.updateLinkState(mapLink);
            }
            return;
        }
        if (!this.isDetailed() && iNetLink instanceof VirtualNetLink) {
            iNetLink2 = (VirtualNetLink)iNetLink;
            try {
                iNetLinkArray = VirtualLinksDirector.getLinkTerminations((VirtualNetLink)iNetLink2);
                for (int i = 0; i < iNetLinkArray.length; ++i) {
                    object2 = (VirtualNetLink)iNetLinkArray[i];
                    if (object2 == iNetLink2) continue;
                    try {
                        if (!VirtualLinksDirector.arePeers((VirtualNetLink)iNetLink2, (VirtualNetLink)object2) || this.getMapLink(object2) == null) continue;
                        if (this.dbg.on()) {
                            this.dbg.println("Discarded VL - this peer is already in map: " + object2);
                        }
                        return;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (this.dbg.on()) {
                            this.dbg.println("Cannot state if vl[" + iNetLink2 + "] and candidate[" + object2 + "] are peers.");
                        }
                        return;
                    }
                }
            }
            catch (MissingLink missingLink) {
                if (this.dbg.on()) {
                    this.dbg.println("Cannot state if vl[" + iNetLink2 + "] is complete.\n" + missingLink.getMessage());
                }
                return;
            }
        }
        if ((iNetLink2 = this.netModel.findReverseLink(iNetLink)) == null) {
            if (this.dbg.on()) {
                this.dbg.println("Cannot find reverse link");
            }
            return;
        }
        iNetLinkArray = iNetLink.getLinkModel();
        ILinkModel iLinkModel = iNetLink2.getLinkModel();
        object2 = this.getMapLink(iNetLink);
        MapLink mapLink = this.getMapLink(iNetLink2);
        if (bl || mapLink == null && object2 == null) {
            MapLink mapLink2;
            if (this.dbg.on()) {
                try {
                    this.dbg.println("New link: " + iNetLink.getSrc().getNodeModel().getName() + "/" + iNetLink.getSrcSlotNumber() + "/" + PortHelper.getConcatenatedString((int[])iNetLink.getSrcPortNumber()) + "/" + iNetLink.getSrcHo() + " - " + iNetLink.getDst().getNodeModel().getName() + "/" + iNetLink.getDstSlotNumber() + "/" + PortHelper.getConcatenatedString((int[])iNetLink.getDstPortNumber()) + "/" + iNetLink.getDstHo());
                }
                catch (Exception exception) {
                    this.dbg.println("problem printing debugged new link.");
                }
            }
            if ((mapLink2 = this.addLink(iNetLink, iNetLinkArray.src(), iNetLinkArray.dst(), this.getLinkClass(iNetLink), object)) != null) {
                this.updateLinkState(mapLink2);
            }
        } else {
            this.updateLinkState(mapLink);
        }
    }

    private String getLinkClass(Object object) {
        return LinkClass.getLinkClass(object);
    }

    protected boolean isLinkAcceptable(INetLink iNetLink) {
        if (iNetLink instanceof CompositeNetLink && !this.showCompositeLink) {
            return false;
        }
        if (iNetLink instanceof OscNetLink) {
            return false;
        }
        if (this.isNetworkMap() && iNetLink instanceof OchTrailTunnelNetLink) {
            return false;
        }
        if (iNetLink instanceof DwdmNetLink || iNetLink.isVirtual() || iNetLink.getLinkModel().physicalLinkType() == 3) {
            return true;
        }
        boolean bl = (iNetLink.isLOTunnel() || iNetLink.isLOCapable()) && !iNetLink.isLAP();
        boolean bl2 = this.notLot(iNetLink) && !iNetLink.isLAP();
        boolean bl3 = true;
        if (iNetLink instanceof NetLink) {
            NetLink netLink = (NetLink)iNetLink;
            boolean bl4 = bl3 = netLink.inBLSR() && netLink.isPca() || !netLink.inBLSR();
        }
        if (this.loTopo && this.pcaTopo) {
            if (this.dbg.on) {
                this.dbg.println(iNetLink.prettyString());
            }
            if (this.dbg.on) {
                this.dbg.println("    vtTopo && pcaTopo returning " + (bl && bl3));
            }
            return bl && bl3;
        }
        if (this.loTopo) {
            if (this.dbg.on) {
                this.dbg.println(iNetLink.prettyString());
            }
            if (this.dbg.on) {
                this.dbg.println("    loTopo returning " + (bl && !iNetLink.isPca()));
            }
            return bl && !iNetLink.isPca();
        }
        if (this.pcaTopo) {
            if (this.dbg.on) {
                this.dbg.println(iNetLink.prettyString());
            }
            if (this.dbg.on) {
                this.dbg.println("    pcaTopo returning " + (bl3 && bl2));
            }
            return bl3 && bl2;
        }
        if (this.dbg.on) {
            this.dbg.println(iNetLink.prettyString());
        }
        if (this.dbg.on) {
            this.dbg.println("    neither topo returning " + (bl2 && !iNetLink.isPca()));
        }
        return bl2 && !iNetLink.isPca();
    }

    protected boolean notLot(INetLink iNetLink) {
        return !iNetLink.isLOTunnel();
    }

    protected boolean isNetLinkUpBothDirection(INetLink iNetLink) {
        boolean bl;
        boolean bl2 = bl = iNetLink.getLinkModel().state() == 1;
        if (iNetLink instanceof DwdmNetLink) {
            return bl;
        }
        INetLink iNetLink2 = this.netModel.findReverseLink(iNetLink);
        return iNetLink2 != null && bl && iNetLink2.getLinkModel().state() == 1;
    }

    protected void updateLinkState(MapLink mapLink) {
        int n;
        INetLink iNetLink;
        block9: {
            if (mapLink == null || !(mapLink.getUserObject() instanceof INetLink)) {
                return;
            }
            iNetLink = (INetLink)mapLink.getUserObject();
            n = 1;
            if (iNetLink instanceof VirtualNetLink) {
                if (this.vld.isLinkUp((VirtualNetLink)iNetLink)) {
                    n = 2;
                }
            } else {
                try {
                    if (this.isNetLinkUpBothDirection(iNetLink)) {
                        n = 2;
                    }
                }
                catch (Exception exception) {
                    if (!this.dbg.on()) break block9;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (this.dbg.on()) {
            this.dbg.println("\t" + iNetLink.prettyString() + " going to state: " + n);
        }
        ((NetMapLink)mapLink).setState(n);
        if (this.dbg.on()) {
            this.dbg.println("updateLinkState state=" + n);
        }
    }

    public MapLink getDirectionalMapLink(INetLink iNetLink) {
        MapLink mapLink = this.getMapLink(iNetLink);
        if (mapLink == null && (iNetLink = this.netModel.findReverseLink(iNetLink)) != null) {
            mapLink = this.getMapLink(iNetLink);
        }
        return mapLink;
    }

    protected void updateLink(INetLink iNetLink) {
        if (this.dbg.on()) {
            this.dbg.println("updateLink link=" + iNetLink);
            if (iNetLink != null) {
                this.dbg.println("\t" + iNetLink.prettyString());
            }
        }
        MapLink mapLink = this.getMapLink(iNetLink);
        if (iNetLink.isDeleted()) {
            if (this.dbg.on()) {
                this.dbg.println("updateLink: link is deleted");
            }
            if (iNetLink instanceof VirtualNetLink) {
                INetLink[] iNetLinkArray = null;
                iNetLinkArray = VirtualLinksDirector.getAvailLinkTerminations((VirtualNetLink)iNetLink);
                if (this.dbg.on()) {
                    this.dbg.println("updateLink: found " + iNetLinkArray.length + " VL terminations not deleted.");
                }
                if (mapLink == null) {
                    if (this.dbg.on()) {
                        this.dbg.println("updateLink: MapLink is: " + mapLink + " finding out the map link...");
                    }
                    INetLink iNetLink2 = null;
                    for (int i = 0; mapLink == null && i < iNetLinkArray.length; ++i) {
                        mapLink = this.getMapLink(iNetLinkArray[i]);
                        iNetLink2 = iNetLinkArray[i];
                    }
                    if (mapLink != null) {
                        if (this.dbg.on()) {
                            this.dbg.println("updateLink: map link is " + iNetLink2.prettyString());
                        }
                        if (this.dbg.on()) {
                            this.dbg.println("updateLink: removing observer of NL " + iNetLink.prettyString());
                        }
                        iNetLink.deleteObserver(this);
                        if (this.dbg.on()) {
                            this.dbg.println("updateLink: deleting link " + iNetLink2.prettyString() + " from map");
                        }
                        this.deleteLink(iNetLink2);
                        return;
                    }
                    if (this.dbg.on()) {
                        this.dbg.println("updateLink: no map link found");
                    }
                }
            }
            if (this.dbg.on()) {
                this.dbg.println("updateLink: removing observer of NL " + iNetLink.prettyString());
            }
            iNetLink.deleteObserver(this);
            if (mapLink == null && (iNetLink = this.netModel.findReverseLink(iNetLink)) != null) {
                if (this.dbg.on()) {
                    this.dbg.println("updateLink: found reverse link");
                }
                mapLink = this.getMapLink(iNetLink);
            }
            if (mapLink != null) {
                if (this.dbg.on()) {
                    this.dbg.println("updateLink: deleting link " + iNetLink.prettyString() + " from map");
                }
                this.deleteLink(iNetLink);
            }
        } else {
            if (mapLink == null && (iNetLink = this.netModel.findReverseLink(iNetLink)) != null) {
                mapLink = this.getMapLink(iNetLink);
                if (this.dbg.on()) {
                    this.dbg.println("use reverse for: " + mapLink);
                }
            }
            if (mapLink != null) {
                this.updateLinkState(mapLink);
            } else if (this.dbg.on() && iNetLink != null) {
                this.dbg.println("Could not find a maplink for " + iNetLink.prettyString() + " or its reverse link");
            }
        }
    }

    public synchronized void update(Observable observable, Object object) {
        if (this.dbg.on()) {
            this.dbg.println("Received an update from:" + observable + " arg=" + object);
        }
        if (observable instanceof INetLink) {
            if (this.dbg.on()) {
                this.dbg.println("\tUpdate from link: " + ((INetLink)((Object)observable)).prettyString());
            }
            this.updateLink((INetLink)((Object)observable));
        } else if (observable instanceof INetElement) {
            INetElement iNetElement = (INetElement)((Object)observable);
            if (observable != null) {
                MapNode mapNode;
                if (this.dbg.on()) {
                    this.dbg.println("receive topology update from " + iNetElement.getName() + " topoHost=" + (iNetElement.isTopoHost() ? "true" : "false"));
                }
                if ((mapNode = this.getMapNode(iNetElement.getNodeModel())) != null && mapNode instanceof NetMapNode) {
                    ((NetMapNode)mapNode).updateNodeName();
                }
            }
        } else if (observable instanceof Network.NetElementCreationNotifier) {
            if (this.dbg.on()) {
                this.dbg.println("update: received NetElementCreationNotifier event");
            }
            if (this.updateCreatesNew()) {
                INodeModel iNodeModel = ((INetElement)object).getNodeModel();
                ((INetElement)object).addObserver(this);
                this.addNode(iNodeModel, true, null);
            }
        } else if (observable instanceof Network.NetLinkCreationNotifier) {
            INetLink iNetLink;
            if (this.dbg.on()) {
                this.dbg.println("update: received NetLinkCreationNotifier event");
            }
            if (this.isLinkAcceptable(iNetLink = (INetLink)object) && this.updateCreatesNew()) {
                this.addLink(iNetLink, null);
            }
        } else if (observable instanceof Network.TopologyCreationNotifier && this.dbg.on()) {
            this.dbg.println("update: received TopologyCreationNotifier event");
            this.dbg.println("update: NOT IMPLEMENTED");
        }
    }

    protected void doubleClicked(MapNode mapNode) {
        this.openNode(mapNode);
    }

    protected void doubleClicked(MapDomain mapDomain) {
        if (this.isNetworkMap()) {
            this.tryJumpView(new ViewName(mapDomain.getName()));
        } else {
            super.doubleClicked(mapDomain);
        }
    }

    private void openNode(MapNode mapNode) {
        ViewName viewName;
        if (mapNode == null) {
            return;
        }
        INodeModel iNodeModel = (INodeModel)mapNode.getUserObject();
        if (this.isNodeOperational(iNodeModel) && (viewName = new ViewName(iNodeModel.getNodeId())) != null) {
            this.tryJumpView(viewName);
        }
    }

    protected boolean isNodeOperational(INodeModel iNodeModel) {
        if (iNodeModel.isInited() && iNodeModel.getConnectionState()) {
            return true;
        }
        ErrorMsg.displayWarning((Component)this.getGraphWindow(), (EID)NEMC.WID_NODE_NOT_INITIALIZED_PARAM_1, iNodeModel.getName());
        return false;
    }

    public MapDomain createDomain(Object object) {
        return new NetDomainNode(this);
    }

    protected MapLinkBundle createLinkBundle(Node node, Node node2, String string, int n) {
        return new NetLinkBundle(this, node, node2, string, n);
    }

    public boolean getMapProperty(Object object, int n) {
        if (this.isNetworkMap()) {
            return MapPersist.getPersistProperty(object, n);
        }
        if (n == 101) {
            return this.getNodeCoordinatesFromCache((Node)object);
        }
        if (this instanceof CircuitMap && n == 109) {
            return MapPersist.getPersistProperty(object, n);
        }
        if (n == 110 || n == 112) {
            return MapPersist.getPersistProperty(object, n);
        }
        return false;
    }

    public void mapPropertyChanged(Object object, int n, String string, String string2) {
        if (this.isNetworkMap()) {
            MapPersist.setPersistProperty(object, n, string, string2);
        } else if (n == 101) {
            this.saveNodeCoordinatesToCache((Node)object);
        }
    }

    public void domainRemoved(MapDomain mapDomain) {
        if (this.isNetworkMap()) {
            this.nvc.removeDomain(mapDomain);
        }
    }

    public void domainCreated(MapDomain mapDomain) {
        if (this.isNetworkMap()) {
            this.nvc.createDomain(mapDomain);
        }
    }

    public void domainNameChanged(MapDomain mapDomain, String string, String string2) {
        if (this.isNetworkMap()) {
            this.nvc.domainNameChange(mapDomain, string, string2);
        }
    }

    public boolean nodeIsForwardable(MapNode mapNode) {
        Object object = mapNode.getUserObject();
        return object != null && object instanceof INodeModel;
    }

    private void doOpenDomain(MapDomain mapDomain) {
        if (this.isNetworkMap()) {
            if (mapDomain == null) {
                this.tryJumpView(ViewName.ROOT_VIEW);
            } else {
                this.tryJumpView(new ViewName(mapDomain.getName()));
            }
        } else {
            super.displayDomain(mapDomain);
        }
    }

    protected void doGoToRootGraph() {
        if (this.isNetworkMap()) {
            this.nvc.tryJumpView(ViewName.ROOT_VIEW);
        } else {
            super.doGoToRootGraph();
        }
    }

    protected void doGoToNodeDomain(MapNode mapNode) {
        if (!this.isNetworkMap()) {
            super.doGoToNodeDomain(mapNode);
        } else if (mapNode == null) {
            this.tryJumpView(ViewName.ROOT_VIEW);
        } else {
            this.doOpenDomain(mapNode.getRealNode().getDomain());
        }
    }

    protected void tryJumpView(ViewName viewName) {
        if (this.nvc != null && viewName != null) {
            this.nvc.tryJumpView(viewName);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_SAVE_NODE_POSITION) {
            this.doSaveNodePositions();
        } else if (string == CMD_NODE_RESET_POS) {
            this.doResetNodePosition();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected synchronized void doResetNodePosition() {
        if (!CerentDialog.yesNoDialog((Component)JOptionPane.getFrameForComponent(this.getGraphWindow()), (String)"This operation will overwrite previously saved node positions.\nOK to continue?", (String)CMD_NODE_RESET_POS)) {
            return;
        }
        new GetLocThread(JOptionPane.getFrameForComponent(this.getGraphWindow())).start();
    }

    protected synchronized void doSaveNodePositions() {
        if (!CerentDialog.yesNoDialog((Component)JOptionPane.getFrameForComponent(this.getGraphWindow()), (String)"Only nodes where you are a Superuser\nwill be allowed to save.  OK to continue?", (String)CMD_SAVE_NODE_POSITION)) {
            return;
        }
        new SaveLocThread(JOptionPane.getFrameForComponent(this.getGraphWindow())).start();
    }

    private boolean isNetworkMap() {
        return this instanceof NetworkMap;
    }

    protected JButton getAutoLayoutHelpButton() {
        return new CSHelpButton(NetCSHelpConst.AutoLayoutDialog);
    }

    protected boolean getNodeCoordinatesFromCache(Node node) {
        if (node == null) {
            return false;
        }
        boolean bl = false;
        String string = MapPersist.buildLongitudePrefStr(node);
        String string2 = MapPersist.buildLatitudePrefStr(node);
        if (string != null && string2 != null) {
            Double d = (Double)this.localCache.get(string);
            Double d2 = (Double)this.localCache.get(string2);
            if (d != null && d2 != null) {
                node.setCoordinates(d, d2);
                bl = true;
            } else {
                bl = MapPersist.getPersistProperty(node, 101);
                if (bl) {
                    this.saveNodeCoordinatesToCache(node);
                }
            }
        }
        return bl;
    }

    protected void saveNodeCoordinatesToCache(Node node) {
        if (node == null) {
            return;
        }
        String string = MapPersist.buildLongitudePrefStr(node);
        String string2 = MapPersist.buildLatitudePrefStr(node);
        if (string != null && string2 != null) {
            this.localCache.remove(string);
            this.localCache.remove(string2);
            this.localCache.put(string, new Double(node.getCenterX()));
            this.localCache.put(string2, new Double(node.getCenterY()));
        }
    }

    public void setNetMapLinkState(String string, MapLink mapLink, int n) {
        if (mapLink != null) {
            if (mapLink instanceof NetMapLink) {
                NetMapLink netMapLink = (NetMapLink)mapLink;
                netMapLink.setState(n);
            } else {
                Color color = NetMapLink.stateToColor(n);
                this.dbg.println("setNetMapLinkState(): cannot set state.");
                this.dbg.println("\tInstead setting color: " + MapGraphicsUtil.getColorString(color));
                this.dbg.println("\tOffending MapLink: " + mapLink);
                mapLink.setLineColor(color);
            }
        }
    }

    public void setViewToCenter() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractNetworkMap.this.centerView();
            }
        });
    }

    class SaveLocThread
    extends Thread {
        private String message = "";
        private Frame parent;

        public SaveLocThread(Frame frame) {
            this.parent = frame;
        }

        public void run() {
            MapNode[] mapNodeArray = AbstractNetworkMap.this.getMapNodes();
            int n = mapNodeArray.length;
            JobProgressDialog jobProgressDialog = new JobProgressDialog(JOptionPane.getFrameForComponent(AbstractNetworkMap.this.getGraphWindow()), "Saving Node Position", "");
            for (int i = 0; i < n; ++i) {
                jobProgressDialog.setPercentCompleted((int)((float)(i + 1) / (float)n * 100.0f));
                MapNode mapNode = mapNodeArray[i];
                Object object = mapNode.getUserObject();
                if (!(object instanceof INodeModel)) continue;
                String string = "???";
                INodeModel iNodeModel = (INodeModel)object;
                try {
                    string = iNodeModel.getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!AbstractPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.SUPERUSER)) {
                    this.message = this.message + string + " - not authorized\n";
                    continue;
                }
                try {
                    int n2 = MapPersist.toOldX((int)mapNode.getCenterX());
                    int n3 = MapPersist.toOldY((int)mapNode.getCenterY());
                    String string2 = String.valueOf(n2) + "," + String.valueOf(n3);
                    if (AbstractNetworkMap.this.dbg.on) {
                        AbstractNetworkMap.this.dbg.println("doSaveNodePositions: node" + iNodeModel.getName() + " value=" + string2);
                    }
                    iNodeModel.setProperty(AbstractNetworkMap.POSITION_XY, string2);
                }
                catch (Exception exception) {
                    this.message = this.message + string + " - save failed\n";
                }
                try {
                    Thread.sleep(25L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            jobProgressDialog.dispose();
            jobProgressDialog = null;
            if (this.message.length() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        new TextAreaDialog(SaveLocThread.this.parent, "Save Node Position Error", SaveLocThread.this.message, 250, 150);
                    }
                });
            }
        }
    }

    class GetLocThread
    extends Thread {
        private Frame parent;

        public GetLocThread(Frame frame) {
            this.parent = frame;
        }

        public void run() {
            MapNode[] mapNodeArray = AbstractNetworkMap.this.getMapNodes();
            int n = mapNodeArray.length;
            JobProgressDialog jobProgressDialog = new JobProgressDialog(JOptionPane.getFrameForComponent(AbstractNetworkMap.this.getGraphWindow()), "Resetting Node Position", "");
            for (int i = 0; i < n; ++i) {
                jobProgressDialog.setPercentCompleted((int)((float)(i + 1) / (float)n * 100.0f));
                if (mapNodeArray[i] instanceof NetMapNode) {
                    ((NetMapNode)mapNodeArray[i]).resetPosition();
                }
                try {
                    Thread.sleep(25L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            jobProgressDialog.dispose();
            jobProgressDialog = null;
        }
    }
}

