/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CoreNodeModel;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.HoServerTrailModel;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkPhysicalType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.LinkPhysicalType;
import cerent.cms.model.LoServerTrailModel;
import cerent.cms.model.ServerTrailModel;
import cerent.cms.model.ServerTrailsDirector;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.NonRoutableNetLink;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.network.LinkClass;
import cerent.util.HoLoHelper;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.ServerTrailUtil;
import java.util.Iterator;
import java.util.List;

public class MapLinkRenderer {
    private static final SDebug db = new SDebug("MapLinkRenderer");

    public static String getLinkLabel(INetLink iNetLink) {
        StringBuffer stringBuffer = new StringBuffer(MapLinkRenderer.getLinkName(iNetLink) + " (" + MapLinkRenderer.getProtectionTypeLabel(iNetLink) + ")");
        return stringBuffer.toString();
    }

    public static String getProtectionTypeLabel(INetLink iNetLink) {
        String string;
        ILinkModel iLinkModel = iNetLink.getLinkModel();
        StringBuffer stringBuffer = new StringBuffer();
        INetLink iNetLink2 = null;
        iNetLink2 = iNetLink.getReverseLink();
        if (iNetLink2 != null && iNetLink.getPhysicalSize() != iNetLink2.getPhysicalSize()) {
            stringBuffer.append("Unknown");
            return stringBuffer.toString();
        }
        if (iNetLink.isServerTrail()) {
            stringBuffer.append("\"" + iNetLink.getServerTrailIdString() + "\" ");
        }
        stringBuffer.append(MapLinkRenderer.getProtectionTypeString(iNetLink) + " " + MapLinkRenderer.getLinkTypeString(iNetLink, iLinkModel));
        String string2 = LinkClass.getLinkClass(iNetLink);
        if (string2 != null) {
            stringBuffer.append(" " + string2);
        }
        if ((string = MapLinkRenderer.getRingIDString(iLinkModel)).length() > 0) {
            stringBuffer.append(", Ring ID=" + string);
        }
        return stringBuffer.toString();
    }

    public static String getRingIDString(ILinkModel iLinkModel) {
        StringBuffer stringBuffer = new StringBuffer();
        if (iLinkModel != null && iLinkModel instanceof LinkModel && (iLinkModel.protectionType() == 0 || iLinkModel.protectionType() == 4 || iLinkModel.isPca())) {
            stringBuffer.append(((LinkModel)iLinkModel).blsrRingName());
        }
        return stringBuffer.toString();
    }

    protected static String getWavelength(IEntityModel iEntityModel) {
        String string;
        block5: {
            string = null;
            if (iEntityModel.getModuleModel() instanceof IDwdmModuleModel) {
                IDwdmModuleModel iDwdmModuleModel = (IDwdmModuleModel)iEntityModel.getModuleModel();
                try {
                    string = iDwdmModuleModel.getWavelengthAsString();
                    if (string != null) {
                        string = string + "nm";
                        if (MapLinkRenderer.db.on) {
                            db.println("Dwdm Wavelength = " + string);
                        }
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    if (!MapLinkRenderer.db.on) break block5;
                    db.println("getWavelengthAsString not supported");
                }
            }
        }
        return string;
    }

    public static String getLinkName(INetLink iNetLink) {
        String string;
        ILinkModel iLinkModel;
        INetLink iNetLink2;
        String string2;
        ILinkModel iLinkModel2 = iNetLink.getLinkModel();
        ServerTrailModel serverTrailModel = null;
        if (iLinkModel2.src() instanceof CoreNodeModel) {
            string2 = iLinkModel2.src().getName();
        } else if (iNetLink.isServerTrail()) {
            serverTrailModel = ServerTrailsDirector.instance().getTrailModelById(iNetLink.getServerTrailId());
            string2 = serverTrailModel instanceof HoServerTrailModel ? ServerTrailUtil.getEndpointString((IPathDefModel)((HoServerTrailModel)serverTrailModel).getSrcTrailStart()) : ServerTrailUtil.getEndpointString((IPathDefModel)((LoServerTrailModel)serverTrailModel).getSrcTrailStart());
        } else if (iLinkModel2.isVirtual() || iLinkModel2.src() == null) {
            iNetLink2 = Network.instance().findReverseLink(iNetLink);
            iLinkModel = iNetLink2.getLinkModel();
            db.fine("getLineName(" + iNetLink + ") -> reverse is " + iNetLink2 + " revModel is " + iLinkModel);
            string2 = MapLinkRenderer.getEntityString(iLinkModel.dst(), iLinkModel.dstEntityIndex());
        } else {
            string2 = MapLinkRenderer.getEntityString(iLinkModel2.src(), iLinkModel2.srcEntityIndex());
            if (iNetLink.getSrcHo() != null) {
                string2 = string2 + "/" + HoLoHelper.getDisplay(iNetLink.getSrcHo(), true);
            }
        }
        if (string2.equals("unknown")) {
            string2 = iNetLink.getSrc().getName() + "/s" + iNetLink.getSrcSlotNumber() + "/p" + PortHelper.getConcatenatedString((int[])iNetLink.getSrcPortNumber());
        }
        if (iLinkModel2.dst() instanceof CoreNodeModel) {
            string = iLinkModel2.dst().getName();
        } else if (iNetLink.isServerTrail()) {
            string = serverTrailModel instanceof HoServerTrailModel ? ServerTrailUtil.getEndpointString((IPathDefModel)((HoServerTrailModel)serverTrailModel).getDstTrailStart()) : ServerTrailUtil.getEndpointString((IPathDefModel)((LoServerTrailModel)serverTrailModel).getDstTrailStart());
        } else if (iLinkModel2.isVirtual() || iLinkModel2.dst() == null) {
            iNetLink2 = Network.instance().findReverseLink(iNetLink);
            iLinkModel = iNetLink2.getLinkModel();
            db.fine("getLineName(" + iNetLink + ") -> reverse is " + iNetLink2 + " revModel is " + iLinkModel);
            string = MapLinkRenderer.getEntityString(iLinkModel.src(), iLinkModel.srcEntityIndex());
        } else {
            string = MapLinkRenderer.getEntityString(iLinkModel2.dst(), iLinkModel2.dstEntityIndex());
            if (iNetLink.getDstHo() != null) {
                string = string + "/" + HoLoHelper.getDisplay(iNetLink.getDstHo(), true);
            }
        }
        if (string.equals("unknown")) {
            string = iNetLink.getDst().getName() + "/s" + iNetLink.getDstSlotNumber() + "/p" + PortHelper.getConcatenatedString((int[])iNetLink.getDstPortNumber());
        }
        if (iNetLink instanceof NonRoutableNetLink) {
            String string3;
            iNetLink2 = (NonRoutableNetLink)iNetLink;
            if (((NonRoutableNetLink)iNetLink2).isSrcDwdmPort() && (iLinkModel = MapLinkRenderer.getEntity(iLinkModel2.src(), iLinkModel2.srcEntityIndex())) != null && (string3 = MapLinkRenderer.getWavelength((IEntityModel)iLinkModel)) != null && string3.length() > 0) {
                string2 = string2 + ", " + string3;
            }
            if (((NonRoutableNetLink)iNetLink2).isDstDwdmPort() && (iLinkModel = MapLinkRenderer.getEntity(iLinkModel2.dst(), iLinkModel2.dstEntityIndex())) != null && (string3 = MapLinkRenderer.getWavelength((IEntityModel)iLinkModel)) != null && string3.length() > 0) {
                string = string + ", " + string3;
            }
        }
        return string2.compareTo(string) < 0 ? string2 + " - " + string : string + " - " + string2;
    }

    public static String getLinkTypeString(INetLink iNetLink, ILinkModel iLinkModel) {
        int n = iLinkModel.linkType();
        switch (n) {
            case 1: {
                return MapLinkRenderer.getPhysicalLinkString(iNetLink, iLinkModel);
            }
            case 2: {
                String string = "";
                INetElement iNetElement = Network.instance().findNetElem(iLinkModel.src().getNodeId());
                INetElement iNetElement2 = Network.instance().findNetElem(iLinkModel.dst().getNodeId());
                if (iNetElement != null && iNetElement2 != null) {
                    List list = NetCircuitManager.instance().findLoTunnels(iNetElement, iNetElement2, true);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                        ILinkModel iLinkModel2 = iNetCircuit.getLotLink().getLinkModel();
                        if (iLinkModel2.src() == iLinkModel.dst() && iLinkModel2.dst() == iLinkModel.src()) {
                            iLinkModel2 = iNetCircuit.getReverseLotLink().getLinkModel();
                        }
                        if (iLinkModel2.dstEntityIndex() != iLinkModel.dstEntityIndex() || iLinkModel2.dstHo() != iLinkModel.dstHo() || iLinkModel2.srcEntityIndex() != iLinkModel.srcEntityIndex() || iLinkModel2.srcHo() != iLinkModel.srcHo() || iLinkModel2.linkType() != iLinkModel.linkType() || iLinkModel2.protectionType() != iLinkModel.protectionType()) continue;
                        string = " - " + iNetCircuit.getCircuitName();
                    }
                }
                return "LO Tunnel" + string;
            }
            case 4: {
                return MapLinkRenderer.getPhysicalLinkString(iNetLink, iLinkModel) + " Core Network Link";
            }
            case 7: {
                String string = "";
                INetElement iNetElement = Network.instance().findNetElem(iLinkModel.src().getNodeId());
                INetElement iNetElement3 = Network.instance().findNetElem(iLinkModel.dst().getNodeId());
                if (iNetElement != null && iNetElement3 != null) {
                    List list = NetCircuitManager.instance().findLoTunnels(iNetElement, iNetElement3, false);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                        ILinkModel iLinkModel3 = iNetCircuit.getLapLink().getLinkModel();
                        if (iLinkModel3.src() == iLinkModel.dst() && iLinkModel3.dst() == iLinkModel.src()) {
                            iLinkModel3 = iNetCircuit.getReverseLapLink().getLinkModel();
                        }
                        if (iLinkModel3.dstEntityIndex() != iLinkModel.dstEntityIndex() || iLinkModel3.dstHo() != iLinkModel.dstHo() || iLinkModel3.srcEntityIndex() != iLinkModel.srcEntityIndex() || iLinkModel3.srcHo() != iLinkModel.srcHo() || iLinkModel3.linkType() != iLinkModel.linkType() || iLinkModel3.protectionType() != iLinkModel.protectionType()) continue;
                        string = " - " + iNetCircuit.getCircuitName();
                    }
                }
                return "LAP" + string;
            }
            case 6: {
                return MapLinkRenderer.getPhysicalLinkString(iNetLink, iLinkModel);
            }
            case 9: {
                String string = iNetLink.getServerTrailCktSizeString();
                return string;
            }
        }
        return "??";
    }

    public static String getPhysicalLinkString(INetLink iNetLink, ILinkModel iLinkModel) {
        int n = iLinkModel.physicalType();
        ILinkPhysicalType iLinkPhysicalType = LinkPhysicalType.getLinkPhysicalType((int)n);
        IFramingType iFramingType = FramingType.getFramingType((int)iLinkModel.src().getFramingType());
        return iLinkPhysicalType.getDisplayString(iFramingType.isSonet());
    }

    public static String getProtectionTypeString(INetLink iNetLink) {
        INetLink iNetLink2;
        ILinkModel iLinkModel = iNetLink.getLinkModel();
        TDMTerminology tDMTerminology = iLinkModel.src().getTDMTerminology();
        String string = tDMTerminology.getRingTerms(1);
        int n = iNetLink.getProtectionType();
        if ((n == 0 || n == 4 || n == 1) && (iNetLink2 = iNetLink.getReverseLink()) != null && iNetLink.getProtectionType() != iNetLink2.getProtectionType()) {
            n = 3;
        }
        switch (n) {
            case 0: {
                return "2F " + string;
            }
            case 4: {
                return "4F " + string;
            }
            case 1: {
                return "1+1";
            }
            case 7: {
                if (iNetLink instanceof NonRoutableNetLink && (((NonRoutableNetLink)(iNetLink2 = (NonRoutableNetLink)iNetLink)).isSrcDwdmPort() || ((NonRoutableNetLink)iNetLink2).isDstDwdmPort())) {
                    return "Splitter";
                }
                return "Y-Cable";
            }
            case 8: {
                return "Splitter";
            }
            case 2: 
            case 10: {
                return "Protected";
            }
            case 5: {
                return "2F-PCA";
            }
            case 6: {
                return "4F-PCA";
            }
            case 11: {
                return string;
            }
            case 13: {
                return "PCA";
            }
            case 15: {
                return "Unknown";
            }
        }
        return "Unprotected";
    }

    public static String getOspfAreaIdString(INetLink iNetLink) {
        long l;
        String string;
        if (iNetLink != null && (string = InetUtil.makeDottedString((int)(l = iNetLink.getOspfAreaId()))) != "") {
            return "OSPF Area Id: " + string;
        }
        return "";
    }

    public static String getEntityString(INodeModel iNodeModel, int n) {
        IEntityModel iEntityModel = MapLinkRenderer.getEntity(iNodeModel, n);
        if (iEntityModel == null) {
            return "unknown";
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(iNodeModel.getName());
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            stringBuffer.append("/shelf");
            stringBuffer.append(iEntityModel.getShelfId());
        }
        stringBuffer.append("/s");
        stringBuffer.append(iEntityModel.getSlot());
        stringBuffer.append("/p");
        if (iEntityModel instanceof IPortModel) {
            stringBuffer.append(PortHelper.getPortNumString((IPortModel)((IPortModel)iEntityModel)));
        } else {
            stringBuffer.append(iEntityModel.getPositionInParent());
        }
        return stringBuffer.toString();
    }

    public static IEntityModel getEntity(INodeModel iNodeModel, int n) {
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
        }
        catch (NullPointerException nullPointerException) {
            db.finest("NPE in getEntity(), node=" + iNodeModel + ", index= " + n + " " + nullPointerException);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.finest("AbstractCmsNoSuchEntityEx in getEntity(), node=" + iNodeModel + ", index= " + n + " " + (Object)((Object)abstractCmsNoSuchEntityException));
        }
        return iEntityModel;
    }
}

