/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.IModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.network.IVitalStatsPaneObject;
import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.NetMapNode;
import cerent.cms.ui.network.NetworkMap;
import cerent.util.SDebug;
import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Image;
import javax.swing.JComponent;

public class NetDomainNode
extends MapDomain
implements IVitalStatsPaneObject {
    private static final SDebug db = new SDebug("NetDomainNode");
    private static final Image[] DOMAIN_IMAGE = new Image[]{NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_green.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_yellow.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_orange.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_red.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_grey.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_blue.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_dkblue.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_magenta.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_green.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_yellow.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_orange.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_red.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_grey.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_blue.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_dkblue.gif"), NetDomainNode.createImage("/images/icons/net/32x32-NetworkCloud_magenta.gif")};

    public NetDomainNode(MapToolkit mapToolkit) {
        super(mapToolkit);
    }

    public void init(Object object, double d, double d2, Object object2) {
        if (db.on()) {
            db.println("init() called");
        }
        super.init(object, d, d2, object2);
    }

    protected Image getIcon() {
        return DOMAIN_IMAGE[this.getState()];
    }

    protected void refreshUI() {
        this.setIcon(this.getIcon());
    }

    public int getState() {
        int n = 0;
        MapNode[] mapNodeArray = this.getNodes();
        for (int i = 0; i < mapNodeArray.length; ++i) {
            NetMapNode netMapNode;
            MapNode mapNode = mapNodeArray[i];
            if (mapNode.isVirtual() || !(mapNode instanceof NetMapNode) || (netMapNode = (NetMapNode)mapNode).getState() <= n) continue;
            n = netMapNode.getState();
        }
        if (this.getChildrenCount() == 0) {
            n = 4;
        }
        return n;
    }

    public String getVitalStatsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Domain:" + this.getName() + "\n");
        int n = this.getChildrenCount();
        stringBuffer.append("# of Nodes:" + n + "\n");
        if (n > 0 && this.getState() != 0) {
            stringBuffer.append("Highest Severity:\n  " + this.getStateDescription());
        }
        return stringBuffer.toString();
    }

    public String getStateDescription() {
        return NetMapNode.getStateDescription(this.getState());
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.isNetworkMap()) {
            super.initPopupMenu(uPopupMenu);
            this.actOrg.setEnabled("Rename Domain...", this.isSuperuser() || MapPersist.storeDomainInPrefs());
            this.actOrg.setEnabled("Remove Domain", this.isSuperuser() || MapPersist.storeDomainInPrefs());
        } else {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, "Open Domain", 79);
        }
    }

    protected boolean isSuperuser() {
        return AbstractPane.isUserAuthorized((IModel)NetworkModel.instance().getCmsHostModel(), SecurityLevel.SUPERUSER);
    }

    private boolean isNetworkMap() {
        return this.mtk instanceof NetworkMap;
    }
}

