/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.CircuitOptDir;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.network.IVitalStatsPaneObject;
import cerent.cms.ui.network.LinkClassIconUtil;
import cerent.cms.ui.network.MapLinkRenderer;
import cerent.cms.ui.network.ProtectionSwitchState;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.DetailedMapLink;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Color;
import java.awt.Image;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class NetMapLink
extends DetailedMapLink
implements IVitalStatsPaneObject {
    private static final SDebug db = new SDebug("NetMapLink");
    public static final int LINK_SELECTED_STATE = 0;
    public static final int LINK_DOWN_STATE = 1;
    public static final int LINK_UP_STATE = 2;
    public static final int LINK_INCLUDED_STATE = 3;
    public static final int LINK_ACTIVE_STATE = 4;
    public static final int LINK_STANDBY_STATE = 5;
    public static final int LINK_EXCLUDED_STATE = 6;
    public static final int LINK_ROLL_STATE = 7;
    public static Color LINK_UNKNOWN_COLOR = Color.gray;
    public static Color LINK_SELECTED_COLOR = Color.yellow;
    public static Color LINK_DOWN_COLOR = Color.gray;
    public static Color LINK_UP_COLOR = Color.green;
    public static Color LINK_INCLUDED_COLOR = Color.blue;
    public static Color LINK_ACTIVE_COLOR = Color.green;
    public static Color LINK_STANDBY_COLOR = Color.magenta;
    public static Color LINK_EXCLUDED_COLOR = Color.red;
    public static Color LINK_ROLL_COLOR = Color.orange;
    private ProtectionSwitchState pss = null;

    public NetMapLink(MapToolkit mapToolkit, MapNode mapNode, MapNode mapNode2, String string) {
        super(mapToolkit, mapNode, mapNode2, string);
    }

    public synchronized void init(Object object, Object object2) {
        super.init(object, object2);
        if (!this.mtk.isDetailed()) {
            this.pss = new ProtectionSwitchState(this.mtk, this);
        }
    }

    public String getToolTipText() {
        Object object = this.getUserObject();
        if (object instanceof INetLink) {
            return this.getNetLinkTooltip();
        }
        return "External Link";
    }

    public String getVitalStatsString() {
        if (!(this.getUserObject() instanceof INetLink)) {
            return "";
        }
        INetLink iNetLink = (INetLink)this.getUserObject();
        StringBuffer stringBuffer = new StringBuffer();
        if (iNetLink instanceof DwdmNetLink) {
            stringBuffer.append(this.getLinkName() + "\n");
            DwdmNetLink dwdmNetLink = (DwdmNetLink)iNetLink;
            stringBuffer.append("Optical Direction: " + CircuitOptDir.getCktOptDirStringFromCktOptDir(dwdmNetLink.getOptLinkDir()) + "\n");
            stringBuffer.append("Optical Ring Name: " + dwdmNetLink.getOptRingName() + "\n");
        } else if (iNetLink.isVirtual()) {
            VirtualNetLink virtualNetLink = (VirtualNetLink)this.getUserObject();
            try {
                VirtualLinksDirector.getLinkTerminations(virtualNetLink);
                if (VirtualLinksDirector.hasSeparateTxRx(virtualNetLink)) {
                    stringBuffer.append("TX " + this.getVLinkName() + "\n");
                    stringBuffer.append("RX " + this.getPeerVLinkName());
                } else {
                    stringBuffer.append(this.getVLinkName());
                }
                stringBuffer.append("\n  Provisionable Patchcord\n");
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Cannot make up the complete VL.\n" + exception.getMessage());
                }
                INetLink[] iNetLinkArray = VirtualLinksDirector.getCoupledLinkTerminations(virtualNetLink);
                for (int i = 0; i < iNetLinkArray.length; ++i) {
                    stringBuffer.append((i > 0 ? "\n" : "") + this.parseVirtualNetLink((VirtualNetLink)iNetLinkArray[i]));
                }
                stringBuffer.append("\n  Incomplete Provisionable Patchcord:");
            }
        } else {
            stringBuffer.append(this.getLinkName() + "\n");
            stringBuffer.append("  " + MapLinkRenderer.getProtectionTypeLabel(iNetLink) + "\n");
            stringBuffer.append("  " + MapLinkRenderer.getOspfAreaIdString(iNetLink) + "\n");
            String string = null;
            if (!this.mtk.isDetailed()) {
                string = this.pss.getProtectionSwitchStateString();
            }
            if (string != null) {
                stringBuffer.append("  Protection Switch: " + string + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String getMenuHeaderText() {
        String string = "";
        try {
            Object object = this.getUserObject();
            if (object != null && object instanceof INetLink) {
                INetLink iNetLink = (INetLink)object;
                if (iNetLink instanceof DwdmNetLink) {
                    DwdmNetLink dwdmNetLink = (DwdmNetLink)iNetLink;
                    string = this.getLinkName() + ", Optical Direction: " + CircuitOptDir.getCktOptDirStringFromCktOptDir(dwdmNetLink.getOptLinkDir()) + ", Optical Ring Name: " + dwdmNetLink.getOptRingName();
                } else {
                    string = MapLinkRenderer.getLinkLabel(iNetLink);
                }
            }
        }
        catch (Exception exception) {
            db.finer("Exception in getTooltip() " + exception);
        }
        return string;
    }

    private String getNetLinkTooltip() {
        String string = "";
        Object object = this.getUserObject();
        if (object instanceof INetLink) {
            Object object2;
            if (object instanceof DwdmNetLink) {
                object2 = (DwdmNetLink)object;
                string = "<html>" + this.getLinkName() + ", Optical Direction: " + CircuitOptDir.getCktOptDirStringFromCktOptDir(((DwdmNetLink)object2).getOptLinkDir()) + ", Optical Ring Name: " + ((DwdmNetLink)object2).getOptRingName();
                String[] stringArray = ((DwdmNetLink)object2).getSpanLoss();
                if (stringArray[0] != "N/A" || stringArray[1] != "N/A" || stringArray[2] != "N/A") {
                    string = string + "<br>Measured Span Loss: " + stringArray[2] + ", Expected Min Span Loss: " + stringArray[0] + ", Expected Max Span Loss: " + stringArray[1];
                }
                string = string + "</html>";
            } else if (object instanceof VirtualNetLink) {
                object2 = (VirtualNetLink)object;
                string = "<html>";
                try {
                    VirtualLinksDirector.getLinkTerminations((VirtualNetLink)object2);
                    string = VirtualLinksDirector.hasSeparateTxRx((VirtualNetLink)object2) ? string + "TX " + this.getVLinkName() + "<br>" + "RX " + this.getPeerVLinkName() + "<br>(Provisionable Patchcord)" : string + this.getVLinkName() + "<br>(Provisionable Patchcord)";
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("Cannot make up the complete VL.\n" + exception.getMessage());
                    }
                    INetLink[] iNetLinkArray = VirtualLinksDirector.getCoupledLinkTerminations((VirtualNetLink)object2);
                    for (int i = 0; i < iNetLinkArray.length; ++i) {
                        string = string + (i > 0 ? "<br>" : "") + this.parseVirtualNetLink((VirtualNetLink)iNetLinkArray[i]);
                    }
                    string = string + "<br>Incomplete Provisionable Patchcord";
                }
                string = string + "</html>";
            } else {
                string = object instanceof OchTrailTunnelNetLink ? this.getLinkName() + " OCH-Trail" : MapLinkRenderer.getLinkLabel((INetLink)object);
            }
            object2 = null;
            if (!this.mtk.isDetailed()) {
                object2 = this.pss.getProtectionSwitchStateString();
            }
            if (object2 != null) {
                string = string + ", " + (String)object2;
            }
        } else {
            string = "External Link";
        }
        return string;
    }

    public String getLinkDesc() {
        INetLink iNetLink = (INetLink)this.getUserObject();
        return MapLinkRenderer.getLinkLabel(iNetLink);
    }

    public String getLinkTypeString() {
        if (!(this.getUserObject() instanceof INetLink)) {
            return "";
        }
        ILinkModel iLinkModel = ((INetLink)this.getUserObject()).getLinkModel();
        return MapLinkRenderer.getLinkTypeString((INetLink)this.getUserObject(), iLinkModel);
    }

    public String getProtectionTypeString() {
        if (!(this.getUserObject() instanceof INetLink)) {
            return "";
        }
        return MapLinkRenderer.getProtectionTypeString((INetLink)this.getUserObject());
    }

    public String getLinkName() {
        if (!(this.getUserObject() instanceof INetLink)) {
            return "";
        }
        return MapLinkRenderer.getLinkName((INetLink)this.getUserObject());
    }

    public String getSrcEntityString() {
        if (!(this.getUserObject() instanceof INetLink)) {
            return "";
        }
        INetLink iNetLink = (INetLink)this.getUserObject();
        return MapLinkRenderer.getEntityString(iNetLink.getSrc().getNodeModel(), iNetLink.getSrcEntityIndex());
    }

    public String getDstEntityString() {
        if (!(this.getUserObject() instanceof INetLink)) {
            return "";
        }
        INetLink iNetLink = (INetLink)this.getUserObject();
        return MapLinkRenderer.getEntityString(iNetLink.getDst().getNodeModel(), iNetLink.getDstEntityIndex());
    }

    public IEntityModel getSrcEntity() {
        if (!(this.getUserObject() instanceof INetLink)) {
            return null;
        }
        INetLink iNetLink = (INetLink)this.getUserObject();
        return MapLinkRenderer.getEntity(iNetLink.getSrc().getNodeModel(), iNetLink.getSrcEntityIndex());
    }

    public IEntityModel getDstEntity() {
        if (!(this.getUserObject() instanceof INetLink)) {
            return null;
        }
        INetLink iNetLink = (INetLink)this.getUserObject();
        return MapLinkRenderer.getEntity(iNetLink.getDst().getNodeModel(), iNetLink.getDstEntityIndex());
    }

    public void setState(int n) {
        final int n2 = n;
        super.setState(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NetMapLink.this.setLineColor(NetMapLink.stateToColor(n2));
            }
        });
    }

    public static Color stateToColor(int n) {
        switch (n) {
            case 1: {
                return LINK_DOWN_COLOR;
            }
            case 2: {
                return LINK_UP_COLOR;
            }
            case 0: {
                return LINK_SELECTED_COLOR;
            }
            case 3: {
                return LINK_INCLUDED_COLOR;
            }
            case 4: {
                return LINK_ACTIVE_COLOR;
            }
            case 5: {
                return LINK_STANDBY_COLOR;
            }
            case 6: {
                return LINK_EXCLUDED_COLOR;
            }
            case 7: {
                return LINK_ROLL_COLOR;
            }
        }
        return LINK_UNKNOWN_COLOR;
    }

    protected static int getLinkAggregatedState(MapLink[] mapLinkArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < mapLinkArray.length; ++i) {
            NetMapLink netMapLink;
            if (!(mapLinkArray[i] instanceof NetMapLink) || (netMapLink = (NetMapLink)mapLinkArray[i]) == null) continue;
            int n7 = netMapLink.getState();
            if (n7 == 2) {
                ++n;
                continue;
            }
            if (n7 == 1) {
                ++n2;
                continue;
            }
            if (n7 == 3) {
                ++n3;
                continue;
            }
            if (n7 == 6) {
                ++n4;
                continue;
            }
            if (n7 == 4) {
                ++n5;
                continue;
            }
            if (n7 != 5) continue;
            ++n6;
        }
        if (n5 > 0) {
            return 4;
        }
        if (n6 > 0) {
            return 5;
        }
        if (n3 > 0) {
            return 3;
        }
        if (n4 > 0) {
            return 6;
        }
        if (n2 > 0) {
            return 1;
        }
        return 2;
    }

    public void destroy() {
        if (!this.mtk.isDetailed()) {
            this.pss.destroy();
        }
        super.destroy();
    }

    protected Image getLinkIcon(String string) {
        return LinkClassIconUtil.getLinkIcon(string);
    }

    public String getVLinkName() {
        String string = "";
        if (this.getUserObject() instanceof VirtualNetLink) {
            VirtualNetLink virtualNetLink = (VirtualNetLink)this.getUserObject();
            string = this.parseVirtualNetLink(virtualNetLink);
        }
        return string;
    }

    public String getPeerVLinkName() {
        String string;
        block5: {
            string = "incomplete";
            try {
                if (!(this.getUserObject() instanceof VirtualNetLink) || !VirtualLinksDirector.hasSeparateTxRx((VirtualNetLink)this.getUserObject())) break block5;
                VirtualNetLink virtualNetLink = (VirtualNetLink)this.getUserObject();
                Collection collection = Network.instance().getNetLinks();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    INetLink iNetLink = (INetLink)iterator.next();
                    if (!(iNetLink instanceof VirtualNetLink)) continue;
                    VirtualNetLink virtualNetLink2 = (VirtualNetLink)iNetLink;
                    try {
                        if (!VirtualLinksDirector.arePeers(virtualNetLink, virtualNetLink2)) continue;
                        string = this.parseVirtualNetLink(virtualNetLink2);
                        break;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) continue;
                        db.println("Cannot state if myVL[" + virtualNetLink + "] and vl[" + virtualNetLink2 + "] are peers.");
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block5;
                db.println("Cannot state if vl[" + (VirtualNetLink)this.getUserObject() + "] has separate Tx/Rx.\n" + abstractCmsNoSuchEntityException.getMessage());
            }
        }
        return string;
    }

    private String formatLinkName(INodeModel iNodeModel, IEntityModel iEntityModel, INodeModel iNodeModel2, IEntityModel iEntityModel2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (VirtualLinksDirector.shouldSwap(iEntityModel, iEntityModel2)) {
            object = iNodeModel;
            IEntityModel iEntityModel3 = iEntityModel;
            iNodeModel = iNodeModel2;
            iEntityModel = iEntityModel2;
            iNodeModel2 = object;
            iEntityModel2 = iEntityModel3;
        }
        stringBuffer.append(iNodeModel.getName());
        if (iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            stringBuffer.append("/sh");
            stringBuffer.append(iEntityModel.getShelfId());
        }
        stringBuffer.append("/s");
        stringBuffer.append(iEntityModel.getSlot());
        stringBuffer.append("/p");
        if (iEntityModel instanceof IPortModel) {
            stringBuffer.append(PortHelper.getPortNumString((IPortModel)((IPortModel)iEntityModel)));
        } else {
            stringBuffer.append(iEntityModel.getPositionInParent());
        }
        object = NetMapLink.getWavelength(iEntityModel);
        if (object != null && ((String)object).length() > 0) {
            stringBuffer.append(", " + (String)object);
        }
        stringBuffer.append(" - ");
        stringBuffer.append(iNodeModel2.getName());
        if (iNodeModel2.provides(Feature.MULTISHELF) && iNodeModel2.isMultishelf()) {
            stringBuffer.append("/sh");
            stringBuffer.append(iEntityModel2.getShelfId());
        }
        stringBuffer.append("/s");
        stringBuffer.append(iEntityModel2.getSlot());
        stringBuffer.append("/p");
        if (iEntityModel2 instanceof IPortModel) {
            stringBuffer.append(PortHelper.getPortNumString((IPortModel)((IPortModel)iEntityModel2)));
        } else {
            stringBuffer.append(iEntityModel2.getPositionInParent());
        }
        object = NetMapLink.getWavelength(iEntityModel2);
        if (object != null && ((String)object).length() > 0) {
            stringBuffer.append(", " + (String)object);
        }
        return stringBuffer.toString();
    }

    protected static String getWavelength(IEntityModel iEntityModel) {
        String string;
        block5: {
            string = null;
            if (iEntityModel.getModuleModel() instanceof IDwdmModuleModel) {
                IDwdmModuleModel iDwdmModuleModel = (IDwdmModuleModel)iEntityModel.getModuleModel();
                try {
                    string = iDwdmModuleModel.getWavelengthAsString();
                    if (string != null) {
                        string = string + "nm";
                        if (NetMapLink.db.on) {
                            db.println("Dwdm Wavelength = " + string);
                        }
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    if (!NetMapLink.db.on) break block5;
                    db.println("getWavelengthAsString not supported");
                }
            }
        }
        return string;
    }

    private String parseVirtualNetLink(VirtualNetLink virtualNetLink) {
        String string;
        block5: {
            Object object;
            string = "unknown";
            Network network = Network.instance();
            ILinkModel iLinkModel = virtualNetLink.getLinkModel();
            ILinkModel iLinkModel2 = null;
            INetLink iNetLink = network.findNetLinkFromLinkModel(iLinkModel);
            if (iNetLink != null) {
                object = network.findReverseLink(iNetLink);
                iLinkModel2 = object != null ? object.getLinkModel() : null;
            }
            object = iLinkModel.src();
            INodeModel iNodeModel = iLinkModel.dst();
            int n = iLinkModel.srcEntityIndex();
            int n2 = iLinkModel.dstEntityIndex();
            if (n == 0 && iLinkModel2 != null) {
                n = iLinkModel2.dstEntityIndex();
            }
            if (n2 == 0 && iLinkModel2 != null) {
                n2 = iLinkModel2.srcEntityIndex();
            }
            try {
                IEntityTableModel iEntityTableModel = object.getEntityTable();
                IEntityTableModel iEntityTableModel2 = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                IEntityModel iEntityModel2 = iEntityTableModel2.getEntityModelByIndex(n2);
                string = this.formatLinkName((INodeModel)object, iEntityModel, iNodeModel, iEntityModel2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return string;
    }
}

