/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.INodeModel;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.network.LinkAccessor;
import cerent.cms.ui.network.NodeAccessor;
import cerent.util.matcher.AbstractMatcher;
import cerent.util.matcher.LongFieldMatcher;
import java.util.ArrayList;

public class NetworkViewFilter {
    private ArrayList matcherList = new ArrayList();
    private NodeAccessor nodeAccessor = new NodeAccessor();
    private LinkAccessor linkAccessor = new LinkAccessor();
    private static final String NODE_TYPE_MATCHER = "NodeTypeMatcher";
    private static final String LINK_TYPE_MATCHER = "LinkTypeMatcher";

    public synchronized boolean doesMatch(INodeModel iNodeModel) {
        boolean bl = false;
        int n = 0;
        if (iNodeModel == null) {
            return bl;
        }
        AbstractMatcher abstractMatcher = null;
        int n2 = this.matcherList.size();
        for (int i = 0; i < n2; ++i) {
            abstractMatcher = (AbstractMatcher)this.matcherList.get(i);
            if (!abstractMatcher.getName().equals(NODE_TYPE_MATCHER)) continue;
            ++n;
            if (!abstractMatcher.doesMatch((Object)iNodeModel)) continue;
            bl = true;
            break;
        }
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean doesMatch(INetLink iNetLink) {
        boolean bl = false;
        int n = 0;
        if (iNetLink == null) {
            return bl;
        }
        AbstractMatcher abstractMatcher = null;
        int n2 = this.matcherList.size();
        for (int i = 0; i < n2; ++i) {
            abstractMatcher = (AbstractMatcher)this.matcherList.get(i);
            if (!abstractMatcher.getName().equals(LINK_TYPE_MATCHER)) continue;
            ++n;
            if (!abstractMatcher.doesMatch((Object)iNetLink)) continue;
            bl = true;
            break;
        }
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public synchronized void addMatcher(AbstractMatcher abstractMatcher) {
        this.matcherList.add(abstractMatcher);
    }

    public synchronized void removeAllMatchers() {
        this.matcherList.clear();
    }

    public AbstractMatcher createNodeTypeMatcher(int n) {
        String string = NODE_TYPE_MATCHER;
        return new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)new NodeTypeAccessor(), null);
    }

    public AbstractMatcher createLinkTypeMatcher(int n) {
        String string = LINK_TYPE_MATCHER;
        return new LongFieldMatcher(string, n, (LongFieldMatcher.IAccessor)new LinkTypeAccessor(), null);
    }

    protected class LinkTypeAccessor
    implements LongFieldMatcher.IAccessor {
        protected LinkTypeAccessor() {
        }

        public long getAttribute(Object object) {
            return NetworkViewFilter.this.linkAccessor.getLinkType((INetLink)object);
        }
    }

    protected class NodeTypeAccessor
    implements LongFieldMatcher.IAccessor {
        protected NodeTypeAccessor() {
        }

        public long getAttribute(Object object) {
            return NetworkViewFilter.this.nodeAccessor.getNodeType((INodeModel)object);
        }
    }
}

