/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.model.NodeModel;
import cerent.cms.ui.IVitalStatsPane;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.network.IVitalStatsPaneObject;
import cerent.cms.ui.network.NetDomainNode;
import cerent.cms.ui.network.NetMapNode;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import java.util.HashSet;

public class SelectionController {
    private MapToolkit mtk;
    private IVitalStatsPane vsp;
    private HashSet selectedObjects = new HashSet();

    SelectionController(MapToolkit mapToolkit, IVitalStatsPane iVitalStatsPane) {
        this.vsp = iVitalStatsPane;
        this.mtk = mapToolkit;
    }

    void isSelected(IVitalStatsPaneObject iVitalStatsPaneObject, boolean bl) {
        if (bl) {
            this.selectedObjects.add(iVitalStatsPaneObject);
        } else {
            this.selectedObjects.remove(iVitalStatsPaneObject);
        }
        this.updateVitalStatsPane(this.getSelectedObject());
    }

    void updateVitalStatsPane(Object object) {
        IVitalStatsPaneObject iVitalStatsPaneObject = (IVitalStatsPaneObject)this.getSelectedObject();
        if (iVitalStatsPaneObject == null) {
            this.vsp.setText("");
            return;
        }
        if (object != iVitalStatsPaneObject) {
            return;
        }
        this.vsp.setText(iVitalStatsPaneObject.getVitalStatsString());
    }

    ViewName getSelectedView() {
        Node node = null;
        try {
            node = this.getSelectedNode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (node != null) {
            if (node instanceof NetMapNode) {
                NodeModel nodeModel = (NodeModel)node.getUserObject();
                if (nodeModel != null && nodeModel.isInited() && nodeModel.getConnectionState()) {
                    return new ViewName(nodeModel.getNodeId());
                }
                ErrorMsg.displayWarning(null, (EID)NEMC.WID_NODE_NOT_INITIALIZED_PARAM_1, nodeModel.getName());
            } else if (node instanceof NetDomainNode) {
                return new ViewName(node.getName());
            }
        }
        return null;
    }

    Object getSelectedObject() {
        if (this.selectedObjects.size() != 1) {
            return null;
        }
        return this.selectedObjects.iterator().next();
    }

    Node getSelectedNode() {
        Object object = this.getSelectedObject();
        if (object != null && object instanceof Node) {
            return (Node)object;
        }
        return null;
    }

    Link getSelectedLink() {
        Object object = this.getSelectedObject();
        if (object != null && object instanceof Link) {
            return (Link)object;
        }
        return null;
    }
}

