/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.IpTunnelCircuitInfo;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.OwCircuitInfo;
import cerent.cms.model.PCMCoding;
import cerent.cms.model.UdcF1CircuitInfo;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.ohcircuits.OhCircuitCreationDialog;
import cerent.util.SDebug;
import cerent.util.gui.GridPanel;
import cerent.util.gui.IntegerDocument;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OhCcdAttrsPane
extends WizardPane
implements ActionListener {
    private OhCircuitCreationDialog parent;
    private JTextField nameTF;
    private JLabel pcmLB;
    private JComboBox typeCB;
    private JComboBox pcmCB;
    private JLabel maxBwLabel;
    private JLabel maxBwPercentLabel;
    private JTextField maxBwTF;
    private JPanel maxBwTP;
    private static final int CKT_NAME_LEN = 48;
    private static int defaultMinVal = 10;
    private static int maxVal = 100;
    private static final SDebug db = new SDebug("OhCcdAttrsPane");

    public OhCcdAttrsPane(String string, OhCircuitCreationDialog ohCircuitCreationDialog) {
        super(string, ohCircuitCreationDialog);
        this.parent = ohCircuitCreationDialog;
        JPanel jPanel = OhCcdAttrsPane.createVerticalPanel("Circuit");
        GridPanel gridPanel = new GridPanel(10, 10);
        this.nameTF = new JTextField();
        gridPanel.addRow("Name:", (JComponent)this.nameTF);
        this.typeCB = new UComboBox((Object[])OhCircuitType.getAllOhCktTypes());
        this.typeCB.addActionListener(this);
        gridPanel.addRow("Type:", (JComponent)this.typeCB);
        this.pcmCB = new UComboBox((Object[])PCMCoding.getAllPCMCodings());
        this.pcmLB = new JLabel("PCM:");
        gridPanel.addRow((JComponent)this.pcmLB, (JComponent)this.pcmCB);
        this.maxBwTP = OhCcdAttrsPane.createHorizontalPanel(null);
        this.maxBwTP.setAlignmentX(0.0f);
        this.maxBwLabel = new JLabel("Maximum Bandwidth: ");
        this.maxBwPercentLabel = new JLabel(" %");
        int n = 0;
        int n2 = 100;
        IntegerDocument integerDocument = new IntegerDocument(n, n2, 3);
        this.maxBwTF = new JTextField(4);
        this.maxBwTF.setDocument(integerDocument);
        this.maxBwTF.setMaximumSize(this.maxBwTF.getPreferredSize());
        this.maxBwLabel.setLabelFor(this.maxBwTF);
        this.maxBwTP.add(this.maxBwLabel);
        this.maxBwTP.add(this.maxBwTF);
        this.maxBwTP.add(this.maxBwPercentLabel);
        gridPanel.addRow((JComponent)this.maxBwTP, 0);
        jPanel.add((Component)gridPanel);
        jPanel.add(Box.createVerticalGlue());
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "West");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OhCircuitType ohCircuitType = (OhCircuitType)this.typeCB.getSelectedItem();
        if (ohCircuitType == null) {
            return;
        }
        this.parent.circuitInfo.setCircuitType(ohCircuitType.getIndex());
        boolean bl = this.forOwCircuit();
        boolean bl2 = this.isIpTunnel();
        boolean bl3 = this.isF1Udc();
        this.pcmLB.setVisible(bl);
        this.pcmCB.setVisible(bl);
        this.maxBwTP.setVisible(bl2);
        this.maxBwLabel.setVisible(bl2);
        this.maxBwPercentLabel.setVisible(bl2);
        this.maxBwTF.setVisible(bl2);
        this.maxBwTF.setEnabled(bl2);
        String string = Integer.toString(10);
        if (this.maxBwTF.isEnabled()) {
            this.maxBwTF.setText(string);
            this.maxBwTF.requestFocus();
            this.maxBwTF.setEditable(bl2);
        }
        if (bl) {
            if (!(this.parent.circuitInfo instanceof OwCircuitInfo)) {
                this.parent.circuitInfo = new OwCircuitInfo(this.parent.circuitInfo);
            }
        } else if (bl2) {
            if (!(this.parent.circuitInfo instanceof IpTunnelCircuitInfo)) {
                this.parent.circuitInfo = new IpTunnelCircuitInfo(this.parent.circuitInfo);
            }
        } else if (bl3 && !(this.parent.circuitInfo instanceof UdcF1CircuitInfo)) {
            this.parent.circuitInfo = new UdcF1CircuitInfo(this.parent.circuitInfo);
        }
    }

    public void validatePage() throws Exception {
        int n = 48;
        if (this.nameTF.getText().length() > n) {
            throw new Exception("Circuit name is too long (max " + n + ")");
        }
        this.parent.circuitInfo.setCircuitName(this.nameTF.getText());
        if (this.typeCB.getSelectedItem() == null) {
            throw new Exception("Circuit Type not selected");
        }
        this.parent.circuitInfo.setCircuitType(((OhCircuitType)this.typeCB.getSelectedItem()).getIndex());
        if (this.forOwCircuit()) {
            ((OwCircuitInfo)this.parent.circuitInfo).setPCMCoding(this.pcmCB.getSelectedIndex());
        }
        if (this.isIpTunnel()) {
            int n2 = Integer.parseInt(this.maxBwTF.getText());
            if (n2 >= defaultMinVal && n2 <= maxVal) {
                ((IpTunnelCircuitInfo)this.parent.circuitInfo).setMaxBwPercent(n2);
            } else {
                throw new Exception(" Bandwidth must be between " + defaultMinVal + " and " + maxVal);
            }
        }
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name: ");
        stringBuffer.append(this.parent.circuitInfo.getCircuitName());
        stringBuffer.append("\nType: ");
        OhCircuitType ohCircuitType = OhCircuitType.getOhCktTypeObj((int)this.parent.circuitInfo.getCircuitType());
        stringBuffer.append(ohCircuitType.getLongName());
        if (this.isIpTunnel()) {
            stringBuffer.append("\nMax Bandwidth: ");
            stringBuffer.append(((IpTunnelCircuitInfo)this.parent.circuitInfo).getMaxBwPercent());
        } else {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void refresh() {
        if (OhCcdAttrsPane.db.on) {
            db.finer("refresh");
        }
        this.nameTF.setText(this.parent.circuitName);
        this.typeCB.setSelectedItem(OhCircuitType.getOhCktTypeObj((int)this.parent.circuitInfo.getCircuitType()));
    }

    public void close() {
        this.typeCB.hidePopup();
    }

    protected boolean forOwCircuit() {
        return OhCircuitType.getOhCktTypeObj((int)this.parent.circuitInfo.getCircuitType()).isOwCircuitType();
    }

    protected boolean isIpTunnel() {
        return OhCircuitType.getOhCktTypeObj((int)this.parent.circuitInfo.getCircuitType()).isIpTunnelType();
    }

    protected boolean isF1Udc() {
        return OhCircuitType.getOhCktTypeObj((int)this.parent.circuitInfo.getCircuitType()).isF1UdcType();
    }

    protected void setPCMCoding(int n) {
        this.pcmCB.setSelectedIndex(n);
    }

    protected void setMaxBwPercent(int n) {
        String string = Integer.toString(n);
        this.maxBwTF.setText(string);
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.OhCcdAttrsPane;
    }
}

