/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IPortModel;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhCircuitEnd;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.SdccCircuitInfo;
import cerent.cms.model.UdcF1CircuitInfo;
import cerent.cms.model.UdcRate;
import cerent.cms.ocm.OhNetCircuitEnd;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.circuits.SortablePortString;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.ohcircuits.OhCcdEndpointsPane;
import cerent.cms.ui.ohcircuits.OhCircuitCreationDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.GridPanel;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class OhCcdEndpointPanel
extends WizardPane
implements ActionListener {
    protected OhNetCircuitEnd endpoint;
    protected final String SHELFID_NC = "1";
    private JLabel dccChannelLB;
    private JComboBox slotCB;
    private JComboBox portCB;
    private JComboBox dccChannelCB;
    private JLabel udcRateLB;
    private JComboBox udcRateCB;
    private JLabel shelfLabel;
    private JComboBox shelfCB;
    private SortedMap slotMap;
    private SortedMap shelfMap;
    private SortedMap portMap;
    private SortedMap dccChannelMap;
    private OhCcdEndpointsPane parent;
    private INodeModel nodeModel;
    private EnhancedPortModel portModel;
    private OhChannelType lastDccChannel;
    private String title;
    private static final SDebug db = new SDebug("OhCcdEndpointPanel");

    public OhCcdEndpointPanel(String string, OhCircuitCreationDialog ohCircuitCreationDialog, OhCcdEndpointsPane ohCcdEndpointsPane) {
        super(string, ohCircuitCreationDialog);
        if (db.on()) {
            db.finer(string + "<init>");
        }
        this.parent = ohCcdEndpointsPane;
        if (string != null) {
            this.setBorder(BorderFactory.createTitledBorder(string));
        }
        this.title = string;
        this.setLayout(new BorderLayout());
        GridPanel gridPanel = new GridPanel(10, 10);
        this.shelfLabel = new JLabel("Shelf ID:");
        this.shelfCB = this.addCB(this.shelfLabel, "shelfCB", gridPanel);
        this.shelfLabel.setVisible(false);
        this.shelfCB.setVisible(false);
        this.slotCB = this.addCB(new JLabel("Slot:"), "slotCB", gridPanel);
        this.portCB = this.addCB(new JLabel("Port:"), "portCB", gridPanel);
        this.dccChannelLB = new JLabel("Channel:");
        this.dccChannelCB = this.addCB(this.dccChannelLB, "dccChannelCB", gridPanel);
        this.udcRateLB = new JLabel("UDC Rate:");
        this.udcRateCB = this.addCB(this.udcRateLB, "udcRateCB", gridPanel);
        this.add((Component)gridPanel);
    }

    void reset() {
        if (db.on()) {
            db.fine(this.title + " reset");
        }
        this.nodeModel = null;
        this.endpoint = new OhNetCircuitEnd();
        this.setCBList(this.shelfCB, null);
        this.setCBList(this.slotCB, null);
        this.setCBList(this.portCB, null);
        this.setCBList(this.dccChannelCB, null);
        this.setCBList(this.udcRateCB, null);
        this.parent.setNextEnabled(false);
        this.refresh();
    }

    private JComboBox addCB(JLabel jLabel, String string, GridPanel gridPanel) {
        UComboBox uComboBox = new UComboBox();
        uComboBox.setName(string);
        uComboBox.addActionListener(this);
        gridPanel.addRow((JComponent)jLabel, (JComponent)uComboBox);
        return uComboBox;
    }

    void setNode(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
        if (this.endpoint.getNodeModel() != iNodeModel) {
            this.endpoint.setNodeModel(iNodeModel);
            this.refresh();
        }
    }

    public void validatePage() throws Exception {
        IOhCircuitEnd iOhCircuitEnd;
        this.debugEndpoint(this.title + " validatePage: ");
        OhCircuitType ohCircuitType = OhCircuitType.getOhCktTypeObj((int)this.parent.getCircuitInfo().getCircuitType());
        if (!this.isFullySelected()) {
            throw new Exception(this.getName() + " is not fully specified");
        }
        IPortModel iPortModel = this.portModel.getPortModel();
        if (this.isMSNode(iPortModel.getNodeModel()) && this.parent.isDestinationPane()) {
            iOhCircuitEnd = this.parent.getCircuitInfo().getSrcPoint();
            int n = iOhCircuitEnd.getNodeId();
            INetElement iNetElement = Network.instance().findNetElem(n);
            INodeModel iNodeModel = iNetElement.getNodeModel();
            try {
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF)) {
                    db.fine("nodeId is " + n + ", pm.nodeId is " + iPortModel.getNodeModel().getNodeId());
                    if (n == iPortModel.getNodeModel().getNodeId() && iOhCircuitEnd.getShelf() != iPortModel.getShelfId()) {
                        db.fine("Src shelf is " + iOhCircuitEnd.getShelf() + " while dst shelf is " + iPortModel.getShelfId());
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_MS_OH_CKT_MUST_USE_SAME_SHELF));
                    }
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.fine("Caught " + (Object)((Object)abstractCmsIOException) + ", unable to fetch NodeId from " + iPortModel);
            }
        }
        iOhCircuitEnd = new OhCircuitEnd(iPortModel.getNodeModel().getNodeId(), this.isMSNode(iPortModel.getNodeModel()) ? iPortModel.getShelfId() : 1, iPortModel.getSlot(), iPortModel.getEntityIndex());
        this.endpoint = new OhNetCircuitEnd(iOhCircuitEnd);
        if (this.parent.isSourcePane()) {
            db.fine("setting src to " + this.endpoint);
            this.parent.getCircuitInfo().setSrcPoint((IOhCircuitEnd)this.endpoint);
        } else {
            db.fine("setting dst to " + this.endpoint);
            this.parent.getCircuitInfo().setDestPoints(new IOhCircuitEnd[]{this.endpoint});
        }
        if (this.forSdccCircuit() || this.forIpTunnelCircuit()) {
            if (!(this.parent.getCircuitInfo() instanceof SdccCircuitInfo)) {
                this.parent.setCircuitInfo(new SdccCircuitInfo(this.parent.getCircuitInfo()));
            }
            SdccCircuitInfo sdccCircuitInfo = (SdccCircuitInfo)this.parent.getCircuitInfo();
            if (this.parent.isSourcePane()) {
                if (this.forIpTunnelCircuit()) {
                    sdccCircuitInfo.setSrcChannelType(OhChannelType.SDCC_IPTUNNEL_OBJ);
                } else {
                    sdccCircuitInfo.setSrcChannelType((OhChannelType)this.dccChannelCB.getSelectedItem());
                }
            } else if (this.forIpTunnelCircuit()) {
                sdccCircuitInfo.setDstChannelType(OhChannelType.SDCC_IPTUNNEL_OBJ);
            } else {
                sdccCircuitInfo.setDstChannelType((OhChannelType)this.dccChannelCB.getSelectedItem());
            }
        } else if (this.forF1UdcCircuit()) {
            if (!(this.parent.getCircuitInfo() instanceof UdcF1CircuitInfo)) {
                this.parent.setCircuitInfo(new UdcF1CircuitInfo(this.parent.getCircuitInfo()));
            }
            UdcF1CircuitInfo udcF1CircuitInfo = (UdcF1CircuitInfo)this.parent.getCircuitInfo();
            if (this.portModel != null && !this.portModel.getPortModel().isOptical()) {
                udcF1CircuitInfo.setPortRate((UdcRate)this.udcRateCB.getSelectedItem());
            }
        }
        if (db.on()) {
            db.fine(this.title + " validatePage: endpoint OK - " + this.endpoint);
        }
    }

    public void refresh() {
        this.debugEndpoint(this.title + " refresh: ");
        this.dccChannelLB.setVisible(this.forSdccCircuit() || this.forIpTunnelCircuit());
        this.dccChannelCB.setVisible(this.forSdccCircuit() || this.forIpTunnelCircuit());
        if (this.nodeModel != null) {
            int n;
            this.getDropPorts();
            if (this.isMSNode(this.nodeModel)) {
                this.shelfCB.setVisible(true);
                this.shelfLabel.setVisible(true);
                this.setCBList(this.shelfCB, this.shelfMap.keySet());
            } else {
                this.shelfCB.setVisible(false);
                this.shelfLabel.setVisible(false);
                this.slotMap = (SortedMap)this.shelfMap.get("1");
                if (this.slotMap != null) {
                    this.setCBList(this.slotCB, this.slotMap.keySet());
                }
            }
            if (this.portModel != null) {
                int n2;
                n = ((DefaultComboBoxModel)this.shelfCB.getModel()).getIndexOf(this.portModel.getShelfString());
                if (n >= 0) {
                    this.shelfCB.setSelectedIndex(n);
                }
                this.setCBList(this.slotCB, ((SortedMap)this.shelfMap.get(this.portModel.getShelfString())).keySet());
                int n3 = ((DefaultComboBoxModel)this.slotCB.getModel()).getIndexOf(this.portModel.getSlotString());
                if (n3 >= 0) {
                    this.slotCB.setSelectedIndex(n3);
                }
                if ((n2 = ((DefaultComboBoxModel)this.portCB.getModel()).getIndexOf(this.portModel.getPortString())) >= 0) {
                    this.portCB.setSelectedIndex(n2);
                }
            }
            if (this.forSdccCircuit() && this.lastDccChannel != null && (n = ((DefaultComboBoxModel)this.dccChannelCB.getModel()).getIndexOf(this.lastDccChannel)) >= 0) {
                this.dccChannelCB.setSelectedIndex(n);
            }
            if (this.slotCB.getSelectedIndex() < 0) {
                this.setCBList(this.portCB, null);
                this.hideUdcRate();
            }
        } else {
            this.setCBList(this.shelfCB, null);
            this.setCBList(this.slotCB, null);
            this.setCBList(this.portCB, null);
            this.setCBList(this.dccChannelCB, null);
            this.hideUdcRate();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.shelfCB) {
            String string = (String)this.shelfCB.getSelectedItem();
            if (this.isNull(string, "shelf")) {
                return;
            }
            this.slotMap = (SortedMap)this.shelfMap.get(string);
            if (this.slotMap.size() == 0) {
                if (db.on()) {
                    db.finer(this.title + " slotMap is empty");
                }
                this.setCBList(this.slotCB, null);
                return;
            }
            Object[] objectArray = this.slotMap.keySet().toArray();
            List<Object> list = Arrays.asList(objectArray);
            this.setCBList(this.slotCB, list);
        } else if (object == this.slotCB) {
            String string = (String)this.slotCB.getSelectedItem();
            if (this.isNull(string, "slot")) {
                return;
            }
            this.portMap = (SortedMap)this.slotMap.get(string);
            if (this.portMap.size() == 0) {
                if (db.on()) {
                    db.finer(this.title + " portMap is empty");
                }
                this.setCBList(this.portCB, null);
                return;
            }
            Object[] objectArray = this.portMap.keySet().toArray();
            List<Object> list = Arrays.asList(objectArray);
            this.setCBList(this.portCB, list);
            if ((this.forSdccCircuit() || this.forIpTunnelCircuit()) && this.portCB.getSelectedIndex() < 0) {
                this.setCBList(this.dccChannelCB, null);
            }
            if (this.forF1UdcCircuit() && this.portCB.getSelectedIndex() < 0) {
                this.hideUdcRate();
            }
        } else if (object == this.portCB) {
            SortablePortString sortablePortString = (SortablePortString)this.portCB.getSelectedItem();
            if (this.isNull(sortablePortString, "port")) {
                return;
            }
            Object v = this.portMap.get(sortablePortString);
            if (!this.forSdccCircuit() && !this.forIpTunnelCircuit()) {
                this.setPortModel((EnhancedPortModel)v);
            } else {
                this.dccChannelMap = (SortedMap)v;
                this.setCBList(this.dccChannelCB, this.dccChannelMap.keySet());
            }
            if (this.forF1UdcCircuit()) {
                boolean bl;
                boolean bl2 = bl = this.portModel != null && !this.portModel.getPortModel().isOptical();
                if (!bl) {
                    this.hideUdcRate();
                } else {
                    this.udcRateLB.setVisible(true);
                    this.udcRateCB.setVisible(true);
                    this.setCBList(this.udcRateCB, (Collection)this.getSupportedUdcRates());
                }
            }
        } else if (object == this.dccChannelCB) {
            OhChannelType ohChannelType = (OhChannelType)this.dccChannelCB.getSelectedItem();
            if (this.isNull(ohChannelType, "newChannelType")) {
                return;
            }
            this.setPortModel((EnhancedPortModel)this.dccChannelMap.get(ohChannelType));
        }
        if (db.on()) {
            db.fine("is endpoint fully selected? " + this.isFullySelected());
        }
        if (this.parent != null && this.isFullySelected()) {
            if (this.parent.isDestinationPane()) {
                this.parent.setFinishEnabled(true);
            } else {
                this.parent.setNextEnabled(true);
            }
        }
    }

    private void hideUdcRate() {
        this.udcRateLB.setVisible(false);
        this.udcRateCB.setVisible(false);
        this.setCBList(this.udcRateCB, null);
    }

    private void getDropPorts() {
        Set set = this.parent.availPorts;
        this.slotMap = new TreeMap();
        this.shelfMap = new TreeMap();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            UdcRate udcRate;
            TreeMap<SortablePortString, EnhancedPortModel> treeMap;
            IPortModel iPortModel = (IPortModel)iterator.next();
            if (iPortModel == null) {
                if (!db.on()) continue;
                db.fine(this.title + " getDropPorts: null entity returned from " + "getAvailDropPorts");
                continue;
            }
            EnhancedPortModel enhancedPortModel = new EnhancedPortModel(iPortModel);
            String string = enhancedPortModel.getSlotString();
            String string2 = enhancedPortModel.getShelfString();
            SortablePortString sortablePortString = enhancedPortModel.getPortString();
            TreeMap treeMap2 = (TreeMap)this.shelfMap.get(string2);
            if (treeMap2 == null) {
                treeMap2 = new TreeMap();
                this.shelfMap.put(string2, treeMap2);
            }
            if ((treeMap = (TreeMap<SortablePortString, EnhancedPortModel>)treeMap2.get(string)) == null) {
                treeMap = new TreeMap<SortablePortString, EnhancedPortModel>();
                treeMap2.put(string, treeMap);
            }
            if (this.forF1UdcCircuit() && this.parent.isDestinationPane()) {
                udcRate = ((UdcF1CircuitInfo)this.parent.getCircuitInfo()).getPortRate();
                if (udcRate != null && !this.supportsUdcRate(iPortModel, udcRate)) continue;
                treeMap.put(sortablePortString, enhancedPortModel);
                continue;
            }
            if (this.forSdccCircuit() || this.forIpTunnelCircuit()) {
                udcRate = new TreeMap();
                IOhConnectionModels iOhConnectionModels = enhancedPortModel.getPortModel().getNodeModel().getOhConnectionModels();
                List<OhChannelType> list = this.forIpTunnelCircuit() ? Arrays.asList(OhChannelType.IPTUNNEL_CHANNEL_TYPES) : Arrays.asList(OhChannelType.DCC_CHANNEL_TYPES);
                for (int i = 0; i < list.size(); ++i) {
                    OhChannelType ohChannelType = list.get(i);
                    if (!iOhConnectionModels.isChannelAvailable(enhancedPortModel.getPortModel().getIndex(), ohChannelType)) continue;
                    udcRate.put(ohChannelType, enhancedPortModel);
                }
                if (udcRate.isEmpty()) continue;
                treeMap.put(sortablePortString, (EnhancedPortModel)udcRate);
                continue;
            }
            treeMap.put(sortablePortString, enhancedPortModel);
        }
    }

    private void setPortModel(EnhancedPortModel enhancedPortModel) {
        if (this.portModel == null || this.portModel.getPortModel() != enhancedPortModel.getPortModel()) {
            this.portModel = enhancedPortModel;
            if (db.on()) {
                db.fine(this.title + " setPortModel: node = " + this.portModel.getPortModel().getNodeModel().getName() + ", shelf = " + this.portModel.getShelfString() + ", slot = " + this.portModel.getSlotString() + ", port = " + this.portModel.getPortString());
            }
        }
        if (this.forSdccCircuit() && this.dccChannelCB.getSelectedItem() != null) {
            this.lastDccChannel = (OhChannelType)this.dccChannelCB.getSelectedItem();
        }
    }

    private void setCBList(List list, Collection collection) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JComboBox)) continue;
            this.setCBList((JComboBox)e, collection);
        }
    }

    private void setCBList(JComboBox jComboBox, Collection collection) {
        jComboBox.removeActionListener(this);
        if (collection != null) {
            Object[] objectArray = collection.toArray();
            if (db.on()) {
                db.fine(this.title + " setCBList: " + jComboBox.getName() + " choices: " + ((AbstractCollection)collection).toString());
            }
            jComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
        }
        jComboBox.setSelectedItem(null);
        if (collection == null) {
            if (db.on()) {
                db.fine(this.title + " setCBList: disabling " + jComboBox.getName());
            }
            jComboBox.setEnabled(false);
        } else {
            jComboBox.addActionListener(this);
            if (jComboBox.getItemCount() == 1) {
                jComboBox.setSelectedIndex(0);
                jComboBox.setEnabled(false);
            } else {
                jComboBox.setEnabled(true);
            }
        }
    }

    private void debugEndpoint(String string) {
        if (db.on()) {
            db.fine(string + "endpoint.node = " + this.nodeModel);
            db.fine(string + "endpoint.entity = " + this.portModel);
            if (this.portModel != null) {
                db.fine(string + "shelf = " + this.portModel.getShelfString());
                db.fine(string + "slot = " + this.portModel.getSlotString());
                db.fine(string + "port = " + this.portModel.getPortString());
            }
        }
    }

    private boolean isNull(Object object, String string) {
        if (object == null) {
            if (db.on()) {
                db.fine(this.title + " " + string + " is null");
            }
            return true;
        }
        return false;
    }

    public void close() {
        this.shelfCB.hidePopup();
        this.slotCB.hidePopup();
        this.portCB.hidePopup();
        this.dccChannelCB.hidePopup();
        this.udcRateCB.hidePopup();
    }

    public void recycle() {
        if (this.shelfMap != null) {
            this.shelfMap.clear();
        }
        if (this.slotMap != null) {
            this.slotMap.clear();
        }
        if (this.portMap != null) {
            this.portMap.clear();
        }
        if (this.dccChannelMap != null) {
            this.dccChannelMap.clear();
        }
        if (this.shelfCB != null) {
            this.shelfCB.removeActionListener(this);
        }
        if (this.slotCB != null) {
            this.slotCB.removeActionListener(this);
        }
        if (this.portCB != null) {
            this.portCB.removeActionListener(this);
        }
        if (this.dccChannelCB != null) {
            this.dccChannelCB.removeActionListener(this);
        }
        this.parent = null;
        this.removeAll();
    }

    protected String getStatusText() {
        return this.asSlashSeparatedString(this.endpoint);
    }

    public String asSlashSeparatedString(OhNetCircuitEnd ohNetCircuitEnd) {
        StringBuffer stringBuffer = new StringBuffer(23);
        try {
            UdcRate udcRate;
            IPortModel iPortModel = (IPortModel)ohNetCircuitEnd.getEntityModel();
            int n = iPortModel.getSlot();
            if (this.isMSNode(iPortModel.getNodeModel())) {
                stringBuffer.append("shelf");
                stringBuffer.append(iPortModel.getShelfId());
                stringBuffer.append("/");
            }
            stringBuffer.append("s");
            stringBuffer.append(n);
            stringBuffer.append("/p");
            stringBuffer.append(PortHelper.getPortNumString((IPortModel)iPortModel));
            stringBuffer.append("\n");
            if (this.forSdccCircuit() || this.forIpTunnelCircuit()) {
                stringBuffer.append("/c ");
                SdccCircuitInfo sdccCircuitInfo = (SdccCircuitInfo)this.parent.getCircuitInfo();
                if (this.parent.isSourcePane()) {
                    stringBuffer.append(sdccCircuitInfo.getSrcChannelType());
                } else {
                    stringBuffer.append(sdccCircuitInfo.getDstChannelType());
                }
            } else if (this.forF1UdcCircuit() && (udcRate = ((UdcF1CircuitInfo)this.parent.getCircuitInfo()).getPortRate()) != null) {
                stringBuffer.append("UDC Rate: " + udcRate.getName());
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unavailable";
        }
        return stringBuffer.toString();
    }

    private boolean isFullySelected() {
        return this.slotCB.getSelectedIndex() >= 0 && this.portCB.getSelectedIndex() >= 0 && (!this.forSdccCircuit() || this.dccChannelCB.getSelectedIndex() >= 0) && !this.udcRateMissing();
    }

    private boolean forSdccCircuit() {
        return this.parent.getCircuitInfo().getCircuitType() == 4;
    }

    private boolean forIpTunnelCircuit() {
        return this.parent.getCircuitInfo().getCircuitType() == 6;
    }

    private boolean forF1UdcCircuit() {
        return this.parent.getCircuitInfo().getCircuitType() == 0;
    }

    private List getSupportedUdcRates() {
        UdcRate[] udcRateArray = new UdcRate[]{UdcRate.CLEAR_CHANNEL_OBJ};
        if (this.portModel != null && !this.portModel.getPortModel().isOptical() && this.nodeModel.provides(Feature.PROV_UDC_RATE)) {
            UdcRate udcRate = ((UdcF1CircuitInfo)this.parent.getCircuitInfo()).getPortRate();
            udcRateArray = udcRate == null || this.parent.isSourcePane() ? UdcRate.getAllUdcRates() : new UdcRate[]{UdcRate.getUdcRateObj((int)udcRate.getIndex())};
        }
        return Arrays.asList(udcRateArray);
    }

    private boolean supportsUdcRate(IPortModel iPortModel, UdcRate udcRate) {
        boolean bl = false;
        if (iPortModel.isOptical() || iPortModel.getNodeModel().provides(Feature.PROV_UDC_RATE)) {
            bl = true;
        } else if (udcRate == UdcRate.UDC_RATE_DEFAULT_OBJ || udcRate == UdcRate.CLEAR_CHANNEL_OBJ) {
            bl = true;
        }
        return bl;
    }

    private boolean udcRateMissing() {
        boolean bl = false;
        if (this.forF1UdcCircuit() && this.portModel != null && !this.portModel.getPortModel().isOptical()) {
            bl = this.udcRateCB.getSelectedIndex() < 0;
        }
        return bl;
    }

    private boolean isMSNode(INodeModel iNodeModel) {
        boolean bl = false;
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            bl = true;
        }
        return bl;
    }

    private class PortComparator
    implements Comparator {
        private PortComparator() {
        }

        public int compare(Object object, Object object2) {
            try {
                if (object == null && object2 == null) {
                    return 0;
                }
                if (object == null) {
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                int n = Integer.parseInt((String)object);
                int n2 = Integer.parseInt((String)object2);
                return n - n2;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
    }

    private class EnhancedPortModel {
        private IPortModel port;
        private String shelfString;
        private String slotString;
        private SortablePortString portString;

        EnhancedPortModel(IPortModel iPortModel) {
            this.port = iPortModel;
            this.createSlotString();
            this.createShelfString();
            this.createPortString();
        }

        void createShelfString() {
            this.shelfString = OhCcdEndpointPanel.this.isMSNode(this.port.getNodeModel()) ? Integer.toString(this.port.getShelfId()) : "1";
        }

        void createSlotString() {
            IModuleModel iModuleModel = this.port.getModuleModel();
            INodeModel iNodeModel = this.port.getNodeModel();
            if (iModuleModel == null) {
                IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel);
                this.slotString = iEntityCellRenderer.getString((Object)this.port.getParent(), null);
            } else {
                IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModel);
                this.slotString = iEntityCellRenderer.getString((Object)iModuleModel, null);
            }
        }

        void createPortString() {
            this.portString = new SortablePortString((IEntityModel)this.port);
            if (!this.port.isOptical()) {
                this.portString.setPortString(this.port.toString());
            }
        }

        IPortModel getPortModel() {
            return this.port;
        }

        String getShelfString() {
            return this.shelfString;
        }

        String getSlotString() {
            return this.slotString;
        }

        SortablePortString getPortString() {
            return this.portString;
        }
    }
}

