/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.model.NodeModel;
import cerent.cms.model.OhCircuitInfo;
import cerent.cms.model.OhCircuitType;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.ohcircuits.OhCcdEndpointPanel;
import cerent.cms.ui.ohcircuits.OhCircuitCreationDialog;
import cerent.cms.ui.ohcircuits.OhNodeSelector;
import cerent.util.AnnotatedException;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class OhCcdEndpointsPane
extends WizardPane
implements ActionListener {
    private JPanel leftPanel;
    private OhNodeSelector nodeCB;
    private OhCcdEndpointPanel mainPanel;
    private OhCcdEndpointsPane excludePanel;
    private String endpointName;
    OhCircuitCreationDialog parent;
    INodeModel nodeModel;
    INodeModel lastNodeModel;
    boolean isSourcePane;
    Set emptySet = new TreeSet();
    Set availPorts = this.emptySet;
    protected static final SDebug db = new SDebug("OhCcdEndpointsPane");

    public OhCcdEndpointsPane(String string, String string2, OhCircuitCreationDialog ohCircuitCreationDialog) {
        super(string, ohCircuitCreationDialog);
        this.parent = ohCircuitCreationDialog;
        this.endpointName = string2;
        this.setLayout(new GridLayout(1, 0));
        this.leftPanel = OhCcdEndpointsPane.createVerticalPanel(null);
        this.add(this.leftPanel);
        JPanel jPanel = OhCcdEndpointsPane.createHorizontalPanel(null);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(new JLabel("Node: ", 0));
        this.nodeCB = new OhNodeSelector(this.getCircuitInfo());
        jPanel.add(this.nodeCB);
        jPanel.add(Box.createHorizontalGlue());
        this.nodeCB.addActionListener(this);
        this.leftPanel.add(jPanel);
        this.mainPanel = new OhCcdEndpointPanel(string2, ohCircuitCreationDialog, this);
        this.leftPanel.add((Component)((Object)this.mainPanel));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.reset();
    }

    void reset() {
        if (db.on()) {
            db.fine(this.endpointName + " reset: nodeModel = null");
        }
        this.nodeModel = null;
        this.lastNodeModel = null;
        this.availPorts = this.emptySet;
        this.mainPanel.reset();
        this.nodeCB.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nodeCB) {
            this.setNode((INodeModel)this.nodeCB.getSelectedItem());
        }
    }

    void setNode(INodeModel iNodeModel) {
        if (iNodeModel == this.nodeModel) {
            if (db.on()) {
                db.fine(this.endpointName + " setNode: NOP, returning");
            }
            return;
        }
        this.nodeModel = iNodeModel;
        if (db.on()) {
            db.fine(this.endpointName + " setNode: nodeModel = " + this.nodeModel);
        }
        if (iNodeModel != null && !iNodeModel.getConnectionState()) {
            if (db.on()) {
                db.fine(this.endpointName + " setNode: " + iNodeModel + " is disconnected");
            }
            this.clearNode(iNodeModel.getName() + " is disconnected: no endpoints are available");
        } else {
            if (this.parent.attrPane.forOwCircuit() && this.isSourcePane()) {
                this.updatePCMCoding();
            }
            try {
                this.updateAvailPorts(iNodeModel);
                this.mainPanel.setNode(iNodeModel);
            }
            catch (AnnotatedException annotatedException) {
                this.clearNode((Object)annotatedException);
            }
        }
    }

    void updatePCMCoding() {
        if (this.nodeModel == null) {
            return;
        }
        int n = this.nodeModel.getNeType().startsWith("15454") ? 0 : 1;
        this.parent.attrPane.setPCMCoding(n);
    }

    private void clearNode(final Object object) {
        if (db.on()) {
            db.fine(this.endpointName + " clearNode: " + object.toString());
        }
        if (object instanceof Throwable) {
            SDebug.printStackTrace((Throwable)((Throwable)object));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (db.on()) {
                    db.fine(OhCcdEndpointsPane.this.endpointName + " Runnable: clearing node");
                }
                if (OhCcdEndpointsPane.this.nodeModel != null) {
                    String string = "Node Selection Error";
                    OhCcdEndpointsPane.this.nodeCB.updateNodeList(OhCcdEndpointsPane.this.getCircuitInfo());
                    OhCcdEndpointsPane.this.nodeCB.setSelectedItem(null);
                    ErrorMsg.displayDetailed((Component)((Object)OhCcdEndpointsPane.this), NEMC.EID_NODE_SELECTION_ERROR, object.toString());
                }
            }
        });
    }

    public OhCcdEndpointPanel getMainPanel() {
        return this.mainPanel;
    }

    public void excludeEndpoints(OhCcdEndpointsPane ohCcdEndpointsPane) {
        this.excludePanel = ohCcdEndpointsPane;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void validatePage() throws Exception {
        if (this.nodeModel == null) {
            throw new Exception(this.endpointName + " node must be selected");
        }
        this.lastNodeModel = this.nodeModel;
        this.mainPanel.validatePage();
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.nodeModel.getName());
        stringBuffer.append("/");
        stringBuffer.append(this.mainPanel.getStatusText());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void refresh() {
        Set set = this.availPorts;
        this.updateNodeList();
        if (this.lastNodeModel != null) {
            if (db.on()) {
                db.println(this.endpointName + " refresh: lastNodeModel = " + this.lastNodeModel);
            }
            if (((DefaultComboBoxModel)this.nodeCB.getModel()).getIndexOf(this.lastNodeModel) < 0) {
                if (db.on()) {
                    db.println("The original node is not available any more.");
                }
                this.lastNodeModel = null;
            }
            this.nodeCB.setSelectedItem(this.lastNodeModel);
        } else {
            if (db.on()) {
                db.println(this.endpointName + " refresh: nodeModel = " + this.nodeModel);
            }
            this.nodeCB.setSelectedItem(this.nodeModel);
        }
        if (set == this.availPorts) {
            if (OhCcdEndpointsPane.db.on) {
                db.println(this.endpointName + " refresh: calling updateAvailPorts");
            }
            try {
                this.updateAvailPorts(this.nodeModel);
            }
            catch (AnnotatedException annotatedException) {
                this.clearNode((Object)annotatedException);
            }
        }
        if (db.on()) {
            db.fine(this.endpointName + " refresh: nodeModel = " + this.nodeModel);
        }
        this.mainPanel.refresh();
    }

    protected void updateNodeList() {
        this.nodeCB.removeActionListener(this);
        IOhCircuitInfo iOhCircuitInfo = this.getCircuitInfo();
        this.nodeCB.updateNodeList(iOhCircuitInfo);
        if (this.isDestinationPane() && iOhCircuitInfo.getCircuitType() == 6) {
            this.nodeCB.removeItem(this.parent.getSourceNode());
        }
        this.nodeCB.addActionListener(this);
        this.nodeCB.setSelectedItem(null);
    }

    public void enteringPage() throws Exception {
        if (this.parent != null) {
            int n = this.getCircuitInfo().getCircuitType();
            if (this.isDestinationPane() && n == 6) {
                this.nodeCB.removeItem((NodeModel)this.parent.getSourceNode());
                if (db.on()) {
                    db.println("Source node: " + this.parent.getSourceNode());
                }
            }
        }
        super.enteringPage();
    }

    public void setNodeList(List list) {
        this.nodeCB.removeActionListener(this);
        if (this.isDestinationPane() && this.getCircuitInfo().getCircuitType() == 6) {
            INodeModel iNodeModel = this.parent.getSourceNode();
            list.remove(iNodeModel);
        }
        this.nodeCB.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.nodeCB.addActionListener(this);
        this.nodeCB.setSelectedItem(null);
    }

    private void updateAvailPorts(INodeModel iNodeModel) throws AnnotatedException {
        if (db.on()) {
            db.fine(this.endpointName + " updateAvailPorts");
        }
        this.availPorts = this.emptySet;
        if (iNodeModel == null) {
            if (db.on()) {
                db.fine(this.endpointName + " updateAvailPorts: got 0 ports from " + "null nodeModel");
            }
            return;
        }
        try {
            Set set;
            OhCircuitType ohCircuitType = OhCircuitType.getOhCktTypeObj((int)this.getCircuitInfo().getCircuitType());
            HashMap<INodeModel, Set> hashMap = (HashMap<INodeModel, Set>)this.parent.availPortsMap.get(ohCircuitType);
            if (hashMap == null) {
                hashMap = new HashMap<INodeModel, Set>();
                this.parent.availPortsMap.put(ohCircuitType, hashMap);
            }
            if ((set = (Set)hashMap.get(iNodeModel)) == null) {
                set = OhCircuitManager.instance().getAvailPortEntities(iNodeModel, this.getCircuitInfo());
                hashMap.put(iNodeModel, set);
            }
            this.availPorts = set;
            if (db.on()) {
                db.fine(this.endpointName + " updateAvailPorts: got " + this.availPorts.size() + " ports");
                db.finer(this.endpointName + "available ports " + ((AbstractCollection)((Object)this.availPorts)).toString());
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("Failure getting list of available ports from " + iNodeModel.getName(), exception);
        }
    }

    public void close() {
        this.nodeCB.hidePopup();
        this.mainPanel.close();
    }

    public void recycle() {
        if (this.mainPanel != null) {
            this.mainPanel.recycle();
            this.mainPanel = null;
        }
        this.availPorts = this.emptySet;
        this.nodeModel = null;
        this.lastNodeModel = null;
        this.parent = null;
        if (this.nodeCB != null) {
            this.nodeCB.removeActionListener(this);
            this.nodeCB.removeAll();
            this.nodeCB = null;
        }
        this.removeAll();
    }

    boolean isSourcePane() {
        return this.parent.getSourcePane() == this;
    }

    boolean isDestinationPane() {
        return this.parent.getDestinationPane() == this;
    }

    IOhCircuitInfo getCircuitInfo() {
        return this.parent.circuitInfo;
    }

    void setCircuitInfo(OhCircuitInfo ohCircuitInfo) {
        this.parent.circuitInfo = ohCircuitInfo;
    }

    void setNextEnabled(boolean bl) {
        this.parent.setNextEnabled(bl);
    }

    void setFinishEnabled(boolean bl) {
        this.parent.setFinishEnabled(bl);
    }

    public CSHelpID getHelpID() {
        if (this.getName().equals("Circuit Source")) {
            return NetCSHelpConst.OhCcdSrcEndpointsPane;
        }
        return NetCSHelpConst.OhCcdDstEndpointsPane;
    }
}

