/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.InvalidBandwidthException;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhCircuitInfo;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ohcircuits.OhNetCircuitModel;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ocm.IpEncapsulatedTunnel;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.route.NoRoute;
import cerent.cms.ui.NetworkProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ohcircuits.OhCircuitEditTabbedView;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IntegerDocument;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OhCedIpTunnelPane
extends NetworkProvPane
implements ActionListener,
DocumentListener,
Runnable {
    private OhCircuit curCircuit;
    private JCheckBox changeCB;
    private JLabel typeLabel;
    private JLabel channelLabel;
    private boolean typeChanged;
    private boolean maxBwChanged;
    private boolean isIpTunnel;
    private JLabel maxBwLabel;
    private JLabel maxBwPercentLabel;
    private JTextField maxBwTF;
    private JPanel maxBwTP;
    private int maxBwPercent;
    public static final String CHANGE_IP = "IP Tunnel";
    private OhCircuitEditTabbedView parentView;
    private int defaultMinVal = 10;
    private int maxVal = 100;
    private static final SDebug db = new SDebug("OhCedIpTunnelPane");

    public OhCedIpTunnelPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.parentView = (OhCircuitEditTabbedView)tabbedView;
        this.setCircuit(((OhNetCircuitModel)tabbedView.getUiModel()).getOhCircuit());
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this.getAttributesPanel());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(new JLabel("Overhead Circuit Type: "));
        this.typeLabel = new JLabel();
        jPanel3.add(this.typeLabel);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(new JLabel("Channel:  "));
        this.channelLabel = new JLabel();
        jPanel3.add(this.channelLabel);
        jPanel2.add(jPanel3);
        jPanel.add(jPanel2);
        this.add(jPanel);
        this.typeChanged = false;
        this.maxBwChanged = false;
        this.updateInfo();
    }

    private void setCircuit(OhCircuit ohCircuit) {
        if (ohCircuit != null) {
            this.curCircuit = ohCircuit;
            this.curCircuit.addObserver((Observer)((Object)this));
            if (ohCircuit.getCircuitTypeObj().isIpTunnelType()) {
                this.isIpTunnel = true;
                this.maxBwPercent = ((IpEncapsulatedTunnel)this.curCircuit).getMaxBwPercent();
            } else if (ohCircuit.getCircuitTypeObj().isDccTunnelType()) {
                this.isIpTunnel = false;
            }
        }
    }

    private JPanel getAttributesPanel() {
        String string;
        JPanel jPanel;
        JPanel jPanel2;
        block4: {
            jPanel2 = OhCedIpTunnelPane.createVerticalPanel("Attributes");
            jPanel2.add(Box.createVerticalStrut(5));
            jPanel = OhCedIpTunnelPane.createHorizontalPanel(null);
            jPanel.setAlignmentX(0.0f);
            string = " ";
            if (!this.isIpTunnel) {
                string = CHANGE_IP;
            } else {
                try {
                    string = Model.getTDMTerminology(this.getUiModel()).getGeneralTerms(8) + " Tunnel";
                }
                catch (AnnotatedException annotatedException) {
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)annotatedException);
                }
            }
        }
        this.changeCB = new JCheckBox("Change to " + string);
        jPanel.add(this.changeCB);
        this.setChangeCB();
        jPanel.add(Box.createHorizontalStrut(354));
        jPanel2.add(jPanel);
        jPanel2.add(this.getMaxBwPanel());
        return jPanel2;
    }

    private JPanel getMaxBwPanel() {
        int n = 3;
        int n2 = 0;
        IntegerDocument integerDocument = new IntegerDocument(n2, this.maxVal, n);
        this.maxBwTP = OhCedIpTunnelPane.createHorizontalPanel(null);
        this.maxBwTP.setAlignmentX(0.0f);
        this.maxBwLabel = new JLabel("Maximum Bandwidth: ");
        this.maxBwPercentLabel = new JLabel("%");
        this.maxBwTF = new JTextField(4);
        this.maxBwTF.setDocument(integerDocument);
        this.maxBwTF.getDocument().addDocumentListener(this);
        this.maxBwTF.setMaximumSize(this.maxBwTF.getPreferredSize());
        this.maxBwLabel.setLabelFor(this.maxBwTF);
        this.maxBwTP.add(this.maxBwLabel);
        this.maxBwTP.add(this.maxBwTF);
        this.maxBwTP.add(this.maxBwPercentLabel);
        this.setMaxBwUI(this.isIpTunnel);
        return this.maxBwTP;
    }

    private void setMaxBwUI(boolean bl) {
        this.maxBwTP.setVisible(bl);
        this.maxBwLabel.setVisible(bl);
        this.maxBwPercentLabel.setVisible(bl);
        this.maxBwTF.setVisible(bl);
        this.maxBwTF.setEnabled(bl);
        String string = this.isIpTunnel ? Integer.toString(((IpEncapsulatedTunnel)this.curCircuit).getMaxBwPercent()) : Integer.toString(10);
        if (bl && this.maxBwTF.isEnabled()) {
            this.maxBwTF.setText(string);
            this.maxBwTF.requestFocus();
            this.maxBwTF.setEditable(bl);
        }
    }

    private void setChangeCB() {
        this.changeCB.addActionListener(this);
    }

    private void setTypeChanged(boolean bl) {
        this.typeChanged = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.changeCB) {
            this.setTypeChanged(this.changeCB.isSelected());
            if (this.changeCB.isSelected()) {
                if (!this.isIpTunnel) {
                    this.setMaxBwUI(true);
                } else {
                    this.maxBwTF.setEnabled(false);
                }
            } else if (this.isIpTunnel) {
                this.maxBwTF.setEnabled(true);
            } else {
                this.setMaxBwUI(false);
            }
            this.setDirty();
        }
    }

    private void typeChanged() {
        String string = null;
        int n = this.maxBwPercent;
        OhCircuit ohCircuit = null;
        Throwable throwable = null;
        boolean bl = this.curCircuit.getCircuitTypeObj().isDccTunnelType();
        if (this.isIpTunnel) {
            n = ((IpEncapsulatedTunnel)this.curCircuit).getMaxBwPercent();
        }
        OhCircuitInfo ohCircuitInfo = OhCircuitManager.instance().createTunnelInfo(this.curCircuit, n, true);
        if (this.curCircuit.getState() == 4) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_OHCIRCUIT_INCOMPLETE);
        } else {
            string = bl ? "Change DCC tunnel to IP Tunnel?" : "Change IP Tunnel to DCC tunnel?";
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)"Change Tunnel")) {
                block18: {
                    try {
                        this.parentView.setUpgradeInProgress(this.typeChanged);
                        ohCircuit = OhCircuitManager.instance().upgradeTunnelCircuit(this.curCircuit, this.maxBwPercent);
                    }
                    catch (AnnotatedException annotatedException) {
                        throwable = annotatedException;
                        if (db.on()) {
                            db.println("Tunnel Change: creating tunnel failed");
                        }
                    }
                    catch (DeletionError deletionError) {
                        throwable = deletionError;
                        if (!db.on()) break block18;
                        db.println("Tunnel Change: creating tunnel failed");
                    }
                }
                if (throwable != null) {
                    if (this.curCircuit.getState() != 4) {
                        this.handleException((Exception)throwable);
                        try {
                            ohCircuit = OhCircuitManager.instance().rollBack(ohCircuitInfo, this.maxBwPercent);
                        }
                        catch (AnnotatedException annotatedException) {
                            if (db.on()) {
                                SDebug.printStackTrace((Throwable)annotatedException);
                            }
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_TUNNEL_ROLLBACK_FAILED, (Object)"Failed");
                        }
                    } else {
                        ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_OHCIRCUIT_INCOMPLETE);
                    }
                }
            }
            if (ohCircuit != null && ohCircuit.getCircuitName().length() > 0) {
                String string2 = ohCircuit.getCircuitName();
                try {
                    ohCircuit.rename(string2);
                    if (OhCedIpTunnelPane.db.on) {
                        db.fine("apply: ckt.rename(\"" + string2 + "\") succeeded ");
                    }
                }
                catch (Exception exception) {
                    AnnotatedException annotatedException = new AnnotatedException("The circuit has been created successfully but could not be renamed  to \" " + string2 + " \" . " + " the circuit to rename it. ", exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_CKT_NAME_PARAM_1, (Object)string2);
                }
            }
        }
        this.parentView.setUpgradeInProgress(false);
    }

    private void handleException(Exception exception) {
        AnnotatedException annotatedException;
        if (exception instanceof AnnotatedException) {
            annotatedException = (AnnotatedException)((Object)exception);
            exception = annotatedException.getChild();
        }
        annotatedException = null;
        if (exception instanceof NoRoute) {
            NoRoute noRoute = (NoRoute)((Object)exception);
            annotatedException = noRoute.getDetailedLog();
            if (annotatedException != null) {
                CerentDialog.errorDialog((Component)((Object)this), (String)ErrorMsg.getString((EID)NEMC.EID_TUNNEL_UPGRADE_ROUTE_FAILED), (String)"Route Error", (DetailedLog)annotatedException, (boolean)false);
            } else {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_TUNNEL_UPGRADE_ROUTE_FAILED, (Object)"Route Error");
            }
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_TUNNEL_UPGRADE_FAILED, (Object)"Upgrade Failed");
        }
    }

    public void applyChangesToModel() {
        String string = this.maxBwTF.getText();
        try {
            if (this.typeChanged) {
                if (!this.isIpTunnel) {
                    this.maxBwPercent = Integer.parseInt(string);
                    this.validateBandwidth(this.maxBwPercent);
                }
                this.typeChanged();
            } else if (this.maxBwChanged && this.isIpTunnel) {
                int n = Integer.parseInt(string);
                this.validateBandwidth(n);
                ((IpEncapsulatedTunnel)this.curCircuit).updateMaxBwPercent(n);
            }
        }
        catch (InvalidBandwidthException invalidBandwidthException) {
            ErrorMsg.displayError((Component)((Object)this), NEMC.EID_IPTUNNEL_BANDWIDTH_ERROR_PARAM_2, String.valueOf(this.defaultMinVal), String.valueOf(this.maxVal));
        }
    }

    private void validateBandwidth(int n) throws InvalidBandwidthException {
        if (n < this.defaultMinVal || n > this.maxVal) {
            throw new InvalidBandwidthException("Invalid bandwidth");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (db.on()) {
            db.println("dispose");
        }
        OhCedIpTunnelPane ohCedIpTunnelPane = this;
        synchronized (ohCedIpTunnelPane) {
            this.curCircuit.deleteObserver((Observer)((Object)this));
            this.curCircuit = null;
        }
        super.destroy();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.maxBwChanged = true;
        this.setDirty();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.maxBwChanged = true;
        this.setDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.maxBwChanged = true;
        this.setDirty();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        if (this.isIpTunnel) {
            int n = ((IpEncapsulatedTunnel)this.curCircuit).getMaxBwPercent();
            this.maxBwTF.setText(Integer.toString(n));
        }
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    public void update(Observable observable, Object object) {
        if (object != ModelUpdateType.DELETED) {
            this.updateInfo();
        }
    }

    private synchronized void updateInfo() {
        if (this.curCircuit == null || this.curCircuit.getState() == 2) {
            return;
        }
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        db.fine("OhCedIpTunnellPane.updateInfo() runnable");
        if (!this.parentView.getUpgradeInProgress() && this.curCircuit.getState() != 4) {
            try {
                this.channelLabel.setText("getChannel");
                OhCircuitType ohCircuitType = this.curCircuit.getCircuitTypeObj();
                String string = ohCircuitType.toString();
                this.typeLabel.setText(string);
                String string2 = "N/A";
                if (ohCircuitType.getIndex() == 6) {
                    string2 = ((IpEncapsulatedTunnel)this.curCircuit).getChannelType().getName();
                    this.maxBwPercent = ((IpEncapsulatedTunnel)this.curCircuit).getMaxBwPercent();
                    db.fine("OhCedIpTunnellPane.updateInfo():" + this.maxBwPercent);
                    if (this.maxBwTF != null) {
                        this.maxBwTF.setText(Integer.toString(this.maxBwPercent));
                    }
                } else if (ohCircuitType.getIndex() == 4) {
                    string2 = OhChannelType.getOhChannelTypeObj((int)0).getName();
                }
                this.channelLabel.setText(string2);
                try {
                    this.refreshFromModel();
                }
                catch (Exception exception) {
                    db.fine("OhCedIpTunnellPane.updateInfo(): Error when refreshing from model.");
                }
            }
            catch (NullPointerException nullPointerException) {
                db.fine("OhCedIpTunnellPane.updateInfo(): Circuit has been set to null while trying to update Pane.");
            }
        } else if (db.on()) {
            db.println("Upgrade in progress");
        }
    }
}

