/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.provalarms;

import cerent.cms.model.Attribute;
import cerent.cms.model.IAlarmModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISetSeverity;
import cerent.cms.model.IStringTag;
import cerent.cms.model.InvalidUpperBound;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractProvTablePane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.provalarms.NodeProfileDeletionDialog;
import cerent.cms.ui.provalarms.ProfileLoadDialog;
import cerent.cms.ui.provalarms.ProfileRenameDialog;
import cerent.cms.ui.provalarms.ProfileStoreDialog;
import cerent.cms.ui.provalarms.ProvAlarmable;
import cerent.cms.ui.provalarms.ProvAlarmsComparePane;
import cerent.cms.ui.provalarms.ProvAlarmsTableCellRenderer;
import cerent.cms.ui.provalarms.ProvAlarmsTableModel;
import cerent.cms.ui.provalarms.ProvAlarmsUsagePane;
import cerent.cms.ui.provalarms.ProvNodeProfile;
import cerent.cms.ui.provalarms.ProvNodeProfileSelector;
import cerent.cms.ui.provalarms.ProvNodeSelector;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FilePropertyEditor;
import cerent.util.gui.FixedLengthDocument;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.ProvAlarmsReader;
import cerent.util.gui.ProvAlarmsWriter;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.MenuElement;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class ProvAlarmsPane
extends AbstractProvTablePane
implements ActionListener,
MouseListener,
TableColumnModelListener {
    protected JCheckBox toggleCheckBox;
    protected JCheckBox hideRowsCheckBox;
    protected JCheckBox showSACheckBox;
    protected int numColumnsSelected = 0;
    protected int numButtons = 12;
    protected JButton[] buttons = new JButton[this.numButtons];
    protected int LOAD_FUNCTION = 0;
    protected int STORE_FUNCTION = 1;
    protected int DELETEPROFILE_FUNCTION = 2;
    protected int CLONEPROFILE_FUNCTION = 3;
    protected int RENAMEPROFILE_FUNCTION = 4;
    protected int REMOVEPROFILE_FUNCTION = 5;
    protected int RESET_FUNCTION = 6;
    protected int COMPAREPROFILE_FUNCTION = 7;
    protected int AVAILABLEPROFILE_FUNCTION = 8;
    protected int USAGEPROFILE_FUNCTION = 9;
    protected int TEST_FUNCTION = 10;
    protected int NEWPROFILE_FUNCTION = 11;
    private static final SDebug db = new SDebug("ProvAlarmsPane");
    static Dimension SELECTIONBOX_DIM = new Dimension(200, 150);
    static Dimension BUTTON0_DIM = new Dimension(75, 25);
    static Dimension BUTTON1_DIM = new Dimension(125, 25);
    static int ALARMTEXT_WIDTH = 250;
    static int PROFILE_WIDTH = 100;
    private static final String HIDE_STRING = "Hide reference values";
    JPopupMenu popup;
    String PREF_SCOPE_VALUE = "warnAlarmProfileScope";
    String PREF_SCOPE_DESCR = "Scope Change Will Lose Alarm Profile Editor Contents";
    boolean isThisGuestPane = false;
    boolean displayedIgnorableInThisInstance = false;

    protected void appendProfileToTable(int n, String string, String string2) {
        TableColumn tableColumn = new TableColumn(n);
        ProvAlarmsTableCellRenderer provAlarmsTableCellRenderer = new ProvAlarmsTableCellRenderer();
        tableColumn.setCellRenderer(provAlarmsTableCellRenderer);
        provAlarmsTableCellRenderer.setInvisibility(this.toggleCheckBox.isSelected());
        provAlarmsTableCellRenderer.setShowSA(this.showSACheckBox.isSelected());
        this.setAlarmCellRenderer(tableColumn);
        tableColumn.setHeaderValue(string);
        this.table.getColumnModel().addColumn(tableColumn);
        tableColumn.setPreferredWidth(PROFILE_WIDTH);
        this.dataModel.fireTableStructureChanged();
        this.triggerToggleCheckBox();
    }

    protected void removeProfileFromTable(String string) {
        TableColumn tableColumn = this.table.getColumn(string);
        this.table.removeColumn(tableColumn);
        this.table.removeColumnSelectionInterval(0, 0);
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn2 = enumeration.nextElement();
            String string2 = (String)tableColumn2.getHeaderValue();
            int n = ((ProvAlarmsTableModel)this.dataModel).columnNameIndex(string2);
            if (db.on()) {
                db.println("Header val: " + string2 + " -> (model offset) " + n);
            }
            tableColumn2.setModelIndex(n);
        }
        if (this.hideRowsCheckBox.isSelected()) {
            ((ProvAlarmsTableModel)this.dataModel).hideIdenticalRows();
        }
        this.triggerToggleCheckBox();
    }

    String profileExists(String string, boolean bl) {
        String string2 = null;
        if (((ProvAlarmsTableModel)this.dataModel).columnNameExists(string)) {
            for (int i = 0; i < 9; ++i) {
                string2 = string + " (Copy " + i + ")";
                if (((ProvAlarmsTableModel)this.dataModel).columnNameExists(string2)) continue;
                String string3 = "Profile \"" + string + "\" exists in the editor.  Renaming this " + " profile to \"" + string2 + "\"";
                if (bl) {
                    CerentDialog.infoDialog((Component)((Object)this), (String)string3, (String)("Loading " + string2));
                } else {
                    db.println(string3);
                }
                return string2;
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANT_IMPORT_PROFILE_PARAM_1, (Object)string);
            return null;
        }
        return string;
    }

    public void OptionPaneTextFieldFocus(JOptionPane jOptionPane, final JTextField jTextField, String string) {
        Component[] componentArray = jOptionPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component[] componentArray2 = ((JPanel)componentArray[i]).getComponents();
            for (int j = 0; j < componentArray2.length; ++j) {
                if (!(componentArray2[j] instanceof JButton) || !((JButton)componentArray2[j]).getText().equals(string)) continue;
                final JButton jButton = (JButton)componentArray2[j];
                jTextField.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jTextField.getText().trim().length() > 0) {
                            jButton.doClick();
                        }
                    }
                });
            }
        }
    }

    protected void syncDirty() {
        this.setDirty(false);
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            if (!((ProvAlarmsTableModel)this.dataModel).columnIsDirty(i)) continue;
            this.setDirty(true);
            break;
        }
    }

    protected boolean containsOnlyStorableProfiles() {
        int[] nArray = this.table.getSelectedColumns();
        if (nArray.length < 1) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            String string = this.table.getColumnName(nArray[i]);
            if (!ProvAlarmsTableModel.permProfileSet.contains(string)) continue;
            return false;
        }
        return true;
    }

    protected void removePermanentProfiles(AbstractCollection abstractCollection) {
        abstractCollection.removeAll(ProvAlarmsTableModel.permProfileSet);
    }

    protected void forceColumnApply(int n) throws Exception {
        ((ProvAlarmsTableModel)this.dataModel).forceDirty(n);
        ((ProvAlarmsTableModel)this.dataModel).applyToColumn(n);
    }

    private void doStoreNode(Object[] objectArray, int[] nArray) {
        if (db.on()) {
            db.println("doStoreNode: ");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((ProvAlarmsTableModel)this.dataModel).verifyProfilesMatchNode((String)objectArray[i]);
            if (db.on()) {
                db.println("\t" + (String)objectArray[i]);
            }
            for (int j = 0; j < nArray.length; ++j) {
                TableColumn tableColumn = this.table.getColumnModel().getColumn(nArray[j]);
                int n = tableColumn.getModelIndex();
                String string = this.dataModel.getColumnName(n);
                if (ProvAlarmsTableModel.permProfileSet.contains(string) || string.startsWith("&")) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_RESERVED_PROFILE_NAME_PARAM_1, (Object)(string + " is a Reserved Profile Name." + " Not Storing."));
                    continue;
                }
                if (db.on()) {
                    db.println("\t\t" + this.table.getColumnName(nArray[j]));
                }
                ((ProvAlarmsTableModel)this.dataModel).addNodeProfileMapping((Component)((Object)this), (String)objectArray[i], this.dataModel.getColumnName(n));
                try {
                    ((ProvAlarmsTableModel)this.dataModel).applyToColumn(n);
                    continue;
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private void doStoreFile(String string, int n) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        int n2 = tableColumn.getModelIndex();
        if (string != null) {
            try {
                ProvAlarmsWriter provAlarmsWriter = new ProvAlarmsWriter(this.dataModel, n2);
                if (!provAlarmsWriter.writeFile(string)) {
                    ErrorMsg.displayError(null, (EID)NEMC.EID_WRITE_FILE_ERROR_PARAM_1, (Object)string);
                }
                ((ProvAlarmsTableModel)this.dataModel).applyToColumn(n2);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void doNewProfile() {
        JTextField jTextField = new JTextField();
        jTextField.setDocument(new FixedLengthDocument(64));
        Object[] objectArray = new Object[]{"New Profile Name", jTextField};
        String string = "OK";
        String string2 = "Cancel";
        Object[] objectArray2 = new Object[]{string, string2};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(jOptionPane);
        arrayList.add(jTextField);
        arrayList.add(this);
        ProfileRenameDialog profileRenameDialog = ProfileRenameDialog.instance((Component)((Object)this), true, "New Profile", arrayList);
        this.OptionPaneTextFieldFocus(jOptionPane, jTextField, string);
        try {
            profileRenameDialog.show();
            Object object = jOptionPane.getValue();
            if (object == null || !object.equals(string)) {
                return;
            }
            String string3 = jTextField.getText();
            if ((string3 = this.profileExists(string3, true)) == null) {
                return;
            }
            ((ProvAlarmsTableModel)this.dataModel).setupNewProfile(string3, "new profile ", 1);
            int n = ((ProvAlarmsTableModel)this.dataModel).columnNameIndex(string3);
            for (int i = 0; i < ((ProvAlarmsTableModel)this.dataModel).getNumAlarms(); ++i) {
                ((ProvAlarmsTableModel)this.dataModel).rawSetValueAt(ISetSeverity.SET_TRANSPARENT, i, n);
            }
            this.forceColumnApply(n);
            this.appendProfileToTable(n, string3, "new profile: ");
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        if (this.hideRowsCheckBox.isSelected()) {
            ((ProvAlarmsTableModel)this.dataModel).hideIdenticalRows();
        }
        this.table.sizeColumnsToFit(-1);
    }

    protected void doImportNode(String string, Object[] objectArray) {
        if (string == null || objectArray.length < 1 || objectArray == null) {
            ErrorMsg.displayError(null, (EID)NEMC.EID_DO_IMPORT_NODE_ERROR);
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Serializable serializable;
            String string2 = (String)objectArray[i];
            String string3 = this.profileExists(string2, true);
            if (string3 == null) continue;
            ((ProvAlarmsTableModel)this.dataModel).setupNewProfile(string3, "loaded from node: " + string, 1);
            int n = ((ProvAlarmsTableModel)this.dataModel).columnNameIndex(string3);
            ProvNodeProfile provNodeProfile = ((ProvAlarmsTableModel)this.dataModel).returnNodeInfo(string);
            INodeModel iNodeModel = provNodeProfile.getNodeModel();
            if (iNodeModel != null) {
                try {
                    int n2;
                    IAlarmModel iAlarmModel = iNodeModel.getAlarmModel();
                    serializable = (ProvAlarmsTableModel)this.dataModel;
                    IStringTag[] iStringTagArray = iAlarmModel.getAlarmableList();
                    String string4 = iAlarmModel.getAlarmSeveritiesFromProfile(string2);
                    if (db.on()) {
                        for (n2 = 0; n2 < iStringTagArray.length; ++n2) {
                            db.println("Alarmable #" + n2 + "\t" + iStringTagArray[n2].getFirst() + "\t" + iStringTagArray[n2].getSecond());
                        }
                    }
                    for (n2 = 0; n2 < iStringTagArray.length; ++n2) {
                        String string5 = ProvAlarmsTableModel.filterAlarmable(iStringTagArray[n2].getFirst(), 0);
                        String string6 = ProvAlarmsTableModel.filterAlarmable(iStringTagArray[n2].getSecond(), 1);
                        ProvAlarmable provAlarmable = new ProvAlarmable(string5, string6);
                        Integer n3 = ProvAlarmsTableModel.charToSeverity(string4.charAt(n2));
                        if (n3 == null) {
                            if (!db.on()) continue;
                            db.println("No default alarmable val:" + provAlarmable.getKey());
                            continue;
                        }
                        ((ProvAlarmsTableModel)serializable).setRowValue(n3, provAlarmable.getKey(), n);
                    }
                }
                catch (Exception exception) {
                    ((ProvAlarmsTableModel)this.dataModel).removeProfile(string3);
                    ((ProvAlarmsTableModel)this.dataModel).verifyProfilesMatchNode(string);
                    return;
                }
            } else {
                if (db.on()) {
                    db.println("No node; bsing the profile data...");
                }
                for (int j = 0; j < ((ProvAlarmsTableModel)this.dataModel).getNumAlarms(); ++j) {
                    try {
                        serializable = new Integer((j + i) % 5);
                        ((ProvAlarmsTableModel)this.dataModel).rawSetValueAt(serializable, j, n);
                        continue;
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            try {
                this.forceColumnApply(n);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            this.appendProfileToTable(n, string3, "loaded from node: " + string);
        }
        if (this.hideRowsCheckBox.isSelected()) {
            ((ProvAlarmsTableModel)this.dataModel).hideIdenticalRows();
        }
        this.table.sizeColumnsToFit(-1);
    }

    public void doImportFile(String string) {
        int n;
        Object object;
        int n2 = 15;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        Vector vector = new Vector(this.dataModel.getRowCount() + 1);
        if (string != null) {
            try {
                object = new ProvAlarmsReader(this.dataModel.getRowCount() + 1);
                vector = ((ProvAlarmsReader)object).readFile(string);
                if (vector == null) {
                    ErrorMsg.displayError(null, (EID)NEMC.EID_FILE_NOT_FOUND_OR_IO_EX_PARAM_1, (Object)string);
                    return;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                ErrorMsg.displayError(null, NEMC.EID_FILE_NOT_FOUND_OR_IO_EX_PARAM_1, fileNotFoundException.getMessage(), string);
            }
            catch (UnmappableCharacterException unmappableCharacterException) {
                ErrorMsg.displayError(null, NEMC.EID_PROFILE_DECODE, unmappableCharacterException.getMessage(), string);
            }
            catch (MalformedInputException malformedInputException) {
                ErrorMsg.displayError(null, NEMC.EID_PROFILE_FORMAT, malformedInputException.getMessage(), string);
            }
            catch (IOException iOException) {
                ErrorMsg.displayError(null, NEMC.EID_PROFILE_READ, iOException.getMessage(), string);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else {
            return;
        }
        object = (String)vector.elementAt(0);
        object = this.profileExists((String)object, true);
        if (object == null) {
            return;
        }
        ((ProvAlarmsTableModel)this.dataModel).setupNewProfile((String)object, "loaded from file: " + string, 1);
        int n4 = ((ProvAlarmsTableModel)this.dataModel).columnNameIndex((String)object);
        for (int i = 1; i < vector.size(); ++i) {
            int n5;
            String string2;
            String string3 = (String)vector.elementAt(i);
            try {
                ProvAlarmsTableModel.ParsedImportString parsedImportString = ProvAlarmsTableModel.parseAlarmFromImportString(string3);
                string2 = parsedImportString.getFullAlarmName();
                n5 = parsedImportString.getSeverity();
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error on line " + i + ": " + exception.getMessage());
                continue;
            }
            for (int j = 0; j < ((ProvAlarmsTableModel)this.dataModel).getNumAlarms(); ++j) {
                String string4 = (String)((ProvAlarmsTableModel)this.dataModel).rawGetValueAt(j, 0);
                try {
                    if (!string4.equals(string2)) continue;
                    ((ProvAlarmsTableModel)this.dataModel).rawSetValueAt(new Integer(n5), j, n4);
                    continue;
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        try {
            ((ProvAlarmsTableModel)this.dataModel).applyToColumn(n4);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.appendProfileToTable(n4, (String)object, "loaded from file: " + string);
        this.table.sizeColumnsToFit(-1);
        if (n3 >= n2) {
            stringBuffer.append("* plus more errors, total= " + n3 + "\n");
        }
        if ((n = ((ProvAlarmsTableModel)this.dataModel).columnNameIndex((String)object)) >= 0 && ((ProvAlarmsTableModel)this.dataModel).columnContainsUnset(n)) {
            stringBuffer.append("\nWarning: At least one row has been set to \"" + ProvAlarmsTableCellRenderer.UNSET_TERM + "\".\n" + "This may be because of possible errors " + "listed above or the file\nmay not contain a " + "definition for an alarm in this table.\n" + "Please verify the \"" + ProvAlarmsTableCellRenderer.UNSET_TERM + "\" values in this loaded profile.");
        }
        if (stringBuffer.length() > 0) {
            ErrorMsg.displayWarning((Component)((Object)this), (EID)NEMC.WID_LOAD_WARNINGS_PARAM_2, string, stringBuffer.toString());
        }
        stringBuffer = null;
    }

    public void doDeleteProfiles(String string, ArrayList arrayList) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        ProvNodeProfile provNodeProfile = ((ProvAlarmsTableModel)this.dataModel).returnNodeInfo(string);
        INodeModel iNodeModel = provNodeProfile.getNodeModel();
        Iterator iterator = ProvAlarmsPane.getUsageArray(iNodeModel).iterator();
        while (iterator.hasNext()) {
            object = (Object[])iterator.next();
            if (object == null || object[2] == null) continue;
            hashSet.add((String)object[2]);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            Object object2;
            object = (String)arrayList.get(i);
            if (hashSet.contains(object)) {
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)((String)object + " is being actively used on " + string + ".  Entities on this node using\n" + (String)object + " will use " + "Inherited" + " instead.\nAre you sure you want to remove " + (String)object + "?"), (String)"Confirm Profile Removal")) continue;
                object2 = ProvAlarmsPane.getUsageArray(iNodeModel).iterator();
                while (object2.hasNext()) {
                    Object[] objectArray = (Object[])object2.next();
                    if (objectArray == null || objectArray[2] == null || objectArray[3] == null || !objectArray[2].equals(object)) continue;
                    IEntityModel iEntityModel = (IEntityModel)objectArray[3];
                    try {
                        if (iEntityModel.getParent() == null) {
                            if (db.on()) {
                                db.println("node profile was using deleted profile; force to Default.");
                            }
                            iEntityModel.setAlarmProfileName("Default");
                            continue;
                        }
                        iEntityModel.setAlarmProfileName("Inherited");
                    }
                    catch (InvalidUpperBound invalidUpperBound) {
                        SDebug.printStackTrace((Throwable)invalidUpperBound);
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            } else {
                object2 = "Really delete \"" + (String)object + "\" from " + string + "?";
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)object2, (String)" Delete Alarm Profile")) continue;
            }
            if ((n = ((ProvAlarmsTableModel)this.dataModel).removeNodeProfileMapping(string, (String)object)) > 0) continue;
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_FAILED_TO_DELETE_PROFILE_PARAM_1, (Object)("Failed to delete profile " + arrayList.get(i) + " from node " + string));
        }
    }

    protected void doDeleteAction() {
        Object object;
        Serializable serializable;
        Object object2;
        ArrayList arrayList = this.getNodeInfoList(SecurityLevel.PROVISIONING);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = (ProvNodeProfile)arrayList.get(i);
            ((ProvAlarmsTableModel)this.dataModel).verifyProfilesMatchNode(((ProvNodeProfile)object2).getNodeName());
            serializable = ((ProvNodeProfile)object2).getProfileList();
            for (int j = 0; j < ((ArrayList)serializable).size(); ++j) {
                object = (String)((ArrayList)serializable).get(j);
                if (arrayList2.contains(object)) continue;
                arrayList2.add((String)object);
            }
            arrayList3.add(((ProvNodeProfile)object2).getNodeName());
        }
        this.removePermanentProfiles(arrayList2);
        Collections.sort(arrayList2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        object2 = new GridBagConstraints();
        serializable = new JPanel();
        ((Container)serializable).setLayout(gridBagLayout);
        ((GridBagConstraints)object2).anchor = 18;
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).gridwidth = 0;
        JLabel jLabel = new JLabel("Select Node+Profile combinations to delete:");
        gridBagLayout.setConstraints(jLabel, (GridBagConstraints)object2);
        ((Container)serializable).add(jLabel);
        ((GridBagConstraints)object2).gridwidth = 1;
        object = new JList<Object>(arrayList3.toArray());
        JList<Object> jList = new JList<Object>(arrayList2.toArray());
        ((JComponent)object).setBorder(BorderFactory.createLoweredBevelBorder());
        jList.setBorder(BorderFactory.createLoweredBevelBorder());
        UScrollPane uScrollPane = new UScrollPane();
        UScrollPane uScrollPane2 = new UScrollPane();
        uScrollPane.getViewport().setView((Component)object);
        uScrollPane2.getViewport().setView(jList);
        uScrollPane.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Node Names"));
        uScrollPane2.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Profile Names"));
        uScrollPane.setPreferredSize(SELECTIONBOX_DIM);
        uScrollPane2.setPreferredSize(SELECTIONBOX_DIM);
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 1;
        gridBagLayout.setConstraints((Component)uScrollPane, (GridBagConstraints)object2);
        ((Container)serializable).add((Component)uScrollPane);
        ((GridBagConstraints)object2).gridx = 1;
        ((GridBagConstraints)object2).gridy = 1;
        gridBagLayout.setConstraints((Component)uScrollPane2, (GridBagConstraints)object2);
        ((Container)serializable).add((Component)uScrollPane2);
        Object[] objectArray = new Object[]{"", serializable};
        String string = "OK";
        String string2 = "Cancel";
        Object[] objectArray2 = new Object[]{string, string2};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        arrayList4.add(jOptionPane);
        arrayList4.add(object);
        arrayList4.add(jList);
        NodeProfileDeletionDialog nodeProfileDeletionDialog = NodeProfileDeletionDialog.instance((Component)((Object)this), true, "Select Node/Profile Combinations for Delete", arrayList4);
        nodeProfileDeletionDialog.setResizable(false);
        try {
            nodeProfileDeletionDialog.show();
            if (jOptionPane.getValue().equals(string)) {
                boolean bl = false;
                Object[] objectArray3 = ((JList)object).getSelectedValues();
                Object[] objectArray4 = jList.getSelectedValues();
                for (int i = 0; i < objectArray3.length; ++i) {
                    int n;
                    String string3 = (String)objectArray3[i];
                    ((ProvAlarmsTableModel)this.dataModel).verifyProfilesMatchNode(string3);
                    ArrayList arrayList5 = null;
                    for (int j = 0; j < arrayList.size(); ++j) {
                        ProvNodeProfile provNodeProfile = (ProvNodeProfile)arrayList.get(j);
                        if (!provNodeProfile.getNodeName().equals(string3)) continue;
                        arrayList5 = provNodeProfile.getProfileList();
                    }
                    ArrayList<Object> arrayList6 = new ArrayList<Object>();
                    for (n = 0; n < objectArray4.length; ++n) {
                        if (arrayList5 == null || !arrayList5.contains(objectArray4[n])) continue;
                        arrayList6.add(objectArray4[n]);
                    }
                    if (arrayList6.size() > 0) {
                        if (db.on()) {
                            db.println("Remove from " + string3 + ":");
                            for (n = 0; n < arrayList6.size(); ++n) {
                                db.println(arrayList6.get(n).toString());
                            }
                        }
                        this.doDeleteProfiles(string3, arrayList6);
                        continue;
                    }
                    bl = true;
                }
                if (bl) {
                    ErrorMsg.displayWarning((Component)((Object)this), (EID)NEMC.WID_INVALID_NODE_PROFILE_COMBINATION);
                }
            }
        }
        catch (Exception exception) {
            db.finest("Exception in doDeleteAction() - silent catch " + exception);
        }
    }

    protected void doLoadAction() {
        ArrayList arrayList = this.getNodeInfoList(SecurityLevel.RETRIEVE);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        JLabel jLabel = new JLabel("Select where to load profile from:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 1;
        JRadioButton jRadioButton = new JRadioButton("From Node ");
        JRadioButton jRadioButton2 = new JRadioButton("From File    ");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        gridBagConstraints.anchor = 18;
        ProvNodeProfileSelector provNodeProfileSelector = new ProvNodeProfileSelector(arrayList, this, (ProvAlarmsTableModel)this.dataModel, jRadioButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(provNodeProfileSelector.getPanel(), gridBagConstraints);
        jPanel.add(provNodeProfileSelector.getPanel());
        FilePropertyEditor filePropertyEditor = new FilePropertyEditor(jRadioButton2);
        filePropertyEditor.setFilter("Provisionable Alarms Files (*.pfl)", "pfl");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(filePropertyEditor, gridBagConstraints);
        jPanel.add(filePropertyEditor);
        class FromListener
        implements ActionListener {
            private final /* synthetic */ JRadioButton val$fromNodeBtn;
            private final /* synthetic */ ProvNodeProfileSelector val$npsc;
            private final /* synthetic */ FilePropertyEditor val$fpe;

            FromListener(JRadioButton jRadioButton, ProvNodeProfileSelector provNodeProfileSelector, FilePropertyEditor filePropertyEditor) {
                this.val$fromNodeBtn = jRadioButton;
                this.val$npsc = provNodeProfileSelector;
                this.val$fpe = filePropertyEditor;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.val$fromNodeBtn) {
                    this.val$npsc.setEnabled(true);
                    this.val$fpe.setEnabled(false);
                } else {
                    this.val$npsc.setEnabled(false);
                    this.val$fpe.setEnabled(true);
                }
            }
        }
        FromListener fromListener = new FromListener(jRadioButton, provNodeProfileSelector, filePropertyEditor);
        jRadioButton.addActionListener(fromListener);
        jRadioButton2.addActionListener(fromListener);
        jRadioButton.doClick();
        Object[] objectArray = new Object[]{"", jPanel};
        String string = "OK";
        String string2 = "Cancel";
        Object[] objectArray2 = new Object[]{string, string2, CSHelpButton.getCaption()};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(jOptionPane);
        arrayList2.add(provNodeProfileSelector);
        arrayList2.add(jRadioButton);
        arrayList2.add(filePropertyEditor);
        ProfileLoadDialog profileLoadDialog = ProfileLoadDialog.instance((Component)((Object)this), true, "Load Profile(s)", arrayList2);
        profileLoadDialog.setResizable(false);
        try {
            profileLoadDialog.show();
            if (jOptionPane.getValue().equals(string)) {
                if (jRadioButton.isSelected()) {
                    String string3 = (String)provNodeProfileSelector.getNodeList().getSelectedValue();
                    Object[] objectArray3 = provNodeProfileSelector.getAvailableProfiles().getSelectedValues();
                    for (int i = 0; i < objectArray3.length; ++i) {
                        if (!db.on()) continue;
                        db.println(i + (String)provNodeProfileSelector.getNodeList().getSelectedValue() + " -> " + objectArray3[i]);
                    }
                    this.doImportNode(string3, objectArray3);
                } else {
                    this.doImportFile((String)filePropertyEditor.getValue());
                }
            }
        }
        catch (Exception exception) {
            db.finest("Exception in doLoadAction() - silent catch " + exception);
        }
        jRadioButton.removeActionListener(fromListener);
        jRadioButton2.removeActionListener(fromListener);
    }

    protected void doStoreAction() {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        int n;
        Object object4;
        boolean bl = false;
        if (this.table.getSelectedColumns().length == 0) {
            object4 = this.table.getColumnModel();
            for (n = 0; n < this.table.getColumnCount(); ++n) {
                object3 = object4.getColumn(n);
                int n2 = ((TableColumn)object3).getModelIndex();
                if (!((ProvAlarmsTableModel)this.dataModel).isColumnEditable(n2)) continue;
                this.table.setColumnSelectionInterval(n, n);
                bl = true;
                break;
            }
            if (this.table.getSelectedColumns().length == 0) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANT_AUTOSELECT_PROFILE);
                return;
            }
        }
        if (db.on()) {
            db.println("doStoreAction");
        }
        object4 = this.getNodeInfoList(SecurityLevel.PROVISIONING);
        for (n = 0; n < ((ArrayList)object4).size(); ++n) {
            object3 = (ProvNodeProfile)((ArrayList)object4).get(n);
            ((ProvAlarmsTableModel)this.dataModel).verifyProfilesMatchNode(((ProvNodeProfile)object3).getNodeName());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.table.getSelectedColumns();
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            int n4 = nArray[i];
            arrayList.add(this.table.getColumnName(n4));
            stringBuffer.append(this.table.getColumnName(n4));
            if (i < nArray.length - 1) {
                stringBuffer.append("\n");
            }
            if (!((ProvAlarmsTableModel)this.dataModel).columnContainsUnset(n3 = ((TableColumn)(serializable = this.table.getColumnModel().getColumn(n4))).getModelIndex()) || CerentDialog.yesNoDialog((Component)((Object)this), (String)("There is at least one \"" + ProvAlarmsTableCellRenderer.UNSET_TERM + "\" value in profile '" + this.table.getColumnName(n4) + "'.\nAre you sure you wish to store this profile anyway?"), (String)("At least one \"" + ProvAlarmsTableCellRenderer.UNSET_TERM + "\" value in profile."))) continue;
            return;
        }
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        serializable = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JRadioButton jRadioButton = new JRadioButton("To Node(s) ");
        JRadioButton jRadioButton2 = new JRadioButton("To File     ");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        if (arrayList.size() > 1) {
            jRadioButton2.setEnabled(false);
        }
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Select where to store the following profiles:");
        jPanel2.add((Component)jLabel, "North");
        if (bl) {
            stringBuffer.append(" (autoselected)");
        }
        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
        jTextArea.setForeground(jLabel.getForeground());
        jTextArea.setColumns(60);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        UScrollPane uScrollPane = new UScrollPane((Component)jTextArea, 20, 31);
        uScrollPane.setPreferredSize(new Dimension(300, 40));
        jPanel2.add((Component)uScrollPane);
        gridBagLayout.setConstraints(jPanel2, (GridBagConstraints)serializable);
        jPanel.add(jPanel2);
        ((GridBagConstraints)serializable).gridwidth = 1;
        ProvNodeSelector provNodeSelector = new ProvNodeSelector((ArrayList)object4, arrayList, jRadioButton);
        JPanel jPanel3 = provNodeSelector.getPanel();
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        gridBagLayout.setConstraints(jPanel3, (GridBagConstraints)serializable);
        jPanel.add(jPanel3);
        if (db.on()) {
            db.print("List to store is: ");
            object2 = ((ArrayList)object4).iterator();
            while (object2.hasNext()) {
                object = (ProvNodeProfile)object2.next();
                db.print(object + " ");
            }
            db.println("");
        }
        object2 = new FilePropertyEditor(jRadioButton2);
        ((FilePropertyEditor)object2).setFilter("Provisionable Alarms Files (*.pfl)", "pfl");
        ((FilePropertyEditor)object2).setApproveButtonText("Select");
        ((FilePropertyEditor)object2).setAppendFilter(true);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 2;
        gridBagLayout.setConstraints((Component)object2, (GridBagConstraints)serializable);
        jPanel.add((Component)object2);
        class ToListener
        implements ActionListener {
            private final /* synthetic */ JRadioButton val$toNodeBtn;
            private final /* synthetic */ ProvNodeSelector val$nsc;
            private final /* synthetic */ FilePropertyEditor val$fpe;

            ToListener(JRadioButton jRadioButton, ProvNodeSelector provNodeSelector, FilePropertyEditor filePropertyEditor) {
                this.val$toNodeBtn = jRadioButton;
                this.val$nsc = provNodeSelector;
                this.val$fpe = filePropertyEditor;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.val$toNodeBtn) {
                    this.val$nsc.setEnabled(true);
                    this.val$fpe.setEnabled(false);
                } else {
                    this.val$nsc.setEnabled(false);
                    this.val$fpe.setEnabled(true);
                }
            }
        }
        object = new ToListener(jRadioButton, provNodeSelector, (FilePropertyEditor)object2);
        jRadioButton.addActionListener((ActionListener)object);
        jRadioButton2.addActionListener((ActionListener)object);
        jRadioButton.doClick();
        Object[] objectArray = new Object[]{"", jPanel};
        String string = "OK";
        String string2 = "Cancel";
        Object[] objectArray2 = new Object[]{string, string2, CSHelpButton.getCaption()};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        jTextArea.setBackground(jOptionPane.getBackground());
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(jOptionPane);
        arrayList2.add(provNodeSelector);
        arrayList2.add(jRadioButton);
        ProfileStoreDialog profileStoreDialog = ProfileStoreDialog.instance((Component)((Object)this), true, "Store Profile(s)", arrayList2);
        profileStoreDialog.setResizable(false);
        try {
            profileStoreDialog.show();
            if (jOptionPane.getValue().equals(string)) {
                if (jRadioButton.isSelected()) {
                    Object[] objectArray3 = provNodeSelector.getNodeList().getSelectedValues();
                    this.doStoreNode(objectArray3, nArray);
                } else {
                    this.doStoreFile((String)((FilePropertyEditor)object2).getValue(), nArray[0]);
                }
            }
        }
        catch (Exception exception) {
            db.finest("Exception in doStoreAction() - silent catch " + exception);
        }
        jRadioButton.removeActionListener((ActionListener)object);
        jRadioButton2.removeActionListener((ActionListener)object);
    }

    protected void doCloneAction() {
        int n = this.table.getSelectedColumns()[0];
        int n2 = this.table.getRowCount();
        String string = this.table.getColumnName(n);
        if (this.table.getSelectedColumnCount() != 1) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_COLUMN_HIGHLIGHTED);
            return;
        }
        String string2 = null;
        JTextField jTextField = new JTextField();
        jTextField.setDocument(new FixedLengthDocument(64));
        Object[] objectArray = new Object[]{"New Profile Name", jTextField};
        String string3 = "OK";
        String string4 = "Cancel";
        Object[] objectArray2 = new Object[]{string3, string4};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(jOptionPane);
        arrayList.add(jTextField);
        arrayList.add(this);
        ProfileRenameDialog profileRenameDialog = ProfileRenameDialog.instance((Component)((Object)this), true, "Clone Profile \"" + string + "\"", arrayList);
        this.OptionPaneTextFieldFocus(jOptionPane, jTextField, string3);
        try {
            profileRenameDialog.show();
            if (!jOptionPane.getValue().equals(string3)) {
                return;
            }
            string2 = jTextField.getText();
            if ((string2 = this.profileExists(string2, true)) == null) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        ((ProvAlarmsTableModel)this.dataModel).setupNewProfile(string2, "cloned from profile: " + string, 0);
        int n3 = ((ProvAlarmsTableModel)this.dataModel).columnNameIndex(string2);
        ((ProvAlarmsTableModel)this.dataModel).copyAllSeverities(string, string2);
        try {
            this.forceColumnApply(n3);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.appendProfileToTable(n3, string2, "cloned from profile: " + string);
        this.table.sizeColumnsToFit(-1);
    }

    protected void doRemoveAction() {
        if (this.table.getSelectedColumnCount() != 1) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_PROFILE_HIGHLIGHTED);
            return;
        }
        int n = this.table.getSelectedColumns()[0];
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        int n2 = tableColumn.getModelIndex();
        if (((ProvAlarmsTableModel)this.dataModel).columnIsDirty(n2) && !CerentDialog.yesNoDialog((Component)((Object)this), (String)"This profile has been modified.  Are you sure you want to remove it?", (String)"Confirm Profile Removal")) {
            return;
        }
        if (((ProvAlarmsTableModel)this.dataModel).isColumnPermanent(n2)) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_PERMANENT_COLUMN);
            return;
        }
        String string = this.dataModel.getColumnName(n2);
        ((ProvAlarmsTableModel)this.dataModel).removeProfile(string);
        this.removeProfileFromTable(string);
        this.syncDirty();
        this.table.sizeColumnsToFit(-1);
    }

    protected void doResetAction() {
        int[] nArray = this.table.getSelectedColumns();
        if (nArray.length < 1) {
            ErrorMsg.displayError(null, (EID)NEMC.EID_SELECT_PROFILES);
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.table.getColumnModel().getColumn(nArray[i]).getModelIndex();
            if (!((ProvAlarmsTableModel)this.dataModel).isColumnEditable(n)) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_RESET_COLUMN, (Object)"Non-editable Column");
                return;
            }
            if (((ProvAlarmsTableModel)this.dataModel).columnIsDirty(n) && !CerentDialog.yesNoDialog((Component)((Object)this), (String)("Profile " + ((ProvAlarmsTableModel)this.dataModel).getColumnName(n) + " has been modified.  " + "Are you sure you want to reset this profile?"), (String)"Confirm Profile Reset")) continue;
            try {
                this.table.removeEditor();
                ((ProvAlarmsTableModel)this.dataModel).refreshFromColumn(n);
                if (this.hideRowsCheckBox.isSelected()) {
                    ((ProvAlarmsTableModel)this.dataModel).hideIdenticalRows();
                }
                this.syncDirty();
                continue;
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_FAIL_REFRESH_PANE);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void doRenameAction() {
        if (this.table.getSelectedColumnCount() != 1) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_PROFILE_HIGHLIGHTED);
            return;
        }
        int n = this.table.getSelectedColumns()[0];
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        int n2 = tableColumn.getModelIndex();
        if (((ProvAlarmsTableModel)this.dataModel).isColumnPermanent(n2)) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_RENAME_COLUMN);
            return;
        }
        JTextField jTextField = new JTextField(30);
        jTextField.setDocument(new FixedLengthDocument(64));
        Object[] objectArray = new Object[]{"New Profile Name", jTextField};
        String string = "OK";
        String string2 = "Cancel";
        Object[] objectArray2 = new Object[]{string, string2};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(jOptionPane);
        arrayList.add(jTextField);
        arrayList.add(this);
        ProfileRenameDialog profileRenameDialog = ProfileRenameDialog.instance((Component)((Object)this), true, "Rename Profile (" + this.table.getColumnName(n) + ")", arrayList);
        this.OptionPaneTextFieldFocus(jOptionPane, jTextField, string);
        try {
            profileRenameDialog.show();
            if (!jOptionPane.getValue().equals(string)) {
                return;
            }
            String string3 = jTextField.getText();
            if ((string3 = this.profileExists(string3, true)) == null) {
                return;
            }
            tableColumn.setHeaderValue(string3);
            ((ProvAlarmsTableModel)this.dataModel).setColumnName(n2, string3);
            this.forceColumnApply(n2);
            this.table.sizeColumnsToFit(-1);
            this.table.getTableHeader().resizeAndRepaint();
        }
        catch (Exception exception) {
            db.finest("Exception in doRenameAction() - silent catch " + exception);
        }
    }

    protected void doAvailableAction() {
        ArrayList arrayList = this.getNodeInfoList(SecurityLevel.RETRIEVE);
        for (int i = 0; i < arrayList.size(); ++i) {
            ProvNodeProfile provNodeProfile = (ProvNodeProfile)arrayList.get(i);
            ((ProvAlarmsTableModel)this.dataModel).verifyProfilesMatchNode(provNodeProfile.getNodeName());
        }
        ProvAlarmsUsagePane provAlarmsUsagePane = ProvAlarmsUsagePane.instance("Available Profiles on Each Node", this, 0);
        provAlarmsUsagePane.display();
    }

    protected void doCompareAction() {
        if (this.table.getSelectedColumnCount() < 2) {
            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_NEED_TWO_COLS_HIGHLIGHTED);
            return;
        }
        int[] nArray = this.table.getSelectedColumns();
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(nArray[i]);
            nArray2[i] = tableColumn.getWidth();
            nArray3[i] = tableColumn.getModelIndex();
        }
        try {
            ProvAlarmsComparePane provAlarmsComparePane = new ProvAlarmsComparePane((Component)((Object)this), this.dataModel, nArray3, nArray2);
            provAlarmsComparePane.display();
        }
        catch (ProvAlarmsComparePane.IdenticalProfilesException identicalProfilesException) {
            CerentDialog.infoDialog((Component)((Object)this), (String)"The profiles are identical.", (String)"No Differences");
        }
    }

    protected boolean doUsageAction() {
        ProvAlarmsUsagePane provAlarmsUsagePane = ProvAlarmsUsagePane.instance("Usage of Profiles on Each Node", this, 1);
        provAlarmsUsagePane.display();
        return true;
    }

    ArrayList getProfileUsage() {
        ArrayList arrayList = new ArrayList();
        INodeModel[] iNodeModelArray = ((ProvAlarmsTableModel)this.dataModel).returnNodeModels(SecurityLevel.RETRIEVE);
        for (int i = 0; i < iNodeModelArray.length; ++i) {
            if (db.on()) {
                db.println(i + " getting usage of " + iNodeModelArray[i].getName());
            }
            arrayList.addAll(ProvAlarmsPane.getUsageArray(iNodeModelArray[i]));
        }
        return arrayList;
    }

    public static ArrayList getUsageArray(INodeModel iNodeModel) {
        return iNodeModel.getAlarmProfileUsage();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = Integer.parseInt(actionEvent.getActionCommand());
        if (n == this.LOAD_FUNCTION) {
            this.doLoadAction();
        } else if (n == this.STORE_FUNCTION) {
            this.doStoreAction();
        } else if (n == this.DELETEPROFILE_FUNCTION) {
            this.doDeleteAction();
        } else if (n == this.CLONEPROFILE_FUNCTION) {
            this.doCloneAction();
        } else if (n == this.RENAMEPROFILE_FUNCTION) {
            this.doRenameAction();
        } else if (n == this.REMOVEPROFILE_FUNCTION) {
            this.doRemoveAction();
        } else if (n == this.RESET_FUNCTION) {
            this.doResetAction();
        } else if (n == this.COMPAREPROFILE_FUNCTION) {
            this.doCompareAction();
        } else if (n == this.AVAILABLEPROFILE_FUNCTION) {
            this.doAvailableAction();
        } else if (n == this.USAGEPROFILE_FUNCTION) {
            this.doUsageAction();
        } else if (n == this.TEST_FUNCTION) {
            this.doTestAction();
        } else if (n == this.NEWPROFILE_FUNCTION) {
            this.doNewProfile();
        } else if (db.on()) {
            db.println("ProvAlarmsPane: no ActionPerformed command!");
        }
    }

    protected void triggerToggleCheckBox() {
        boolean bl;
        boolean bl2 = bl = this.table.getColumnCount() > 2;
        if (this.toggleCheckBox != null) {
            this.toggleCheckBox.setEnabled(bl);
            if (!this.toggleCheckBox.isEnabled()) {
                this.toggleCheckBox.setSelected(false);
                this.toggleCheckBox.setText(HIDE_STRING);
            } else {
                this.toggleCheckBox.setText("Hide values matching profile " + ((ProvAlarmsTableModel)this.dataModel).getColumnName(1));
            }
        }
    }

    protected void setAlarmCellRenderer(TableColumn tableColumn) {
        JComboBox jComboBox = new JComboBox(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                this.selectedItemReminder = null;
                super.contentsChanged(listDataEvent);
            }

            protected void fireActionEvent() {
                this.hidePopup();
                super.fireActionEvent();
            }
        };
        jComboBox.addItem(ISetSeverity.SET_NOT_REPORTED);
        jComboBox.addItem(ISetSeverity.SET_NOT_ALARMED);
        jComboBox.addItem(ISetSeverity.SET_MINOR);
        jComboBox.addItem(ISetSeverity.SET_MAJOR);
        jComboBox.addItem(ISetSeverity.SET_CRITICAL);
        jComboBox.addItem(ISetSeverity.SET_UNSET);
        jComboBox.addItem(ISetSeverity.SET_TRANSPARENT);
        ProvSeverityListCellRenderer provSeverityListCellRenderer = new ProvSeverityListCellRenderer();
        jComboBox.setRenderer(provSeverityListCellRenderer);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        tableColumn.setCellEditor(defaultCellEditor);
    }

    protected void forceTableCellRender() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            ProvAlarmsTableCellRenderer provAlarmsTableCellRenderer = new ProvAlarmsTableCellRenderer();
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            int n = tableColumn.getModelIndex();
            if (n == 0) continue;
            tableColumn.setCellRenderer(provAlarmsTableCellRenderer);
            if (n == 1) continue;
            this.setAlarmCellRenderer(tableColumn);
        }
    }

    protected void selectivelyEnableStoreButton() {
        if (this.buttons[this.STORE_FUNCTION] == null) {
            return;
        }
        boolean bl = false;
        if (this.table.getColumnCount() == 2) {
            TableColumn tableColumn;
            String string;
            ProvAlarmsTableModel provAlarmsTableModel;
            int n;
            Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
            while (enumeration.hasMoreElements() && (n = (provAlarmsTableModel = (ProvAlarmsTableModel)this.dataModel).columnNameIndex(string = (String)(tableColumn = enumeration.nextElement()).getHeaderValue())) >= 0) {
                if (!provAlarmsTableModel.isColumnEditable(n)) continue;
                bl = true;
                break;
            }
        } else {
            bl = this.containsOnlyStorableProfiles();
        }
        this.buttons[this.STORE_FUNCTION].setEnabled(bl);
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.selectivelyEnableStoreButton();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.selectivelyEnableStoreButton();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected JComponent createButtonPanel() {
        String[] stringArray = new String[]{"Load...", "Store...", "Delete...", "Clone...", "Rename...", "Remove", "Reset", "Compare", "Available", "Usage", "***Test***", "New..."};
        Insets insets = new Insets(2, 1, 2, 1);
        for (int i = 0; i < this.numButtons; ++i) {
            this.buttons[i] = new JButton();
            this.buttons[i].setActionCommand(String.valueOf(i));
            this.buttons[i].setText(stringArray[i]);
            this.buttons[i].setPreferredSize(BUTTON0_DIM);
            this.buttons[i].setMinimumSize(BUTTON0_DIM);
            this.buttons[i].setMaximumSize(BUTTON0_DIM);
            this.buttons[i].setMargin(insets);
            if (i == this.LOAD_FUNCTION || i == this.AVAILABLEPROFILE_FUNCTION || i == this.USAGEPROFILE_FUNCTION || i == this.DELETEPROFILE_FUNCTION || i == this.TEST_FUNCTION || i == this.NEWPROFILE_FUNCTION) continue;
            this.buttons[i].setEnabled(false);
        }
        this.buttons[this.STORE_FUNCTION].addActionListener(this);
        this.buttons[this.LOAD_FUNCTION].addActionListener(this);
        this.buttons[this.DELETEPROFILE_FUNCTION].addActionListener(this);
        this.buttons[this.CLONEPROFILE_FUNCTION].addActionListener(this);
        this.buttons[this.RENAMEPROFILE_FUNCTION].addActionListener(this);
        this.buttons[this.REMOVEPROFILE_FUNCTION].addActionListener(this);
        this.buttons[this.RESET_FUNCTION].addActionListener(this);
        this.buttons[this.COMPAREPROFILE_FUNCTION].addActionListener(this);
        this.buttons[this.AVAILABLEPROFILE_FUNCTION].addActionListener(this);
        this.buttons[this.USAGEPROFILE_FUNCTION].addActionListener(this);
        this.buttons[this.TEST_FUNCTION].addActionListener(this);
        this.buttons[this.NEWPROFILE_FUNCTION].addActionListener(this);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(NetCSHelpConst.ProvAlarmsPane);
        cSHelpButtonPane.addLeft(this.buttons[this.NEWPROFILE_FUNCTION]);
        cSHelpButtonPane.addLeft(this.buttons[this.LOAD_FUNCTION]);
        cSHelpButtonPane.addLeft(this.buttons[this.STORE_FUNCTION]);
        cSHelpButtonPane.addLeft(this.buttons[this.DELETEPROFILE_FUNCTION]);
        cSHelpButtonPane.addLeft(this.buttons[this.COMPAREPROFILE_FUNCTION]);
        cSHelpButtonPane.addLeft(this.buttons[this.AVAILABLEPROFILE_FUNCTION]);
        cSHelpButtonPane.addLeft(this.buttons[this.USAGEPROFILE_FUNCTION]);
        return cSHelpButtonPane;
    }

    protected JComponent createBottomPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.toggleCheckBox = new JCheckBox(HIDE_STRING, false);
        this.toggleCheckBox.setEnabled(false);
        this.hideRowsCheckBox = new JCheckBox("Hide identical rows", false);
        this.showSACheckBox = new JCheckBox("Only show service-affecting severities", false);
        jPanel2.setLayout(new GridLayout(1, 3));
        class SABoxListener
        implements ItemListener {
            boolean showSA = false;

            SABoxListener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                this.showSA = itemEvent.getStateChange() != 2;
                ProvAlarmsPane.this.table.clearSelection();
                ProvAlarmsPane.this.table.removeEditor();
                for (int i = 0; i < ProvAlarmsPane.this.dataModel.getColumnCount(); ++i) {
                    TableColumn tableColumn = ProvAlarmsPane.this.table.getColumnModel().getColumn(i);
                    if (!(tableColumn.getCellRenderer() instanceof ProvAlarmsTableCellRenderer)) continue;
                    ((ProvAlarmsTableCellRenderer)tableColumn.getCellRenderer()).setShowSA(this.showSA);
                }
                ProvAlarmsPane.this.dataModel.fireTableDataChanged();
            }
        }
        this.showSACheckBox.addItemListener(new SABoxListener());
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 5));
        jPanel3.add(this.showSACheckBox);
        jPanel2.add(jPanel3);
        class ToggleBoxListener
        implements ItemListener {
            boolean invisibility = false;

            ToggleBoxListener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                this.invisibility = itemEvent.getStateChange() != 2;
                ProvAlarmsPane.this.table.clearSelection();
                ProvAlarmsPane.this.table.removeEditor();
                for (int i = 0; i < ProvAlarmsPane.this.dataModel.getColumnCount(); ++i) {
                    TableColumn tableColumn = ProvAlarmsPane.this.table.getColumnModel().getColumn(i);
                    if (!(tableColumn.getCellRenderer() instanceof ProvAlarmsTableCellRenderer)) continue;
                    ((ProvAlarmsTableCellRenderer)tableColumn.getCellRenderer()).setInvisibility(this.invisibility);
                }
                ProvAlarmsPane.this.dataModel.fireTableDataChanged();
            }
        }
        this.toggleCheckBox.addItemListener(new ToggleBoxListener());
        jPanel3.add(this.toggleCheckBox);
        class HideRowsBoxListener
        implements ItemListener {
            HideRowsBoxListener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    ((ProvAlarmsTableModel)ProvAlarmsPane.this.dataModel).resetRowMappings();
                } else {
                    ((ProvAlarmsTableModel)ProvAlarmsPane.this.dataModel).hideIdenticalRows();
                }
            }
        }
        this.hideRowsCheckBox.addItemListener(new HideRowsBoxListener());
        jPanel3.add(this.hideRowsCheckBox);
        jPanel2.add(jPanel3);
        JComponent jComponent = this.createButtonPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jComponent, "South");
        return jPanel;
    }

    protected void init() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        borderLayout.setVgap(5);
        this.setLayout(borderLayout);
        this.removeAll();
        this.add((Component)this.scrollPane, "Center");
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(ALARMTEXT_WIDTH);
        this.forceTableCellRender();
        this.add(this.createBottomPanel(), "South");
        ListSelectionModel listSelectionModel = this.table.getColumnModel().getSelectionModel();
        listSelectionModel.addListSelectionListener(new TableSelectionListener());
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Store...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(String.valueOf(this.STORE_FUNCTION));
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Rename...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(String.valueOf(this.RENAMEPROFILE_FUNCTION));
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Clone...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(String.valueOf(this.CLONEPROFILE_FUNCTION));
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Reset");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(String.valueOf(this.RESET_FUNCTION));
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Remove");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(String.valueOf(this.REMOVEPROFILE_FUNCTION));
        this.popup.add(jMenuItem);
        this.table.addMouseListener(this);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(this);
    }

    public ProvAlarmsPane(String string, TabbedView tabbedView, INodeModel[] iNodeModelArray, boolean bl) {
        super(string, tabbedView, new ProvAlarmsTableModel(true, iNodeModelArray), true);
        this.table = this.getTable();
        this.dataModel = this.dataModel;
        this.table.getColumnModel().addColumnModelListener(this);
        this.displayedIgnorableInThisInstance = false;
        this.isThisGuestPane = bl;
    }

    protected void doTestAction() {
        ArrayList arrayList = this.getNodeInfoList(SecurityLevel.PROVISIONING);
        if (db.on()) {
            Object object;
            int n;
            db.println("*-- Node/Profile usage, start");
            for (n = 0; n < arrayList.size(); ++n) {
                object = (ProvNodeProfile)arrayList.get(n);
                db.print(((ProvNodeProfile)object).getNodeName());
                ArrayList arrayList2 = ((ProvNodeProfile)object).getProfileList();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    db.print("\t" + arrayList2.get(i));
                }
                db.println("");
            }
            db.println("*-- Node/Profile usage, end");
            for (n = 0; n < this.dataModel.getColumnCount(); ++n) {
                object = this.table.getColumnModel().getColumn(n);
                db.print("" + n);
                db.print("" + ((TableColumn)object).getHeaderValue());
                db.print(" --MODEL--> " + ((TableColumn)object).getModelIndex());
                db.print("/" + this.dataModel.getColumnName(((TableColumn)object).getModelIndex()));
                db.print("/" + ((ProvAlarmsTableModel)this.dataModel).getColumnDesc(((TableColumn)object).getModelIndex()));
                db.println("");
            }
            ((ProvAlarmsTableModel)this.dataModel).dumpAll();
        }
    }

    protected Attribute[] getAttributes(String string) {
        return NetworkDefaults.getAttributeMap().getAttributeArray(string);
    }

    protected ArrayList getNodeInfoList(SecurityLevel securityLevel) {
        return ((ProvAlarmsTableModel)this.dataModel).getNodeInfoList(securityLevel);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        String string;
        MenuElement[] menuElementArray;
        int n;
        int n2;
        int n3;
        Object object = mouseEvent.getSource();
        if (db.on()) {
            db.println("A " + object.getClass() + " was clicked.");
        }
        if ((n3 = this.table.convertColumnIndexToModel(n2 = this.table.columnAtPoint(mouseEvent.getPoint()))) == 0) {
            n = this.table.rowAtPoint(mouseEvent.getPoint());
            menuElementArray = this.table.getValueAt(n, n2);
            string = "Alarmable \"" + menuElementArray + "\" used by: " + ((ProvAlarmsTableModel)this.dataModel).getTooltip(menuElementArray);
            this.uiToolkit.setSBText(string);
        }
        if (n2 < 0) {
            return;
        }
        if (object instanceof JTableHeader) {
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                if (!this.table.isColumnSelected(n2)) {
                    this.table.addColumnSelectionInterval(n2, n2);
                } else {
                    this.table.removeColumnSelectionInterval(n2, n2);
                }
            } else {
                this.table.setColumnSelectionInterval(n2, n2);
            }
        }
        if (mouseEvent.isMetaDown()) {
            n = this.table.convertColumnIndexToModel(n2);
            if (db.on()) {
                db.println("highlight tableCol " + n2 + " which is model col " + n);
            }
            if (n != 0) {
                this.table.setColumnSelectionInterval(n2, n2);
                menuElementArray = this.popup.getSubElements();
                if (((ProvAlarmsTableModel)this.dataModel).columnIsDirty(n)) {
                    ((JMenuItem)menuElementArray[3]).setEnabled(true);
                } else {
                    ((JMenuItem)menuElementArray[3]).setEnabled(false);
                }
                string = ((ProvAlarmsTableModel)this.dataModel).getColumnName(n);
                ((JMenuItem)menuElementArray[0]).setEnabled(!ProvAlarmsTableModel.permProfileSet.contains(string));
                ((JMenuItem)menuElementArray[1]).setEnabled(n != 0);
                ((JMenuItem)menuElementArray[4]).setEnabled(n != 0);
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        if (this.table.getColumnCount() < 1) {
            block13: {
                if (db.on()) {
                    db.println("enteringPage for first time, calling init");
                }
                try {
                    if (this.uiToolkit != null) {
                        this.uiToolkit.setCursor(3);
                        this.uiToolkit.setSBText("Loading Alarmables...");
                    }
                    String string = "AlarmType::Condition";
                    ((ProvAlarmsTableModel)this.dataModel).initAlarmColumn(string, "");
                    if (this.dataModel.getColumnCount() > 0) {
                        TableColumn tableColumn = new TableColumn(0);
                        tableColumn.setHeaderValue(string);
                        this.table.getColumnModel().addColumn(tableColumn);
                        this.dataModel.fireTableStructureChanged();
                        if (db.on()) {
                            db.println("enteringPage(), created first column");
                        }
                        break block13;
                    }
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_CANNOT_LOAD_ALARMABLES);
                    if (db.on()) {
                        db.println("enteringPage(), can't create column #0!");
                    }
                    return;
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                finally {
                    if (this.uiToolkit != null) {
                        this.uiToolkit.setCursor(0);
                        this.uiToolkit.setSBText("");
                    }
                }
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
            this.init();
            for (int i = this.STORE_FUNCTION; i <= this.TEST_FUNCTION; ++i) {
                this.buttons[i].setEnabled(false);
            }
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected int getLeavingPageOption() {
        boolean bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)"Some profiles have been changed but not stored.\nLeaving this tab will discard these changes.\nOK to continue?", (String)"Changed Profiles Not Stored");
        if (bl) {
            return 1;
        }
        return 2;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (!((ProvAlarmsTableModel)this.dataModel).isDirty() && this.isThisGuestPane && !this.displayedIgnorableInThisInstance && this.table.getColumnCount() > 1) {
            IgnorableDialog.warningDialog((String)ErrorMsg.getString((EID)NEMC.WID_UNSAVED_ALARM_PROFILE), (String)this.PREF_SCOPE_VALUE, (String)this.PREF_SCOPE_DESCR);
            this.displayedIgnorableInThisInstance = true;
        }
        if (this.uiToolkit != null) {
            this.uiToolkit.setCursor(0);
            this.uiToolkit.setSBText("");
        }
        super.leavingPage();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        ((ProvAlarmsTableModel)this.dataModel).destroy();
        super.destroy();
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            ProvAlarmsPane.this.numColumnsSelected = ProvAlarmsPane.this.table.getSelectedColumns().length;
            boolean bl = false;
            for (int i = 0; i < ProvAlarmsPane.this.table.getSelectedColumns().length; ++i) {
                TableColumn tableColumn = ProvAlarmsPane.this.table.getColumnModel().getColumn(ProvAlarmsPane.this.table.getSelectedColumns()[i]);
                int n = tableColumn.getModelIndex();
                if (n != 0) continue;
                bl = true;
                break;
            }
            if (ProvAlarmsPane.this.numColumnsSelected == 1) {
                String string;
                TableColumn tableColumn = ProvAlarmsPane.this.table.getColumnModel().getColumn(ProvAlarmsPane.this.table.getSelectedColumns()[0]);
                int n = tableColumn.getModelIndex();
                String string2 = ((ProvAlarmsTableModel)ProvAlarmsPane.this.dataModel).getColumnName(n);
                String string3 = ((ProvAlarmsTableModel)ProvAlarmsPane.this.dataModel).getColumnDesc(n);
                String string4 = "Alarm Profile ";
                String string5 = string = n == 1 ? " [REFERENCE COLUMN] " : " ";
                if (string3 == null || string3.length() == 0) {
                    ProvAlarmsPane.this.uiToolkit.setSBText(string4 + "\"" + string2 + "\"" + string);
                } else {
                    ProvAlarmsPane.this.uiToolkit.setSBText(string4 + "\"" + string2 + "\"" + " (" + string3 + ")" + string);
                }
            } else {
                ProvAlarmsPane.this.uiToolkit.setSBText("");
            }
            boolean bl2 = ProvAlarmsPane.this.table.getColumnCount() > 1;
            boolean bl3 = ProvAlarmsPane.this.table.getColumnCount() == 2;
            ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.DELETEPROFILE_FUNCTION].setEnabled(true);
            ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.AVAILABLEPROFILE_FUNCTION].setEnabled(true);
            ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.USAGEPROFILE_FUNCTION].setEnabled(true);
            if (listSelectionModel.isSelectionEmpty()) {
                ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.CLONEPROFILE_FUNCTION].setEnabled(true);
                if (bl3) {
                    ProvAlarmsPane.this.selectivelyEnableStoreButton();
                } else {
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.STORE_FUNCTION].setEnabled(false);
                }
                ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.COMPAREPROFILE_FUNCTION].setEnabled(false);
                ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.RENAMEPROFILE_FUNCTION].setEnabled(false);
                ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.CLONEPROFILE_FUNCTION].setEnabled(false);
                ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.REMOVEPROFILE_FUNCTION].setEnabled(false);
                ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.RESET_FUNCTION].setEnabled(false);
            } else {
                if (!bl) {
                    ProvAlarmsPane.this.selectivelyEnableStoreButton();
                } else {
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.STORE_FUNCTION].setEnabled(false);
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.RESET_FUNCTION].setEnabled(false);
                }
                if (ProvAlarmsPane.this.numColumnsSelected > 1 && !bl) {
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.COMPAREPROFILE_FUNCTION].setEnabled(true);
                } else {
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.COMPAREPROFILE_FUNCTION].setEnabled(false);
                }
                if (ProvAlarmsPane.this.numColumnsSelected == 1 && !bl) {
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.CLONEPROFILE_FUNCTION].setEnabled(true);
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.RENAMEPROFILE_FUNCTION].setEnabled(true);
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.REMOVEPROFILE_FUNCTION].setEnabled(true);
                } else {
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.CLONEPROFILE_FUNCTION].setEnabled(false);
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.RENAMEPROFILE_FUNCTION].setEnabled(false);
                    ProvAlarmsPane.this.buttons[ProvAlarmsPane.this.REMOVEPROFILE_FUNCTION].setEnabled(false);
                }
            }
        }
    }

    class ProvSeverityListCellRenderer
    extends DefaultListCellRenderer {
        ProvSeverityListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null && db.on()) {
                db.println("LIST CELL VALUE WAS NULL?");
            }
            Integer n2 = (Integer)object;
            JLabel jLabel = ProvAlarmsTableCellRenderer.labels[n2];
            if (bl) {
                jLabel.setBackground(jList.getSelectionBackground());
                ProvAlarmsTableCellRenderer.labels[n2].setForeground(Color.white);
            } else {
                jLabel.setBackground(jList.getBackground());
                ProvAlarmsTableCellRenderer.labels[n2].setForeground(Color.black);
            }
            return jLabel;
        }
    }
}

