/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.span;

import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.span.SdAbstractPane;
import cerent.cms.ui.span.SpanUpgradeDialog;
import cerent.cms.ui.span.UpsrSwitchJob;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SdUpsrPane
extends SdAbstractPane
implements IJobListener {
    private static final ImageIcon INFO_ICON = new ImageIcon(CerentDialog.class.getResource("/images/icons/informational32.gif"));
    private static final ImageIcon ERROR_ICON = new ImageIcon(CerentDialog.class.getResource("/images/icons/fatal_error32.gif"));
    public static final String SWITCH_AWAY = " - switched away\n";
    public static final String SWITCH_BACK = " - switched back\n";
    public static final String FAIL_SWITCH_AWAY = " - failed switching away\n";
    public static final String FAIL_SWITCH_BACK = " - failed switching back\n";
    protected static final int FIRST_PAGE = 1;
    protected static final int LAST_PAGE = 6;
    private static final NetCircuitManager ncm = NetCircuitManager.instance();
    private StringBuffer successes = new StringBuffer();
    private StringBuffer failures = new StringBuffer();
    private JobProgressDialog progressDlg = null;
    private ArrayList upsrList = new ArrayList();
    private int numJobs = 0;
    private int jobsDone = 0;
    private Object objectLock = new Object();
    private JobController jc;

    public SdUpsrPane(String string, SpanUpgradeDialog spanUpgradeDialog, int n) {
        super(string, spanUpgradeDialog, n);
    }

    protected String getTopMessage() {
        return "You are about to perform a span upgrade on an unprotected span.\nThis operation may result in traffic loss.\n \nAt each step, always verify that no unexpected service affecting\nalarms are raised.\n \nTo continue, select the upgrade settings below:";
    }

    protected int getFirstPageNum() {
        return 1;
    }

    protected int getLastPageNum() {
        return 6;
    }

    private String getUpsrTerm() {
        String string = " ";
        if (this.linkModel != null) {
            string = this.parent.terms.getRingTerms(0);
        }
        return string;
    }

    protected String getDesc() {
        String string = "";
        switch (this.step) {
            case 2: {
                string = "If this span carries " + this.getUpsrTerm() + " circuits, " + "they will be switched away.  If the\n" + "span carries unprotected circuits, the traffic will be " + "lost unless\n" + "protected by another mechanism.\n \n" + "When you are ready, click Next.";
                break;
            }
            case 3: {
                String string2 = "Remove the";
                String string3 = "from the following";
                string = this.getEquipmentChangeString(OLD_EQUIPMENT, string2, string3) + " \nWhen you are done, click Next.";
                break;
            }
            case 4: {
                String string4 = "Insert the";
                String string5 = "into the following";
                string = this.getEquipmentChangeString(NEW_EQUIPMENT, string4, string5) + " \nWhen the cards finish booting, test the optical receive levels\n" + "for the newly installed card and apply attenuation, if needed.\n" + "Refer to the user documentation for minimum/maximum\n" + "optical levels.\n \n" + "When you are ready, reconnect the fibers and click Next.";
                break;
            }
            case 5: {
                string = "Verify that no unexpected service affecting alarms are raised for\nthe following slots:\n \n" + this.getWorkingSlotString(this.parent.srcInfo) + "\n" + this.getWorkingSlotString(this.parent.dstInfo) + "\n \n" + "Click Next to switch the revertive " + this.getUpsrTerm() + " circuits back to this span.";
                break;
            }
            case 6: {
                string = "You have completed a span upgrade.  Click the Finish button\nto exit this dialog box.";
            }
        }
        return string;
    }

    private LinkedList getCircuitSpans() {
        LinkedList linkedList = new LinkedList();
        INetLink iNetLink = this.parent.getNetLink();
        INetLink iNetLink2 = Network.instance().findReverseLink(iNetLink);
        this.getNetCircuitSpan(linkedList, iNetLink);
        this.getNetCircuitSpan(linkedList, iNetLink2);
        return linkedList;
    }

    private void getNetCircuitSpan(LinkedList linkedList, INetLink iNetLink) {
        List list = ncm.getCircuitSpans(iNetLink);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
            INetCircuit iNetCircuit = iNetCircuitSpan.getCircuit();
            if (iNetCircuit.getCircuitTypeObj().isTunnelCircuitType()) {
                this.getNetCircuitSpan(linkedList, iNetCircuit.getLotLink());
                this.getNetCircuitSpan(linkedList, iNetCircuit.getReverseLotLink());
            }
            if (!iNetCircuitSpan.isUpsr()) continue;
            linkedList.add(iNetCircuitSpan);
        }
    }

    private void switchCircuits(LinkedList linkedList, int n) {
        this.successes = new StringBuffer();
        this.failures = new StringBuffer();
        this.jobsDone = 0;
        this.numJobs = 0;
        this.parent.setEnabled(false);
        this.jc = JobControllerFactory.createJC((int)5);
        this.upsrList = this.step == 2 ? new ArrayList() : this.parent.getUpsrCircuitList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
            if (!iNetCircuitSpan.isUpsr()) continue;
            UpsrSwitchJob upsrSwitchJob = new UpsrSwitchJob(iNetCircuitSpan, n);
            JobGroup jobGroup = new JobGroup((IJobControl)upsrSwitchJob, (IJobListener)this, (Object)iNetCircuitSpan.getCircuit().getCircuitName());
            this.jc.submitJob(jobGroup);
            ++this.numJobs;
            if (this.step != 2) continue;
            this.upsrList.add(iNetCircuitSpan.getCircuit().getCircuitName());
        }
        if (this.numJobs == 0) {
            JobControllerFactory.disposeJC((JobController)this.jc);
            if (this.step != 2 && this.upsrList != null && this.upsrList.size() > 0) {
                ErrorMsg.displayError((Component)JOptionPane.getFrameForComponent(this.parent), (EID)NEMC.EID_SWITCHING_ERROR, (Object)(this.getUpsrTerm() + " Switching Error."));
            }
            this.parent.setEnabled(true);
        } else {
            if (this.step == 2) {
                this.parent.setUpsrCircuitList(this.upsrList);
            }
            this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "Switching " + this.getUpsrTerm() + " circuits", "Switching...                              ");
        }
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
        try {
            Object object2 = this.objectLock;
            synchronized (object2) {
                int n;
                Iterator iterator;
                if (jobStatus.value() == 2) {
                    if (jobStatus.getResult() instanceof Exception && (iterator = (Exception)jobStatus.getResult()) != null) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)((Object)iterator));
                        }
                        this.failures.append(((Throwable)((Object)iterator)).getMessage());
                    }
                } else if (jobStatus.getResult() instanceof String) {
                    this.successes.append((String)jobStatus.getResult());
                }
                if (this.progressDlg != null) {
                    ++this.jobsDone;
                    this.progressDlg.setProgressText("Switched " + this.jobsDone + " out of " + this.numJobs + (this.numJobs > 1 ? " circuits" : " circuit"));
                    this.progressDlg.setPercentCompleted((int)((double)((float)this.jobsDone / (float)this.numJobs) * 100.0));
                }
                if (this.step != 2 && (n = this.upsrList.indexOf(iterator = (String)object)) != -1) {
                    this.upsrList.remove(iterator);
                }
                if (this.jc.isIdle()) {
                    if (SdUpsrPane.db.on) {
                        db.println("disposing Job Controller");
                    }
                    JobControllerFactory.disposeJC((JobController)this.jc);
                    this.parent.setCircuitsForced(this.jobsDone);
                    this.parent.setEnabled(true);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SdUpsrPane.this.progressDlg.dispose();
                            SdUpsrPane.this.progressDlg = null;
                        }
                    });
                    if (this.step != 2) {
                        iterator = this.upsrList.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            this.failures.append(string + FAIL_SWITCH_BACK);
                        }
                    }
                    this.showSwitchStatus();
                }
            }
        }
        catch (Exception exception) {
            this.parent.setEnabled(true);
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)JOptionPane.getFrameForComponent(this.parent), (EID)NEMC.EID_SPAN_UPGRADE_ERROR);
        }
    }

    private void performStep1() throws Exception {
        this.parent.setEquipmentInfo(this.srcEqTypeCB.getSelectedItem(), this.dstEqTypeCB.getSelectedItem(), this.portRateCB.getSelectedItem());
        this.parent.setStatusText("- Upgrading to " + this.parent.getNewEquipmentsString() + ",\n" + "Port Rate: " + this.portRateCB.getSelectedItem() + "\n");
    }

    private void performStep2() throws Exception {
        this.checkNodeInitiations();
        this.switchCircuits(this.getCircuitSpans(), 3);
        this.parent.setStatusText("- FORCE " + this.getUpsrTerm() + " circuits if found\n");
    }

    private void showSwitchStatus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = SdUpsrPane.this.failures.length();
                int n2 = SdUpsrPane.this.successes.length();
                ImageIcon imageIcon = INFO_ICON;
                String string = "All";
                if (n > 0) {
                    if (n2 > 0) {
                        string = "Not all";
                        imageIcon = ERROR_ICON;
                    } else {
                        string = "No";
                        imageIcon = ERROR_ICON;
                    }
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (n > 0) {
                    stringBuffer.append("These circuits were not successfully switched:");
                    stringBuffer.append("\n");
                    stringBuffer.append(SdUpsrPane.this.failures.toString());
                    stringBuffer.append("\n");
                }
                if (n2 > 0) {
                    stringBuffer.append("These circuits were successfully switched:");
                    stringBuffer.append("\n");
                    stringBuffer.append(SdUpsrPane.this.successes.toString());
                    stringBuffer.append("\n");
                }
                String string2 = string + " " + SdUpsrPane.this.getUpsrTerm() + " circuits were successfully switched.";
                if (imageIcon == INFO_ICON) {
                    DetailedDialog detailedDialog = DetailedDialog.instance((Frame)JOptionPane.getFrameForComponent(SdUpsrPane.this.parent), (String)"Circuits Switch Status");
                    detailedDialog.setText(string2, imageIcon);
                    detailedDialog.append(stringBuffer.toString());
                    detailedDialog.setSize(400, detailedDialog.getHeight());
                    detailedDialog.show();
                } else {
                    ErrorMsg.displayError(JOptionPane.getFrameForComponent(SdUpsrPane.this.parent), NEMC.EID_CIRCUITS_SWITCH_ERROR, string2, stringBuffer.toString());
                }
                SdUpsrPane.this.successes = new StringBuffer();
                SdUpsrPane.this.failures = new StringBuffer();
            }
        });
    }

    private void performStep3() throws Exception {
        this.parent.setStatusText("- Provisioned the slots to " + this.parent.getNewEquipmentsString() + "\n" + this.getWorkingSlotString(this.parent.srcInfo, "  ") + "\n" + this.getWorkingSlotString(this.parent.dstInfo, "  ") + "\n");
        this.checkNodeInitiations();
        this.parent.srcInfo.changeToNewEquipment();
        this.parent.dstInfo.changeToNewEquipment();
    }

    private void performStep5() throws Exception {
        this.checkNodeInitiations();
        this.switchCircuits(this.getCircuitSpans(), 0);
        this.parent.setStatusText("- CLEAR sent\n");
    }

    public void validatePage() throws Exception {
        try {
            this.parent.setStatusText("");
            switch (this.step) {
                case 1: {
                    this.performStep1();
                    break;
                }
                case 2: {
                    this.performStep2();
                    if (!this.parent.getAllEndpointSidesNeedEqUpgrade().isEmpty()) break;
                    if (db.on()) {
                        db.fine("No side to upgrade");
                    }
                    this.parent.pressNext();
                    this.parent.pressNext();
                    break;
                }
                case 3: {
                    this.performStep3();
                    break;
                }
                case 5: {
                    this.performStep5();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            SdUpsrPane sdUpsrPane = this;
            sdUpsrPane.parent.getDebug();
            SDebug.printStackTrace((Throwable)nullPointerException);
            throw new Exception("A system or network condition is preventing Span Upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n");
        }
    }

    public void handleCancel() {
        if (db.on()) {
            db.println("step=" + this.step);
        }
        if (this.step == 4 && CerentDialog.yesNoDialog((Component)this.parent, (String)("Would you like to revert the provisioning for\n  " + this.getWorkingSlotString(this.parent.srcInfo) + "\n" + "  " + this.getWorkingSlotString(this.parent.dstInfo) + "?"), (String)"Cancel Span Upgrade", (int)0)) {
            try {
                this.parent.srcInfo.revertToOldEquipment();
                this.parent.dstInfo.revertToOldEquipment();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this.parent, (EID)NEMC.EID_GENERAL_EXCEPTION);
            }
        }
        if (this.step == 5) {
            boolean bl;
            boolean bl2 = this.parent.getSrcUpgradeType() == SpanUpgradeDialog.PPM_2_PPM_UPGRADE;
            boolean bl3 = bl = this.parent.getDstUpgradeType() == SpanUpgradeDialog.PPM_2_PPM_UPGRADE;
            if ((bl2 || bl) && CerentDialog.yesNoDialog((Component)this.parent, (String)("Would you like to revert the provisioning for" + (bl2 ? "\n  " + this.getWorkingSlotString(this.parent.srcInfo) : "") + (bl ? "\n  " + this.getWorkingSlotString(this.parent.dstInfo) : "") + "?"), (String)"Cancel Span Upgrade", (int)0)) {
                try {
                    if (bl2) {
                        this.parent.srcInfo.revertToOldEquipment();
                    }
                    if (bl) {
                        this.parent.dstInfo.revertToOldEquipment();
                    }
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)this.parent, (EID)NEMC.EID_GENERAL_EXCEPTION);
                }
            }
        }
        if (this.step >= 3 && this.step <= 5 && this.parent.getCircuitsForced() > 0 && CerentDialog.yesNoDialog((Component)this.parent, (String)("Would you like to switch all revertive " + this.getUpsrTerm() + " circuits back to this span?"), (String)"Cancel Span Upgrade", (int)0)) {
            if (!this.bothNodesInitiated()) {
                ErrorMsg.displayError((Component)this.parent, (EID)NEMC.EID_UNABLE_TO_SWITCH_CIRCUITS_BACK);
                return;
            }
            this.switchCircuits(this.getCircuitSpans(), 0);
        }
    }

    public int getNextStepNum() throws Exception {
        if (this.step == 2 && !this.parent.needChangeCardInUpgrade()) {
            this.performStep3();
            return 5;
        }
        return super.getNextStepNum();
    }
}

