/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.span;

import cerent.cms.model.Attribute;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.cms.ui.network.NetMapLink;
import cerent.cms.ui.network.NetworkMap;
import cerent.cms.ui.span.ISpanUpgrade;
import cerent.cms.ui.span.SdBlsrPane;
import cerent.cms.ui.span.SdEndpointInfo;
import cerent.cms.ui.span.SdEndpointSide;
import cerent.cms.ui.span.SdIOCardEndpointInfo;
import cerent.cms.ui.span.SdOnePlusOnePane;
import cerent.cms.ui.span.SdPpmEndpointInfo;
import cerent.cms.ui.span.SdUpsrPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;

public class SpanUpgradeDialog
extends WizardDialog {
    public static int IOCARD_2_IOCARD_UPGRADE = 0;
    public static int PPM_2_PPM_UPGRADE = 1;
    public static int IOCARD_2_PPM_UPGRADE = 2;
    public static final String MSG_UNABLE_TO_PROCEED = "A system or network condition is preventing Span Upgrade from continuing.\nIf one or both node icons are gray, they are not reachable.  Wait a few minutes\nto see if they become reachable, then continue.  If the problem persists,\nclick Cancel and then follow the manual span upgrade procedures to complete\nthe upgrade or reverse the upgrade steps completed so far.\n";
    private static final SDebug db = new SDebug("SpanUpgradeDialog");
    private INetLink netLink;
    private LinkModel linkModel;
    protected TDMTerminology terms;
    protected SdEndpointInfo srcInfo;
    protected SdEndpointInfo dstInfo;
    private NetworkMap parent;
    private String paneTitle;
    private String statusText = "";
    public JLabel spanDescLabel;
    private int circuitsForced = 0;
    private ISpanUpgrade pane;
    private String linkLabel;
    private ArrayList upsrCircuitList = new ArrayList();
    private int srcUpgradeType;
    private int dstUpgradeType;

    public SpanUpgradeDialog(Frame frame, NetworkMap networkMap, NetMapLink netMapLink) {
        this(frame, networkMap, netMapLink, "Span Upgrade", false);
    }

    public SpanUpgradeDialog(Frame frame, NetworkMap networkMap, NetMapLink netMapLink, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.parent = networkMap;
            this.linkLabel = netMapLink.getLinkDesc();
            this.netLink = (INetLink)netMapLink.getUserObject();
            if (!(this.netLink.getLinkModel() instanceof LinkModel)) {
                throw new Exception("Invalid Link Type");
            }
            this.linkModel = (LinkModel)this.netLink.getLinkModel();
            this.terms = this.linkModel.src().getTDMTerminology();
            this.getEndPointsInfo();
            switch (this.linkModel.protectionType()) {
                case 0: {
                    this.initBlsr2();
                    break;
                }
                case 1: {
                    this.initOnePlusOne();
                    break;
                }
                case 3: {
                    this.initUpsr();
                    break;
                }
                case 4: {
                    this.initBlsr4();
                    break;
                }
                default: {
                    throw new Exception("Invalid Span Type: " + this.linkModel.protectionType());
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_SPAN_UPGRADE_ERROR);
            this.setNextEnabled(false);
        }
        this.addStatusPanel(new WizardDialog.StatusPanel(this, "/images/CTC_dialogVignette.gif", new Dimension(250, 200)));
        this.setBackEnabled(false);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private void initOnePlusOne() throws Exception {
        for (int i = 1; i <= 11; ++i) {
            this.addPage(new SdOnePlusOnePane(this.getPageName(i, 11), this, i));
        }
    }

    private void initUpsr() {
        for (int i = 1; i <= 6; ++i) {
            this.addPage(new SdUpsrPane(this.getPageName(i, 6), this, i));
        }
    }

    private void initBlsr2() {
        for (int i = 1; i <= 6; ++i) {
            this.addPage(new SdBlsrPane(this.getPageName(i, 6), this, i, false));
        }
    }

    private void initBlsr4() throws Exception {
        for (int i = 1; i <= 6; ++i) {
            this.addPage(new SdBlsrPane(this.getPageName(i, 6), this, i, true));
        }
    }

    private void getEndPointsInfo() throws Exception {
        String string;
        this.paneTitle = "Upgrading " + this.getLinkLabel();
        String string2 = this.linkModel.src().getNodeModel().getName();
        if (string2.compareTo(string = this.linkModel.dst().getNodeModel().getName()) < 0) {
            this.srcInfo = SpanUpgradeDialog.createSdEndpointInfo(this.linkModel, true);
            this.dstInfo = SpanUpgradeDialog.createSdEndpointInfo(this.linkModel, false);
        } else {
            this.srcInfo = SpanUpgradeDialog.createSdEndpointInfo(this.linkModel, false);
            this.dstInfo = SpanUpgradeDialog.createSdEndpointInfo(this.linkModel, true);
        }
        this.srcUpgradeType = this.srcInfo.isIOCardUpgrade() ? IOCARD_2_IOCARD_UPGRADE : PPM_2_PPM_UPGRADE;
        this.dstUpgradeType = this.dstInfo.isIOCardUpgrade() ? IOCARD_2_IOCARD_UPGRADE : PPM_2_PPM_UPGRADE;
    }

    public String getLinkLabel() {
        return this.linkLabel;
    }

    public INetLink getNetLink() {
        return this.netLink;
    }

    public LinkModel getLinkModel() {
        return this.linkModel;
    }

    public void setEquipmentInfo(Object object, Object object2, Object object3) throws Exception {
        Attribute attribute = (Attribute)object;
        Attribute attribute2 = (Attribute)object2;
        int n = attribute.getIntValue();
        int n2 = attribute2.getIntValue();
        Attribute attribute3 = (Attribute)object3;
        int n3 = attribute3.getIntValue();
        this.setNewEqType(this.srcInfo, n, n3, this.srcUpgradeType);
        this.setNewEqType(this.dstInfo, n2, n3, this.dstUpgradeType);
    }

    private void setNewEqType(SdEndpointInfo sdEndpointInfo, int n, int n2, int n3) throws Exception {
        int n4 = 0;
        int n5 = 0;
        if (n3 == PPM_2_PPM_UPGRADE) {
            n5 = n2;
        } else {
            n4 = n;
            n5 = n2;
        }
        if (sdEndpointInfo.isIOCardUpgrade()) {
            sdEndpointInfo.setNewCardType(n4, n5);
        } else {
            sdEndpointInfo.setNewPortType(n5);
        }
    }

    private Vector getAttributesFromEqTypes(Collection collection) {
        Vector<Attribute> vector = new Vector<Attribute>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n;
            String string;
            Object e = iterator.next();
            if (!(e instanceof Integer) || (string = EqTypeHelper.getPortRateString((TDMTerminology)this.terms, (int)(n = ((Integer)e).intValue()))) == null) continue;
            vector.add(new Attribute(string, n));
        }
        return vector;
    }

    public Vector getCommonPortRates() {
        ArrayList arrayList;
        block7: {
            arrayList = new ArrayList();
            try {
                arrayList.addAll(SpanUpgradeDialog.getCommonPortElements(this.srcInfo.getListOfValidUpgradeType(), this.dstInfo.getListOfValidUpgradeType()));
                int n = this.netLink.getPhysicalType();
                if (n == 2) {
                    arrayList.remove(new Integer(29));
                } else if (n == 3) {
                    arrayList.remove(new Integer(29));
                    arrayList.remove(new Integer(30));
                } else if (n == 4) {
                    arrayList.remove(new Integer(29));
                    arrayList.remove(new Integer(30));
                    arrayList.remove(new Integer(61));
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.getAttributesFromEqTypes(arrayList);
    }

    public static List getCommonPortElements(List list, List list2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        if (list != null && list2 != null) {
            arrayList2.addAll(SpanUpgradeDialog.cardEqTypes2PortEqTypes(list));
            arrayList3.addAll(SpanUpgradeDialog.cardEqTypes2PortEqTypes(list2));
            arrayList.add(new Integer(29));
            arrayList.add(new Integer(30));
            arrayList.add(new Integer(61));
            arrayList.retainAll(arrayList2);
            arrayList.retainAll(arrayList3);
        }
        return arrayList;
    }

    private static List cardEqTypes2PortEqTypes(List list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            arrayList.addAll(EqTypeHelper.cardEqType2PortEqTypes((int)n));
        }
        return arrayList;
    }

    public Vector getAvailEquipmentsA(int n) {
        return this.getAvailEquipments(this.srcInfo, n);
    }

    public Vector getAvailEquipmentsB(int n) {
        return this.getAvailEquipments(this.dstInfo, n);
    }

    private Vector getAvailEquipments(SdEndpointInfo sdEndpointInfo, int n) {
        Vector vector = new Vector();
        if (sdEndpointInfo instanceof SdIOCardEndpointInfo) {
            ArrayList arrayList;
            try {
                arrayList = sdEndpointInfo.getListOfValidUpgradeType();
            }
            catch (Exception exception) {
                arrayList = new ArrayList();
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Integer n2 = (Integer)iterator.next();
                int n3 = n2;
                if (!this.eqTypeSupportsPortRate(n3, n)) continue;
                vector.add(n2);
            }
            vector = this.getAttributesFromEqTypes(vector);
        } else if (sdEndpointInfo instanceof SdPpmEndpointInfo) {
            String string = EqTypeHelper.getPortRateString((TDMTerminology)this.terms, (int)n);
            Attribute attribute = new Attribute("PPM Upgrade to " + string, n);
            vector.add(attribute);
        }
        return vector;
    }

    private boolean eqTypeSupportsPortRate(int n, int n2) {
        List list = EqTypeHelper.cardEqType2PortEqTypes((int)n);
        return list.contains(new Integer(n2));
    }

    public static boolean isSpanUpgradable(ILinkModel iLinkModel) {
        if (!(iLinkModel instanceof LinkModel)) {
            return false;
        }
        try {
            SdEndpointInfo sdEndpointInfo = SpanUpgradeDialog.createSdEndpointInfo((LinkModel)iLinkModel, true);
            SdEndpointInfo sdEndpointInfo2 = SpanUpgradeDialog.createSdEndpointInfo((LinkModel)iLinkModel, false);
            return !SpanUpgradeDialog.getCommonPortElements(sdEndpointInfo.getListOfValidUpgradeType(), sdEndpointInfo2.getListOfValidUpgradeType()).isEmpty();
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    public void dispose() {
        if (SpanUpgradeDialog.db.on) {
            db.println("disposing...");
        }
        this.getContentPane().removeAll();
        super.dispose();
    }

    protected void apply() throws Exception {
        this.parent.endSpanUpgrade();
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String string) {
        this.statusText = string;
    }

    public void setObserverPane(ISpanUpgrade iSpanUpgrade) {
        this.pane = iSpanUpgrade;
    }

    public void setCircuitsForced(int n) {
        this.circuitsForced = n;
    }

    public int getCircuitsForced() {
        return this.circuitsForced;
    }

    public void setUpsrCircuitList(ArrayList arrayList) {
        this.upsrCircuitList = arrayList;
    }

    public ArrayList getUpsrCircuitList() {
        return this.upsrCircuitList;
    }

    protected void handleCancel() {
        if (this.pane != null) {
            this.pane.handleCancel();
        }
        this.parent.endSpanUpgrade();
    }

    protected String getCancelMessage() {
        return "Canceling span upgrade may require that you complete the upgrade manually.\n" + super.getCancelMessage();
    }

    private static SdEndpointInfo createSdEndpointInfo(LinkModel linkModel, boolean bl) throws Exception {
        IPortModel iPortModel = SpanUpgradeDialog.getPortModel(linkModel, bl);
        if (iPortModel.getParent() instanceof IModuleModel) {
            return new SdIOCardEndpointInfo(linkModel, bl);
        }
        return new SdPpmEndpointInfo(linkModel, bl);
    }

    public static IPortModel getPortModel(LinkModel linkModel, boolean bl) throws Exception {
        if (bl) {
            return SpanUpgradeDialog.getPortModel(linkModel.src(), linkModel.srcEntityIndex());
        }
        return SpanUpgradeDialog.getPortModel(linkModel.dst(), linkModel.dstEntityIndex());
    }

    public static IPortModel getPortModel(INodeModel iNodeModel, int n) throws Exception {
        try {
            return (IPortModel)iNodeModel.getEntityTable().getEntityModelByIndex(n);
        }
        catch (Exception exception) {
            SpanUpgradeDialog.getDebug();
            SDebug.printStackTrace((Throwable)exception);
            throw new Exception(MSG_UNABLE_TO_PROCEED);
        }
    }

    public int getSrcUpgradeType() {
        return this.srcUpgradeType;
    }

    public int getDstUpgradeType() {
        return this.dstUpgradeType;
    }

    public static SDebug getDebug() {
        return db;
    }

    public List getAllEndpointSidesNeedEqUpgrade() {
        List list = this.getAllEndpointSidesNeedEqUpgrade(1);
        List list2 = this.getAllEndpointSidesNeedEqUpgrade(2);
        list.addAll(list2);
        return list;
    }

    public List getAllEndpointSides(int n) {
        ArrayList<SdEndpointSide> arrayList = new ArrayList<SdEndpointSide>();
        SdEndpointSide[] sdEndpointSideArray = new SdEndpointSide[]{this.srcInfo.getEndpointSide(n), this.dstInfo.getEndpointSide(n)};
        for (int i = 0; i < sdEndpointSideArray.length; ++i) {
            if (sdEndpointSideArray[i] == null) continue;
            arrayList.add(sdEndpointSideArray[i]);
        }
        return arrayList;
    }

    public List getAllEndpointSides() {
        List list = this.getAllEndpointSides(1);
        list.addAll(this.getAllEndpointSides(2));
        return list;
    }

    public List getAllEndpointSidesNeedEqUpgrade(int n) {
        ArrayList<SdEndpointSide> arrayList = new ArrayList<SdEndpointSide>();
        Iterator iterator = this.getAllEndpointSides(n).iterator();
        while (iterator.hasNext()) {
            SdEndpointSide sdEndpointSide = (SdEndpointSide)iterator.next();
            if (!sdEndpointSide.needEquipmentChangeInUpgrade()) continue;
            arrayList.add(sdEndpointSide);
        }
        return arrayList;
    }

    public boolean needChangeCardInUpgrade() {
        Iterator iterator = this.getAllEndpointSides().iterator();
        while (iterator.hasNext()) {
            SdEndpointSide sdEndpointSide = (SdEndpointSide)iterator.next();
            if (!sdEndpointSide.needToChangeCardInUpgrade()) continue;
            return true;
        }
        return false;
    }

    public String getOldEquipmentsString() {
        return this.getEquipmentsString(false, this.getAllEndpointSidesNeedEqUpgrade());
    }

    public String getNewEquipmentsString() {
        return this.getEquipmentsString(true, this.getAllEndpointSidesNeedEqUpgrade());
    }

    public String getOldEquipmentsString(int n) {
        return this.getEquipmentsString(false, this.getAllEndpointSidesNeedEqUpgrade(n));
    }

    public String getNewEquipmentsString(int n) {
        return this.getEquipmentsString(true, this.getAllEndpointSidesNeedEqUpgrade(n));
    }

    private String getEquipmentsString(boolean bl, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n;
            String string;
            SdEndpointSide sdEndpointSide = (SdEndpointSide)iterator.next();
            if (db.on()) {
                db.info("side = " + sdEndpointSide);
            }
            if (hashSet.contains(string = EqTypeHelper.getPortRateString((TDMTerminology)this.terms, (int)(n = bl ? sdEndpointSide.getNewEquipmentType() : sdEndpointSide.getOldEquipmentType())))) continue;
            hashSet.add(string);
            stringBuffer.append((stringBuffer.length() == 0 ? "" : "/") + string);
        }
        return stringBuffer.toString();
    }

    private String getPageName(int n, int n2) {
        return (n == n2 ? "" : "Step " + n + ": ") + this.paneTitle;
    }

    private String getPageName(int n, ISpanUpgrade iSpanUpgrade) {
        if (iSpanUpgrade instanceof SdUpsrPane) {
            return this.getPageName(n, 6);
        }
        if (iSpanUpgrade instanceof SdBlsrPane) {
            return this.getPageName(n, 6);
        }
        return this.getPageName(n, 11);
    }

    protected void handleNext(String string) throws Exception {
        if (this.pane != null) {
            int n = this.pane.getNextStepNum();
            if (db.on()) {
                db.info("pageTitle=" + this.getPageName(n, this.pane));
            }
            this.showPage(this.getPageName(n, this.pane), true);
        }
    }

    protected void handleBack(String string) {
        super.handleBack(string);
        try {
            this.getCurrent().refresh();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }
}

