/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.Feature;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.ncp.EtherNodeDropCircuitEnd;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ui.vlan.VlanStpEntry;
import cerent.util.IAsyncObserver;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class VlanStpDataSource
extends AbstractRowDataSource
implements Runnable {
    private static final SDebug db = new SDebug("VlanStpDataSource");
    private IEtherBridgeModel etherbridge;
    private ArrayList rows = new ArrayList();
    private IAsyncObserver refreshObserver = null;

    public VlanStpDataSource(IEtherBridgeModel iEtherBridgeModel) {
        this.etherbridge = iEtherBridgeModel;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rows.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection getAllObjects() {
        return new ArrayList(this.rows);
    }

    public void refresh(IAsyncObserver iAsyncObserver) {
        this.refreshObserver = iAsyncObserver;
        new Thread(this).start();
    }

    private void retrieveCkts(ArrayList arrayList) {
        INodeModel iNodeModel = this.etherbridge.getNodeModel();
        List list = NetCircuitManager.instance().getCircuits(iNodeModel);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit;
            block7: {
                iNetCircuit = (INetCircuit)iterator.next();
                if (db.on()) {
                    db.println("Evaluating ckt=" + iNetCircuit.getCircuitName() + " stp=" + iNetCircuit.isStpEnabled() + " src=" + iNetCircuit.getPrimarySource());
                }
                if (!iNetCircuit.isCircuitRefValid() || !iNetCircuit.isStpEnabled()) continue;
                try {
                    if (!iNetCircuit.isVlanCapable()) {
                    }
                    break block7;
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)incorrectCircuitState);
                }
                continue;
            }
            IVlanModel[] iVlanModelArray = iNetCircuit.getVlans();
            int n = -1;
            try {
                n = this.etherbridge.getCircuitStpId(iNetCircuit.getCircuitId());
            }
            catch (Exception exception) {
                db.println("While retrieving SPT ID for ckt=" + iNetCircuit.getCircuitName());
                SDebug.printStackTrace((Throwable)exception);
            }
            String string = iNetCircuit.getPrimarySource() instanceof EtherNodeDropCircuitEnd ? "EtherSwitch group" : "EtherSwitch point-to-point";
            arrayList.add(new VlanStpEntry(string, iNetCircuit.getCircuitName(), n, iVlanModelArray));
        }
    }

    public void changed() {
        this.fireDataSourceChanged();
    }

    private void retrievePorts(ArrayList arrayList) {
        IPortModel[] iPortModelArray = this.etherbridge.getStpFrontPorts();
        for (int i = 0; i < iPortModelArray.length; ++i) {
            IPortModel iPortModel = iPortModelArray[i];
            int n = this.etherbridge.getPortStpId(iPortModel);
            if (n <= 0) continue;
            IVlanModel[] iVlanModelArray = this.etherbridge.getPortVlanList(iPortModel);
            String string = iPortModel.getEqTypeName();
            int[] nArray = iPortModel.getNodeModel().provides(Feature.EXP_PORT_NUM) ? iPortModel.getPortNum() : new int[]{iPortModel.getPort()};
            arrayList.add(new VlanStpEntry(string, iPortModel.getSlot(), nArray, n, iVlanModelArray));
        }
    }

    public void run() {
        ArrayList arrayList = new ArrayList();
        this.retrieveCkts(arrayList);
        this.retrievePorts(arrayList);
        Collections.sort(arrayList);
        this.rows = arrayList;
        this.fireDataSourceChanged();
        if (this.refreshObserver != null) {
            this.refreshObserver.asyncUpdate((Object)this, JobStatus.JOB_COMPLETE);
        }
    }
}

