/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeShelfModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.vlan.VlanStpColumnRenderer;
import cerent.cms.ui.vlan.VlanStpDataSource;
import cerent.cms.ui.vlan.VlanStpEntry;
import cerent.util.IAsyncObserver;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class VlanStpPane
extends AbstractPane
implements ActionListener,
Runnable,
IAsyncObserver {
    private JPanel watchPanel;
    private JButton refreshButton;
    private JButton closeButton;
    private JLabel refreshLabel;
    private static SDebug db = new SDebug("VlanStpPane");
    private VlanStpDataSource dataSource;
    private SortableRowTableModel tableModel;
    private IVlanModel[] preselVlans;
    private JDialog closeDialog;
    private String refreshLabelText;
    private boolean presel;

    public VlanStpPane(String string, TabbedView tabbedView) {
        super(string, null, tabbedView);
        IEtherBridgeModel iEtherBridgeModel;
        if (tabbedView != null) {
            iEtherBridgeModel = null;
            if (tabbedView.getUiModel() instanceof INodeShelfModel) {
                INodeShelfModel iNodeShelfModel = (INodeShelfModel)tabbedView.getUiModel();
                iEtherBridgeModel = iNodeShelfModel.getEtherBridgeModel();
            } else {
                INodeModel iNodeModel = (INodeModel)tabbedView.getUiModel();
                iEtherBridgeModel = iNodeModel.getEtherBridgeModel();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.init(iEtherBridgeModel, null, null);
    }

    public VlanStpPane(JDialog jDialog, IEtherBridgeModel iEtherBridgeModel, IVlanModel[] iVlanModelArray) {
        super("VlanStpPane", null, null);
        this.init(iEtherBridgeModel, iVlanModelArray, jDialog);
    }

    private void init(IEtherBridgeModel iEtherBridgeModel, IVlanModel[] iVlanModelArray, JDialog jDialog) {
        this.uiToolkit = iEtherBridgeModel.getNodeModel().getUiToolkit();
        this.setLayout(new BorderLayout());
        this.presel = iVlanModelArray != null && iVlanModelArray.length > 0;
        ColumnRenderer[] columnRendererArray = VlanStpColumnRenderer.createTableRenderers();
        this.dataSource = new VlanStpDataSource(iEtherBridgeModel);
        this.tableModel = new SortableRowTableModel((RowDataSource)this.dataSource, columnRendererArray);
        this.table = new UTable((TableModel)((Object)this.tableModel));
        this.tableModel.initTable(this.table);
        this.add((Component)new UScrollPane((Component)this.table));
        this.createButtonPanel(jDialog);
        this.preselVlans = iVlanModelArray;
        if (!this.presel) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
            this.table.getColumnModel().removeColumn(tableColumn);
            this.table.setSelectionMode(2);
        } else {
            JLabel jLabel = new JLabel("Selected entries use one or more of the VLANS requested for the circuit creation/edition");
            this.add(jLabel, "North");
        }
    }

    private void createButtonPanel(JDialog jDialog) {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(NetCSHelpConst.VlanStpPane);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        this.refreshLabel = new JLabel(" ");
        cSHelpButtonPane.addLeft(this.refreshButton);
        if (jDialog != null) {
            this.closeButton = new JButton("Close");
            this.closeButton.addActionListener(this);
            cSHelpButtonPane.addRight(this.closeButton);
            this.closeDialog = jDialog;
        }
        cSHelpButtonPane.addRight(this.refreshLabel);
        this.add(cSHelpButtonPane, "South");
    }

    public CSHelpID getHelpID() {
        return NetCSHelpConst.VlanStpPane;
    }

    public void updateRefreshLabel(Date date) {
        this.refreshLabelText = date != null ? "Refreshed:" + VlanStpPane.getFormattedDateTime(date) : "Retrieving VLAN and Spanning Tree data from node...";
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        try {
            this.uiToolkit.setCursor(3);
            if (object == this.refreshButton) {
                this.refresh();
            } else if (object == this.closeButton) {
                this.closeDialog.dispose();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
    }

    public void enteringPage() throws Exception {
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName() + "-" + this.presel);
        this.refresh();
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName() + "-" + this.presel);
    }

    public void refresh() {
        this.refreshButton.setEnabled(false);
        this.updateRefreshLabel(null);
        this.dataSource.refresh(this);
    }

    public void destroy() {
        if (null != this.table) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        if (null != this.refreshButton) {
            this.refreshButton.removeActionListener(this);
        }
        this.watchPanel = null;
        this.refreshButton = null;
        this.refreshLabel = null;
        super.destroy();
    }

    private void updateTableSelection() {
        int n;
        if (db.on()) {
            db.println("updateSelection preselVlans=" + this.preselVlans);
            if (this.preselVlans != null) {
                for (n = 0; n < this.preselVlans.length; ++n) {
                    db.println("   " + n + "=" + this.preselVlans[n].getName() + "/" + this.preselVlans[n].getId());
                }
            }
        }
        if (this.preselVlans != null) {
            for (n = 0; n < this.dataSource.getRowCount(); ++n) {
                VlanStpEntry vlanStpEntry = (VlanStpEntry)this.dataSource.getObjectAtRow(n);
                IVlanModel[] iVlanModelArray = vlanStpEntry.getVlans();
                boolean bl = false;
                for (int i = 0; i < this.preselVlans.length; ++i) {
                    boolean bl2 = false;
                    for (int j = 0; j < iVlanModelArray.length; ++j) {
                        if (this.preselVlans[i] != iVlanModelArray[j] && this.preselVlans[i].getId() != iVlanModelArray[j].getId()) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break;
                }
                vlanStpEntry.setSelected(bl);
                if (!db.on()) continue;
                db.println("updateSelection " + vlanStpEntry + " sel=" + bl);
            }
            this.dataSource.changed();
        }
    }

    public void run() {
        this.refreshLabel.setText(this.refreshLabelText);
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        this.updateTableSelection();
        this.updateRefreshLabel(new Date());
        this.refreshButton.setEnabled(true);
    }
}

