/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.vlan;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DuplicateVlan;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoMoreVlan;
import cerent.cms.model.NoSuchVlan;
import cerent.cms.model.VlanIdOutOfRange;
import cerent.cms.model.VlanInUse;
import cerent.cms.model.VlanNameTooLong;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.ITopology;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.cms.vlan.IoError;
import cerent.cms.vlan.NetVlanInfo;
import cerent.cms.vlan.NetVlanInfoComparator;
import cerent.cms.vlan.VlanInUseInNetwork;
import cerent.cms.vlan.VlanInfoComparator;
import cerent.util.ComparisonUtil;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class VlanSetManager
extends CmsObservable
implements IObserver {
    public static String DEFAULT_VLAN_NAME = "default";
    public static short DEFAULT_VLAN_ID = 1;
    public static short MAX_VLAN_ID = (short)4093;
    public static short MAX_VLAN_NAME_LEN = (short)32;
    private static VlanSetManager manager;
    private SortedSet newNodeSet = Collections.synchronizedSortedSet(new TreeSet(new NetElemComparator()));
    private SortedSet changedNodeSet = Collections.synchronizedSortedSet(new TreeSet(new NetElemComparator()));
    private SortedSet phantomLinkSet = Collections.synchronizedSortedSet(new TreeSet(new NetLinkComparator()));
    private Map vlanModelMap = null;
    private Object vlanModelMapLockObject;
    private Set vlanCapableNodes = new HashSet();
    private static final SDebug dbg;

    public static synchronized VlanSetManager instance() {
        if (manager == null) {
            manager = new VlanSetManager();
        }
        return manager;
    }

    private VlanSetManager() {
        this.vlanModelMapLockObject = new Object();
        Thread thread = new Thread("VlanSetManager"){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            1.sleep(6000L);
                            VlanSetManager.this.processNewNode();
                            VlanSetManager.this.processChangedNodes();
                            VlanSetManager.this.processPhantomLinks();
                        }
                    }
                    catch (Exception exception) {
                        dbg.println("Vlan Set Manager hit an exception");
                        dbg;
                        SDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setName("CTC VLanProcessThread");
        thread.start();
    }

    private void newNetElement(INetElement iNetElement) {
        if (iNetElement != null) {
            this.newNodeSet.add(iNetElement);
        }
    }

    private void newPhantomLink(INetLink iNetLink) {
        if (iNetLink != null) {
            this.phantomLinkSet.add(iNetLink);
        }
    }

    private IEtherBridgeModel getEtherBridge(INodeModel iNodeModel, String string) {
        IEtherBridgeModel iEtherBridgeModel = null;
        if (iNodeModel != null && iNodeModel.isInited()) {
            iEtherBridgeModel = iNodeModel.getEtherBridgeModel();
            if (iEtherBridgeModel == null && dbg.on()) {
                dbg.println(string + ": unable to get EtherBridgeModel on " + this.getNameOf(iNodeModel));
            }
        } else if (dbg.on()) {
            dbg.println(string + ": node " + this.getNameOf(iNodeModel) + " is not initialized");
        }
        return iEtherBridgeModel;
    }

    public Collection allVlansList() {
        TreeSet<IVlanModel> treeSet = new TreeSet<IVlanModel>(new VlanInfoComparator());
        Iterator iterator = this.allVlansMap().values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((TreeSet)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                NetVlanInfo netVlanInfo = (NetVlanInfo)iterator2.next();
                treeSet.add(netVlanInfo.getVlan());
            }
        }
        return treeSet;
    }

    public Collection allNetVlansList() {
        TreeSet treeSet = new TreeSet(new NetVlanInfoComparator());
        Iterator iterator = this.allVlansMap().values().iterator();
        while (iterator.hasNext()) {
            treeSet.addAll((TreeSet)iterator.next());
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map allVlansMap() {
        AbstractSet abstractSet;
        Iterator iterator;
        Network network = Network.instance();
        Object object = this.vlanModelMapLockObject;
        synchronized (object) {
            if (this.vlanModelMap != null) {
                iterator = network.getTopologies().iterator();
                abstractSet = new HashSet<Integer>();
                if (iterator.hasNext()) {
                    abstractSet.add(new Integer(((ITopology)iterator.next()).getTopoId()));
                }
                if (((Object)this.vlanModelMap.keySet()).equals(abstractSet)) {
                    return this.vlanModelMap;
                }
            }
        }
        iterator = network.getTopologies().iterator();
        abstractSet = new TreeSet(new NetVlanInfoComparator());
        if (this.vlanModelMap == null) {
            this.vlanModelMap = new HashMap();
        } else {
            this.vlanModelMap.clear();
        }
        if (dbg.on()) {
            dbg.println("Update vlanModelMap");
        }
        while (iterator.hasNext()) {
            object = (ITopology)iterator.next();
            int n = object.getTopoId();
            ((TreeSet)abstractSet).addAll(this.allVlansList((ITopology)object));
            Object object2 = this.vlanModelMapLockObject;
            synchronized (object2) {
                TreeSet treeSet = new TreeSet(new NetVlanInfoComparator());
                treeSet.addAll(abstractSet);
                this.vlanModelMap.put(new Integer(n), treeSet);
            }
            ((TreeSet)abstractSet).clear();
        }
        return this.vlanModelMap;
    }

    public Collection allVlansList(INetElement iNetElement) {
        Topology topology = iNetElement.getTopology();
        return this.allVlansList(topology);
    }

    public Collection allVlansList(ITopology iTopology) {
        int n = iTopology.getTopoId();
        Iterator iterator = this.getNodesWithTopoId(n).iterator();
        TreeSet<IVlanModel> treeSet = new TreeSet<IVlanModel>(new VlanInfoComparator());
        TreeSet<NetVlanInfo> treeSet2 = new TreeSet<NetVlanInfo>(new NetVlanInfoComparator());
        TreeSet<NetVlanInfo> treeSet3 = new TreeSet<NetVlanInfo>(new NetVlanInfoComparator());
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            IEtherBridgeModel iEtherBridgeModel = this.getEtherBridge(iNetElement.getNodeModel(), "allVlansList");
            if (iEtherBridgeModel == null) continue;
            try {
                treeSet.addAll(Arrays.asList(iEtherBridgeModel.getVlanList()));
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (dbg.on()) {
                    dbg.println("allVlansList: Cms IO Exception on " + this.getNameOf(iNetElement));
                }
                treeSet.clear();
                continue;
            }
            Iterator iterator2 = treeSet.iterator();
            while (iterator2.hasNext()) {
                NetVlanInfo netVlanInfo;
                IVlanModel iVlanModel = (IVlanModel)iterator2.next();
                try {
                    netVlanInfo = new NetVlanInfo(iVlanModel, n);
                }
                catch (Exception exception) {
                    if (!dbg.on()) continue;
                    dbg.println("initialize NetVlanInfo: hit exception on " + this.getNameOf(iNetElement));
                    continue;
                }
                treeSet2.add(netVlanInfo);
            }
            treeSet3.addAll(treeSet2);
            if (dbg.on()) {
                dbg.println("allVlansList: adding " + treeSet2.size() + " Vlans from " + this.getNameOf(iNetElement) + " to topo id = " + n);
                dbg.println("Total Vlans = " + treeSet3.size() + " in topology of id = " + n);
            }
            treeSet.clear();
            treeSet2.clear();
        }
        return treeSet3;
    }

    public static IVlanInfo[] vlanModelToVlanInfo(IVlanModel[] iVlanModelArray) {
        IVlanInfo[] iVlanInfoArray = new IVlanInfo[iVlanModelArray.length];
        for (int i = 0; i < iVlanModelArray.length; ++i) {
            iVlanInfoArray[i] = iVlanModelArray[i].getVlanInfo();
        }
        return iVlanInfoArray;
    }

    public void createVlan(short s, String string) throws DuplicateVlan, NoMoreVlan, VlanIdOutOfRange, VlanNameTooLong {
        this.createVlan(s, string, Network.instance().getNonDefaultTopoOfSmallestId(), true);
    }

    public void createVlan(short s, String string, ITopology iTopology) throws DuplicateVlan, NoMoreVlan, VlanIdOutOfRange, VlanNameTooLong {
        this.createVlan(s, string, iTopology, true);
    }

    private void createVlan(short s, String string, ITopology iTopology, boolean bl) throws DuplicateVlan, NoMoreVlan, VlanIdOutOfRange, VlanNameTooLong {
        Iterator iterator = this.getNodesWithTopoId(iTopology.getTopoId()).iterator();
        if (dbg.on()) {
            dbg.println("createVlan() in topoId = " + iTopology.getTopoId());
        }
        if (bl && this.containsVlan(s, string, iTopology)) {
            throw new DuplicateVlan("DuplicateVlan");
        }
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            IEtherBridgeModel iEtherBridgeModel = this.getEtherBridge(iNetElement.getNodeModel(), "createVlan");
            if (iEtherBridgeModel == null) continue;
            try {
                iEtherBridgeModel.createVlan(s, string);
            }
            catch (DuplicateVlan duplicateVlan) {
                if (!dbg.on()) continue;
                dbg.println("createVlan: VLAN already known to " + this.getNameOf(iNetElement));
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!dbg.on()) continue;
                dbg.println("createVlan: CMS IO exception at " + this.getNameOf(iNetElement));
            }
        }
    }

    private void restoreVlan(short s, String string, ITopology iTopology) {
        block8: {
            try {
                this.createVlan(s, string, iTopology, false);
            }
            catch (VlanIdOutOfRange vlanIdOutOfRange) {
                if (dbg.on()) {
                    dbg.println("OutOfRangeEx while trying to restore VLAN");
                }
            }
            catch (DuplicateVlan duplicateVlan) {
                if (dbg.on()) {
                    dbg.println("DuplicateEx while trying to restore VLAN");
                }
            }
            catch (NoMoreVlan noMoreVlan) {
                if (dbg.on()) {
                    dbg.println("NoMoreVlanEx while trying to restore VLAN");
                }
            }
            catch (VlanNameTooLong vlanNameTooLong) {
                if (!dbg.on()) break block8;
                dbg.println("NameTooLongEx while trying to restore VLAN");
            }
        }
    }

    public void deleteVlan(IVlanModel iVlanModel) throws VlanInUseInNetwork, IoError {
        this.deleteVlan(iVlanModel, Network.instance().getNonDefaultTopoOfSmallestId());
    }

    private boolean inUse(short s, ITopology iTopology) throws IoError {
        Iterator iterator = this.getNodesWithTopoId(iTopology.getTopoId()).iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            IEtherBridgeModel iEtherBridgeModel = this.getEtherBridge(iNetElement.getNodeModel(), "deleteVlan");
            if (iEtherBridgeModel == null) {
                throw new IoError("Unable to verify use of VLAN at " + this.getNameOf(iNetElement));
            }
            Iterator<IVlanModel> iterator2 = Arrays.asList(iEtherBridgeModel.getVlanList()).iterator();
            while (iterator2.hasNext()) {
                IVlanModel iVlanModel = iterator2.next();
                if (iVlanModel.getId() != s || !iVlanModel.inUse()) continue;
                if (dbg.on()) {
                    dbg.println("vlan in use at " + this.getNameOf(iNetElement));
                }
                return true;
            }
        }
        return false;
    }

    public void deleteVlan(IVlanModel iVlanModel, ITopology iTopology) throws VlanInUseInNetwork, IoError {
        Iterator iterator = this.getNodesWithTopoId(iTopology.getTopoId()).iterator();
        if (this.inUse(iVlanModel.getId(), iTopology)) {
            throw new VlanInUseInNetwork("VLAN in use in topology " + iTopology.getTopoId());
        }
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            IEtherBridgeModel iEtherBridgeModel = this.getEtherBridge(iNetElement.getNodeModel(), "deleteVlan");
            if (iEtherBridgeModel == null) {
                throw new IoError("Unable to delete VLAN at " + this.getNameOf(iNetElement));
            }
            try {
                iEtherBridgeModel.deleteVlan(iVlanModel.getId());
            }
            catch (NoSuchVlan noSuchVlan) {
                if (!dbg.on()) continue;
                dbg.println("deleteVlan: VLAN not known at " + this.getNameOf(iNetElement));
            }
            catch (VlanInUse vlanInUse) {
                block9: {
                    if (dbg.on()) {
                        dbg.println("deleteVlan: VLAN in use at " + this.getNameOf(iNetElement));
                    }
                    try {
                        this.restoreVlan(iVlanModel.getId(), iVlanModel.getName(), iTopology);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (!dbg.on()) break block9;
                        dbg.println("deleteVlan: CMS IO exception at " + this.getNameOf(iNetElement));
                    }
                }
                throw new VlanInUseInNetwork("VLAN in use at " + this.getNameOf(iNetElement));
            }
        }
    }

    public IVlanModel defaultVlan() {
        return this.findVlanModel(DEFAULT_VLAN_ID);
    }

    public IVlanModel findVlanModel(short s) {
        return this.findVlanModel(s, Network.instance().getNonDefaultTopoOfSmallestId());
    }

    public IVlanModel findVlanModel(short s, ITopology iTopology) {
        Collection collection = this.allVlansList(iTopology);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            NetVlanInfo netVlanInfo = (NetVlanInfo)iterator.next();
            IVlanModel iVlanModel = netVlanInfo.getVlan();
            if (s != iVlanModel.getId()) continue;
            return iVlanModel;
        }
        return null;
    }

    public boolean containsVlan(short s) {
        return this.containsVlan(s, (ITopology)Network.instance().getNonDefaultTopoOfSmallestId());
    }

    public boolean containsVlan(short s, ITopology iTopology) {
        Collection collection = this.allVlansList(iTopology);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            NetVlanInfo netVlanInfo = (NetVlanInfo)iterator.next();
            IVlanModel iVlanModel = netVlanInfo.getVlan();
            if (s != iVlanModel.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean containsVlan(String string) {
        return this.containsVlan(string, (ITopology)Network.instance().getNonDefaultTopoOfSmallestId());
    }

    public boolean containsVlan(String string, ITopology iTopology) {
        Collection collection = this.allVlansList(iTopology);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            NetVlanInfo netVlanInfo = (NetVlanInfo)iterator.next();
            IVlanModel iVlanModel = netVlanInfo.getVlan();
            try {
                if (!iVlanModel.getName().equals(string)) continue;
                return true;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                dbg.finest("AbstractCmsIOException in containsVlan(), vlan=" + string + " " + (Object)((Object)abstractCmsIOException));
            }
        }
        return false;
    }

    public boolean containsVlan(short s, String string) {
        return this.containsVlan(s, string, Network.instance().getNonDefaultTopoOfSmallestId());
    }

    public boolean containsVlan(short s, String string, ITopology iTopology) {
        Collection collection = this.allVlansList(iTopology);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            NetVlanInfo netVlanInfo = (NetVlanInfo)iterator.next();
            IVlanModel iVlanModel = netVlanInfo.getVlan();
            try {
                if (s != iVlanModel.getId() && !iVlanModel.getName().equals(string)) continue;
                return true;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                dbg.finest("AbstractCmsIOException in containsVlan(), vlan=" + string + ", vlanId=" + s + " " + (Object)((Object)abstractCmsIOException));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNewNode() {
        Object object;
        INodeModel iNodeModel;
        Object object2;
        NetElement netElement = null;
        LinkedList<NetElement> linkedList = new LinkedList<NetElement>();
        boolean bl = false;
        while (this.newNodeSet.size() != 0) {
            try {
                try {
                    object2 = this.newNodeSet;
                    synchronized (object2) {
                        netElement = (NetElement)this.newNodeSet.first();
                        this.newNodeSet.remove(netElement);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!dbg.on()) break;
                    dbg.println("Somehow the vlan nodeset list became empty!");
                    break;
                }
                if (netElement == null || netElement.isDeleted()) {
                    if (!dbg.on()) continue;
                    dbg.println("Vlan: NetElem is null!");
                    continue;
                }
                iNodeModel = netElement.getNodeModel();
                if (iNodeModel == null) {
                    if (!dbg.on()) continue;
                    dbg.println("NodeModel is null!");
                    continue;
                }
                object2 = this.getEtherBridge(iNodeModel, "newNode");
                if (object2 == null) {
                    if (dbg.on()) {
                        dbg.println(this.getNameOf(netElement) + " failed to get EtherBridgeModel" + " - will retry");
                    }
                    if (netElement == null) continue;
                    linkedList.add(netElement);
                    continue;
                }
                try {
                    object2.getVlanIdList();
                    if (dbg.on()) {
                        dbg.println(this.getNameOf(netElement) + " is vlan capable");
                    }
                    this.vlanCapableNodes.add(netElement);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!dbg.on()) continue;
                    dbg.println(this.getNameOf(netElement) + " is not vlan capable");
                    continue;
                }
                catch (AbstractMethodError abstractMethodError) {
                    if (dbg.on()) {
                        dbg.println(this.getNameOf(netElement) + " is vlan capable");
                    }
                    this.vlanCapableNodes.add(netElement);
                }
                object = new LinkedList();
                ((LinkedList)object).addAll(Arrays.asList(object2.getVlanList()));
                Iterator iterator = ((AbstractSequentialList)object).iterator();
                while (iterator.hasNext()) {
                    IVlanModel iVlanModel = (IVlanModel)iterator.next();
                    iVlanModel.addObserver((IObserver)this);
                    try {
                        short s = iVlanModel.getId();
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        iVlanModel.deleteObserver((IObserver)this);
                    }
                }
                ((LinkedList)object).clear();
                object2.addObserver((IObserver)this);
                this.invalidate();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (dbg.on()) {
                    dbg.println(abstractCmsIOException.toString() + " exception at node " + this.getNameOf(netElement) + ", will try after 6 seconds");
                }
                if (netElement == null) continue;
                linkedList.add(netElement);
                continue;
            }
            bl = true;
        }
        if (!bl) {
            this.newNodeSet.addAll(linkedList);
            return;
        }
        object2 = this.vlanCapableNodes.iterator();
        while (object2.hasNext()) {
            object = (NetElement)object2.next();
            try {
                iNodeModel = ((NetElement)object).getNodeModel();
                if (iNodeModel == null) {
                    if (!dbg.on()) continue;
                    dbg.println("NodeModel is null!!!!");
                    continue;
                }
                this.ensureAllVlansExist((INetElement)object);
            }
            catch (IoError ioError) {
                if (dbg.on()) {
                    dbg.println(ioError.toString() + " IoError at node " + this.getNameOf((INetElement)object) + ", will try after 6 seconds");
                }
                linkedList.add((NetElement)object);
            }
        }
        this.newNodeSet.addAll(linkedList);
        this.sendOutNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChangedNodes() {
        if (this.changedNodeSet.size() != 0) {
            LinkedList linkedList;
            Object object = this.changedNodeSet;
            synchronized (object) {
                linkedList = new LinkedList(this.changedNodeSet);
                this.changedNodeSet.clear();
            }
            object = linkedList.iterator();
            while (object.hasNext()) {
                INetElement iNetElement = (INetElement)object.next();
                IEtherBridgeModel iEtherBridgeModel = this.getEtherBridge(iNetElement.getNodeModel(), "changedNodes");
                if (iEtherBridgeModel == null) continue;
                LinkedList<IVlanModel> linkedList2 = new LinkedList<IVlanModel>();
                linkedList2.addAll(Arrays.asList(iEtherBridgeModel.getVlanList()));
                Iterator iterator = linkedList2.iterator();
                while (iterator.hasNext()) {
                    IVlanModel iVlanModel = (IVlanModel)iterator.next();
                    iVlanModel.addObserver((IObserver)this);
                    try {
                        short s = iVlanModel.getId();
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        iVlanModel.deleteObserver((IObserver)this);
                    }
                }
            }
            this.invalidateAndNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPhantomLinks() {
        if (this.phantomLinkSet.size() != 0) {
            LinkedList linkedList;
            Object object = this.phantomLinkSet;
            synchronized (object) {
                linkedList = new LinkedList(this.phantomLinkSet);
                this.phantomLinkSet.clear();
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (INetLink)iterator.next();
                INetElement iNetElement = object.getSrc();
                INetElement iNetElement2 = object.getDst();
                try {
                    this.ensureVlansExist(iNetElement.getTopology(), iNetElement2);
                    this.ensureVlansExist(iNetElement2.getTopology(), iNetElement);
                    this.invalidateAndNotify(iNetElement.getTopology());
                    this.invalidateAndNotify(iNetElement2.getTopology());
                }
                catch (IoError ioError) {
                    if (dbg.on()) {
                        dbg.println(ioError.toString() + " IoError at either node " + this.getNameOf(iNetElement) + " or " + this.getNameOf(iNetElement2) + ", will try after 6 seconds");
                    }
                    this.phantomLinkSet.add(object);
                }
            }
        }
    }

    public void ensureVlansExist(INodeModel iNodeModel, IVlanModel[] iVlanModelArray) throws IoError {
        IEtherBridgeModel iEtherBridgeModel = this.getEtherBridge(iNodeModel, "ensureVlansExist");
        if (iEtherBridgeModel == null) {
            return;
        }
        TreeSet<IVlanModel> treeSet = new TreeSet<IVlanModel>(new VlanComparator());
        treeSet.addAll(Arrays.asList(iEtherBridgeModel.getVlanList()));
        Iterator<IVlanModel> iterator = Arrays.asList(iVlanModelArray).iterator();
        while (iterator.hasNext()) {
            IVlanModel iVlanModel = iterator.next();
            if (treeSet.contains(iVlanModel)) continue;
            try {
                iEtherBridgeModel.createVlan(iVlanModel.getId(), iVlanModel.getName());
            }
            catch (DuplicateVlan duplicateVlan) {
                if (!dbg.on()) continue;
                dbg.println("ensureVlansExist: vlan already known");
            }
            catch (VlanIdOutOfRange vlanIdOutOfRange) {
                if (!dbg.on()) continue;
                dbg.println("ensureVlansExist: VLAN id out of range");
            }
            catch (NoMoreVlan noMoreVlan) {
                if (!dbg.on()) continue;
                dbg.println("ensureVlansExist: No more vlans");
            }
            catch (VlanNameTooLong vlanNameTooLong) {
                if (!dbg.on()) continue;
                dbg.println("ensureVlansExist: VLAN name too long");
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (dbg.on()) {
                    dbg.println("ensureVlansExist: I/O error with network element");
                }
                throw new IoError("CMS IO Error");
            }
        }
        treeSet.clear();
    }

    private void ensureAllVlansExist(INetElement iNetElement) throws IoError {
        INodeModel iNodeModel = iNetElement.getNodeModel();
        IEtherBridgeModel iEtherBridgeModel = this.getEtherBridge(iNodeModel, "ensureAllVlansExist");
        if (iEtherBridgeModel == null) {
            return;
        }
        if (dbg.on()) {
            dbg.println("ensureAllVlansExist: processing " + this.getNameOf(iNodeModel));
        }
        Collection collection = this.allVlansList(iNetElement);
        TreeSet<IVlanModel> treeSet = new TreeSet<IVlanModel>(new VlanInfoComparator());
        treeSet.addAll(Arrays.asList(iEtherBridgeModel.getVlanList()));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            NetVlanInfo netVlanInfo = (NetVlanInfo)iterator.next();
            IVlanModel iVlanModel = netVlanInfo.getVlan();
            if (treeSet.contains(iVlanModel)) continue;
            try {
                iEtherBridgeModel.createVlan(iVlanModel.getId(), iVlanModel.getName());
            }
            catch (DuplicateVlan duplicateVlan) {
                if (!dbg.on()) continue;
                dbg.println("ensureAllVlansExist: vlan already known for " + this.getNameOf(iNodeModel));
            }
            catch (VlanIdOutOfRange vlanIdOutOfRange) {
                if (!dbg.on()) continue;
                dbg.println("ensureAllVlansExist: VLAN id out of range for " + this.getNameOf(iNodeModel));
            }
            catch (NoMoreVlan noMoreVlan) {
                if (!dbg.on()) continue;
                dbg.println("ensureAllVlansExist: No more vlans for " + this.getNameOf(iNodeModel));
            }
            catch (VlanNameTooLong vlanNameTooLong) {
                if (!dbg.on()) continue;
                dbg.println("ensureAllVlansExist: VLAN name too long for " + this.getNameOf(iNodeModel));
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (dbg.on()) {
                    dbg.println("ensureAllVlansExist: I/O error with network element " + this.getNameOf(iNodeModel));
                }
                throw new IoError("Cannot create Vlan(s) on " + this.getNameOf(iNodeModel) + " as node is " + "temporarily unavailable");
            }
        }
        treeSet.clear();
    }

    private void ensureVlansExist(ITopology iTopology, INetElement iNetElement) throws IoError {
        int n = iTopology.getTopoId();
        if (n == iNetElement.getTopoId()) {
            return;
        }
        if (dbg.on()) {
            dbg.println("ensureVlansExist: adding vlans from topoId " + iNetElement.getTopoId() + " to topoId " + iTopology.getTopoId());
        }
        Iterator iterator = this.allVlansList(iNetElement).iterator();
        Iterator iterator2 = this.getNodesWithTopoId(n).iterator();
        while (iterator2.hasNext()) {
            INodeModel iNodeModel = ((INetElement)iterator2.next()).getNodeModel();
            IEtherBridgeModel iEtherBridgeModel = this.getEtherBridge(iNodeModel, "ensureVlansExist");
            if (iEtherBridgeModel == null) continue;
            TreeSet<IVlanModel> treeSet = new TreeSet<IVlanModel>(new VlanInfoComparator());
            treeSet.addAll(Arrays.asList(iEtherBridgeModel.getVlanList()));
            while (iterator.hasNext()) {
                NetVlanInfo netVlanInfo = (NetVlanInfo)iterator.next();
                IVlanModel iVlanModel = netVlanInfo.getVlan();
                if (treeSet.contains(iVlanModel)) continue;
                try {
                    iEtherBridgeModel.createVlan(iVlanModel.getId(), iVlanModel.getName());
                }
                catch (DuplicateVlan duplicateVlan) {
                    if (!dbg.on()) continue;
                    dbg.println("ensureAllVlansExist: vlan already known for " + this.getNameOf(iNodeModel));
                }
                catch (VlanIdOutOfRange vlanIdOutOfRange) {
                    if (!dbg.on()) continue;
                    dbg.println("ensureAllVlansExist: VLAN id out of range for " + this.getNameOf(iNodeModel));
                }
                catch (NoMoreVlan noMoreVlan) {
                    if (!dbg.on()) continue;
                    dbg.println("ensureAllVlansExist: No more vlans for " + this.getNameOf(iNodeModel));
                }
                catch (VlanNameTooLong vlanNameTooLong) {
                    if (!dbg.on()) continue;
                    dbg.println("ensureAllVlansExist: VLAN name too long for " + this.getNameOf(iNodeModel));
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (dbg.on()) {
                        dbg.println("ensureAllVlansExist: I/O error with network element " + this.getNameOf(iNodeModel));
                    }
                    throw new IoError("Cannot create Vlan(s) on " + this.getNameOf(iNodeModel) + " as node is " + "temporarily unavailable");
                }
            }
            treeSet.clear();
        }
    }

    public void update(IObservable iObservable, Object object) {
        Object object2;
        INetElement iNetElement;
        Network network = Network.instance();
        if (iObservable instanceof IEtherBridgeModel && (Integer)object == ModelUpdateType.ADDED && (iNetElement = network.getNetElem((object2 = ((IEtherBridgeModel)iObservable).getNodeModel()).getNodeId())) != null && !this.changedNodeSet.contains(iNetElement)) {
            this.changedNodeSet.add(iNetElement);
            if (dbg.on()) {
                dbg.println("vlan table changed in node " + this.getNameOf(iNetElement) + ": updating it");
            }
        }
        if (iObservable instanceof IVlanModel) {
            if ((Integer)object == ModelUpdateType.DELETED) {
                object2 = ((IVlanModel)iObservable).getNodeModel();
                iNetElement = network.getNetElem(object2.getNodeId());
                if (iNetElement != null && !this.changedNodeSet.contains(iNetElement)) {
                    this.changedNodeSet.add(iNetElement);
                    if (dbg.on()) {
                        dbg.println("vlan deleted in node" + this.getNameOf(iNetElement));
                    }
                }
                ((IVlanModel)iObservable).deleteObserver((IObserver)this);
            } else if ((Integer)object == ModelUpdateType.CHANGED && (iNetElement = network.getNetElem((object2 = ((IVlanModel)iObservable).getNodeModel()).getNodeId())) != null && !this.changedNodeSet.contains(iNetElement)) {
                this.changedNodeSet.add(iNetElement);
                if (dbg.on()) {
                    dbg.println("vlan changed in node" + this.getNameOf(iNetElement));
                }
            }
        }
        if (iObservable instanceof Network.NetElementCreationNotifier && object instanceof NetElement) {
            object2 = (NetElement)object;
            if (dbg.on()) {
                dbg.println("update: received update about new NE " + ((NetElement)object2).getHostName());
            }
            if (((NetElement)object2).getNodeId() == 0 || ((NetElement)object2).getNodeId() == -1) {
                object2.addObserver((IObserver)this);
            } else {
                this.newNetElement((INetElement)object2);
            }
        }
        if (iObservable instanceof INetElement) {
            object2 = (INetElement)iObservable;
            if (object == ModelUpdateType.CHANGED) {
                if (dbg.on()) {
                    dbg.println("update: received CHANGED event from NE " + object2.getHostName());
                }
                if (object2.getNodeId() != 0 && object2.getNodeId() != -1) {
                    if (dbg.on()) {
                        dbg.println("update: NE has valid node ID, adding new NE");
                    }
                    this.newNetElement((INetElement)object2);
                }
            } else if (object == ModelUpdateType.DELETED) {
                if (dbg.on()) {
                    dbg.println("update: received DELETED event from NE " + object2.getHostName());
                }
                this.vlanCapableNodes.remove(object2);
                ((NetElement)object2).deleteObserver(this);
            }
        }
        if (iObservable instanceof Network.NetLinkCreationNotifier && object instanceof INetLink) {
            object2 = (INetLink)object;
            if (dbg.on()) {
                dbg.println("update: received update about new NL " + object2.prettyString());
            }
            if (object2.isPhantom()) {
                this.newPhantomLink((INetLink)object2);
            }
        }
    }

    private void invalidateAndNotify() {
        this.invalidate();
        this.sendOutNotification();
    }

    private void sendOutNotification() {
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        Object object = this.vlanModelMapLockObject;
        synchronized (object) {
            this.vlanModelMap = null;
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateAndNotify(ITopology iTopology) {
        if (this.vlanModelMap == null) {
            return;
        }
        Object object = this.vlanModelMapLockObject;
        synchronized (object) {
            if (this.vlanModelMap.containsKey(new Integer(iTopology.getTopoId()))) {
                this.vlanModelMap.remove(new Integer(iTopology.getTopoId()));
            }
        }
        this.sendOutNotification();
    }

    private String getNameOf(INodeModel iNodeModel) {
        String string = "UNKNOWN";
        if (iNodeModel != null) {
            if (iNodeModel.isInited() && iNodeModel.getConnectionState()) {
                try {
                    string = iNodeModel.getName();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    string = iNodeModel.getHostName();
                }
            } else {
                string = iNodeModel.getHostName();
            }
        }
        return string;
    }

    private String getNameOf(INetElement iNetElement) {
        String string = "UNKNOWN";
        if (iNetElement != null) {
            string = this.getNameOf(iNetElement.getNodeModel());
        }
        return string;
    }

    public List getNodesWithTopoId(int n) {
        LinkedList<NetElement> linkedList = new LinkedList<NetElement>();
        Iterator iterator = this.vlanCapableNodes.iterator();
        while (iterator.hasNext()) {
            NetElement netElement = (NetElement)iterator.next();
            if (netElement.getTopoId() != n) continue;
            linkedList.add(netElement);
        }
        return linkedList;
    }

    public boolean isVlanEnabledNetwork() {
        return this.vlanCapableNodes.size() > 0;
    }

    static {
        dbg = new SDebug("Vlan", false);
    }

    private class VlanComparator
    implements Comparator {
        private VlanComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof IVlanModel)) {
                throw new ClassCastException("VlanComparator failed: expected IVlanModel, got " + object.getClass().getName());
            }
            if (!(object2 instanceof IVlanModel)) {
                throw new ClassCastException("VlanComparator failed: expected IVlanModel, got " + object2.getClass().getName());
            }
            IVlanModel iVlanModel = (IVlanModel)object;
            IVlanModel iVlanModel2 = (IVlanModel)object2;
            return ComparisonUtil.compare((int)iVlanModel.getId(), (int)iVlanModel2.getId());
        }
    }
}

