/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.topo.NetElement;
import cerent.launcher.CachedJar;
import cerent.launcher.CachedJarFactory;
import cerent.launcher.ClassLoaderFactory;
import cerent.util.DetailedLog;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.JobStatus;
import cerent.version.NetworkVersionMonitor;
import cerent.version.Ngrp;
import com.cisco.ctc.core.CoreException;
import com.cisco.ctc.core.DownloadArea;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;

public class CoreSoftwareUpgradeInstaller {
    private static CoreSoftwareUpgradeInstaller instance;
    private boolean upgradeInProgress = false;
    private boolean communicationsError = false;
    private boolean preferenceError = false;
    private boolean noNodesAvailableError = false;
    private boolean invalidUpgradeError = false;
    private static final SDebug db;

    public static CoreSoftwareUpgradeInstaller instance() {
        if (instance == null) {
            instance = new CoreSoftwareUpgradeInstaller();
        }
        return instance;
    }

    public boolean isUpgradeInProgress() {
        return this.upgradeInProgress;
    }

    private CachedJar upgradeCtcJarFile(String string, ArrayList arrayList, CoreSoftwareUpgradeJob coreSoftwareUpgradeJob) {
        boolean bl = false;
        CachedJar cachedJar = null;
        Iterator iterator = arrayList.iterator();
        do {
            NetElement netElement = (NetElement)iterator.next();
            String string2 = netElement.getHostName();
            String string3 = "http://" + string2;
            CachedJarFactory cachedJarFactory = new CachedJarFactory(string3, string, string2);
            try {
                cachedJar = cachedJarFactory.create();
                if (db.on()) {
                    db.println("Downloading the " + string + " jar file from " + string3 + ".");
                }
                ClassLoaderFactory.download((CachedJar)cachedJar, (boolean)false, (boolean)false);
                bl = false;
            }
            catch (IOException iOException) {
                if (db.on()) {
                    db.println("IOException caught while downloading jar upgrade from: " + string2);
                }
                bl = true;
            }
        } while (bl && iterator.hasNext() && !coreSoftwareUpgradeJob.aborted);
        if (!bl) {
            return cachedJar;
        }
        this.communicationsError = true;
        cachedJar = null;
        return cachedJar;
    }

    private DownloadArea setupDownloadArea(DownloadArea downloadArea, NetElement netElement) {
        DownloadArea downloadArea2;
        block4: {
            downloadArea2 = downloadArea;
            try {
                if (downloadArea2 == null) {
                    String string = netElement.getNodeModel().getSwVersion();
                    downloadArea2 = new DownloadArea(netElement.getHostName(), string);
                } else {
                    downloadArea2.setDownloadHostname(netElement.getHostName());
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("General error occured attempting to perform a future proof upgrade.");
                db.println("Error creating DownloadArea.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return downloadArea2;
    }

    private boolean completeDownloadArea(DownloadArea downloadArea) {
        boolean bl;
        block11: {
            try {
                if (downloadArea != null) {
                    downloadArea.completeArea();
                }
            }
            catch (CoreException coreException) {
                if (db.on()) {
                    db.println("CoreException caught during core sw upgrade: " + coreException.getMessage());
                    SDebug.printStackTrace((Throwable)coreException);
                }
                this.invalidUpgradeError = true;
            }
            catch (IOException iOException) {
                if (db.on()) {
                    db.println("IOException caught during core sw upgrade.");
                    SDebug.printStackTrace((Throwable)iOException);
                }
                this.communicationsError = true;
            }
            catch (Exception exception) {
                if (!db.on()) break block11;
                db.println("General failure occurred during future proof core sw upgrade.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        boolean bl2 = bl = downloadArea != null ? downloadArea.isAreaComplete() : false;
        if (bl) {
            try {
                downloadArea.storeDirPreference();
                this.updateFutureProofLauncherPreference(downloadArea);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Error occurred attempting to store the download area preferences.");
                }
                this.preferenceError = true;
            }
        }
        return bl;
    }

    private boolean futureProofUpgrade(CoreSoftwareUpgradeJob coreSoftwareUpgradeJob, ArrayList arrayList) {
        boolean bl;
        block5: {
            Iterator iterator = arrayList.iterator();
            DownloadArea downloadArea = null;
            bl = false;
            while (!bl && iterator.hasNext() && !coreSoftwareUpgradeJob.aborted) {
                NetElement netElement = (NetElement)iterator.next();
                downloadArea = this.setupDownloadArea(downloadArea, netElement);
                bl = this.completeDownloadArea(downloadArea);
            }
            if (!bl || this.preferenceError) {
                try {
                    if (downloadArea != null) {
                        downloadArea.cleanArea();
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("Error occurred attempting to clean up the download area after failure.");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return bl;
    }

    private boolean nonFutureProofUpgrade(CoreSoftwareUpgradeJob coreSoftwareUpgradeJob, ArrayList arrayList) {
        Object object;
        ArrayList<CachedJar> arrayList2 = new ArrayList<CachedJar>();
        int n = 0;
        String[] stringArray = null;
        CachedJar cachedJar = this.upgradeCtcJarFile("LAUNCHER", arrayList, coreSoftwareUpgradeJob);
        if (cachedJar != null) {
            ++n;
            stringArray = this.getLatestCoreJarNames(cachedJar);
            arrayList2.add(cachedJar);
        }
        int n2 = 0;
        while (n > 0 && n2 < stringArray.length && !coreSoftwareUpgradeJob.aborted) {
            if (stringArray[n2] == "LAUNCHER") {
                ++n2;
                continue;
            }
            object = this.upgradeCtcJarFile(stringArray[n2], arrayList, coreSoftwareUpgradeJob);
            if (object != null) {
                arrayList2.add((CachedJar)object);
                if (db.on()) {
                    db.println("Successfully downloaded the " + stringArray[n2] + " jar file.");
                }
                ++n;
            }
            ++n2;
        }
        if (n == stringArray.length && !coreSoftwareUpgradeJob.aborted) {
            if (!this.upgradeThirdPartyJars(cachedJar, arrayList, coreSoftwareUpgradeJob)) {
                return false;
            }
            if (db.on()) {
                db.println("Successful download of all core jar files.  Updating preferences.");
            }
            try {
                this.updateJarPreferences(cachedJar, true);
                object = arrayList2.iterator();
                while (object.hasNext()) {
                    this.updateJarPreferences((CachedJar)object.next(), false);
                }
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Error occurred saving preferences.");
                }
                this.preferenceError = true;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean upgradeCtcCoreSoftware(CoreSoftwareUpgradeJob coreSoftwareUpgradeJob) {
        ArrayList arrayList = NetworkVersionMonitor.instance().getLatestVersionElements();
        boolean bl = false;
        this.preferenceError = false;
        this.communicationsError = false;
        this.noNodesAvailableError = false;
        this.invalidUpgradeError = false;
        String string = NetworkVersionMonitor.instance().getLatestVersionAvailable();
        String string2 = Ngrp.getAbbreviatedCustomerVisibleFormat((String)string);
        if (!arrayList.isEmpty() && !coreSoftwareUpgradeJob.aborted) {
            String string3 = "The update of the CTC software to R" + string2 + " is now in progess. To cancel the update,\n" + "select \"Cancel CTC Update\" from the Tools menu.";
            DetailedLog detailedLog = new DetailedLog(1, string3);
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
            bl = this.upgradeVersionSupportsFutureProofing(string) ? this.futureProofUpgrade(coreSoftwareUpgradeJob, arrayList) : this.nonFutureProofUpgrade(coreSoftwareUpgradeJob, arrayList);
        } else {
            if (arrayList.isEmpty()) {
                this.noNodesAvailableError = true;
            }
            return false;
        }
        if (bl) {
            NetworkVersionMonitor.instance().setLatestVersionUpgraded(((NetElement)arrayList.get(0)).getSwVersion());
        }
        return bl;
    }

    private String[] getLatestCoreJarNames(CachedJar cachedJar) {
        String[] stringArray = null;
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(cachedJar.getURLs(), null);
            Class<?> clazz = uRLClassLoader.loadClass("cerent.util.ICtcCoreJarFileNames");
            Field field = clazz.getField("coreJarNames");
            stringArray = (String[])field.get(clazz);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Exception occurred attempting to retrieve the latest core jar names.");
                SDebug.printStackTrace((Throwable)exception);
            }
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private Object[] getLatestVersionThirdPartyJarTypes(URLClassLoader uRLClassLoader) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = uRLClassLoader.loadClass("cerent.launcher.Bootstrap");
        Method method = clazz.getMethod("getThirdPartyJarTypes", new Class[0]);
        Object[] objectArray = (Object[])method.invoke(null, null);
        return objectArray;
    }

    private boolean upgradeThirdPartyJars(CachedJar cachedJar, ArrayList arrayList, CoreSoftwareUpgradeJob coreSoftwareUpgradeJob) {
        int n = 0;
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(cachedJar.getURLs(), null);
            Object[] objectArray = this.getLatestVersionThirdPartyJarTypes(uRLClassLoader);
            Class<?> clazz = uRLClassLoader.loadClass("cerent.util.IThirdPartyJar");
            Method method = clazz.getMethod("getVersion", new Class[0]);
            Method method2 = clazz.getMethod("getFileName", new Class[0]);
            for (int i = 0; i < objectArray.length; ++i) {
                String string;
                String string2 = (String)method2.invoke(objectArray[i], null);
                if (!this.downloadThirdPartyJar(string2, string = (String)method.invoke(objectArray[i], null), arrayList, coreSoftwareUpgradeJob)) continue;
                ++n;
            }
            return n == objectArray.length;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.print("Exception occurred trying to retrieve third party class information.");
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    private boolean downloadThirdPartyJar(String string, String string2, ArrayList arrayList, CoreSoftwareUpgradeJob coreSoftwareUpgradeJob) {
        boolean bl = false;
        Object var6_6 = null;
        Iterator iterator = arrayList.iterator();
        do {
            NetElement netElement = (NetElement)iterator.next();
            String string3 = netElement.getHostName();
            try {
                ClassLoaderFactory.forceDownloadThirdPartyJar((String)string, (String)string2, (String)string3, (boolean)false);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Exception caught while attempt to download the " + string + " version " + string2 + "jar file upgrade.");
                }
                SDebug.printStackTrace((Throwable)exception);
                bl = true;
            }
        } while (bl && iterator.hasNext() && !coreSoftwareUpgradeJob.aborted);
        if (!bl) {
            return true;
        }
        this.communicationsError = true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFutureProofLauncherPreference(DownloadArea downloadArea) throws FileNotFoundException, InterruptedIOException, IOException {
        Preferences preferences;
        String string = downloadArea.getLauncherPath();
        Preferences preferences2 = preferences = Preferences.instance((String)Preferences.getDefaultLauncherPrefsFileName());
        synchronized (preferences2) {
            String string2 = "ctc.launcher";
            String string3 = "ctc-jar-futurelauncher";
            preferences.setProperty(string2, string3, string);
            string3 = "ctc-jar-futurelauncher-version";
            String string4 = NetworkVersionMonitor.instance().getLatestVersionAvailable();
            String string5 = Ngrp.getAbbreviatedCustomerVisibleFormat((String)string4);
            preferences.setProperty(string2, string3, string5);
            preferences.store();
        }
    }

    private void updateJarPreferences(CachedJar cachedJar, boolean bl) throws FileNotFoundException, IOException {
        String string = cachedJar.getCachedName();
        Preferences preferences = null;
        preferences = bl ? Preferences.instance((String)Preferences.getDefaultLauncherPrefsFileName()) : Preferences.instance((String)Preferences.getDefaultCtcPrefsFileName());
        cachedJar.storeJarPreference(string, preferences, true, true);
    }

    private boolean isLaterOrSameVersion(String string, String string2) {
        return string.compareTo(string2) >= 0;
    }

    private boolean upgradeVersionSupportsFutureProofing(String string) {
        String string2 = "08.00";
        return this.isLaterOrSameVersion(string, string2);
    }

    public CoreSoftwareUpgradeJob createCoreSoftwareUpgradeJob() {
        return new CoreSoftwareUpgradeJob();
    }

    static {
        db = new SDebug("CoreSoftwareUpgradeInstaller");
    }

    public class CoreSoftwareUpgradeJob
    implements IJobControl {
        protected boolean aborted = false;

        public String getName() {
            return "Core Software Upgrade";
        }

        public JobStatus executeJob() {
            String string = NetworkVersionMonitor.instance().getLatestVersionAvailable();
            if (!NetworkVersionMonitor.instance().isLaterVersionAvailable()) {
                DetailedLog detailedLog = new DetailedLog(1, "The CTC software update could not be completed.\nNo later version of the CTC is available.");
                EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
                return new JobStatus(2, (Object)new Exception("No later version is available"));
            }
            CoreSoftwareUpgradeInstaller.this.upgradeInProgress = true;
            boolean bl = false;
            try {
                bl = CoreSoftwareUpgradeInstaller.this.upgradeCtcCoreSoftware(this);
            }
            catch (Exception exception) {
                bl = false;
            }
            CoreSoftwareUpgradeInstaller.this.upgradeInProgress = false;
            return this.determineJobStatus(bl, string);
        }

        public void abortJob() {
            this.aborted = true;
        }

        private JobStatus determineJobStatus(boolean bl, String string) {
            JobStatus jobStatus = null;
            String string2 = Ngrp.getAbbreviatedCustomerVisibleFormat((String)string);
            String string3 = "The CTC software update to R" + string2;
            if (bl) {
                jobStatus = new JobStatus(4);
                string3 = string3 + " is now complete. To begin using\n the new version, please restart the CTC.";
            } else if (this.aborted) {
                jobStatus = new JobStatus(3, (Object)new Exception("Cancelled by user."));
                string3 = string3 + " was aborted at the user's request.";
            } else {
                if (CoreSoftwareUpgradeInstaller.this.communicationsError) {
                    jobStatus = new JobStatus(2, (Object)new Exception("Communications error occurred"));
                    string3 = string3 + " could not be completed.\nA communications error occurred during the attempt to update the CTC software.";
                } else if (CoreSoftwareUpgradeInstaller.this.preferenceError) {
                    jobStatus = new JobStatus(2, (Object)new Exception("Preference saving error occurred"));
                    string3 = string3 + " could not be completed.\nAn error occurred while attempting to save the CTC preferences.";
                } else if (CoreSoftwareUpgradeInstaller.this.noNodesAvailableError) {
                    jobStatus = new JobStatus(2, (Object)new Exception("No later version is available"));
                    string3 = string3 + " could not be completed.\nNo nodes with a later version of the CTC were found.\n" + "Connectivity may be unavailable to node(s) with a later version.";
                } else if (CoreSoftwareUpgradeInstaller.this.invalidUpgradeError) {
                    jobStatus = new JobStatus(2, (Object)new Exception("Unable to upgrade to selected version"));
                    string3 = string3 + " could not be completed.\nCTC is unable to update the current version to R" + string2 + "\ndue to a known incompatibility in the update process between these two versions.";
                } else {
                    jobStatus = new JobStatus(2, (Object)new Exception("CTC upgrade error occurred"));
                    string3 = string3 + " could not be completed.\nAn error occurred while attempting to update the CTC software";
                }
                CoreSoftwareUpgradeInstaller.this.communicationsError = false;
                CoreSoftwareUpgradeInstaller.this.preferenceError = false;
                CoreSoftwareUpgradeInstaller.this.noNodesAvailableError = false;
                CoreSoftwareUpgradeInstaller.this.invalidUpgradeError = false;
            }
            DetailedLog detailedLog = new DetailedLog(1, string3);
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
            return jobStatus;
        }
    }
}

