/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.ConcurrentReaderMap;
import cerent.util.IMethodAccess;
import cerent.util.ReflectionUtil;
import java.lang.reflect.Method;

public class MethodCache
implements IMethodAccess {
    private ConcurrentReaderMap map = new ConcurrentReaderMap();

    public Method[] addDeclaredMethodsIfNeeded(Class clazz) {
        Method[] methodArray = (Method[])this.map.get((Object)clazz);
        if (methodArray == null) {
            methodArray = clazz.getDeclaredMethods();
            this.map.put((Object)clazz, (Object)methodArray);
        }
        return methodArray;
    }

    public Method[] getDeclaredMethods(Class clazz) {
        Method[] methodArray = this.addDeclaredMethodsIfNeeded(clazz);
        return methodArray;
    }

    public Method[] getDeclaredPublicMethods(Class clazz) {
        Method[] methodArray;
        Method[] methodArray2 = this.getDeclaredMethods(clazz);
        int n = MethodCache.getPublicMethodCount(methodArray2);
        if (n < (methodArray = methodArray2).length) {
            methodArray = new Method[n];
            MethodCache.shallowCopyPublicMethods(methodArray2, methodArray, 0);
        }
        return methodArray;
    }

    protected static int getPublicMethodCount(Method[] methodArray) {
        int n = 0;
        int n2 = methodArray == null ? 0 : methodArray.length;
        for (int i = 0; i < n2; ++i) {
            Method method = methodArray[i];
            int n3 = method.getModifiers();
            if ((n3 & 1) == 0) continue;
            ++n;
        }
        return n;
    }

    protected static int shallowCopyPublicMethods(Method[] methodArray, Method[] methodArray2, int n) {
        int n2 = 0;
        int n3 = methodArray == null ? 0 : methodArray.length;
        for (int i = 0; i < n3; ++i) {
            Method method = methodArray[i];
            int n4 = method.getModifiers();
            if ((n4 & 1) == 0) continue;
            methodArray2[n + n2] = method;
            ++n2;
        }
        return n2;
    }

    public Method getDeclaredMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Method method = MethodCache.findMatchingMethod(this.getDeclaredMethods(clazz), string, classArray);
        return MethodCache.returnMethod(method);
    }

    public Method getMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Method method = MethodCache.findMatchingMethod(this.getMethods(clazz), string, classArray);
        return MethodCache.returnMethod(method);
    }

    protected static Method returnMethod(Method method) throws NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException("Method: null");
        }
        return method;
    }

    protected static Method findMatchingMethod(Method[] methodArray, String string, Class[] classArray) {
        int n = methodArray == null ? 0 : methodArray.length;
        for (int i = 0; i < n; ++i) {
            Method method = methodArray[i];
            if (!MethodCache.doesMatch(method, string, classArray)) continue;
            return method;
        }
        return null;
    }

    protected static boolean doesMatch(Method method, String string, Class[] classArray) {
        return method.getName().equals(string) && MethodCache.doesMatch(method.getParameterTypes(), classArray);
    }

    protected static boolean doesMatch(Class[] classArray, Class[] classArray2) {
        boolean bl;
        if (classArray == null && classArray2 == null) {
            return true;
        }
        if (classArray == null ^ classArray2 == null) {
            return false;
        }
        boolean bl2 = bl = classArray.length == classArray2.length;
        if (bl) {
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                bl &= classArray[i].equals(classArray2[i]);
            }
        }
        return bl;
    }

    public Method[] getMethods(Class clazz) {
        Class clazz2;
        Class[] classArray = MethodCache.getSuperclasses(clazz);
        int n = classArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            clazz2 = classArray[i];
            Method[] methodArray = this.getDeclaredMethods(clazz2);
            n2 += MethodCache.getPublicMethodCount(methodArray);
        }
        Method[] methodArray = new Method[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            clazz2 = classArray[i];
            Method[] methodArray2 = this.getDeclaredPublicMethods(clazz2);
            n3 += MethodCache.shallowCopyPublicMethods(methodArray2, methodArray, n3);
        }
        return methodArray;
    }

    protected static Class[] getSuperclasses(Class clazz) {
        return ReflectionUtil.superclasses((Class)clazz, null);
    }
}

