/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.AbstractPropertyEditor;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.security.InvalidParameterException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class ChoicePropertyEditor
extends AbstractPropertyEditor {
    private boolean fromSetValue_ = false;
    private JPanel[] subPanels_;
    private JRadioButton[] buttons_;
    private ButtonGroup group_;
    private String[] values_;
    private int emptySelection_ = -1;
    private int variableSelection_ = -1;
    private int currentSelection_ = 0;

    public ChoicePropertyEditor(String string, String[] stringArray, String[] stringArray2, int n, int n2) throws Exception {
        this.init(string, stringArray, stringArray2, n, n2);
    }

    private void init(String string, String[] stringArray, String[] stringArray2, int n, int n2) throws Exception {
        if (stringArray == null || stringArray2 == null || stringArray.length == 0 || stringArray2.length == 0 || stringArray.length != stringArray2.length) {
            throw new Exception("labels and values must be non-nulland of equal non-zero length");
        }
        this.variableSelection_ = n2;
        this.emptySelection_ = n;
        this.setLayout(new BoxLayout(this, 1));
        if (string != null) {
            this.setBorder(new TitledBorder(string));
        }
        this.group_ = new ButtonGroup();
        this.subPanels_ = new JPanel[stringArray.length];
        this.buttons_ = new JRadioButton[stringArray.length];
        this.values_ = stringArray2;
        int n3 = 0;
        while (n3 < stringArray.length) {
            JRadioButton jRadioButton;
            JPanel jPanel;
            if (stringArray2[n3] == null) {
                throw new Exception("value[" + n3 + "] can't be null");
            }
            this.subPanels_[n3] = jPanel = new JPanel(new FlowLayout(0));
            this.buttons_[n3] = jRadioButton = new JRadioButton(stringArray[n3], false);
            this.group_.add(jRadioButton);
            jPanel.add(jRadioButton);
            this.add(jPanel);
            final int n4 = n3++;
            jRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    Object object = itemEvent.getSource();
                    JRadioButton jRadioButton = (JRadioButton)object;
                    if (jRadioButton.isEnabled()) {
                        ChoicePropertyEditor.this.currentSelection_ = n4;
                        if (!ChoicePropertyEditor.this.fromSetValue_) {
                            ChoicePropertyEditor.this.setDirty(true);
                        }
                        ChoicePropertyEditor.this.fromSetValue_ = false;
                    }
                }
            });
        }
    }

    public Object getValue() {
        String string = this.values_[this.currentSelection_];
        return string;
    }

    public void setValue(Object object) {
        this._setValue((String)object);
    }

    public boolean setVariableValue(String string) {
        boolean bl = false;
        if (0 <= this.variableSelection_ && this.variableSelection_ < this.values_.length) {
            this.values_[this.variableSelection_] = string;
            this.buttons_[this.variableSelection_].setSelected(true);
            this.currentSelection_ = this.variableSelection_;
            bl = true;
        }
        return bl;
    }

    public boolean setEmptyValue() {
        boolean bl = false;
        if (0 <= this.emptySelection_ && this.emptySelection_ < this.values_.length) {
            this.currentSelection_ = this.emptySelection_;
            this.buttons_[this.emptySelection_].setSelected(true);
            bl = true;
        }
        return bl;
    }

    private void _setValue(String string) {
        this.fromSetValue_ = true;
        boolean bl = false;
        if (string == null || string.length() == 0) {
            bl = this.setEmptyValue();
        }
        if (!bl) {
            for (int i = 0; i < this.values_.length; ++i) {
                if (!this.values_[i].equals(string)) continue;
                bl = true;
                this.currentSelection_ = i;
                this.buttons_[i].setSelected(true);
                break;
            }
            if (!bl) {
                bl = this.setVariableValue(string);
            }
            if (!bl) {
                throw new InvalidParameterException("value " + string + " could not be mapped to any" + " existing choices. Try a static choice or" + " enable variable selection");
            }
        }
        this.fromSetValue_ = false;
    }

    public Object[] getValues() {
        return this.values_;
    }

    public JPanel[] subPanels() {
        return this.subPanels_;
    }

    public JRadioButton[] getButtons() {
        return this.buttons_;
    }
}

