/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.BusEvent;
import cerent.util.EventBus;
import cerent.util.SDebug;
import cerent.util.gui.SubsystemStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class StatusBar
extends JPanel
implements Observer {
    protected JLabel mainLabel = new JLabel();
    protected ArrayList items = new ArrayList();
    private LinkedList labelTextList = new LinkedList();
    private LinkedList statusList = new LinkedList();
    private GridBagConstraints gc = new GridBagConstraints();
    private Runnable updThread;
    private static StatusBar singleton;
    private static final SDebug db;

    public static StatusBar instance() {
        if (singleton == null) {
            singleton = new StatusBar();
        }
        return singleton;
    }

    private StatusBar() {
        this.setLayout(new GridBagLayout());
        this.gc.anchor = 10;
        this.gc.fill = 1;
        this.gc.gridy = 0;
        this.gc.gridheight = 1;
        this.gc.gridwidth = 1;
        this.gc.weighty = 1.0;
        this.gc.weightx = 1.0;
        this.mainLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.items.add(0, this.mainLabel);
        this.add((Component)this.mainLabel, this.gc);
        this.gc.weightx = 0.0;
        this.gc.weighty = 0.0;
        this.setPreferredSize(new Dimension(640, 22));
        this.updThread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LinkedList linkedList = StatusBar.this.labelTextList;
                synchronized (linkedList) {
                    try {
                        Iterator iterator = StatusBar.this.labelTextList.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            JLabel jLabel = (JLabel)e;
                            e = iterator.next();
                            String string = (String)e;
                            jLabel.setText(string);
                        }
                    }
                    catch (Exception exception) {
                        StatusBar.this.labelTextList.clear();
                    }
                }
            }
        };
        EventBus.instance().addObserver((Observer)this, (Object)SubsystemStatus.class.toString());
    }

    public void addItem(JComponent jComponent) {
        if (!this.items.contains(jComponent)) {
            this.borderizeComponent(jComponent);
            this.installListener(jComponent);
            this.items.add(1, jComponent);
            this.rebuild();
        }
    }

    public void addItemWithTimedRemoval(JComponent jComponent) {
        this.addItem(jComponent);
        new StatusBarManagerThread(jComponent).start();
    }

    public void appendItem(JComponent jComponent) {
        if (!this.items.contains(jComponent)) {
            this.gc.gridx = this.items.size();
            this.borderizeComponent(jComponent);
            this.installListener(jComponent);
            this.add((Component)jComponent, this.gc);
            this.rebuild();
            this.items.add(jComponent);
        }
    }

    public void removeItem(JComponent jComponent) {
        int n = this.items.indexOf(jComponent);
        if (n > 0) {
            if (jComponent == this.mainLabel && db.on()) {
                db.println("StatusBar.removeItem attempting to remove mainLabel!");
            }
            this.items.remove(n);
            this.remove(jComponent);
            this.rebuild();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof BusEvent) {
            BusEvent busEvent = (BusEvent)object;
            String string = (String)busEvent.getSource();
            Object object2 = busEvent.getEvent();
            if (string == null && object2 == null) {
                if (db.on()) {
                    db.println("busEvent source or event is null");
                }
                return;
            }
            if (db.on()) {
                db.println("busEvent source=" + string + ", event=" + object2);
            }
            if (object2 instanceof JComponent) {
                if (this.items.contains(object2)) {
                    this.removeItem((JComponent)object2);
                } else {
                    this.addItem((JComponent)object2);
                }
            } else if (object2 instanceof String) {
                this.setText((String)object2);
            } else if (db.on()) {
                db.println("update:  Unknown event");
            }
        }
    }

    public void setText(String string) {
        this.setText(string, this.mainLabel);
    }

    public void setTextWithTimedRemoval(String string) {
        this.setText(string, this.mainLabel);
        new Thread("StatusBarHelper"){
            private static final int INTERVAL = 5;

            public void run() {
                try {
                    2.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    db.finest("InterruptedException in setTextWithTimedRemoval, " + interruptedException);
                }
                singleton.setText("");
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string, JLabel jLabel) {
        if (SwingUtilities.isEventDispatchThread()) {
            jLabel.setText(string);
            jLabel.revalidate();
            Dimension dimension = jLabel.getSize();
            jLabel.paintImmediately(0, 0, dimension.width, dimension.height);
        } else {
            LinkedList linkedList = this.labelTextList;
            synchronized (linkedList) {
                this.labelTextList.add(jLabel);
                this.labelTextList.add(string);
            }
            SwingUtilities.invokeLater(this.updThread);
        }
    }

    private void installListener(JComponent jComponent) {
        jComponent.addMouseListener(new StatusBlockMouseListener(jComponent));
    }

    private void borderizeComponent(JComponent jComponent) {
        if (jComponent.getBorder() == null) {
            jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        }
    }

    protected void rebuild() {
        this.removeAll();
        this.gc.weightx = 1.0;
        for (int i = 0; i < this.items.size(); ++i) {
            this.gc.gridx = i;
            this.add((Component)((JComponent)this.items.get(i)), this.gc);
            this.gc.weightx = 0.0;
        }
        this.revalidate();
    }

    public static Border getLoweredBevelBorder(Color color) {
        return BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, color.brighter(), color.darker().darker()), BorderFactory.createEmptyBorder(0, 2, 0, 2));
    }

    static {
        db = new SDebug("StatusBar");
    }

    private class StatusBarManagerThread
    extends Thread {
        private static final int INTERVAL = 5;
        JComponent comp;

        public StatusBarManagerThread(JComponent jComponent) {
            super("StatusBarManagerThread");
            this.comp = null;
            this.comp = jComponent;
            this.setPriority(1);
        }

        public void run() {
            try {
                StatusBarManagerThread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                db.finest("InterruptedException in StatusBarManagerThread::run(), " + interruptedException);
            }
            StatusBar.instance().removeItem(this.comp);
        }
    }

    private class StatusBlockMouseListener
    implements MouseListener {
        private JComponent comp;

        public StatusBlockMouseListener(JComponent jComponent) {
            this.comp = jComponent;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.comp instanceof JLabel) {
                JLabel jLabel = (JLabel)this.comp;
                String string = "";
                if (jLabel.getText().equals("NET")) {
                    string = "Network Discovery: ";
                } else if (jLabel.getText().equals("CKT")) {
                    string = "Circuit Management: ";
                }
                if (jLabel.getBackground() == Color.green) {
                    jLabel.setToolTipText(string + "Active");
                } else if (jLabel.getForeground() == Color.gray) {
                    jLabel.setToolTipText(string + "Disabled");
                } else {
                    jLabel.setToolTipText(string + "Enabled");
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

