/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.EID;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.gui.LetterOrDigitPasswordField;

public class TL1PasswordField
extends LetterOrDigitPasswordField {
    public static final String TL1_PID_CHARS = "+#%";

    public TL1PasswordField(int n) {
        super(n, TL1_PID_CHARS);
    }

    public void isValidPID() throws Exception {
        char[] cArray = this.getPassword();
        if (cArray.length < 1) {
            throw new Exception("Minimum length is 1.");
        }
        if (cArray.length > 10) {
            throw new Exception("Maximum length is 10.");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (!Character.isLetter(cArray[i])) {
                ++n;
            }
            if (TL1_PID_CHARS.indexOf(cArray[i]) <= -1) continue;
            ++n2;
        }
        if (n < 2 || n2 < 1) {
            throw new Exception("Must contain at least two non-letters, and at least one of: +#%");
        }
    }

    public void isNotTooSimple(String string) throws Exception {
        String string2 = new String(this.getPassword());
        boolean bl = false;
        if (string2.length() < 6) {
            throw new Exception("Password is too short, must be at least 6 characters.");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (Character.isLetter(c)) {
                ++n;
            }
            if (c == '+' || c == '#' || c == '%') {
                ++n3;
            }
            if (!Character.isDigit(c)) continue;
            ++n2;
        }
        if (string2.toUpperCase().indexOf(string.toUpperCase()) != -1) {
            bl = true;
        }
        if (n < 1 || n3 < 1 || n2 < 1 || bl) {
            throw new Exception(KErrorMsg.getString((EID)KEMC.EID_PASSWORD_TOO_SIMPLE));
        }
    }
}

