/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.BuildInfo;
import cerent.util.gui.UScrollPane;
import com.cisco.ctc.ui.CTCVignette;
import com.cisco.ctc.ui.LicenseDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class AboutDialog
extends JDialog
implements ActionListener {
    private static final int GAP = 10;
    private static final String CTC_TITLE = "/images/CTC_title.gif";
    private static AboutDialog _instance;
    private static JLabel lblMemUsage;
    private Timer timer = new Timer(2000, new TimerListener());
    private static NumberFormat nf;
    private JPanel aboutPanel;
    private JPanel buttonPanel;
    private JPanel buildPanel;
    private UScrollPane scrollPane;
    private LicenseDialog ld;

    public static AboutDialog instance(JFrame jFrame, String string) {
        if (_instance == null) {
            _instance = new AboutDialog(jFrame, string);
        }
        return _instance;
    }

    private AboutDialog(JFrame jFrame, String string) {
        super(jFrame, string, true);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(CTC_TITLE));
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setBackground(Color.white);
        jLabel.setMinimumSize(jLabel.getPreferredSize());
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setBackground(Color.white);
        jPanel.add(new CTCVignette());
        this.buildPanel = new JPanel(new BorderLayout());
        this.buildPanel.setBackground(Color.white);
        this.buildPanel.setPreferredSize(new Dimension(550, 100));
        this.aboutPanel = new JPanel(new BorderLayout());
        this.aboutPanel.setBackground(Color.white);
        this.aboutPanel.add((Component)jLabel, "North");
        this.aboutPanel.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)this.buildPanel, "North");
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)this.getJvmPanel(), "South");
        this.aboutPanel.add((Component)jPanel2, "South");
        nf.setMaximumFractionDigits(1);
        this.updateMemoryUsage();
        this.timer.start();
        this.buttonPanel = new JPanel();
        JButton jButton = new JButton("Show Licenses");
        jButton.addActionListener(this);
        jButton.setActionCommand("License");
        this.buttonPanel.add(jButton);
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("Close");
        this.buttonPanel.add(jButton2);
        this.buttonPanel.setBackground(Color.white);
        JPanel jPanel3 = (JPanel)this.getContentPane();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel3.setLayout(new BorderLayout(10, 10));
        jPanel3.setBackground(Color.white);
        jPanel3.add((Component)this.aboutPanel, "Center");
        jPanel3.add((Component)this.buttonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    private JPanel getJvmPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBackground(Color.white);
        jPanel.add(new JLabel("Java Heap Usage (MB): "));
        jPanel.add(lblMemUsage);
        return jPanel;
    }

    private void updateMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        long l2 = runtime.totalMemory();
        long l3 = runtime.freeMemory();
        double d = 1048576.0;
        String string = nf.format((double)(l2 - l3) / d) + " used, " + nf.format((double)l3 / d) + " free, " + nf.format((double)l2 / d) + " allocated (maximum=" + nf.format((double)l / d) + ")";
        lblMemUsage.setText(string);
    }

    private void queryNodes() {
        List<Object> list;
        String string;
        INodeModel iNodeModel;
        Object object;
        JTextArea jTextArea = new JTextArea("Versions:");
        jTextArea.setEditable(false);
        jTextArea.setBackground(Color.white);
        String string2 = BuildInfo.sanitize(BuildInfo.version) + " - " + BuildInfo.date;
        jTextArea.append("\n  CTC Core: " + string2);
        TreeMap<String, ArrayList<INodeModel>> treeMap = new TreeMap<String, ArrayList<INodeModel>>();
        Iterator iterator = Network.instance().getElements().iterator();
        while (iterator.hasNext()) {
            object = (INetElement)iterator.next();
            iNodeModel = object.getNodeModel();
            if (!iNodeModel.isInited() || !(iNodeModel instanceof NodeModel)) continue;
            string = iNodeModel.getNeType() + " Support: " + ElementFactoryFinder.getElementFactory(iNodeModel).getBuildInfo((INodeModel)((NodeModel)iNodeModel));
            list = (List)treeMap.get(string);
            if (list == null) {
                list = new ArrayList<INodeModel>();
                treeMap.put(string, (ArrayList<INodeModel>)list);
            }
            list.add(iNodeModel);
        }
        object = treeMap.keySet();
        iNodeModel = object.iterator();
        while (iNodeModel.hasNext()) {
            string = (String)iNodeModel.next();
            list = (ArrayList<INodeModel>)treeMap.get(string);
            jTextArea.append("\n  " + string);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                INodeModel iNodeModel2 = (INodeModel)iterator2.next();
                jTextArea.append("\n    - " + iNodeModel2.getName());
            }
        }
        jTextArea.append("\n  JRE version: " + System.getProperty("java.version"));
        if (this.scrollPane != null) {
            this.buildPanel.remove((Component)this.scrollPane);
        }
        this.scrollPane = new UScrollPane((Component)jTextArea);
        this.scrollPane.setBackground(Color.white);
        this.scrollPane.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.buildPanel.add((Component)this.scrollPane, "Center");
    }

    public void show() {
        this.queryNodes();
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Close")) {
            this.setVisible(false);
        }
        if (actionEvent.getActionCommand().equals("License")) {
            this.ld = LicenseDialog.instance(this, "License Dialog");
            this.ld.pack();
            this.ld.setVisible(true);
        }
    }

    static {
        lblMemUsage = new JLabel();
        nf = NumberFormat.getInstance();
    }

    class TimerListener
    implements ActionListener,
    Runnable {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            AboutDialog.this.updateMemoryUsage();
        }
    }
}

