/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import com.cisco.ctc.ui.AboutDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class LicenseDialog
extends JDialog
implements ActionListener,
TreeSelectionListener {
    private static final int GAP = 10;
    private static LicenseDialog _instance;
    private JTree tree;
    private JEditorPane htmlPane;
    static /* synthetic */ Class class$com$cisco$ctc$ui$LicenseDialog$BookInfo;

    public static LicenseDialog instance(AboutDialog aboutDialog, String string) {
        if (_instance == null) {
            _instance = new LicenseDialog(aboutDialog, string);
        }
        return _instance;
    }

    private LicenseDialog(AboutDialog aboutDialog, String string) {
        super(aboutDialog, string, true);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new BookInfo("Software Licenses", "/resources/licenses/default.html"));
        this.createNodes(defaultMutableTreeNode);
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.expandAll(defaultMutableTreeNode);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.htmlPane);
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setForeground(Color.white);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        jSplitPane.setPreferredSize(new Dimension(600, 300));
        Dimension dimension = new Dimension(250, 300);
        jScrollPane2.setMinimumSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jSplitPane.setDividerLocation(250);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(this);
        jButton.setActionCommand("Close");
        jPanel.add(jButton);
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setOpaque(true);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new BorderLayout(10, 10));
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)jSplitPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setLocationRelativeTo(aboutDialog);
        this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    private void expandAll(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        arrayList.add(defaultMutableTreeNode);
        while (!arrayList.isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)arrayList.remove(0);
            this.tree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
            int n = defaultMutableTreeNode2.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
                if (defaultMutableTreeNode3.isLeaf()) continue;
                arrayList.add(defaultMutableTreeNode3);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        BookInfo bookInfo = (BookInfo)defaultMutableTreeNode.getUserObject();
        this.displayURL(bookInfo.bookURL);
    }

    private void displayURL(URL uRL) {
        try {
            if (uRL != null) {
                this.htmlPane.setPage(uRL);
            } else {
                this.htmlPane.setPage((LicenseDialog)this.new BookInfo((String)"Text Not Found", (String)"/resources/licenses/notfound.html").bookURL);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode4 = null;
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(new BookInfo("Third Party Software Licenses", "/resources/licenses/default.html"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode4 = new DefaultMutableTreeNode(new BookInfo("Apache", "/resources/licenses/apache.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode4);
        defaultMutableTreeNode4 = new DefaultMutableTreeNode(new BookInfo("JacORB", "/resources/licenses/jacorb.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode4);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new BookInfo("Java JRE", "/resources/licenses/default.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode4 = new DefaultMutableTreeNode(new BookInfo("Java JRE", "/resources/licenses/jre.html"));
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        defaultMutableTreeNode4 = new DefaultMutableTreeNode(new BookInfo("Java JRE 3rd Party", "/resources/licenses/jre3rdparty.html"));
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        defaultMutableTreeNode4 = new DefaultMutableTreeNode(new BookInfo("Open SSL", "/resources/licenses/openssl.html"));
        defaultMutableTreeNode2.add(defaultMutableTreeNode4);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Close")) {
            this.setVisible(false);
        }
    }

    private class BookInfo {
        public String bookName;
        public URL bookURL;

        public BookInfo(String string, String string2) {
            this.bookName = string;
            this.bookURL = (class$com$cisco$ctc$ui$LicenseDialog$BookInfo == null ? (class$com$cisco$ctc$ui$LicenseDialog$BookInfo = LicenseDialog.class$("com.cisco.ctc.ui.LicenseDialog$BookInfo")) : class$com$cisco$ctc$ui$LicenseDialog$BookInfo).getResource(string2);
        }

        public String toString() {
            return this.bookName;
        }
    }
}

