/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import cerent.cms.ui.DefaultColors;
import cerent.cms.ui.PrefsNodesPropertyPane;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.BuildInfo;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.ImageCanvas;
import cerent.util.gui.LetterOrDigitTextField;
import cerent.util.gui.UFrame;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class LoginDialog
extends UFrame
implements DocumentListener,
KeyListener,
ActionListener {
    private static final String PROTOTYPE_DISPLAY_VALUE = "MMMMMMMMMMMMMMMMMMMMMMMMM";
    private Object owner;
    private JPasswordField tfPassword;
    private LetterOrDigitTextField tfUsername;
    private JComboBox cbNEName;
    private JComboBox cbAddNodes;
    private JCheckBox excludeDyn;
    private JCheckBox cktMgtCB;
    private JButton bLogin;
    private JButton bClear;
    private ImageCanvas imgPanel;
    private String neName;
    private boolean isLogin = false;
    private static Preferences prefs = Preferences.instance();
    public static final String PREFS_PATH = "ctc.recent";
    private static final String PREFS_NE_KEY = "nodes";
    private static final String PREFS_USER = "user";
    private static final String PREFS_GROUP = "group";
    public static final String PREFS_EXCL_DYN = "exclude_dyn";
    public static final String PREFS_CKT_MGT = "ckt_mgt";
    public static final String NO_GROUP = "(None)";
    private static final String APPLICATION_ICON = "/images/icons/CTC_icon.gif";
    private static final String LOGIN_VIGNETTE = "/images/CTC_dialogVignette.gif";
    private static final String LOGIN_TITLE = "/images/CTC_title.gif";
    private static final String DIALOG_TITLE = "Login";
    public static KDebug db = new KDebug("LoginDialog");

    public LoginDialog(Object object, String string) {
        super(null, DIALOG_TITLE, false, APPLICATION_ICON);
        db.fine("<LoginDialog>");
        this.addWindowListener(this);
        this.owner = object;
        this.neName = string;
        this.initContentPane();
        db.fine("<LoginDialog> reading NEs from preferences");
        HashSet hashSet = this.getNEsFromPrefs(string);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.cbNEName.addItem(iterator.next());
        }
        this.cbNEName.setSelectedItem(string);
        this.tfUsername.getDocument().addDocumentListener(this);
        this.setColors();
        this.pack();
        this.tfUsername.requestFocus();
        db.fine("<LoginDialog> exit");
    }

    protected void initContentPane() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.setBackground(Color.white);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        JPanel jPanel = new JPanel(new BorderLayout());
        URL uRL = LoginDialog.class.getResource(LOGIN_VIGNETTE);
        this.imgPanel = new ImageCanvas(toolkit.getImage(uRL));
        jPanel.add((Component)this.imgPanel, "West");
        Box box = Box.createVerticalBox();
        uRL = LoginDialog.class.getResource(LOGIN_TITLE);
        ImageCanvas imageCanvas = new ImageCanvas(toolkit.getImage(uRL));
        box.add(imageCanvas);
        Component component = this.createLoginPanel(this.neName);
        box.add(Box.createVerticalStrut(5));
        box.add(component);
        box.add(Box.createVerticalStrut(5));
        box.add(this.createDisablePanel());
        Box box2 = Box.createHorizontalBox();
        this.bLogin = new JButton(" Login ");
        this.getRootPane().setDefaultButton(this.bLogin);
        this.bLogin.addActionListener(this);
        this.bClear = new JButton(" Clear ");
        this.bClear.addActionListener(this);
        box2.add(Box.createHorizontalGlue());
        box2.add(this.bLogin);
        box2.add(Box.createHorizontalGlue());
        box2.add(this.bClear);
        box2.add(Box.createHorizontalGlue());
        box.add(Box.createVerticalStrut(5));
        box.add(box2);
        box.add(Box.createVerticalStrut(10));
        jPanel.add(box);
        container.add((Component)jPanel, "North");
        jPanel.setOpaque(false);
        String string = this.getDisclaimer();
        if (string.length() > 0) {
            JLabel jLabel = new JLabel("<html>" + string);
            jLabel.setVerticalAlignment(0);
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            UScrollPane uScrollPane = new UScrollPane((Component)jLabel);
            uScrollPane.setVerticalScrollBarPolicy(21);
            int n = jLabel.getPreferredSize().width;
            int n2 = jLabel.getPreferredSize().height;
            if (n > 560 || n2 > 210) {
                if ((n2 += 40) < 250) {
                    uScrollPane.setPreferredSize(new Dimension(560, n2));
                } else {
                    uScrollPane.setVerticalScrollBarPolicy(20);
                    uScrollPane.setPreferredSize(new Dimension(520, 250));
                }
            }
            uScrollPane.setOpaque(false);
            uScrollPane.getViewport().setOpaque(false);
            jLabel.setOpaque(false);
            uScrollPane.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 5, 5, 5), BorderFactory.createEtchedBorder()));
            container.add((Component)uScrollPane, "South");
        }
        this.bLogin.setEnabled(this.getUserName().length() > 0);
        this.setResizable(false);
    }

    private Component createLoginPanel(String string) {
        int n = 0;
        GridBagPanel gridBagPanel = new GridBagPanel();
        Set set = PrefsNodesPropertyPane.getGroupNames();
        set.add(NO_GROUP);
        this.cbAddNodes = new JComboBox<String>(set.toArray(new String[0]));
        String string2 = prefs.getProperty(PREFS_PATH, PREFS_GROUP, null);
        if (string2 == null) {
            string2 = set.contains("Topology Hosts") ? "Topology Hosts" : NO_GROUP;
        }
        this.cbAddNodes.setSelectedItem(string2);
        this.cbAddNodes.setEditable(false);
        this.cbAddNodes.setPrototypeDisplayValue(PROTOTYPE_DISPLAY_VALUE);
        this.cbAddNodes.setRenderer(new ToolTipComboBoxRenderer());
        this.cbNEName = new JComboBox();
        this.cbNEName.setEditable(true);
        this.cbNEName.setPrototypeDisplayValue(PROTOTYPE_DISPLAY_VALUE);
        this.cbNEName.setRenderer(new ToolTipComboBoxRenderer());
        this.tfUsername = new LetterOrDigitTextField(20);
        this.tfPassword = new JPasswordField(20);
        this.tfPassword.addKeyListener(this);
        DefaultColors.setColors(gridBagPanel, DefaultColors.LOGIN_B, DefaultColors.LOGIN_F);
        gridBagPanel.inset(4, 3);
        gridBagPanel.fillBoth(100, 0);
        gridBagPanel.anchorWest();
        JLabel jLabel = new JLabel("Version: " + BuildInfo.getShortVersionString());
        gridBagPanel.add((Component)jLabel, 0, n);
        JLabel jLabel2 = new JLabel("User Name");
        DefaultColors.setColors(jLabel2, DefaultColors.LOGIN_B, DefaultColors.LOGIN_F);
        gridBagPanel.add((Component)jLabel2, 0, ++n);
        gridBagPanel.add((Component)this.tfUsername, 1, n);
        jLabel2 = new JLabel("Password");
        DefaultColors.setColors(jLabel2, DefaultColors.LOGIN_B, DefaultColors.LOGIN_F);
        gridBagPanel.add((Component)jLabel2, 0, ++n);
        gridBagPanel.add((Component)this.tfPassword, 1, n);
        jLabel2 = new JLabel("Node Name");
        DefaultColors.setColors(jLabel2, DefaultColors.LOGIN_B, DefaultColors.LOGIN_F);
        gridBagPanel.add((Component)jLabel2, 0, ++n);
        gridBagPanel.add((Component)this.cbNEName, 1, n);
        jLabel2 = new JLabel("Additional Nodes");
        DefaultColors.setColors(jLabel2, DefaultColors.LOGIN_B, DefaultColors.LOGIN_F);
        gridBagPanel.add((Component)jLabel2, 0, ++n);
        gridBagPanel.add((Component)this.cbAddNodes, 1, n);
        return gridBagPanel;
    }

    public Component createDisablePanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.excludeDyn = new JCheckBox("Disable Network Discovery");
        this.excludeDyn.setToolTipText("If checked, DCC connected nodes will not be discovered");
        this.excludeDyn.setSelected(prefs.getBoolean(PREFS_PATH, PREFS_EXCL_DYN, false));
        DefaultColors.setColors(this.excludeDyn, DefaultColors.LOGIN_B, DefaultColors.LOGIN_F);
        jPanel.add(this.excludeDyn);
        this.cktMgtCB = new JCheckBox("Disable Circuit Management");
        this.cktMgtCB.setToolTipText("If checked, circuit operations will not be allowed until circuit management is enabled from CTC");
        DefaultColors.setColors(this.cktMgtCB, DefaultColors.LOGIN_B, DefaultColors.LOGIN_F);
        this.cktMgtCB.setSelected(prefs.getBoolean(PREFS_PATH, PREFS_CKT_MGT, false));
        jPanel.add(this.cktMgtCB);
        Box box = Box.createHorizontalBox();
        box.add(Box.createGlue());
        box.add(jPanel);
        box.add(Box.createGlue());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)box, "North");
        jPanel2.setOpaque(false);
        return jPanel2;
    }

    private String getDisclaimer() {
        String string = "";
        try {
            string = CtcHttpRetriever.getLegalDisclaimer((String)this.neName);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            db.info("<LoginDialog> No Legal Disclaimer Method");
        }
        catch (Exception exception) {
            db.info("<LoginDialog> " + exception.toString());
        }
        int n = string.indexOf(60);
        if (n == -1) {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                if (n2 > 70) {
                    stringBuffer.append("<p>");
                    n2 = 0;
                }
                String string2 = " " + stringTokenizer.nextToken();
                stringBuffer.append(string2);
                n2 += string2.length();
            }
            string = stringBuffer.toString();
        }
        return string.trim();
    }

    public String getUserName() {
        return this.tfUsername.getText().trim();
    }

    public String getPassword() {
        return new String(this.tfPassword.getPassword());
    }

    public String getNodeName() {
        return ((String)this.cbNEName.getSelectedItem()).trim();
    }

    public String[] getNodes() {
        String string = (String)this.cbAddNodes.getSelectedItem();
        return PrefsNodesPropertyPane.getGroupMembers(string);
    }

    public boolean getExcludeDynMode() {
        return this.excludeDyn.isSelected();
    }

    public boolean getCktMgtMode() {
        return this.cktMgtCB.isSelected();
    }

    public String getAdditionalNodeGroup() {
        return this.cbAddNodes.getSelectedItem().toString();
    }

    void reuse(String string) {
        if (string != null) {
            this.tfUsername.setText(string);
            this.bLogin.setEnabled(this.getUserName().length() > 0);
        }
        this.tfPassword.setText("");
    }

    public void clear() {
        this.tfPassword.setText("");
        this.tfUsername.setText("");
        this.bLogin.setEnabled(false);
        this.tfUsername.requestFocus();
    }

    public boolean isLogin() {
        return this.isLogin;
    }

    private void setColors() {
        DefaultColors.setColors(this, DefaultColors.LOGIN_B, DefaultColors.LOGIN_F);
        DefaultColors.setColors(this.imgPanel, DefaultColors.LOGIN_B, DefaultColors.LOGIN_F);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            Object object = actionEvent.getSource();
            if (object == this.bLogin) {
                this.isLogin = true;
                prefs.setProperty(PREFS_PATH, PREFS_GROUP, (String)this.cbAddNodes.getSelectedItem());
                prefs.setBoolean(PREFS_PATH, PREFS_EXCL_DYN, this.excludeDyn.isSelected());
                prefs.setBoolean(PREFS_PATH, PREFS_CKT_MGT, this.cktMgtCB.isSelected());
                this.dispose();
            } else if (object == this.bClear) {
                this.clear();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        Object object;
        if (this.isVisible() && (object = keyEvent.getSource()) == this.tfPassword && (n = keyEvent.getKeyCode()) == 10 && this.bLogin.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.bLogin, 0, "Enter"));
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private HashSet getNEsFromPrefs(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = prefs.getProperty(PREFS_PATH, PREFS_NE_KEY, null);
        string2 = string2 == null ? string : string2 + "," + string;
        int n = 0;
        while (n != -1 && n < string2.length()) {
            int n2 = string2.indexOf(",", n);
            String string3 = null;
            string3 = n2 != -1 ? string2.substring(n, n2) : string2.substring(n);
            hashSet.add(string3);
            n = n2 == -1 ? -1 : n2 + 1;
        }
        this.saveNEsToPrefs(hashSet);
        return hashSet;
    }

    private void saveNEsToPrefs(HashSet hashSet) {
        String string = "";
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (string.equals("")) {
                string = (String)iterator.next();
                continue;
            }
            string = string + "," + (String)iterator.next();
        }
        prefs.setProperty(PREFS_PATH, PREFS_NE_KEY, string);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.bLogin.setEnabled(this.getUserName().length() != 0);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowClosed(WindowEvent windowEvent) {
        Object object = this.owner;
        synchronized (object) {
            this.owner.notifyAll();
        }
        super.windowClosed(windowEvent);
    }

    private class ToolTipComboBoxRenderer
    extends BasicComboBoxRenderer {
        private ToolTipComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            Font font = jList.getFont();
            String string2 = string = object == null ? "" : object.toString();
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
                FontMetrics fontMetrics = jList.getFontMetrics(font);
                double d = LoginDialog.this.cbNEName.getWidth();
                double d2 = 0.0;
                if (fontMetrics != null) {
                    d2 = fontMetrics.getStringBounds(string, jList.getGraphics()).getWidth();
                }
                if (n > -1 && d2 > d) {
                    jList.setToolTipText(string);
                } else {
                    jList.setToolTipText(null);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(font);
            this.setText(string);
            return this;
        }
    }
}

