/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import cerent.cms.model.ProgressEvent;
import cerent.cms.model.ProgressManager;
import cerent.util.BuildInfo;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.ImageCanvas;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.SortDirectionIconFactory;
import com.cisco.ctc.ui.CTCVignette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends UDialog
implements Observer,
Runnable,
ActionListener {
    private static final String FONT_NAME = "Sans Serif";
    private JPanel contentPane;
    private JPanel detailsPane;
    private JTextArea detailsArea;
    private JButton bDetails;
    private JProgressBar progressBar;
    private boolean stopProgress = false;
    private ImageCanvas titlePanel;
    private ImageCanvas imgPanel;
    private boolean detailsOn = false;
    private boolean needToggle = false;
    private LinkedList detailsList = new LinkedList();
    private JDialog warningDialog;
    private JOptionPane warningPane;
    private static final String PROGRESS_TITLE = "/images/CTC_title.gif";
    private static final int PREF_WIDTH = 400;
    private static final int PREF_DETAILS_HEIGHT = 200;

    public static ProgressDialog instance(Frame frame, String string) {
        return new ProgressDialog(frame, string);
    }

    private ProgressDialog(Frame frame, String string) {
        super(frame, string, true);
        ProgressManager.instance().addObserver(this);
        this.setResizable(false);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.contentPane = jPanel;
        this.detailsPane = this.createDetailsPane();
        jPanel.setLayout(new GridBagLayout());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL uRL = ProgressDialog.class.getResource(PROGRESS_TITLE);
        ImageCanvas imageCanvas = new ImageCanvas(toolkit.getImage(uRL));
        CTCVignette cTCVignette = new CTCVignette();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)imageCanvas, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        JLabel jLabel = new JLabel("V" + BuildInfo.getShortVersionString());
        jLabel.setFont(new Font(FONT_NAME, 1, 12));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)cTCVignette, gridBagConstraints);
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = new JLabel("Initializing CTC... Please Wait");
        Dimension dimension = new Dimension(400, 25);
        jLabel2.setPreferredSize(dimension);
        jLabel2.setMinimumSize(dimension);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.bDetails = new JButton();
        this.updateDetailsButton();
        this.bDetails.addActionListener(this);
        jPanel2.add((Component)this.progressBar, "Center");
        jPanel2.add((Component)this.bDetails, "East");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.detailsPane.setVisible(false);
        jPanel.add((Component)this.detailsPane, gridBagConstraints);
        jPanel.setBackground(Color.white);
    }

    private JPanel createDetailsPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.detailsArea = new JTextArea("\n");
        this.detailsArea.setEditable(false);
        this.detailsArea.setLineWrap(true);
        this.detailsArea.setTabSize(5);
        jPanel.add((Component)new UScrollPane((Component)this.detailsArea), "Center");
        jPanel.setPreferredSize(new Dimension(400, 200));
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(String string) {
        LinkedList linkedList = this.detailsList;
        synchronized (linkedList) {
            this.detailsList.add(string);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof ProgressManager && object instanceof ProgressEvent) {
            ProgressEvent progressEvent = (ProgressEvent)object;
            int n = this.progressBar.getValue();
            switch (progressEvent.eventCode) {
                case 1: {
                    this.append("\t" + progressEvent.stepDescriptor + "...\n");
                    n += 5;
                    break;
                }
                case 3: {
                    this.append("\t\t" + progressEvent.stepDescriptor + "\n");
                    n += 5;
                    break;
                }
                case 4: {
                    this.append("\n\tALL DONE SUCCESSFULLY\n");
                    n = 100;
                    ProgressManager.instance().deleteObserver(this);
                    if (this.warningDialog == null || !this.warningDialog.isVisible()) break;
                    this.warningDialog.setVisible(false);
                    this.warningDialog.dispose();
                    this.warningDialog = null;
                    break;
                }
                case 5: {
                    this.append("\t ERROR: Failed in " + progressEvent.stepDescriptor + "\n");
                    if (this.warningDialog == null || !this.warningDialog.isVisible()) {
                        this.showWarningDialog("CTC Initialization", "Failure during " + progressEvent.stepDescriptor + "\nPlease wait, trying once again... ");
                        this.stopProgress = true;
                        break;
                    }
                    this.warningPane.setMessage("Failure during " + progressEvent.stepDescriptor + "\nPlease wait, trying once again... ");
                    this.warningDialog.pack();
                    this.warningDialog.setVisible(true);
                    break;
                }
                default: {
                    if (progressEvent.exception == null) break;
                    this.append("\t\tWARNING: " + progressEvent.exception + "\n");
                }
            }
            if (!this.stopProgress) {
                this.progressBar.setValue(n);
            }
        }
    }

    private void showWarningDialog(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressDialog.this.warningPane = new JOptionPane(string2, 2, -1, CerentDialog.WARNING_ICON);
                ProgressDialog.this.warningDialog = ProgressDialog.this.warningPane.createDialog((Component)((Object)ProgressDialog.this), string);
                ProgressDialog.this.warningDialog.pack();
                ProgressDialog.this.warningDialog.setModal(false);
                ProgressDialog.this.warningDialog.setVisible(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        LinkedList linkedList = this.detailsList;
        synchronized (linkedList) {
            Iterator iterator = this.detailsList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.detailsArea.append(string);
                bl = true;
            }
            this.detailsList.clear();
        }
        if (bl) {
            this.detailsArea.paintImmediately(this.detailsArea.getBounds());
            this.contentPane.repaint();
        }
        if (this.needToggle) {
            this.toggleDetails();
        }
    }

    private void toggleDetails() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.detailsOn = !this.detailsOn;
            this.detailsPane.setVisible(this.detailsOn);
            this.updateDetailsButton();
            this.pack();
            this.center();
            this.needToggle = false;
        } else {
            this.needToggle = true;
            SwingUtilities.invokeLater(this);
        }
    }

    private void updateDetailsButton() {
        this.bDetails.setIcon(SortDirectionIconFactory.getIcon((boolean)this.detailsOn));
        if (this.detailsOn) {
            this.bDetails.setText("Hide Details");
        } else {
            this.bDetails.setText("Show Details");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible() && actionEvent.getSource() == this.bDetails) {
            this.toggleDetails();
        }
    }

    public void showDetails() {
        if (!this.detailsOn) {
            this.toggleDetails();
        }
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            super.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().requestFocus();
            }
        } else {
            super.setVisible(true);
        }
    }

    public void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        super.dispose();
    }
}

