/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import com.cisco.ctc.util.map.AbstractLink;
import com.cisco.ctc.util.map.AbstractNode;
import com.cisco.ctc.util.map.AbstractView;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapImage;
import com.cisco.ctc.util.map.MapImageIcon;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvRect;
import ilog.views.graphic.IlvRectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;

public abstract class AbstractGraph
extends IlvGrapher {
    static final int LAYER_BACKGROUND = 0;
    static final int LAYER_LINK = 1;
    static final int LAYER_ICON = 2;
    static final int LAYER_NODE = 3;
    static final int LAYER_LABEL = 4;
    static final int LAYER_LINE = 5;
    static final int LAYER_SELECTOR = 6;
    static final int LAYER_PORT = 7;
    static final int LAYER_OTHERS = 8;
    protected MapToolkit mtk;
    private Object owner = null;
    private IlvRectangle borderRect = null;

    public AbstractGraph(MapToolkit mapToolkit) {
        this(mapToolkit, mapToolkit);
    }

    public AbstractGraph(MapToolkit mapToolkit, Object object) {
        this.mtk = mapToolkit;
        this.owner = object;
        this.enableBorder(true);
    }

    public void add(Object object) {
        try {
            if (object instanceof AbstractNode) {
                this.addNode((AbstractNode)((Object)object));
            } else if (object instanceof AbstractLink) {
                this.addLink((AbstractLink)((Object)object));
            } else if (object instanceof LinkBundle) {
                this.addLinkBundle((LinkBundle)object);
            } else if (object instanceof MapImage) {
                this.addIcon((MapImage)((Object)object));
            } else if (object instanceof IlvGraphic) {
                this.addOthers((IlvGraphic)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addNode(AbstractNode abstractNode) {
        super.addNode((IlvGraphic)abstractNode, 3, true);
        if (abstractNode instanceof MapNode && this.isDomainGraph()) {
            ((MapDomain)this.owner).nodeAdded((MapNode)abstractNode);
        }
    }

    private void addLinkBundle(LinkBundle linkBundle) {
        super.addLink((IlvLinkImage)linkBundle, 1, true);
    }

    private void addLink(AbstractLink abstractLink) {
        super.addLink((IlvLinkImage)abstractLink, 1, true);
    }

    private void addIcon(MapImage mapImage) {
        if (mapImage instanceof MapImageIcon) {
            super.addObject((IlvGraphic)mapImage, 2, true);
        } else {
            super.addObject((IlvGraphic)mapImage, 0, true);
        }
        mapImage.setSelectable(false);
    }

    private void addOthers(IlvGraphic ilvGraphic) {
        super.addObject(ilvGraphic, 8, true);
    }

    AbstractView getView() {
        Enumeration enumeration = super.getViews();
        if (enumeration.hasMoreElements()) {
            return (AbstractView)((Object)enumeration.nextElement());
        }
        return null;
    }

    public Object getOwner() {
        return this.owner;
    }

    boolean isDomainGraph() {
        return this.getOwner() instanceof MapDomain;
    }

    public void remove(IlvGraphic ilvGraphic) {
        if (ilvGraphic == null) {
            return;
        }
        super.removeObject(ilvGraphic, true);
        if (ilvGraphic instanceof MapNode && this.isDomainGraph()) {
            MapNode mapNode = (MapNode)ilvGraphic;
            ((MapDomain)this.owner).nodeRemoved(mapNode);
        }
    }

    public void setBackgroundImage(String string) {
    }

    public void removeBackgroundImage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getSelectedComponents() {
        ArrayList<IlvGraphic> arrayList = new ArrayList<IlvGraphic>();
        AbstractGraph abstractGraph = this;
        synchronized (abstractGraph) {
            IlvGraphicEnumeration ilvGraphicEnumeration = super.getSelectedObjects();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                arrayList.add(ilvGraphicEnumeration.nextElement());
            }
        }
        return arrayList.toArray(new Object[0]);
    }

    int getSelectedComponentsCount() {
        return this.getSelectedComponents().length;
    }

    void deSelectAll() {
        super.deSelectAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getComponents() {
        ArrayList<IlvGraphic> arrayList = new ArrayList<IlvGraphic>();
        AbstractGraph abstractGraph = this;
        synchronized (abstractGraph) {
            IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                arrayList.add(ilvGraphicEnumeration.nextElement());
            }
        }
        return arrayList.toArray(new Object[0]);
    }

    int getComponentsCount() {
        return this.getComponents().length;
    }

    boolean isObjectsIntersected(Object object, Object object2) {
        if (object instanceof AbstractNode && object2 instanceof AbstractNode) {
            AbstractNode abstractNode = (AbstractNode)((Object)object);
            AbstractNode abstractNode2 = (AbstractNode)((Object)object2);
            IlvRect ilvRect = abstractNode.boundingBox();
            IlvRect ilvRect2 = abstractNode2.boundingBox();
            return ilvRect.intersects((Rectangle2D)ilvRect2);
        }
        return false;
    }

    public boolean isSelected(IlvGraphic ilvGraphic) {
        return super.isSelected(ilvGraphic);
    }

    public final void setSelected(IlvGraphic ilvGraphic, boolean bl, boolean bl2) {
        super.setSelected(ilvGraphic, bl, bl2);
        if (ilvGraphic instanceof Node) {
            ((Node)ilvGraphic).setSelected(bl);
        } else if (ilvGraphic instanceof Link) {
            ((Link)ilvGraphic).setSelected(bl);
        } else if (ilvGraphic instanceof LinkBundle) {
            ((LinkBundle)ilvGraphic).setSelected(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getConnectedLinks(AbstractNode abstractNode) {
        ArrayList<IlvGraphic> arrayList = new ArrayList<IlvGraphic>();
        AbstractGraph abstractGraph = this;
        synchronized (abstractGraph) {
            IlvGraphicEnumeration ilvGraphicEnumeration = super.getLinks((IlvGraphic)abstractNode);
            while (ilvGraphicEnumeration.hasMoreElements()) {
                arrayList.add(ilvGraphicEnumeration.nextElement());
            }
        }
        return arrayList.toArray(new Object[0]);
    }

    public boolean contains(Object object) {
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            return true;
        }
        return false;
    }

    void enableBorder(boolean bl) {
        if (bl) {
            if (this.borderRect == null) {
                IlvRect ilvRect = new IlvRect(0.0f, 0.0f, 3200.0f, 2400.0f);
                this.borderRect = new IlvRectangle(ilvRect, true, false);
            }
            super.addObject((IlvGraphic)this.borderRect, 0, true);
            this.setSelectable((IlvGraphic)this.borderRect, false);
        } else {
            this.remove((IlvGraphic)this.borderRect);
        }
    }

    public void reDraw() {
        super.reDraw();
    }

    public void cleanUp() {
    }
}

