/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.MapImage;
import com.cisco.ctc.util.map.MapImageIcon;
import com.cisco.ctc.util.map.MapLayout;
import ilog.views.IlvGraphic;
import ilog.views.IlvHandlesSelection;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.interactor.IlvSelectInteractor;
import ilog.views.interactor.IlvSelectInteractorMoveSelection;
import ilog.views.interactor.IlvZoomViewInteractor;
import ilog.views.swing.IlvJScrollManagerView;
import ilog.views.swing.IlvToolTipManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.JComponent;

public abstract class AbstractView
extends IlvManagerView
implements TransformerListener {
    static final int VIEW_HEIGHT = 2400;
    static final int VIEW_WIDTH = 3200;
    private int zoomCount = 0;
    private IlvJScrollManagerView graphWin = null;
    private IlvZoomViewInteractor zoomViewInteractor = null;

    public AbstractView() {
        CustomSelectInteractor customSelectInteractor = new CustomSelectInteractor();
        customSelectInteractor.setOpaqueMove(true);
        this.pushInteractor((IlvManagerViewInteractor)customSelectInteractor);
        this.setKeepingAspectRatio(true);
        IlvToolTipManager.registerView((IlvManagerView)this);
        IlvHandlesSelection.defaultHandleColor = Color.black;
        IlvHandlesSelection.defaultHandleBackgroundColor = Color.white;
        IlvHandlesSelection.defaultHandleShape = 3;
        IlvHandlesSelection.defaultHandleSize = 1.0f;
        this.setAntiAliasing(true);
        super.ensureVisible(new IlvPoint(1250.0f, 1050.0f));
        this.addTransformerListener(this);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setBackgroundI(String string) {
        try {
            MapImageIcon mapImageIcon = new MapImageIcon(new URL(string));
            this.getGraph().add((Object)mapImageIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGraph(AbstractGraph abstractGraph) {
        if (abstractGraph != null) {
            super.setManager((IlvManager)abstractGraph);
            this.zoomCount = 0;
        }
    }

    public AbstractGraph getGraph() {
        IlvManager ilvManager = super.getManager();
        if (ilvManager instanceof AbstractGraph) {
            return (AbstractGraph)ilvManager;
        }
        return null;
    }

    public void resetZoom() {
        int n = this.getZoomCount();
        for (int i = 0; i < Math.abs(n - 0); ++i) {
            if (n < 0) {
                this.zoomIn();
                continue;
            }
            this.zoomOut();
        }
    }

    void zoomIn() {
        ++this.zoomCount;
        Dimension dimension = super.getSize();
        super.zoom(new IlvPoint((float)(dimension.width / 2), (float)(dimension.height / 2)), 1.1, 1.1, true);
    }

    void zoomOut() {
        --this.zoomCount;
        Dimension dimension = super.getSize();
        super.zoom(new IlvPoint((float)(dimension.width / 2), (float)(dimension.height / 2)), 0.9090909090909091, 0.9090909090909091, true);
    }

    public int getZoomCount() {
        return this.zoomCount;
    }

    void resetZoomCount() {
        this.zoomCount = 0;
    }

    public void setAntiAliasing(boolean bl) {
        super.setAntialiasing(bl);
    }

    public void doSpringLayout(Rectangle2D rectangle2D) {
        MapLayout.doSpringLayout(this.getGraph(), rectangle2D);
    }

    public void doUniformLengthEdgesLayout(Rectangle2D rectangle2D) {
        MapLayout.doUniformLengthEdgesLayout(this.getGraph(), rectangle2D);
    }

    void reDraw(Rectangle2D rectangle2D) {
        super.invalidateRect(new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight()));
        super.reDrawViews();
    }

    void reDraw() {
        super.invalidateView();
        super.reDrawViews();
    }

    public void updateView() {
    }

    Object getMapObjectAt(float f, float f2) {
        IlvGraphic ilvGraphic = this.getGraph().getObject(new IlvPoint(f, f2), this);
        if (ilvGraphic instanceof MapImage) {
            return null;
        }
        return ilvGraphic;
    }

    public JComponent getGraphWindow() {
        if (this.graphWin == null) {
            this.graphWin = new IlvJScrollManagerView((IlvManagerView)this);
            this.graphWin.setPreferredSize(new Dimension(600, 600));
        }
        return this.graphWin;
    }

    public static int getCanvasCenterX() {
        return 1600;
    }

    public static int getCanvasCenterY() {
        return 1200;
    }

    public static int getCanvasHeight() {
        return 2400;
    }

    public static int getCanvasWidth() {
        return 3200;
    }

    double getRotationAngle(IlvLinkImage ilvLinkImage) {
        double d = 0.0;
        IlvPoint[] ilvPointArray = ilvLinkImage.getLinkPoints(this.getTransformer());
        if (ilvPointArray.length == 2) {
            double d2 = ilvPointArray[1].getX() - ilvPointArray[0].getX();
            double d3 = ilvPointArray[1].getY() - ilvPointArray[0].getY();
            d = d2 == 0.0 ? 90.0 : Math.toDegrees(Math.atan(d3 / d2));
        }
        if (d < 0.0) {
            d = 360.0 + d;
        }
        return d;
    }

    Point2D.Double getWorldPoint(Point2D.Double double_) {
        IlvPoint ilvPoint = new IlvPoint((float)double_.getX(), (float)double_.getY());
        this.getTransformer().inverse(ilvPoint);
        return new Point2D.Double(ilvPoint.getX(), ilvPoint.getY());
    }

    public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
        this.viewChanged();
    }

    protected void viewChanged() {
    }

    public void fitView() {
        AbstractGraph abstractGraph = this.getGraph();
        if (abstractGraph != null) {
            abstractGraph.enableBorder(false);
            super.fitTransformerToContent();
            this.zoomCount = 0;
            abstractGraph.enableBorder(true);
            this.reDraw();
        }
    }

    boolean isSelectZoom() {
        return this.getInteractor() instanceof IlvZoomViewInteractor;
    }

    void zoomSelectedArea() {
        if (this.zoomViewInteractor == null) {
            this.zoomViewInteractor = new IlvZoomViewInteractor();
        }
        super.pushInteractor((IlvManagerViewInteractor)this.zoomViewInteractor);
        this.resetZoomCount();
    }

    public Rectangle2D getViewRect() {
        return new Rectangle2D.Double(0.0, 0.0, super.visibleRect().getWidth(), super.visibleRect().getHeight());
    }

    class CustomSelectInteractorMoveSelection
    extends IlvSelectInteractorMoveSelection {
        public CustomSelectInteractorMoveSelection(IlvSelectInteractor ilvSelectInteractor) {
            super(ilvSelectInteractor);
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            int n = 0;
            int n2 = 0;
            int n3 = AbstractView.getCanvasWidth();
            int n4 = AbstractView.getCanvasHeight();
            IlvPoint ilvPoint = new IlvPoint((float)mouseEvent.getX(), (float)mouseEvent.getY());
            IlvTransformer ilvTransformer = this.getManagerView().getTransformer();
            ilvTransformer.inverse(ilvPoint);
            if (ilvPoint.getX() > 0.0 && ilvPoint.getX() < (double)n3 && ilvPoint.getY() > 0.0 && ilvPoint.getY() < (double)n4) {
                mouseEvent.translatePoint(n, n2);
                super.processMouseMotionEvent(mouseEvent);
            }
        }
    }

    class CustomSelectInteractor
    extends IlvSelectInteractor {
        CustomSelectInteractor() {
        }

        protected IlvManagerViewInteractor getMoveSelectionInteractor() {
            return new CustomSelectInteractorMoveSelection(this);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            int n = 50;
            IlvTransformer ilvTransformer = this.getTransformer();
            int n2 = (int)ilvTransformer.getx0();
            int n3 = (int)ilvTransformer.gety0();
            int n4 = keyEvent.getKeyCode();
            Rectangle rectangle = AbstractView.this.visibleRect();
            int n5 = (int)rectangle.getHeight();
            int n6 = (int)rectangle.getWidth();
            double d = ilvTransformer.getx11();
            double d2 = ilvTransformer.getx22();
            if (n4 == 33 || n4 == 38) {
                if (n3 <= 0) {
                    int n7 = Math.abs(n3) < 2 * n ? Math.abs(n3) : n;
                    AbstractView.this.translate(0.0f, n7, true);
                }
            } else if (n4 == 34 || n4 == 40) {
                double d3 = (double)(Math.abs(n3) + n5) / d2;
                if (d3 < 2400.0) {
                    int n8 = (int)(2400.0 * d2 - (double)Math.abs(n3) - (double)n5);
                    int n9 = Math.min(n8, n);
                    AbstractView.this.translate(0.0f, -1 * n9, true);
                }
            } else if (n4 == 37) {
                if (n2 <= 0) {
                    int n10 = Math.abs(n2) < 2 * n ? Math.abs(n2) : n;
                    AbstractView.this.translate(n10, 0.0f, true);
                }
            } else if (n4 == 39) {
                double d4 = (double)(Math.abs(n2) + n6) / d;
                if (d4 < 3200.0) {
                    int n11 = (int)(3200.0 * d - (double)Math.abs(n2) - (double)n6);
                    int n12 = Math.min(n11, n);
                    AbstractView.this.translate(-1 * n12, 0.0f, true);
                }
            } else if (n4 == 36) {
                // empty if block
            }
        }
    }
}

