/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import com.cisco.ctc.util.map.MapGraphicsUtil;
import java.awt.Color;

public class DetailedMapLinkStyle {
    public static final Color UNKNOWN_COLOR = Color.gray;
    public static final int NO_ARROW = 0;
    public static final int SINGLE_ARROW_FORWARD = 1;
    public static final int SINGLE_ARROW_BACKWARD = 2;
    public static final int DOUBLE_ARROW = 3;
    Color color;
    int direction;

    public DetailedMapLinkStyle() {
        this(0, UNKNOWN_COLOR);
    }

    public DetailedMapLinkStyle(int n, Color color) {
        this.direction = n;
        this.color = color;
    }

    public void reverse() {
        if (this.direction == 1) {
            this.direction = 2;
        } else if (this.direction == 2) {
            this.direction = 1;
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public Color getColor() {
        return this.color;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Link Style:\t");
        switch (this.direction) {
            case 0: {
                stringBuffer.append("No Arrow");
                break;
            }
            case 1: {
                stringBuffer.append("Single Arrow (fwd)");
                break;
            }
            case 2: {
                stringBuffer.append("Single Arrow (bwd)");
                break;
            }
            case 3: {
                stringBuffer.append("Double Arrow");
                break;
            }
            default: {
                stringBuffer.append("Unknown direction: " + this.direction);
            }
        }
        stringBuffer.append("\tColor: " + MapGraphicsUtil.getColorString(this.color));
        return stringBuffer.toString() + "\n";
    }
}

