/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DomainNameEditDialog
extends JDialog
implements ActionListener {
    public static final int CREATE = 1;
    public static final int RENAME = 2;
    private static final String CREATE_TITLE = "Create Domain";
    private static final String RENAME_TITLE = "Rename Domain";
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    private static final int MARGIN = 5;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField nameTF;
    private MapToolkit mtk;
    private int mode;
    private boolean ok = false;
    private String oldName;

    public DomainNameEditDialog(MapToolkit mapToolkit, String string, int n) {
        super(JOptionPane.getFrameForComponent((Component)((Object)mapToolkit)), n == 1 ? CREATE_TITLE : RENAME_TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DomainNameEditDialog.this.dispose();
            }
        });
        this.mtk = mapToolkit;
        this.mode = n;
        this.oldName = string;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getComponentPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo((Component)((Object)mapToolkit));
        this.setVisible(true);
    }

    private JPanel getComponentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add(new JLabel("Name: "));
        this.nameTF = new JTextField(32);
        jPanel.add(this.nameTF);
        this.nameTF.setText(this.oldName);
        this.nameTF.selectAll();
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    public String getName() {
        return this.nameTF.getText();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.mtk.containsDomain(this.getName())) {
                ErrorMsg.displayError((Component)this.mtk.getGraphWindow(), (EID)NEMC.EID_DOMAIN_NAME_EXISTS);
                return;
            }
            if (this.getName().length() > 32) {
                ErrorMsg.displayError((Component)this.mtk.getGraphWindow(), (EID)NEMC.EID_DOMAIN_NAME_TOO_LONG_PARAM_1, (Object)"32");
                return;
            }
            this.ok = true;
            if (this.mode == 2) {
                String string = this.getName();
                if (this.oldName != null && string != null && string.length() > 0 && !this.oldName.equals(string)) {
                    this.mtk.domainNameChanged(this.oldName, string);
                }
            }
        }
        this.dispose();
    }

    boolean isOk() {
        return this.ok;
    }
}

