/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.gui.UPopupMenu;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;

public class MapNode
extends Node {
    public static final String CMD_NODE_TO_ROOT = "Move Node Back To Parent View";
    public static final String CMD_GOTO_NODE_DOMAIN = "Go to Node Domain";
    private MapNode realNode;
    private HashSet vnodes = new HashSet();

    public MapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
        this.realNode = this;
    }

    void setRealNode(MapNode mapNode) {
        this.realNode = mapNode;
    }

    final void init(MapNode mapNode) {
        this.setRealNode(mapNode);
        this.init(mapNode.getUserObject(), mapNode.getCenterX(), mapNode.getCenterY(), mapNode.getUserCookie());
        mapNode.addVNode(this);
    }

    void refreshContainerUI() {
        MapDomain mapDomain = this.getDomain();
        if (mapDomain != null && !this.isVirtual()) {
            mapDomain.refreshUI();
        }
    }

    public void setDesc(String string) {
        super.setDesc(string);
        Iterator iterator = this.vnodes.iterator();
        while (iterator.hasNext()) {
            MapNode mapNode = (MapNode)iterator.next();
            mapNode.setDesc(string);
        }
    }

    public void addDesc(String string) {
        super.addDesc(string);
        Iterator iterator = this.vnodes.iterator();
        while (iterator.hasNext()) {
            MapNode mapNode = (MapNode)iterator.next();
            mapNode.addDesc(string);
        }
    }

    protected void setColor(Color color) {
        if (this.isVirtual()) {
            color = MapGraphicsUtil.getAlphaColor(color, 100);
        }
        super.setColor(color);
        this.refreshContainerUI();
    }

    protected final void setIcon(Image image) {
        super.setIcon(image);
        this.refreshContainerUI();
    }

    protected Color getColor() {
        Color color = super.getColor();
        if (color != null) {
            return new Color(color.getRGB());
        }
        return null;
    }

    private synchronized void addVNode(MapNode mapNode) {
        this.vnodes.add(mapNode);
    }

    private synchronized void removeVNode(MapNode mapNode) {
        if (this.vnodes != null) {
            this.vnodes.remove(mapNode);
        }
    }

    protected void initPopupMenu(UPopupMenu uPopupMenu) {
        if (this.isVirtual()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_GOTO_NODE_DOMAIN, 68);
        }
        if (this.getMapGraph().isDomainGraph() && !this.isVirtual()) {
            this.actOrg.addMenuItem((JComponent)uPopupMenu, null, CMD_NODE_TO_ROOT, 78);
        }
    }

    public MapNode getRealNode() {
        return this.realNode;
    }

    public MapNode[] getVNodes() {
        return this.vnodes.toArray(new MapNode[0]);
    }

    public boolean isSameNodeAs(Node node) {
        if (node instanceof MapNode) {
            return this.getRealNode() == ((MapNode)node).getRealNode();
        }
        return false;
    }

    public boolean isVirtual() {
        return this.realNode != this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_NODE_TO_ROOT) {
            if (this.getMapGraph().isDomainGraph() && !this.isVirtual()) {
                this.doMoveToRoot();
            }
        } else if (string == CMD_GOTO_NODE_DOMAIN) {
            if (this.isVirtual()) {
                this.doGoToNodeDomain();
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void linkAdded(MapLink mapLink) {
    }

    protected void linkToBeRemoved(MapLink mapLink) {
    }

    protected void doGoToNodeDomain() {
        this.mtk.doGoToNodeDomain(this);
    }

    protected boolean canInsertToDomain() {
        return true;
    }

    public MapDomain getDomain() {
        MapGraph mapGraph = this.getMapGraph();
        if (mapGraph != null && mapGraph.getOwner() instanceof MapDomain) {
            return (MapDomain)mapGraph.getOwner();
        }
        return null;
    }

    public String getDomainName() {
        MapDomain mapDomain = this.getDomain();
        if (mapDomain == null) {
            return "";
        }
        return mapDomain.getName();
    }

    protected void doMoveToRoot() {
        this.mtk.moveNode(this);
    }

    protected void doubleClicked() {
        this.mtk.doubleClicked(this);
    }

    public void destroy() {
        try {
            if (this.vnodes != null) {
                Iterator iterator = this.vnodes.iterator();
                while (iterator.hasNext()) {
                    MapNode mapNode = (MapNode)iterator.next();
                    mapNode.destroy();
                }
            }
            super.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MapGraph getMapGraph() {
        return (MapGraph)this.getGraph();
    }

    public boolean isDomain() {
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

