/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.MapObjectAdapter;
import com.cisco.ctc.util.map.MapTransformer;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvPolygon;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MapPolygon
extends IlvPolygon {
    public MapPolygon() {
        super(new IlvPoint[]{new IlvPoint(0.0f, 0.0f), new IlvPoint(1.0f, 0.0f), new IlvPoint(0.0f, 1.0f), new IlvPoint(1.0f, 1.0f)});
        this.setOutline(true);
    }

    public int getPointCount() {
        return super.getPoints().length;
    }

    public void addPoint(double d, double d2) {
        super.insertPoint(this.getPoints().length, (float)d, (float)d2, null);
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    public void removePoints(int n) {
        for (int i = 0; i < n; ++i) {
            super.removePoint(0, null);
        }
    }

    public void setMovable(boolean bl) {
        IlvGraphicBag ilvGraphicBag = super.getGraphicBag();
        if (ilvGraphicBag != null && ilvGraphicBag instanceof AbstractGraph) {
            ((AbstractGraph)ilvGraphicBag).setMovable((IlvGraphic)this, bl);
        }
    }

    public void setSelectable(boolean bl) {
        IlvGraphicBag ilvGraphicBag = super.getGraphicBag();
        if (ilvGraphicBag != null && ilvGraphicBag instanceof AbstractGraph) {
            ((AbstractGraph)ilvGraphicBag).setSelectable((IlvGraphic)this, bl);
        }
    }

    public AbstractGraph getGraph() {
        return (AbstractGraph)super.getGraphicBag();
    }

    public void setLocation(double d, double d2) {
        this.setLocation(d, d2, this.getGraph());
    }

    public void setLocation(double d, double d2, AbstractGraph abstractGraph) {
        MapObjectAdapter.setLocation(abstractGraph, (IlvGraphic)this, d, d2);
    }

    public final String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.getToolTipText();
    }

    public String getToolTipText() {
        return super.getToolTipText();
    }

    public boolean contains(double d, double d2) {
        IlvRect ilvRect = super.boundingBox();
        return ilvRect.contains(d, d2);
    }

    public void setColor(Color color) {
        super.setForeground(color);
        this.reDraw();
    }

    public Color getColor() {
        return super.getForeground();
    }

    public void setOutline(boolean bl) {
        super.setStrokeOn(bl);
    }

    public void setFillOn(boolean bl) {
        super.setFillOn(bl);
    }

    public void reDraw() {
        super.reDraw();
    }

    public final void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        this.drawMe((Graphics2D)graphics, new MapTransformer(ilvTransformer));
    }

    protected void drawMe(Graphics2D graphics2D, MapTransformer mapTransformer) {
        super.draw((Graphics)graphics2D, mapTransformer.getTransform());
    }

    public Rectangle2D.Float getBounds() {
        return super.boundingBox();
    }

    public Rectangle2D.Float getBounds(MapTransformer mapTransformer) {
        return super.boundingBox(mapTransformer.getTransform());
    }

    public void destroy() {
    }
}

