/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import com.cisco.ctc.util.map.AbstractView;
import com.cisco.ctc.util.map.MapGraph;
import com.cisco.ctc.util.map.MapTransformer;
import com.cisco.ctc.util.map.Node;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MapView
extends AbstractView {
    protected Point2D.Double hitPosition = new Point2D.Double(0.0, 0.0);

    void setHitPosition(Point2D.Double double_) {
        this.hitPosition = double_;
    }

    public Point2D.Double getHitPosition() {
        return this.hitPosition;
    }

    void setGraph(MapGraph mapGraph) {
        if (mapGraph == null || this.getGraph() == mapGraph) {
            return;
        }
        if (this.getGraph() != null) {
            this.getGraph().deSelectAll();
        }
        super.setGraph(mapGraph);
        this.setBackgroundColor(mapGraph.getBackgroundColor());
    }

    public void setBackgroundColor(Color color) {
        this.getMapGraph().setBackgroundColor(color);
        super.setBackground(color);
    }

    public void setMapTransformer(MapTransformer mapTransformer) {
        this.setTransformer(mapTransformer.getTransform());
    }

    public MapTransformer getMapTransformer() {
        MapTransformer mapTransformer = new MapTransformer(this.getTransformer());
        return mapTransformer;
    }

    public MapGraph getMapGraph() {
        return (MapGraph)super.getGraph();
    }

    public void centerView() {
        this.centerView(this.getMapGraph().getNodes());
    }

    public Rectangle2D getRect(Node[] nodeArray) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (nodeArray == null || nodeArray.length == 0) {
            return double_;
        }
        double d = MapView.getCanvasWidth();
        double d2 = MapView.getCanvasHeight();
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            if (node == null) continue;
            double d5 = node.getCenterX();
            double d6 = node.getCenterY();
            if (d5 < d) {
                d = d5;
            }
            if (d6 < d2) {
                d2 = d6;
            }
            if (d5 > d3) {
                d3 = d5;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        double_.setRect(d, d2, d3 - d, d4 - d2);
        return double_;
    }

    public void centerView(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        MapTransformer mapTransformer = this.getMapTransformer();
        double d = 1.0;
        double d2 = this.getViewRect().getWidth();
        double d3 = this.getViewRect().getHeight();
        Rectangle2D rectangle2D = this.getRect(nodeArray);
        double d4 = (rectangle2D.getWidth() - d2) / 2.0;
        double d5 = (rectangle2D.getHeight() - d3) / 2.0;
        MapTransformer mapTransformer2 = new MapTransformer(d, mapTransformer.getx12(), mapTransformer.getx21(), d, -(rectangle2D.getX() + d4), -(rectangle2D.getY() + d5));
        this.setMapTransformer(mapTransformer2);
        this.resetZoomCount();
        this.reDraw();
    }

    public boolean isNodesInView(Node[] nodeArray) {
        double d = this.getMapTransformer().getx11();
        double d2 = Math.abs(this.getMapTransformer().getx0() / d);
        double d3 = Math.abs(this.getMapTransformer().gety0() / d);
        double d4 = this.getViewRect().getWidth() / d;
        double d5 = this.getViewRect().getHeight() / d;
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            if (node == null) continue;
            double d6 = node.getCenterX();
            double d7 = node.getCenterY();
            if (!(d6 < d2 || d6 > d2 + d4 || d7 < d3) && !(d7 > d3 + d5)) continue;
            return false;
        }
        return true;
    }
}

