/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map.linkbundle;

import com.cisco.ctc.util.map.linkbundle.IlvLinkBundleFrame;
import com.cisco.ctc.util.map.linkbundle.IlvLinkBundleLayoutManager;
import com.cisco.ctc.util.map.linkbundle.LinkBundleSelectionChangedEvent;
import com.cisco.ctc.util.map.linkbundle.LinkBundleSelectionChangedListener;
import ilog.views.IlvApplyObject;
import ilog.views.IlvFilteredGraphicEnumeration;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicFilter;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvRegion;
import ilog.views.IlvSelection;
import ilog.views.IlvSelectionFactory;
import ilog.views.IlvTransformer;
import ilog.views.event.IlvListenerList;
import ilog.views.graphic.IlvPolylineLinkImage;
import ilog.views.internal.impl.IlvEmptyGraphicEnumeration;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.NoSuchElementException;

public class IlvLinkBundle
extends IlvPolylineLinkImage
implements IlvGraphicBag {
    private IlvGraphicVector _sublinks;
    private IlvGraphicVector _subbundles;
    private IlvLinkImage _overviewLink;
    private IlvLinkBundle _parentLinkBundle;
    private IlvLinkBundle _rootLinkBundle = this;
    private Object _treeLock = this;
    private boolean _layoutRunning = false;
    private boolean _duringSetLineWidth = false;
    private HashMap _names;
    private IlvLinkBundleFrame _frame;
    private IlvLinkBundleLayoutManager _layouter = new IlvLinkBundleLayoutManager();
    private boolean _collapsed = false;
    private boolean _layoutValid;
    private IlvPoint _lastFrom = new IlvPoint();
    private IlvPoint _lastTo = new IlvPoint();
    private transient int _selectionIsAdjusting;
    private transient int _selectionEventType;
    private transient IlvLinkImage _pendingSelectionEvent;
    private transient int _pendingSelectionEventType;
    private transient boolean _lastOfSerieOfEvents;
    private LinkBundleSelectionChangedEvent _selectionChangedEvent;
    private IlvListenerList _selectionListeners;
    private static final float DEFAULT_OFFSET = 5.0f;
    private float _offset = 5.0f;
    private static final boolean DEFAULT_SINGLE_CONNECTION_POINT = false;
    private boolean _singleConnectionPoint = false;
    private static final String SELECTED_PROPERTY_NAME = "__SelectedSublink";
    private static final String Msg_ObjectNotInBundleError = "The object is not in this link bundle";
    private static final String Msg_NullObjMessage = "Object cannot be null";
    private static final String Msg_AlreadyInABag = "Object is already in a bag";

    public IlvLinkBundle() {
        this(null, null, false);
    }

    public IlvLinkBundle(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        this(ilvGraphic, ilvGraphic2, bl, null, null);
    }

    public IlvLinkBundle(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, IlvPoint[] ilvPointArray) {
        this(ilvGraphic, ilvGraphic2, bl, ilvPointArray, null);
    }

    public IlvLinkBundle(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, IlvPoint[] ilvPointArray, IlvLinkImage ilvLinkImage) {
        super(ilvGraphic, ilvGraphic2, bl, ilvPointArray);
        this._offset = 5.0f;
        this._rootLinkBundle = this;
        this.setOverviewLink(ilvLinkImage);
    }

    public IlvLinkBundle(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this._rootLinkBundle = this;
        try {
            IlvGraphic[] ilvGraphicArray = ilvInputStream.readObjects("sublinks");
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                this.addSublink((IlvLinkImage)ilvGraphicArray[i]);
            }
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this._overviewLink = (IlvLinkImage)ilvInputStream.readObject("overviewLink");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this._overviewLink = null;
        }
        try {
            this._collapsed = ilvInputStream.readBoolean("collapsed");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this._collapsed = false;
        }
        try {
            this._offset = ilvInputStream.readFloat("offset");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this._offset = 5.0f;
        }
        try {
            this._frame = (IlvLinkBundleFrame)ilvInputStream.readPersistentObject("frame");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this._frame = null;
        }
        try {
            this._singleConnectionPoint = ilvInputStream.readBoolean("singleConnectionPoint");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this._singleConnectionPoint = false;
        }
    }

    public IlvLinkBundle(IlvLinkBundle ilvLinkBundle) {
        super((IlvPolylineLinkImage)ilvLinkBundle);
        this._rootLinkBundle = this;
        this._treeLock = this;
        this.setOffset(ilvLinkBundle.getOffset());
        IlvLinkImage ilvLinkImage = ilvLinkBundle.getOverviewLink();
        this.setOverviewLink(ilvLinkImage != null ? (IlvLinkImage)ilvLinkImage.copy() : null);
        this.setCollapsed(ilvLinkBundle.isCollapsed());
        IlvLinkBundleFrame ilvLinkBundleFrame = ilvLinkBundle.getFrame();
        this.setFrame(ilvLinkBundleFrame != null ? ilvLinkBundleFrame.copy() : null);
        IlvLinkImage[] ilvLinkImageArray = this.getSublinks();
        int n = ilvLinkImageArray != null ? ilvLinkImageArray.length : 0;
        for (int i = 0; i < n; ++i) {
            IlvGraphic ilvGraphic = ilvLinkImageArray[i].copy();
            if (ilvGraphic == null) continue;
            this.addSublink((IlvLinkImage)ilvGraphic);
        }
        this.resetRootLinkBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IlvGraphicEnumeration getLinkBundles() {
        Object object = this._treeLock;
        synchronized (object) {
            return this._subbundles != null ? this._subbundles.elements() : IlvEmptyGraphicEnumeration.instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getLinkBundlesCount() {
        Object object = this._treeLock;
        synchronized (object) {
            return this._subbundles == null ? 0 : this._subbundles.size();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        if (ilvGraphicBag == this.getGraphicBag()) {
            return;
        }
        if (ilvGraphicBag != null) {
            if (ilvGraphicBag == this) {
                throw new IllegalArgumentException("Cannot add a link bundle in itself.");
            }
            if (ilvGraphicBag instanceof IlvLinkBundle) {
                this.setParentLinkBundle((IlvLinkBundle)ilvGraphicBag);
            } else {
                if (!(ilvGraphicBag instanceof IlvGrapher)) throw new IllegalArgumentException("A link bundle can be added only in a grapher or another link bundle.");
                this.setTreeLock(((IlvGrapher)ilvGraphicBag).getTreeLock());
            }
        } else {
            this.cleanLinkConnectors();
            this.setParentLinkBundle(null);
        }
        super.setGraphicBag(ilvGraphicBag);
    }

    private void resetRootLinkBundle() {
        if (this._parentLinkBundle == null) {
            this._rootLinkBundle = this;
            this._treeLock = this;
        } else {
            this._rootLinkBundle = this._parentLinkBundle._rootLinkBundle;
            this._treeLock = this._parentLinkBundle._treeLock;
        }
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getLinkBundles();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvLinkBundle ilvLinkBundle = (IlvLinkBundle)ilvGraphicEnumeration.nextElement();
            ilvLinkBundle.resetRootLinkBundle();
        }
    }

    private void setParentLinkBundle(IlvLinkBundle ilvLinkBundle) {
        this._parentLinkBundle = ilvLinkBundle;
        this.resetRootLinkBundle();
    }

    private void setTreeLock(Object object) {
        this._treeLock = object;
    }

    public final Object getTreeLock() {
        return this._treeLock;
    }

    public final IlvLinkBundle getRootLinkBundle() {
        return this._rootLinkBundle;
    }

    public final IlvManager getRootManager() {
        IlvLinkBundle ilvLinkBundle = this.getRootLinkBundle();
        return ilvLinkBundle != null && ilvLinkBundle.getGraphicBag() instanceof IlvManager ? (IlvManager)ilvLinkBundle.getGraphicBag() : null;
    }

    public final void setOverviewLink(IlvLinkImage ilvLinkImage) {
        if (ilvLinkImage != this._overviewLink) {
            this.cleanLinkConnectors(this._overviewLink);
            this._overviewLink = ilvLinkImage;
            if (ilvLinkImage != null) {
                ilvLinkImage.setFrom(this.getFrom());
                ilvLinkImage.setTo(this.getTo());
                ilvLinkImage.setOriented(this.isOriented());
                ilvLinkImage.setGraphicBag((IlvGraphicBag)this);
            }
            this.invalidateLayout();
        }
    }

    public final IlvLinkImage getOverviewLink() {
        return this._overviewLink;
    }

    public void addObject(IlvGraphic ilvGraphic, boolean bl) {
        if (!(ilvGraphic instanceof IlvLinkImage)) {
            throw new IllegalArgumentException("obj " + ilvGraphic + " must be a link (class IlvLinkImage or subclass)");
        }
        this.addSublink((IlvLinkImage)ilvGraphic);
    }

    public void removeObject(IlvGraphic ilvGraphic, boolean bl) {
        if (!(ilvGraphic instanceof IlvLinkImage)) {
            throw new IllegalArgumentException("obj " + ilvGraphic + " must be a link (class IlvLinkImage or subclass)");
        }
        this.removeSublink((IlvLinkImage)ilvGraphic);
    }

    public void addSublink(IlvLinkImage ilvLinkImage) {
        this.addSublink(this.getSublinksCount(), ilvLinkImage);
    }

    public void addSublink(int n, IlvLinkImage ilvLinkImage) {
        this.setOrAddSublink(n, ilvLinkImage, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOrAddSublink(int n, IlvLinkImage ilvLinkImage, boolean bl) {
        if (ilvLinkImage == null) {
            throw new IllegalArgumentException("sublink cannot be null");
        }
        if (ilvLinkImage.getGraphicBag() != null) {
            throw new IllegalArgumentException("Link " + ilvLinkImage + " " + Msg_AlreadyInABag + ": " + ilvLinkImage.getGraphicBag());
        }
        if (ilvLinkImage == this || ilvLinkImage instanceof IlvGraphicBag && this.getTopLevelGraphicBag() == ilvLinkImage) {
            throw new IllegalArgumentException("Link " + ilvLinkImage + "is already a branch of this link bundle");
        }
        if (!(ilvLinkImage.getFrom() == this.getFrom() && ilvLinkImage.getTo() == this.getTo() || ilvLinkImage.getFrom() == this.getTo() && ilvLinkImage.getTo() == this.getFrom())) {
            throw new IllegalArgumentException("sublink " + ilvLinkImage + " must have the same origin " + "and destination nodes as the link bundle " + (Object)((Object)this) + " (in any order).");
        }
        boolean bl2 = this.SublinkRangeCheck(n, true);
        Object object = this._treeLock;
        synchronized (object) {
            Object object2;
            ilvLinkImage.setGraphicBag((IlvGraphicBag)this);
            boolean bl3 = true;
            if (bl2) {
                if (this._sublinks == null) {
                    this.initLinkContainer();
                }
                this._sublinks.addElement((IlvGraphic)ilvLinkImage);
            } else if (bl) {
                if (this._sublinks == null) {
                    this.initLinkContainer();
                }
                this._sublinks.insertElementAt((IlvGraphic)ilvLinkImage, n);
            } else {
                object2 = this.getSublink(n);
                if (object2 != ilvLinkImage) {
                    this.removeSublinkImpl((IlvLinkImage)object2, false);
                    if (this._sublinks == null) {
                        this.initLinkContainer();
                    }
                    this._sublinks.setElementAt((IlvGraphic)ilvLinkImage, n);
                } else {
                    bl3 = false;
                }
            }
            if (bl3) {
                if (ilvLinkImage instanceof IlvLinkBundle) {
                    if (this._subbundles == null) {
                        this._subbundles = new IlvGraphicVector(10);
                    }
                    this._subbundles.addElement((IlvGraphic)ilvLinkImage);
                }
                this.invalidateLayout();
                object2 = ilvLinkImage.getName();
                if (object2 != null) {
                    this.setObjectName((IlvGraphic)ilvLinkImage, (String)object2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOrAddSublinkNOT_USED(int n, IlvLinkImage ilvLinkImage, boolean bl) {
        Object object = this._treeLock;
        synchronized (object) {
            if (ilvLinkImage == null) {
                throw new IllegalArgumentException("sublink cannot be null");
            }
            if (ilvLinkImage.getGraphicBag() != null) {
                throw new IllegalArgumentException("Link " + ilvLinkImage + " " + Msg_AlreadyInABag + ": " + ilvLinkImage.getGraphicBag());
            }
            if (ilvLinkImage == this || ilvLinkImage instanceof IlvGraphicBag && this.getTopLevelGraphicBag() == ilvLinkImage) {
                throw new IllegalArgumentException("Link " + ilvLinkImage + "is already a branch of this link bundle");
            }
            ilvLinkImage.setFrom(this.getFrom());
            ilvLinkImage.setTo(this.getTo());
            ilvLinkImage.setOriented(this.isOriented());
            boolean bl2 = false;
            if (this._sublinks == null) {
                this.initLinkContainer();
            }
            this._sublinks.ensureCapacity(n + 1);
            if (n >= this._sublinks.size()) {
                for (int i = this._sublinks.size(); i <= n; ++i) {
                    this._sublinks.addElement(null);
                }
            }
            Object object2 = this._treeLock;
            synchronized (object2) {
                Object object3;
                ilvLinkImage.setGraphicBag((IlvGraphicBag)this);
                boolean bl3 = true;
                if (bl2) {
                    if (this._sublinks == null) {
                        this.initLinkContainer();
                    }
                    this._sublinks.addElement((IlvGraphic)ilvLinkImage);
                } else if (bl) {
                    if (this._sublinks == null) {
                        this.initLinkContainer();
                    }
                    this._sublinks.setElementAt((IlvGraphic)ilvLinkImage, n);
                } else {
                    object3 = this.getSublink(n);
                    if (object3 != null && object3 != ilvLinkImage) {
                        this.removeSublinkImpl((IlvLinkImage)object3, true);
                    }
                    if (this._sublinks == null) {
                        this.initLinkContainer();
                    }
                    this._sublinks.setElementAt((IlvGraphic)ilvLinkImage, n);
                }
                if (bl3) {
                    if (ilvLinkImage instanceof IlvLinkBundle) {
                        if (this._subbundles == null) {
                            this._subbundles = new IlvGraphicVector(10);
                        }
                        this._subbundles.addElement((IlvGraphic)ilvLinkImage);
                    }
                    this.invalidateLayout();
                    object3 = ilvLinkImage.getName();
                    if (object3 != null) {
                        this.setObjectName((IlvGraphic)ilvLinkImage, (String)object3);
                    }
                }
                if (ilvLinkImage.getFrom() == null || ilvLinkImage.getTo() == null) {
                    throw new RuntimeException("Origin and destination cannot be null. Origin: " + ilvLinkImage.getFrom() + " Destination: " + ilvLinkImage.getTo());
                }
                if (ilvLinkImage.getGraphicBag() != this) {
                    throw new RuntimeException("No bag on " + ilvLinkImage);
                }
            }
        }
    }

    public void removeSublink(IlvLinkImage ilvLinkImage) {
        this.removeSublinkImpl(ilvLinkImage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSublinkImpl(IlvLinkImage ilvLinkImage, boolean bl) {
        if (ilvLinkImage == null) {
            throw new IllegalArgumentException(Msg_NullObjMessage);
        }
        if (ilvLinkImage.getGraphicBag() != this) {
            throw new IllegalArgumentException("link " + ilvLinkImage + " not in this link bundle");
        }
        Object object = this._treeLock;
        synchronized (object) {
            String string;
            IlvSelection ilvSelection = this.getSelection(ilvLinkImage);
            if (ilvSelection != null) {
                this.setSelected(ilvLinkImage, false);
            }
            this.cleanLinkConnectors(ilvLinkImage);
            ilvLinkImage.setGraphicBag(null);
            if (this._names != null && (string = this.getObjectName((IlvGraphic)ilvLinkImage)) != null) {
                this._names.remove(string);
            }
            if (!bl) {
                if (this._sublinks != null) {
                    this._sublinks.removeElement((IlvGraphic)ilvLinkImage);
                }
                if (this._subbundles != null && ilvLinkImage instanceof IlvLinkBundle) {
                    this._subbundles.removeElement((IlvGraphic)ilvLinkImage);
                }
            }
            this.invalidateLayout();
        }
    }

    private void initLinkContainer() {
        if (this._sublinks == null) {
            this._sublinks = new IlvGraphicVector();
        } else {
            this._sublinks.removeAllElements();
        }
        this.invalidateLayout();
    }

    public IlvLinkImage getSublink(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.getSublink(ilvPoint, ilvTransformer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvLinkImage getSublink(IlvPoint ilvPoint, IlvTransformer ilvTransformer, boolean bl) {
        Object object = this._treeLock;
        synchronized (object) {
            IlvPoint ilvPoint2 = new IlvPoint(ilvPoint.x, ilvPoint.y);
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint2);
            }
            return this.getSublink(ilvPoint2, ilvPoint, ilvTransformer, bl);
        }
    }

    private IlvLinkImage getSublink(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, boolean bl) {
        IlvLinkImage ilvLinkImage;
        IlvLinkBundle ilvLinkBundle;
        IlvLinkImage ilvLinkImage2 = this.getSublink(ilvPoint, ilvPoint2, ilvTransformer);
        if (bl && ilvLinkImage2 instanceof IlvLinkBundle && !(ilvLinkBundle = (IlvLinkBundle)ilvLinkImage2).isCollapsed() && (ilvLinkImage = ilvLinkBundle.getSublink(ilvPoint2, ilvTransformer, true)) != null) {
            ilvLinkImage2 = ilvLinkImage;
        }
        return ilvLinkImage2;
    }

    private IlvLinkImage getSublink(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getSublinksEnum();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
            return (IlvLinkImage)ilvGraphic;
        }
        return null;
    }

    public IlvSelection getSelection(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        return this.getSelection(ilvPoint, ilvTransformer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvSelection getSelection(IlvPoint ilvPoint, IlvTransformer ilvTransformer, boolean bl) {
        Object object = this._treeLock;
        synchronized (object) {
            IlvPoint ilvPoint2 = new IlvPoint(ilvPoint.x, ilvPoint.y);
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint2);
            }
            return this.getSelection(ilvPoint2, ilvPoint, ilvTransformer, bl);
        }
    }

    private IlvSelection getSelection(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, boolean bl) {
        IlvSelection ilvSelection;
        IlvLinkBundle ilvLinkBundle;
        IlvLinkImage ilvLinkImage;
        if (this.getSelectedSublinksCount(bl) == 0) {
            return null;
        }
        IlvSelection ilvSelection2 = this.getSublinkSelection(ilvPoint, ilvPoint2, ilvTransformer);
        if (ilvSelection2 != null && !this.isRootManagerVisible()) {
            ilvSelection2 = null;
        }
        if (ilvSelection2 == null && bl && this.getLinkBundlesCount() != 0 && (ilvLinkImage = this.getSublink(ilvPoint, ilvPoint2, ilvTransformer, false)) instanceof IlvLinkBundle && !(ilvLinkBundle = (IlvLinkBundle)ilvLinkImage).isCollapsed() && (ilvSelection = ilvLinkBundle.getSelection(ilvPoint, ilvPoint2, ilvTransformer, true)) != null) {
            ilvSelection2 = ilvSelection;
        }
        return ilvSelection2;
    }

    private boolean isRootManagerVisible() {
        IlvGraphicBag ilvGraphicBag;
        if (this._rootLinkBundle != null && (ilvGraphicBag = this._rootLinkBundle.getGraphicBag()) instanceof IlvManager) {
            IlvManager ilvManager = (IlvManager)ilvGraphicBag;
            return ilvManager.isVisible() && ilvManager.isVisible(ilvManager.getLayer((IlvGraphic)this));
        }
        return true;
    }

    private IlvSelection getSublinkSelection(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getSelectedSublinks();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvSelection ilvSelection;
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!ilvGraphic.isVisible() || (ilvSelection = this.getSelection((IlvLinkImage)ilvGraphic)) == null || !ilvSelection.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
            return ilvSelection;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvGraphic getObject(String string) {
        Object object = this._treeLock;
        synchronized (object) {
            if (this._names == null) {
                return null;
            }
            return (IlvGraphic)this._names.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setObjectName(IlvGraphic ilvGraphic, String string) {
        Object object = this._treeLock;
        synchronized (object) {
            if (ilvGraphic.getGraphicBag() != this) {
                throw new IllegalArgumentException(Msg_ObjectNotInBundleError);
            }
            String string2 = ilvGraphic.getName();
            if (string != null) {
                IlvGraphic ilvGraphic2;
                IlvGraphic ilvGraphic3 = ilvGraphic2 = this._names == null ? null : (IlvGraphic)this._names.get(string);
                if (ilvGraphic2 != null) {
                    if (ilvGraphic2 == ilvGraphic) {
                        if (string.equals(string2)) {
                            return true;
                        }
                        ilvGraphic.setNameImpl(string);
                        return true;
                    }
                    if (string2 != null) {
                        if (string.equals(string2)) {
                            ilvGraphic.setNameImpl(null);
                            return false;
                        }
                        IlvGraphic ilvGraphic4 = ilvGraphic2 = this._names == null ? null : (IlvGraphic)this._names.get(string2);
                        if (ilvGraphic2 != null) {
                            if (ilvGraphic2 == ilvGraphic) {
                                return false;
                            }
                            ilvGraphic.setNameImpl(null);
                        }
                    }
                    return false;
                }
                if (string2 != null && this._names != null && (ilvGraphic2 = (IlvGraphic)this._names.get(string2)) == ilvGraphic) {
                    this._names.remove(string2);
                    if (this._names.size() == 0) {
                        this._names = null;
                    }
                }
                ilvGraphic.setNameImpl(string);
                if (this._names == null) {
                    this._names = new HashMap(100);
                }
                this._names.put(string, ilvGraphic);
            } else {
                if (string2 != null && this._names != null && this._names.get(string2) == ilvGraphic) {
                    if (this._names.size() == 0) {
                        this._names = null;
                    }
                    this._names.remove(string2);
                }
                ilvGraphic.setNameImpl(null);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectName(IlvGraphic ilvGraphic) {
        Object object = this._treeLock;
        synchronized (object) {
            return ilvGraphic.getName();
        }
    }

    public void setToolTipText(String string) {
        IlvLinkImage ilvLinkImage = this.getOverviewLink();
        if (ilvLinkImage != null) {
            ilvLinkImage.setToolTipText(string);
        } else {
            super.setToolTipText(string);
        }
    }

    public String getToolTipText() {
        IlvLinkImage ilvLinkImage = this.getOverviewLink();
        return ilvLinkImage != null ? ilvLinkImage.getToolTipText() : super.getToolTipText();
    }

    public String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        String string = this.getToolTipText(this._sublinks, ilvPoint, ilvTransformer);
        return string != null ? string : super.getToolTipText(ilvPoint, ilvTransformer);
    }

    private String getToolTipText(IlvGraphicVector ilvGraphicVector, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        String string = null;
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        ilvTransformer.inverse(ilvPoint2);
        int n = ilvGraphicVector.size();
        for (int i = 0; i < n; ++i) {
            IlvGraphic ilvGraphic = ilvGraphicVector.elementAt(i);
            if (!ilvGraphic.contains(ilvPoint2, ilvPoint, ilvTransformer) || (string = ilvGraphic.getToolTipText(ilvPoint, ilvTransformer)) == null) continue;
            return string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(IlvLinkImage ilvLinkImage, boolean bl) {
        Object object = this._treeLock;
        synchronized (object) {
            if (ilvLinkImage == null) {
                throw new IllegalArgumentException(Msg_NullObjMessage);
            }
            if (ilvLinkImage.getGraphicBag() != this) {
                throw new IllegalArgumentException("Object " + ilvLinkImage + ": " + Msg_ObjectNotInBundleError);
            }
            IlvSelection ilvSelection = this.getSelection(ilvLinkImage);
            if (bl && ilvSelection != null || !bl && ilvSelection == null) {
                return;
            }
            if (bl) {
                IlvSelectionFactory ilvSelectionFactory = this.getSelectionFactory();
                if (ilvSelectionFactory != null) {
                    ilvSelection = ilvSelectionFactory.makeSelection((IlvGraphic)ilvLinkImage);
                }
                if (ilvSelection == null) {
                    ilvSelection = ilvLinkImage.makeSelection();
                }
                this.setSelection((IlvGraphic)ilvLinkImage, ilvSelection);
            } else {
                this.setSelection((IlvGraphic)ilvLinkImage, null);
            }
        }
        this.fireSelectionChanged(ilvLinkImage, bl ? 1 : 2);
    }

    private void fireSelectionChanged(IlvLinkImage ilvLinkImage, int n) {
        this.fireSelectionChanged(ilvLinkImage, true, n);
    }

    private void fireSelectionChanged(IlvLinkImage ilvLinkImage, boolean bl, int n) {
        if (bl) {
            if (this._pendingSelectionEvent != null) {
                this.selectionChanged(this._pendingSelectionEvent, this._pendingSelectionEventType);
            }
            if (this._selectionIsAdjusting > 0) {
                this._pendingSelectionEvent = ilvLinkImage;
                this._pendingSelectionEventType = n;
            } else {
                this._pendingSelectionEvent = null;
                this.selectionChanged(ilvLinkImage, n);
            }
        }
        if (this._parentLinkBundle != null) {
            this._parentLinkBundle.fireSelectionChanged(ilvLinkImage, false, n);
        }
    }

    protected void selectionChanged(IlvLinkImage ilvLinkImage) {
        int n = this._selectionEventType;
        if (this._selectionListeners != null && ilvLinkImage.getGraphicBag() == this) {
            Object[] objectArray = this._selectionListeners.getListenerList();
            if (this._selectionChangedEvent == null) {
                this._selectionChangedEvent = new LinkBundleSelectionChangedEvent(this, null);
                this.setSelectionEventSource(null);
            }
            for (int i = objectArray.length - 1; i >= 0; --i) {
                this._selectionChangedEvent.setSublink(ilvLinkImage);
                this._selectionChangedEvent.setAdjusting(this._lastOfSerieOfEvents || this.isSelectionAdjusting());
                this._selectionChangedEvent.setAdjustmentEnd(this._lastOfSerieOfEvents);
                this._selectionChangedEvent.setType(n);
                ((LinkBundleSelectionChangedListener)objectArray[i]).selectionChanged(this._selectionChangedEvent);
                this._selectionChangedEvent.setSublink(null);
            }
        }
    }

    private void selectionChanged(IlvLinkImage ilvLinkImage, int n) {
        this._selectionEventType = n;
        this.selectionChanged(ilvLinkImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll() {
        Object object = this._treeLock;
        synchronized (object) {
            this.setSelectionAdjusting(true);
            try {
                int n = this._sublinks == null ? 0 : this._sublinks.size();
                for (int i = 0; i < n; ++i) {
                    IlvLinkImage ilvLinkImage = (IlvLinkImage)this._sublinks.elementAt(i);
                    if (!ilvLinkImage.isVisible()) continue;
                    this.setSelected(ilvLinkImage, true);
                }
            }
            finally {
                this.setSelectionAdjusting(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll(boolean bl) {
        Object object = this._treeLock;
        synchronized (object) {
            this.setSelectionAdjusting(true);
            try {
                if (bl && this.getLinkBundlesCount() != 0) {
                    IlvGraphicEnumeration ilvGraphicEnumeration = this.getLinkBundles();
                    while (ilvGraphicEnumeration.hasMoreElements()) {
                        IlvLinkBundle ilvLinkBundle = (IlvLinkBundle)ilvGraphicEnumeration.nextElement();
                        if (ilvLinkBundle.isCollapsed()) continue;
                        ilvLinkBundle.selectAll(true);
                    }
                }
                this.selectAll();
            }
            finally {
                this.setSelectionAdjusting(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deSelectAll() {
        Object object = this._treeLock;
        synchronized (object) {
            if (this.getSelectedSublinksCount() == 0) {
                return;
            }
            this.setSelectionEventSource((Object)this);
            try {
                int n = this._sublinks == null ? 0 : this._sublinks.size();
                for (int i = 0; i < n; ++i) {
                    IlvLinkImage ilvLinkImage = (IlvLinkImage)this._sublinks.elementAt(i);
                    this.setSelected(ilvLinkImage, false);
                }
            }
            finally {
                this.setSelectionEventSource(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deSelectAll(boolean bl) {
        Object object = this._treeLock;
        synchronized (object) {
            if (!bl) {
                this.deSelectAll();
                return;
            }
            if (this.getSelectedSublinksCount(true) == 0) {
                return;
            }
            this.setSelectionEventSource((Object)this);
            this.setSelectionAdjusting(true);
            try {
                IlvGraphicEnumeration ilvGraphicEnumeration = this.getLinkBundles();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    IlvLinkBundle ilvLinkBundle = (IlvLinkBundle)ilvGraphicEnumeration.nextElement();
                    ilvLinkBundle.deSelectAll(true);
                }
                this.deSelectAll();
            }
            finally {
                this.setSelectionAdjusting(false);
                this.setSelectionEventSource(null);
            }
        }
    }

    public IlvSelectionFactory getSelectionFactory() {
        IlvManager ilvManager = this.getRootManager();
        return ilvManager != null ? ilvManager.getSelectionFactory() : null;
    }

    public void setSelectionEventSource(Object object) {
        if (this._selectionChangedEvent == null) {
            this._selectionChangedEvent = new LinkBundleSelectionChangedEvent(this, null);
        }
        if (object != null || !this.isSelectionAdjusting()) {
            this._selectionChangedEvent.setSource(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionAdjusting(boolean bl) {
        if (bl) {
            ++this._selectionIsAdjusting;
        } else {
            if (this._selectionIsAdjusting == 0) {
                System.err.println("bad selection adjustment");
            } else {
                --this._selectionIsAdjusting;
            }
            if (this._selectionIsAdjusting == 0) {
                if (this._pendingSelectionEvent != null) {
                    this._lastOfSerieOfEvents = true;
                    try {
                        this.selectionChanged(this._pendingSelectionEvent, this._pendingSelectionEventType);
                    }
                    finally {
                        this._lastOfSerieOfEvents = false;
                        this._pendingSelectionEvent = null;
                    }
                }
                this.setSelectionEventSource(null);
            }
        }
    }

    public boolean isSelectionAdjusting() {
        return this._selectionIsAdjusting > 0;
    }

    public void addLinkBundleSelectionChangedListener(LinkBundleSelectionChangedListener linkBundleSelectionChangedListener) {
        if (this._selectionListeners == null) {
            this._selectionListeners = new IlvListenerList();
        }
        this._selectionListeners.add((EventListener)linkBundleSelectionChangedListener);
    }

    public void removeLinkBundleSelectionChangedListener(LinkBundleSelectionChangedListener linkBundleSelectionChangedListener) {
        if (this._selectionListeners != null) {
            this._selectionListeners.remove((EventListener)linkBundleSelectionChangedListener);
            if (this._selectionListeners.getListenerCount() == 0) {
                this._selectionListeners = null;
            }
        }
    }

    public final IlvGraphicEnumeration getSelectedSublinks() {
        return this.getSelectedSublinks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IlvGraphicEnumeration getSelectedSublinks(boolean bl) {
        Object object = this._treeLock;
        synchronized (object) {
            return new IlvSelectedSublinksEnumerator(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSelectedSublinksCount() {
        Object object = this._treeLock;
        synchronized (object) {
            return this.getSelectedSublinksCount(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSelectedSublinksCount(boolean bl) {
        Object object = this._treeLock;
        synchronized (object) {
            int n;
            int n2 = n = this._sublinks == null ? 0 : this._sublinks.size();
            if (n == 0) {
                return 0;
            }
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                IlvLinkImage ilvLinkImage = (IlvLinkImage)this._sublinks.elementAt(i);
                if (this.isSelected(ilvLinkImage)) {
                    ++n3;
                }
                if (!bl || !(ilvLinkImage instanceof IlvLinkBundle)) continue;
                n3 += ((IlvLinkBundle)ilvLinkImage).getSelectedSublinksCount(bl);
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(IlvLinkImage ilvLinkImage) {
        Object object = this._treeLock;
        synchronized (object) {
            return this.getSelection(ilvLinkImage) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IlvSelection getSelection(IlvLinkImage ilvLinkImage) {
        Object object = this._treeLock;
        synchronized (object) {
            return (IlvSelection)ilvLinkImage.getProperty(SELECTED_PROPERTY_NAME);
        }
    }

    private void setSelection(IlvGraphic ilvGraphic, IlvSelection ilvSelection) {
        ilvGraphic.setProperty(SELECTED_PROPERTY_NAME, (Object)ilvSelection);
    }

    final IlvLinkBundleLayoutManager getLayoutManager() {
        if (this._layouter == null) {
            this._layouter = new IlvLinkBundleLayoutManager();
        }
        return this._layouter;
    }

    public void setOffset(float f) {
        if (f != this._offset) {
            this.invalidateLayout();
        }
        this._offset = f;
    }

    public float getOffset() {
        return this._offset;
    }

    public void setSingleConnectionPoint(boolean bl) {
        if (bl != this._singleConnectionPoint) {
            this.invalidateLayout();
        }
        this._singleConnectionPoint = bl;
    }

    public boolean isSingleConnectionPoint() {
        return this._singleConnectionPoint;
    }

    public void setCollapsed(boolean bl) {
        this._collapsed = bl;
        this.invalidateLayout();
    }

    public boolean isCollapsed() {
        return this._collapsed;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        this.doLayoutIfNecessary();
        if (this.isCollapsed()) {
            IlvLinkImage ilvLinkImage = this.getOverviewLink();
            if (ilvLinkImage != null) {
                ilvLinkImage.draw(graphics, ilvTransformer);
            } else {
                super.draw(graphics, ilvTransformer);
            }
        } else {
            this.drawFrame(graphics, ilvTransformer);
            this.drawSublinks(graphics, ilvTransformer);
            this.drawSublinkSelections(graphics, ilvTransformer);
        }
    }

    private void drawSublinks(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this._sublinks != null) {
            int n = this._sublinks.size();
            for (int i = 0; i < n; ++i) {
                this._sublinks.elementAt(i).draw(graphics, ilvTransformer);
            }
        }
    }

    private void drawFrame(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvLinkBundleFrame ilvLinkBundleFrame = this.getFrame();
        if (ilvLinkBundleFrame != null) {
            ilvLinkBundleFrame.draw(this, graphics, ilvTransformer);
        }
    }

    private void drawSublinkSelections(Graphics graphics, IlvTransformer ilvTransformer) {
        if (!this.isCollapsed()) {
            IlvGraphicEnumeration ilvGraphicEnumeration = this.getSelectedSublinks();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                IlvSelection ilvSelection = this.getSelection(ilvLinkImage);
                if (ilvSelection == null) continue;
                ilvSelection.draw(graphics, ilvTransformer);
            }
        }
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        this.doLayoutIfNecessary();
        if (this.isCollapsed()) {
            return this.getOverviewLink() == null ? super.boundingBox(ilvTransformer) : this.getOverviewLink().boundingBox(ilvTransformer);
        }
        IlvRect ilvRect = null;
        if (this._sublinks != null && !this.isCollapsed() && this._sublinks.size() > 0) {
            this.validateLayout();
            ilvRect = this.boundingBox(this._sublinks, ilvTransformer);
        } else {
            ilvRect = super.boundingBox(ilvTransformer);
        }
        IlvLinkBundleFrame ilvLinkBundleFrame = this.getFrame();
        if (ilvLinkBundleFrame != null) {
            ilvRect.add(ilvLinkBundleFrame.boundingBox(this, ilvTransformer));
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        return ilvRect;
    }

    private IlvRect boundingBox(IlvGraphicVector ilvGraphicVector, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = ilvGraphicVector.elementAt(0).boundingBox(ilvTransformer);
        int n = ilvGraphicVector.size();
        for (int i = 1; i < n; ++i) {
            IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphicVector.elementAt(i);
            ilvRect.add(ilvLinkImage.boundingBox(ilvTransformer));
            IlvSelection ilvSelection = this.getSelection(ilvLinkImage);
            if (ilvSelection == null) continue;
            ilvRect.add(ilvSelection.boundingBox(ilvTransformer));
        }
        return ilvRect;
    }

    public final boolean isLayoutValid() {
        IlvPoint ilvPoint = new IlvPoint();
        IlvPoint ilvPoint2 = new IlvPoint();
        this.getConnectionPoints(ilvPoint, ilvPoint2, null);
        return this._layoutValid && this._lastFrom.equals((Object)ilvPoint) && this._lastTo.equals((Object)ilvPoint2);
    }

    public final void invalidateLayout() {
        this._layoutValid = false;
    }

    private void validateLayout() {
        this._layoutValid = true;
        this.getConnectionPoints(this._lastFrom, this._lastTo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLayoutIfNecessary() {
        if (!this.isLayoutValid() && !this.isLayoutRunning()) {
            this.setLayoutRunning(true);
            try {
                this.doLayout(this._sublinks);
                this.validateLayout();
            }
            finally {
                this.setLayoutRunning(false);
            }
        }
    }

    private void doLayout(IlvGraphicVector ilvGraphicVector) {
        int n;
        int n2 = n = ilvGraphicVector != null ? ilvGraphicVector.size() : 0;
        if (n == 0) {
            return;
        }
        IlvLinkBundleLayoutManager ilvLinkBundleLayoutManager = this.getLayoutManager();
        if (ilvLinkBundleLayoutManager != null) {
            ilvLinkBundleLayoutManager.layout(this, null);
        }
    }

    private void setLayoutRunning(boolean bl) {
        this._layoutRunning = bl;
    }

    private boolean isLayoutRunning() {
        return this._layoutRunning;
    }

    public IlvLinkBundleFrame getFrame() {
        return this._frame;
    }

    public void setFrame(IlvLinkBundleFrame ilvLinkBundleFrame) {
        if (ilvLinkBundleFrame != this._frame) {
            this.invalidateLayout();
        }
        this._frame = ilvLinkBundleFrame;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.isCollapsed()) {
            IlvLinkImage ilvLinkImage = this.getOverviewLink();
            return ilvLinkImage != null ? ilvLinkImage.contains(ilvPoint, ilvPoint2, ilvTransformer) : super.contains(ilvPoint, ilvPoint2, ilvTransformer);
        }
        return this.getSelection(ilvPoint, ilvPoint2, ilvTransformer, true) != null || this.getSublink(ilvPoint, ilvPoint2, ilvTransformer, true) != null || this.containsFrame(ilvPoint, ilvPoint2, ilvTransformer);
    }

    public boolean containsFrame(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.isCollapsed()) {
            return this.contains(ilvPoint, ilvPoint2, ilvTransformer);
        }
        IlvLinkBundleFrame ilvLinkBundleFrame = this.getFrame();
        return ilvLinkBundleFrame != null ? ilvLinkBundleFrame.contains(this, ilvPoint, ilvPoint2, ilvTransformer) : false;
    }

    public void setSublinks(IlvLinkImage[] ilvLinkImageArray) {
        int n;
        if (this._sublinks != null) {
            n = this._sublinks.size();
            for (int i = 0; i < n; ++i) {
                IlvLinkImage ilvLinkImage = (IlvLinkImage)this._sublinks.elementAt(i);
                this.setSelected(ilvLinkImage, false);
            }
            this.cleanLinkConnectors(this._sublinks);
        }
        if (ilvLinkImageArray == null || ilvLinkImageArray.length == 0) {
            this._sublinks = null;
        } else {
            n = ilvLinkImageArray.length;
            for (int i = 0; i < n; ++i) {
                IlvLinkImage ilvLinkImage = ilvLinkImageArray[i];
                if (ilvLinkImage == null) {
                    throw new IllegalArgumentException("sublinks[" + i + "] must not be null");
                }
                this.addSublink(ilvLinkImage);
            }
        }
        this.invalidateLayout();
    }

    public final IlvGraphicEnumeration getObjects() {
        return this.getSublinksEnum();
    }

    public final IlvLinkImage[] getSublinks() {
        if (this._sublinks == null) {
            return null;
        }
        int n = this._sublinks.size();
        IlvLinkImage[] ilvLinkImageArray = new IlvLinkImage[n];
        this._sublinks.copyInto((IlvGraphic[])ilvLinkImageArray);
        return ilvLinkImageArray;
    }

    public final IlvGraphicEnumeration getSublinksEnum() {
        return this._sublinks == null || this._sublinks.size() == 0 ? IlvEmptyGraphicEnumeration.instance : this._sublinks.elements();
    }

    public final int getSublinksCount() {
        return this._sublinks != null ? this._sublinks.size() : 0;
    }

    public void setSublink(int n, IlvLinkImage ilvLinkImage) {
        this.setOrAddSublink(n, ilvLinkImage, false);
    }

    public IlvLinkImage getSublink(int n) {
        this.SublinkRangeCheck(n, false);
        return this._sublinks == null ? null : (IlvLinkImage)this._sublinks.elementAt(n);
    }

    private boolean SublinkRangeCheck(int n, boolean bl) {
        int n2 = this.getSublinksCount() - (bl ? 0 : 1);
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Min. allowed index: 0, Max. allowed index: " + n2);
        }
        return bl && n == n2;
    }

    public int getPointsCardinal() {
        return this._overviewLink == null ? super.getPointsCardinal() : this._overviewLink.getPointsCardinal();
    }

    public boolean allowsPointInsertion() {
        return this._overviewLink == null ? super.allowsPointInsertion() : this._overviewLink.allowsPointInsertion();
    }

    public boolean allowsPointRemoval() {
        return this._overviewLink == null ? super.allowsPointRemoval() : this._overviewLink.allowsPointRemoval();
    }

    public boolean allowsPointMove(int n) {
        return this._overviewLink == null ? super.allowsPointMove(n) : this._overviewLink.allowsPointMove(n);
    }

    public void insertPoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (this._overviewLink == null) {
            super.insertPoint(n, f, f2, ilvTransformer);
        } else {
            this._overviewLink.insertPoint(n, f, f2, ilvTransformer);
        }
        this.invalidateLayout();
    }

    public void removePoint(int n, IlvTransformer ilvTransformer) {
        if (this._overviewLink == null) {
            super.removePoint(n, ilvTransformer);
        } else {
            this._overviewLink.removePoint(n, ilvTransformer);
        }
    }

    public IlvPoint getPointAt(int n, IlvTransformer ilvTransformer) {
        return this._overviewLink == null ? super.getPointAt(n, ilvTransformer) : this._overviewLink.getPointAt(n, ilvTransformer);
    }

    public void movePoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (this._overviewLink == null) {
            super.movePoint(n, f, f2, ilvTransformer);
        } else {
            this._overviewLink.movePoint(n, f, f2, ilvTransformer);
        }
        this.invalidateLayout();
    }

    public void setIntermediateLinkPoints(IlvPoint[] ilvPointArray, int n, int n2) {
        if (this._overviewLink == null) {
            super.setIntermediateLinkPoints(ilvPointArray, n, n2);
        } else {
            this._overviewLink.setIntermediateLinkPoints(ilvPointArray, n, n2);
        }
        this.invalidateLayout();
    }

    public boolean pointsInBBox() {
        return this._overviewLink == null ? super.pointsInBBox() : this._overviewLink.pointsInBBox();
    }

    public IlvPoint getConnectionReferencePoint(boolean bl, IlvTransformer ilvTransformer) {
        return this._overviewLink == null ? super.getConnectionReferencePoint(bl, ilvTransformer) : this._overviewLink.getConnectionReferencePoint(bl, ilvTransformer);
    }

    public void getConnectionPoints(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this._overviewLink == null) {
            super.getConnectionPoints(ilvPoint, ilvPoint2, ilvTransformer);
        } else {
            this._overviewLink.getConnectionPoints(ilvPoint, ilvPoint2, ilvTransformer);
        }
    }

    public boolean isOriented() {
        return this._overviewLink == null ? super.isOriented() : this._overviewLink.isOriented();
    }

    public void setOriented(boolean bl) {
        if (this._overviewLink == null) {
            super.setOriented(bl);
        } else {
            this._overviewLink.setOriented(bl);
        }
    }

    public void setForeground(Color color) {
        if (this._overviewLink == null) {
            super.setForeground(color);
        } else {
            this._overviewLink.setForeground(color);
        }
    }

    public Color getForeground() {
        return this._overviewLink == null ? super.getForeground() : this._overviewLink.getForeground();
    }

    public float getLineWidth() {
        return this._duringSetLineWidth ? super.getLineWidth() : this.getLineWidthImpl(null, false, true);
    }

    public float getLineWidth(IlvTransformer ilvTransformer) {
        return this.getLineWidth(ilvTransformer, true);
    }

    public float getLineWidth(IlvTransformer ilvTransformer, boolean bl) {
        return this.getLineWidthImpl(ilvTransformer, true, bl);
    }

    private float getLineWidthImpl(IlvTransformer ilvTransformer, boolean bl, boolean bl2) {
        IlvLinkBundleFrame ilvLinkBundleFrame;
        if (this.isCollapsed()) {
            if (bl) {
                return this._overviewLink == null ? super.getLineWidth(ilvTransformer) : this._overviewLink.getLineWidth(ilvTransformer);
            }
            return this._overviewLink == null ? super.getLineWidth() : this._overviewLink.getLineWidth();
        }
        int n = this.getSublinksCount();
        if (n == 0) {
            return 0.0f;
        }
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            IlvLinkImage ilvLinkImage = (IlvLinkImage)this._sublinks.elementAt(i);
            f += ilvLinkImage.getLineWidth(ilvTransformer);
        }
        double d = bl && ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        f = (float)((double)f + (double)((float)(n - 1) * this.getOffset()) * d);
        if (bl2 && (ilvLinkBundleFrame = this.getFrame()) != null) {
            f += 2.0f * ilvLinkBundleFrame.getMargin(this, (IlvTransformer)(bl ? ilvTransformer : null));
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineWidth(float f) {
        if (this._overviewLink == null) {
            this._duringSetLineWidth = true;
            try {
                super.setLineWidth(f);
            }
            finally {
                this._duringSetLineWidth = false;
            }
        } else {
            this._overviewLink.setLineWidth(f);
        }
    }

    public int getEndCap() {
        return this._overviewLink == null ? super.getEndCap() : this._overviewLink.getEndCap();
    }

    public void setEndCap(int n) {
        if (this._overviewLink == null) {
            super.setEndCap(n);
        } else {
            this._overviewLink.setEndCap(n);
        }
    }

    public int getLineJoin() {
        return this._overviewLink == null ? super.getLineJoin() : this._overviewLink.getLineJoin();
    }

    public void setLineJoin(int n) {
        if (this._overviewLink == null) {
            super.setLineJoin(n);
        } else {
            this._overviewLink.setLineJoin(n);
        }
    }

    public float getMaximumLineWidth() {
        return this._overviewLink == null ? super.getMaximumLineWidth() : this._overviewLink.getMaximumLineWidth();
    }

    public void setMaximumLineWidth(float f) {
        if (this._overviewLink == null) {
            super.setMaximumLineWidth(f);
        } else {
            this._overviewLink.setMaximumLineWidth(f);
        }
    }

    public float[] getLineStyle() {
        return this._overviewLink == null ? super.getLineStyle() : this._overviewLink.getLineStyle();
    }

    public void setLineStyle(float[] fArray) {
        if (this._overviewLink == null) {
            super.setLineStyle(fArray);
        } else {
            this._overviewLink.setLineStyle(fArray);
        }
    }

    public IlvPoint[] getLinkPoints(IlvTransformer ilvTransformer) {
        return this._overviewLink == null ? super.getLinkPoints(ilvTransformer) : this._overviewLink.getLinkPoints(ilvTransformer);
    }

    public void applyToObject(IlvGraphic ilvGraphic, IlvApplyObject ilvApplyObject, Object object, boolean bl) {
        IlvRect ilvRect;
        IlvRegion ilvRegion = null;
        if (ilvGraphic.isVisible() && bl && this.getGraphicBag() != null) {
            ilvRect = ilvGraphic.boundingBox(null);
            ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
        }
        ilvApplyObject.apply(ilvGraphic, object);
        if (ilvGraphic.isVisible() && bl && this.getGraphicBag() != null) {
            ilvRect = ilvGraphic.boundingBox(null);
            if (ilvRegion == null) {
                ilvRegion = new IlvRegion();
            }
            ilvRegion.add(ilvRect);
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    public void reshapeObject(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl) {
        IlvRegion ilvRegion = this.getRegion(ilvGraphic, bl);
        ilvGraphic.move(ilvRect.x, ilvRect.y);
        ilvGraphic.resize(ilvRect.width, ilvRect.height);
        this.reDrawRegion(ilvGraphic, ilvRegion, bl);
    }

    public void moveObject(IlvGraphic ilvGraphic, float f, float f2, boolean bl) {
        IlvRegion ilvRegion = this.getRegion(ilvGraphic, bl);
        ilvGraphic.move(f, f2);
        this.reDrawRegion(ilvGraphic, ilvRegion, bl);
    }

    private IlvRegion getRegion(IlvGraphic ilvGraphic, boolean bl) {
        IlvRegion ilvRegion = null;
        if (bl && ilvGraphic.isVisible() && this.getGraphicBag() != null) {
            IlvRect ilvRect = ilvGraphic.boundingBox(null);
            ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
        }
        return ilvRegion;
    }

    private void reDrawRegion(IlvGraphic ilvGraphic, IlvRegion ilvRegion, boolean bl) {
        if (bl && ilvRegion != null) {
            IlvRect ilvRect = ilvGraphic.boundingBox(null);
            ilvRegion.add(ilvRect);
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    public void reDrawRegion(IlvRegion ilvRegion) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag != null) {
            ilvGraphicBag.reDrawRegion(ilvRegion);
        }
    }

    public void reDrawObj(IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag;
        if (ilvGraphic.isVisible() && (ilvGraphicBag = this.getGraphicBag()) != null) {
            IlvRect ilvRect = ilvGraphic.boundingBox(null);
            IlvRegion ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
            ilvGraphicBag.reDrawRegion(ilvRegion);
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        boolean bl;
        IlvLinkBundleFrame ilvLinkBundleFrame;
        float f;
        IlvLinkImage ilvLinkImage;
        super.write(ilvOutputStream);
        IlvLinkImage[] ilvLinkImageArray = this.getSublinks();
        if (ilvLinkImageArray != null && ilvLinkImageArray.length > 0) {
            ilvOutputStream.write("sublinks", (IlvGraphic[])ilvLinkImageArray);
        }
        if ((ilvLinkImage = this.getOverviewLink()) != null) {
            ilvOutputStream.write("overviewLink", (IlvGraphic)ilvLinkImage);
        }
        if (this.isCollapsed()) {
            ilvOutputStream.write("collapsed", true);
        }
        if ((f = this.getOffset()) != 5.0f) {
            ilvOutputStream.write("offset", f);
        }
        if ((ilvLinkBundleFrame = this.getFrame()) != null && ilvLinkBundleFrame instanceof IlvPersistentObject) {
            ilvOutputStream.write("frame", (IlvPersistentObject)ilvLinkBundleFrame);
        }
        if (bl = this.isSingleConnectionPoint()) {
            ilvOutputStream.write("singleConnectionPoint", bl);
        }
    }

    public boolean zoomable() {
        return this.isCollapsed() ? (this._overviewLink != null ? this._overviewLink.zoomable() : super.zoomable()) : false;
    }

    private void cleanLinkConnectors(IlvGraphicVector ilvGraphicVector) {
        if (ilvGraphicVector == null) {
            return;
        }
        int n = ilvGraphicVector.size();
        for (int i = 0; i < n; ++i) {
            this.cleanLinkConnectors((IlvLinkImage)ilvGraphicVector.elementAt(i));
        }
    }

    private void cleanLinkConnectors() {
        this.cleanLinkConnectors(this._sublinks);
        this.cleanLinkConnectors(this._overviewLink);
    }

    private void cleanLinkConnectors(IlvLinkImage ilvLinkImage) {
        if (ilvLinkImage != null) {
            this.cleanLinkConnectors(ilvLinkImage, true);
            if (ilvLinkImage.getFrom() != ilvLinkImage.getTo()) {
                this.cleanLinkConnectors(ilvLinkImage, false);
            }
        }
    }

    private void cleanLinkConnectors(IlvLinkImage ilvLinkImage, boolean bl) {
        if (ilvLinkImage == null) {
            return;
        }
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.Get((IlvLinkImage)ilvLinkImage, (boolean)bl);
        if (ilvLinkConnector != null) {
            ilvLinkConnector.linkRemoved(ilvLinkImage);
        }
        if (ilvLinkImage instanceof IlvLinkBundle) {
            ((IlvLinkBundle)ilvLinkImage).cleanLinkConnectors();
        }
        if (ilvLinkConnector != IlvLinkConnector.GetAttached((IlvLinkImage)ilvLinkImage, (boolean)bl)) {
            IlvGraphic ilvGraphic = bl ? ilvLinkImage.getFrom() : ilvLinkImage.getTo();
            IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
            while (ilvGraphicBag != null && ilvGraphicBag instanceof IlvManager) {
                ilvGraphic = (IlvManager)ilvGraphicBag;
                ilvLinkConnector = IlvLinkConnector.GetAttached((IlvGraphic)ilvGraphic);
                if (ilvLinkConnector != null) {
                    ilvLinkConnector.linkRemoved(ilvLinkImage);
                }
                ilvGraphicBag = ilvGraphic.getGraphicBag();
            }
        }
    }

    private static final class IlvSelectedSublinksEnumerator
    implements IlvGraphicEnumeration {
        private IlvGraphicEnumeration _selectedSublinksEnum;
        private boolean _traverse;
        private IlvLinkBundle _linkBundle;
        private IlvGraphicEnumeration _subbundles;
        private IlvGraphicEnumeration _subbundleSelection;

        IlvSelectedSublinksEnumerator(IlvLinkBundle ilvLinkBundle, boolean bl) {
            this._traverse = bl;
            this._linkBundle = ilvLinkBundle;
            if (this._linkBundle.getSelectedSublinksCount() != 0) {
                this._selectedSublinksEnum = new IlvFilteredGraphicEnumeration(ilvLinkBundle.getSublinksEnum(), new IlvGraphicFilter(){

                    public boolean accept(IlvGraphic ilvGraphic) {
                        return IlvSelectedSublinksEnumerator.this._linkBundle.isSelected((IlvLinkImage)ilvGraphic);
                    }
                });
            }
            if (bl && this._linkBundle.getLinkBundlesCount() != 0) {
                this._subbundles = this._linkBundle.getLinkBundles();
            }
        }

        public final boolean hasMoreElements() {
            if (!this._traverse) {
                return this._selectedSublinksEnum == null ? false : this._selectedSublinksEnum.hasMoreElements();
            }
            if (this._selectedSublinksEnum != null && this._selectedSublinksEnum.hasMoreElements()) {
                return true;
            }
            this._selectedSublinksEnum = null;
            if (this._subbundleSelection != null && this._subbundleSelection.hasMoreElements()) {
                return true;
            }
            this._subbundleSelection = null;
            if (this._subbundles == null) {
                return false;
            }
            while (this._subbundles.hasMoreElements()) {
                IlvLinkBundle ilvLinkBundle = (IlvLinkBundle)this._subbundles.nextElement();
                if (ilvLinkBundle.getSelectedSublinksCount() == 0 && ilvLinkBundle.getLinkBundlesCount() == 0) continue;
                this._subbundleSelection = ilvLinkBundle.getSelectedSublinks(true);
                if (!this._subbundleSelection.hasMoreElements()) continue;
                return true;
            }
            return false;
        }

        public final IlvGraphic nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("no more element");
            }
            if (!this._traverse || this._selectedSublinksEnum != null) {
                return this._selectedSublinksEnum.nextElement();
            }
            return this._subbundleSelection.nextElement();
        }
    }
}

