/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map.linkbundle;

import com.cisco.ctc.util.map.linkbundle.IlvLinkBundle;
import com.cisco.ctc.util.map.linkbundle.IlvLinkBundleFrame;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.linkconnector.IlvClippingLinkConnector;

final class IlvLinkBundleLayoutManager {
    public void layout(IlvLinkBundle ilvLinkBundle, IlvTransformer ilvTransformer) {
        if (ilvLinkBundle.isCollapsed() || ilvLinkBundle.getSublinksCount() == 0) {
            return;
        }
        BaseLineData baseLineData = new BaseLineData((IlvLinkImage)ilvLinkBundle, ilvTransformer);
        int n = baseLineData.getNumberOfPoints();
        if (n < 2) {
            return;
        }
        SublinksData sublinksData = new SublinksData(ilvLinkBundle, n, ilvTransformer);
        float f = ilvLinkBundle.getOffset();
        float f2 = ilvLinkBundle.getLineWidth(ilvTransformer, false);
        boolean bl = ilvLinkBundle.isSingleConnectionPoint();
        this.layout(baseLineData, sublinksData, f2, f, bl, ilvTransformer);
    }

    public IlvPolyPointsInterface getMargin(IlvLinkBundle ilvLinkBundle, boolean bl, IlvTransformer ilvTransformer) {
        IlvLinkBundleFrame ilvLinkBundleFrame = ilvLinkBundle.getFrame();
        if (ilvLinkBundleFrame == null) {
            return null;
        }
        int n = ilvLinkBundle.getSublinksCount();
        IlvLinkBundle ilvLinkBundle2 = n > 0 ? ilvLinkBundle.getSublink(bl ? 0 : n - 1) : ilvLinkBundle;
        BaseLineData baseLineData = new BaseLineData((IlvLinkImage)ilvLinkBundle2, ilvTransformer);
        int n2 = baseLineData.getNumberOfPoints();
        SublinksData sublinksData = new SublinksData(n2, bl);
        float f = ilvLinkBundleFrame.getMargin(ilvLinkBundle, ilvTransformer);
        float f2 = ilvLinkBundle2.getLineWidth(ilvTransformer) + 2.0f * f;
        boolean bl2 = ilvLinkBundle.isSingleConnectionPoint();
        this.layout(baseLineData, sublinksData, f2, f2, bl2, ilvTransformer);
        return sublinksData.getSublinkAt(bl ? 0 : 1);
    }

    private void ensureNumberOfPoints(IlvLinkImage[] ilvLinkImageArray, int n) {
        int n2 = ilvLinkImageArray.length;
        int n3 = n - 2;
        for (int i = 0; i < n2; ++i) {
            IlvLinkImage ilvLinkImage = ilvLinkImageArray[i];
            if (ilvLinkImage.getPointsCardinal() == n) continue;
            if (n == 2) {
                ilvLinkImage.setIntermediateLinkPoints(null, 0, 0);
                continue;
            }
            IlvPoint[] ilvPointArray = new IlvPoint[n - 2];
            for (int j = 0; j < n3; ++j) {
                ilvPointArray[j] = new IlvPoint();
            }
            ilvLinkImage.setIntermediateLinkPoints(ilvPointArray, 0, n3);
        }
    }

    private void layout(BaseLineData baseLineData, SublinksData sublinksData, float f, float f2, boolean bl, IlvTransformer ilvTransformer) {
        float f3;
        float f4;
        int n;
        int n2 = baseLineData.getNumberOfSegments();
        if (n2 == 0) {
            return;
        }
        float[] fArray = new float[2 * n2];
        for (int i = 0; i < n2; ++i) {
            IlvPoint ilvPoint = baseLineData.getSegmentStart(i);
            IlvPoint ilvPoint2 = baseLineData.getSegmentEnd(i);
            fArray[2 * i] = ilvPoint2.x - ilvPoint.x;
            fArray[2 * i + 1] = ilvPoint2.y - ilvPoint.y;
        }
        float[] fArray2 = new float[2 * n2];
        for (n = 0; n < n2; ++n) {
            float f5 = fArray[2 * n];
            f4 = fArray[2 * n + 1];
            if (f5 == 0.0f) {
                fArray2[2 * n] = 0.0f;
                fArray2[2 * n + 1] = f4 > 0.0f ? 1.0f : (f4 < 0.0f ? -1.0f : 0.0f);
                continue;
            }
            if (f4 == 0.0f) {
                fArray2[2 * n] = f5 > 0.0f ? 1.0f : (f5 < 0.0f ? -1.0f : 0.0f);
                fArray2[2 * n + 1] = 0.0f;
                continue;
            }
            f3 = 1.0f / (float)Math.sqrt(f5 * f5 + f4 * f4);
            fArray2[2 * n] = f3 * f5;
            fArray2[2 * n + 1] = f3 * f4;
        }
        n = sublinksData.getNumberOfSublinks();
        float f6 = f * 0.5f;
        for (int i = 0; i < n; ++i) {
            f4 = sublinksData.getLinkWidth(i) * 0.5f;
            f6 -= f4;
            if (sublinksData.needsLayout(i)) {
                int n3 = 0;
                IlvPoint ilvPoint = baseLineData.getSegmentStart(0);
                float f7 = fArray2[0];
                float f8 = fArray2[1];
                f3 = ilvPoint.x - f6 * f8;
                float f9 = ilvPoint.y + f6 * f7;
                sublinksData.movePointAt(i, 0, f3, f9, ilvTransformer);
                for (int j = 1; j < n2; ++j) {
                    ilvPoint = baseLineData.getSegmentStart(j);
                    float f10 = fArray2[2 * j - 2];
                    float f11 = fArray2[2 * j - 1];
                    float f12 = fArray2[2 * j];
                    float f13 = fArray2[2 * j + 1];
                    f7 = f10 + f12;
                    f8 = f11 + f13;
                    float f14 = 0.0f;
                    if (f7 != 0.0f || f8 != 0.0f) {
                        float f15;
                        f14 = 1.0f + f10 * f12 + f11 * f13;
                        if ((double)Math.abs(f15) > 0.001) {
                            float f16 = 1.0f / f14;
                            float f17 = f16 * f7;
                            float f18 = f16 * f8;
                            float f19 = -f6 * f18;
                            float f20 = f6 * f17;
                            if (Math.abs(f19) > 2.0f * Math.abs(f6)) {
                                f19 = 2.0f * (f19 > 0.0f ? Math.abs(f6) : -Math.abs(f6));
                            }
                            if (Math.abs(f20) > 2.0f * Math.abs(f6)) {
                                f20 = 2.0f * (f20 > 0.0f ? Math.abs(f6) : -Math.abs(f6));
                            }
                            sublinksData.movePointAt(i, ++n3, ilvPoint.x + f19, ilvPoint.y + f20, ilvTransformer);
                            continue;
                        }
                    }
                    sublinksData.movePointAt(i, ++n3, ilvPoint.x - f6, ilvPoint.y + f6, ilvTransformer);
                }
                ilvPoint = baseLineData.getSegmentEnd(n2 - 1);
                f7 = fArray2[2 * n2 - 2];
                f8 = fArray2[2 * n2 - 1];
                f3 = ilvPoint.x - f6 * f8;
                f9 = ilvPoint.y + f6 * f7;
                sublinksData.movePointAt(i, ++n3, f3, f9, ilvTransformer);
            }
            f6 -= f4 + f2;
        }
        if (bl) {
            this.postProcessSingleConnectionPoint(baseLineData, sublinksData, ilvTransformer);
        }
    }

    private void postProcessSingleConnectionPoint(BaseLineData baseLineData, SublinksData sublinksData, IlvTransformer ilvTransformer) {
        int n = sublinksData.getNumberOfSublinks();
        IlvPoint ilvPoint = baseLineData.getSegmentStart(0);
        IlvPoint ilvPoint2 = baseLineData.getSegmentEnd(0);
        IlvPoint ilvPoint3 = baseLineData.getSegmentEnd(baseLineData.getNumberOfSegments() - 1);
        IlvPoint ilvPoint4 = baseLineData.getSegmentStart(baseLineData.getNumberOfSegments() - 1);
        for (int i = 0; i < n; ++i) {
            if (!sublinksData.needsLayout(i)) continue;
            this.postProcessSingleConnectionPoint(sublinksData, i, ilvPoint, ilvPoint2, ilvTransformer, true);
            this.postProcessSingleConnectionPoint(sublinksData, i, ilvPoint3, ilvPoint4, ilvTransformer, false);
        }
    }

    private void postProcessSingleConnectionPoint(SublinksData sublinksData, int n, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, boolean bl) {
        if (sublinksData.needsLayout(n)) {
            boolean bl2;
            int n2 = sublinksData.getSublinkAt(n).getPointsCardinal();
            int n3 = bl ? 0 : n2 - 1;
            int n4 = bl ? 1 : n2 - 2;
            IlvPoint ilvPoint3 = sublinksData.getPointAt(n, n3, ilvTransformer);
            IlvPoint ilvPoint4 = sublinksData.getPointAt(n, n4, ilvTransformer);
            sublinksData.movePointAt(n, n3, ilvPoint.x, ilvPoint.y, ilvTransformer);
            float f = ilvPoint4.x - ilvPoint3.x;
            float f2 = ilvPoint4.y - ilvPoint3.y;
            float f3 = Math.abs(f);
            float f4 = Math.abs(f2);
            float f5 = ilvPoint.x - ilvPoint3.x;
            float f6 = ilvPoint.y - ilvPoint3.y;
            float f7 = Math.abs(f5);
            float f8 = Math.abs(f6);
            boolean bl3 = bl2 = f7 <= f4 && f8 <= f3 && (f7 != f4 || f8 != f3) && !this.isOppositeDirections(ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4);
            if (bl2) {
                float f9 = ilvPoint3.x + (f >= 0.0f ? f8 : -f8);
                float f10 = ilvPoint3.y + (f2 >= 0.0f ? f7 : -f7);
                int n5 = bl ? n4 : n3;
                sublinksData.insertPointAt(n, n5, f9, f10, ilvTransformer);
            }
        }
    }

    private boolean isOppositeDirections(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4) {
        return this.isOppositeSign(ilvPoint2.x - ilvPoint.x, ilvPoint4.x - ilvPoint3.x) || this.isOppositeSign(ilvPoint2.y - ilvPoint.y, ilvPoint4.y - ilvPoint3.y);
    }

    private boolean isOppositeSign(float f, float f2) {
        return f < 0.0f && f2 > 0.0f || f > 0.0f && f2 < 0.0f;
    }

    private class SublinksData {
        private IlvPolyPointsInterface[] _sublinks;
        private int _nSublinks;
        private float[] _linkWidths;
        private boolean[] _invertedOrientation;
        private int _nPoints;

        SublinksData(int n, boolean bl) {
            this._sublinks = new IlvPolyPointsInterface[2];
            this._sublinks[0] = bl ? new PolyPoints(n) : null;
            this._sublinks[1] = bl ? null : new PolyPoints(n);
            this._nSublinks = this._sublinks.length;
            this._nPoints = n;
            this._linkWidths = new float[this._nSublinks];
            this._invertedOrientation = new boolean[this._nSublinks];
        }

        SublinksData(IlvLinkBundle ilvLinkBundle, int n, IlvTransformer ilvTransformer) {
            IlvLinkImage[] ilvLinkImageArray = ilvLinkBundle.getSublinks();
            this._sublinks = ilvLinkImageArray;
            this._nSublinks = this._sublinks.length;
            this._nPoints = n;
            this._linkWidths = new float[this._nSublinks];
            this._invertedOrientation = new boolean[this._nSublinks];
            IlvGraphic ilvGraphic = ilvLinkBundle.getFrom();
            for (int i = 0; i < this._nSublinks; ++i) {
                IlvLinkImage ilvLinkImage = ilvLinkImageArray[i];
                this._linkWidths[i] = ilvLinkImage.getLineWidth(ilvTransformer);
                this._invertedOrientation[i] = ilvLinkImage.getFrom() != ilvGraphic;
            }
            IlvLinkBundleLayoutManager.this.ensureNumberOfPoints(ilvLinkImageArray, n);
        }

        IlvPolyPointsInterface[] getSublinks() {
            return this._sublinks;
        }

        IlvPolyPointsInterface getSublinkAt(int n) {
            return this._sublinks[n];
        }

        float getLinkWidth(int n) {
            return this._linkWidths[n];
        }

        int getNumberOfSublinks() {
            return this._nSublinks;
        }

        boolean needsLayout(int n) {
            return this._sublinks[n] != null;
        }

        IlvPoint getPointAt(int n, int n2, IlvTransformer ilvTransformer) {
            return this.getPointAt(n, n2, ilvTransformer, false);
        }

        IlvPoint getPointAt(int n, int n2, IlvTransformer ilvTransformer, boolean bl) {
            IlvPolyPointsInterface ilvPolyPointsInterface = this._sublinks[n];
            return this.getPointAt(ilvPolyPointsInterface, n2, ilvTransformer, bl);
        }

        IlvPoint getPointAt(IlvPolyPointsInterface ilvPolyPointsInterface, int n, IlvTransformer ilvTransformer, boolean bl) {
            boolean bl2;
            IlvLinkImage ilvLinkImage;
            IlvLinkConnector ilvLinkConnector;
            if (bl && this.isStartOrEndPoint(ilvPolyPointsInterface, n) && ilvPolyPointsInterface instanceof IlvLinkImage && (ilvLinkConnector = IlvLinkConnector.Get((IlvLinkImage)(ilvLinkImage = (IlvLinkImage)ilvPolyPointsInterface), (boolean)(bl2 = n == 0))) instanceof IlvClippingLinkConnector) {
                IlvClippingLinkConnector ilvClippingLinkConnector = (IlvClippingLinkConnector)ilvLinkConnector;
                return ilvClippingLinkConnector.getUnclippedConnectionPoint(ilvLinkImage, bl2, ilvTransformer);
            }
            return ilvPolyPointsInterface.getPointAt(n, ilvTransformer);
        }

        private boolean isStartOrEndPoint(IlvPolyPointsInterface ilvPolyPointsInterface, int n) {
            return n == 0 || n == ilvPolyPointsInterface.getPointsCardinal() - 1;
        }

        void movePointAt(int n, int n2, float f, float f2, IlvTransformer ilvTransformer) {
            IlvPolyPointsInterface ilvPolyPointsInterface = this._sublinks[n];
            if (this._invertedOrientation[n]) {
                n2 = this._nPoints - n2 - 1;
            }
            ilvPolyPointsInterface.movePoint(n2, f, f2, ilvTransformer);
        }

        void moveSegmentAt(int n, int n2, float f, float f2, float f3, float f4, IlvTransformer ilvTransformer) {
            IlvPolyPointsInterface ilvPolyPointsInterface = this._sublinks[n2];
            boolean bl = this._invertedOrientation[n2];
            if (bl) {
                n = this._nPoints - n - 1;
            }
            ilvPolyPointsInterface.movePoint(n, f, f2, ilvTransformer);
            ilvPolyPointsInterface.movePoint(n + (bl ? -1 : 1), f3, f4, ilvTransformer);
        }

        void insertPointAt(int n, int n2, float f, float f2, IlvTransformer ilvTransformer) {
            IlvPolyPointsInterface ilvPolyPointsInterface = this._sublinks[n];
            if (this._invertedOrientation[n]) {
                n2 = this._nPoints - n2 - 1;
            }
            ilvPolyPointsInterface.insertPoint(n2, f, f2, ilvTransformer);
        }
    }

    private class PolyPoints
    implements IlvPolyPointsInterface {
        private IlvPoint[] _points;

        public PolyPoints(int n) {
            this._points = new IlvPoint[n];
            for (int i = 0; i < n; ++i) {
                this._points[i] = new IlvPoint();
            }
        }

        public PolyPoints(IlvPoint[] ilvPointArray) {
            this(ilvPointArray, true);
        }

        public PolyPoints(IlvPoint[] ilvPointArray, boolean bl) {
            this.init(ilvPointArray, bl);
        }

        protected IlvPoint[] getPoints() {
            return this._points;
        }

        private void init(IlvPoint[] ilvPointArray, boolean bl) {
            if (bl) {
                this._points = new IlvPoint[ilvPointArray.length];
                for (int i = 0; i < ilvPointArray.length; ++i) {
                    this._points[i] = new IlvPoint(ilvPointArray[i].x, ilvPointArray[i].y);
                }
            } else {
                this._points = ilvPointArray;
            }
        }

        public IlvRect boundingBox(IlvTransformer ilvTransformer) {
            throw new RuntimeException("Not supported");
        }

        public boolean pointsInBBox() {
            throw new RuntimeException("Not supported");
        }

        public IlvPoint getPointAt(int n, IlvTransformer ilvTransformer) {
            IlvPoint ilvPoint = new IlvPoint(this._points[n].x, this._points[n].y);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
            }
            return ilvPoint;
        }

        public int getPointsCardinal() {
            return this._points.length;
        }

        public boolean allowsPointInsertion() {
            return true;
        }

        public boolean allowsPointRemoval() {
            return this.getPointsCardinal() >= 2;
        }

        public boolean allowsPointMove(int n) {
            return true;
        }

        public void insertPoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
            if (n >= 0 && n <= this._points.length) {
                IlvPoint[] ilvPointArray = this._points;
                this._points = new IlvPoint[ilvPointArray.length + 1];
                System.arraycopy(ilvPointArray, n, this._points, n + 1, ilvPointArray.length - n);
                this._points[n] = new IlvPoint(f, f2);
                if (n > 0) {
                    System.arraycopy(ilvPointArray, 0, this._points, 0, n);
                }
            } else {
                throw new IllegalArgumentException("bad index: " + n);
            }
        }

        public void removePoint(int n, IlvTransformer ilvTransformer) {
            if (this._points.length == 1) {
                throw new IllegalArgumentException("PolyPoint must have at least two points.");
            }
            if (n >= 0 && n < this._points.length) {
                int n2;
                IlvPoint[] ilvPointArray = this._points;
                this._points = new IlvPoint[ilvPointArray.length - 1];
                if (n > 0) {
                    System.arraycopy(ilvPointArray, 0, this._points, 0, n);
                }
                if ((n2 = ilvPointArray.length - n - 1) > 0) {
                    System.arraycopy(ilvPointArray, n + 1, this._points, n, n2);
                }
            } else {
                throw new IllegalArgumentException("bad index: " + n);
            }
        }

        public void movePoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
            if (n < 0 || n >= this._points.length) {
                throw new IllegalArgumentException("bad index: " + n);
            }
            this._points[n].x = f;
            this._points[n].y = f2;
        }
    }

    private class BaseLineData {
        private IlvPoint[] _filteredPoints;
        private int _nFilteredPoints;

        BaseLineData(IlvLinkImage ilvLinkImage, IlvTransformer ilvTransformer) {
            IlvPoint[] ilvPointArray = ilvLinkImage.getLinkPoints(ilvTransformer);
            int n = ilvPointArray.length;
            int n2 = 0;
            IlvPoint[] ilvPointArray2 = new IlvPoint[n];
            ilvPointArray2[n2++] = ilvPointArray[0];
            for (int i = 0; i < n; ++i) {
                IlvPoint ilvPoint = ilvPointArray[i];
                if (n2 > 0 && ilvPoint.equals((Object)ilvPointArray2[n2 - 1])) continue;
                ilvPointArray2[n2++] = ilvPoint;
            }
            this._nFilteredPoints = n2;
            this._filteredPoints = ilvPointArray2;
        }

        int getNumberOfPoints() {
            return this._nFilteredPoints;
        }

        int getNumberOfSegments() {
            return this._nFilteredPoints - 1;
        }

        IlvPoint getSegmentStart(int n) {
            return this._filteredPoints[n];
        }

        IlvPoint getSegmentEnd(int n) {
            return this._filteredPoints[n + 1];
        }

        float getSlopeCoeff(int n) {
            IlvPoint ilvPoint = this._filteredPoints[n];
            IlvPoint ilvPoint2 = this._filteredPoints[n + 1];
            return (ilvPoint.y - ilvPoint2.y) / (ilvPoint.x - ilvPoint2.x);
        }

        float getSlopeCoeff(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
            return (ilvPoint.y - ilvPoint2.y) / (ilvPoint.x - ilvPoint2.x);
        }
    }
}

