/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.helper;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.util.KDebug;

public class SlotHelper {
    private static final KDebug db = new KDebug("SlotHelper");

    public static String getSlotNumString(INodeModel iNodeModel, int n) {
        String string;
        block5: {
            string = "";
            if (iNodeModel == null || n == 0) {
                return string;
            }
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            if (iEntityTableModel != null) {
                try {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    if (iEntityModel instanceof IEntityModel) {
                        string = SlotHelper.getSlotNumString(iEntityModel);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block5;
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return string;
    }

    public static String getSlotNumString(IEntityModel iEntityModel) {
        return SlotHelper.getSlotNumString(iEntityModel, '-');
    }

    public static String getSlotNumString(IEntityModel iEntityModel, char c) {
        return SlotHelper.getConcatenatedString(iEntityModel, c, "Shelf");
    }

    public static String getShortConcatenatedString(IEntityModel iEntityModel, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Feature.provides(iEntityModel.getNodeModel(), Feature.MULTISHELF) && iEntityModel.getNodeModel().isMultishelf()) {
            stringBuffer.append(iEntityModel.getShelfId());
            stringBuffer.append(c);
            stringBuffer.append(Integer.toString(iEntityModel.getSlot()));
        } else {
            stringBuffer.append(Integer.toString(iEntityModel.getSlot()));
        }
        return stringBuffer.toString();
    }

    public static String getConcatenatedString(IEntityModel iEntityModel, char c, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Feature.provides(iEntityModel.getNodeModel(), Feature.MULTISHELF) && iEntityModel.getNodeModel().isMultishelf()) {
            stringBuffer.append(string + " ");
            stringBuffer.append(iEntityModel.getShelfId());
            stringBuffer.append(c + "Slot ");
            stringBuffer.append(Integer.toString(iEntityModel.getSlot()));
        } else {
            stringBuffer.append(Integer.toString(iEntityModel.getSlot()));
        }
        return stringBuffer.toString();
    }

    public static String getShelfNumString(IEntityModel iEntityModel) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Feature.provides(iEntityModel.getNodeModel(), Feature.MULTISHELF) && iEntityModel.getNodeModel().isMultishelf()) {
            stringBuffer.append(iEntityModel.getShelfId());
        }
        return stringBuffer.toString();
    }

    public static String getShelfString(IEntityModel iEntityModel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Feature.provides(iEntityModel.getNodeModel(), Feature.MULTISHELF) && iEntityModel.getNodeModel().isMultishelf()) {
            stringBuffer.append(string);
            stringBuffer.append(iEntityModel.getShelfId());
        }
        return stringBuffer.toString();
    }
}

