/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.ICTCException;
import cerent.util.GenericDelegatorFactory;
import cerent.util.IGenericDelegatorInterceptor;
import cerent.util.KDebug;
import cerent.util.ReflectionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;

public class GenericDelegator
implements InvocationHandler,
IGenericDelegatorInterceptor {
    private static ThreadLocal tlproxy_ = new ThreadLocal();
    private Object delegate_;
    protected static final KDebug sdb = new KDebug("GenericDelegator");
    static /* synthetic */ Class class$cerent$util$GenericDelegator$Foo;
    static /* synthetic */ Class class$cerent$util$GenericDelegator$FooGenericDelegator;

    public GenericDelegator(Object object) {
        this._setDelegate(object);
    }

    public Object _getDelegate() {
        return this.delegate_;
    }

    public void _setDelegate(Object object) {
        this.delegate_ = object;
    }

    protected Method transformMethod(Method method) {
        return method;
    }

    protected Object[] transformArgs(Method method, Object[] objectArray) {
        return objectArray;
    }

    protected KDebug getDb() {
        return null;
    }

    protected Object getProxy() {
        return GenericDelegator.checkProxyAccess(tlproxy_.get());
    }

    protected static Object checkProxyAccess(Object object) {
        if (object == null) {
            String string = "proxy instance is null. If this call is initiated through a GD subclass inner-instance class, see EDCS 465367 for the suggested fix";
            sdb.println(string);
            NullPointerException nullPointerException = new NullPointerException(string);
            KDebug.printStackTrace((Throwable)nullPointerException);
            throw nullPointerException;
        }
        return object;
    }

    protected void setProxy(Object object) {
        if (object == null) {
            throw new NullPointerException("new proxy instance to be set cannot be null");
        }
        tlproxy_.set(object);
    }

    public final Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        this.setProxy(object);
        Method method2 = this.transformMethod(method);
        Class<?>[] classArray = method2.getParameterTypes();
        Object[] objectArray2 = this.transformArgs(method2, objectArray);
        KDebug kDebug = this.getDb();
        if (objectArray != objectArray2 && kDebug != null && kDebug.isFinerEnabled()) {
            String string = method.getName();
            String string2 = method2.getName();
            kDebug.finer("method: " + string2 + "(" + string + ")" + " transformed from (" + GenericDelegator.toArgList(objectArray) + ")" + " to (" + GenericDelegator.toArgList(objectArray2) + ")");
        }
        return this.invoke(method2, objectArray2);
    }

    public Object invoke(Method method, Object[] objectArray) throws Throwable {
        return this._invoke(method, objectArray, this.getClass(), this, this.delegate_);
    }

    protected final Object _invoke(Method method, Object[] objectArray, Class clazz, Object object, Object object2) throws Throwable {
        Class[] classArray = method.getParameterTypes();
        KDebug kDebug = this.getDb();
        Object object3 = null;
        try {
            Method method2 = null;
            try {
                method2 = clazz.getMethod(method.getName(), classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method2 != null) {
                IGenericDelegatorInterceptor iGenericDelegatorInterceptor;
                if (sdb.isFinestEnabled()) {
                    sdb.finest("trapping-out call to method: " + ReflectionUtil.getSignatureString(method, true, true));
                }
                if ((iGenericDelegatorInterceptor = object instanceof IGenericDelegatorInterceptor ? (IGenericDelegatorInterceptor)object : null) != null) {
                    iGenericDelegatorInterceptor.overridePreInvoke(method2, objectArray);
                }
                Object object4 = method2.invoke(object, objectArray);
                if (iGenericDelegatorInterceptor != null) {
                    object4 = iGenericDelegatorInterceptor.overridePostInvoke(method2, object4);
                }
                return object4;
            }
            if (object2 == null) {
                throw new NoSuchMethodException("delegate null for method: " + ReflectionUtil.getSignatureString(method, true, false));
            }
            Class<?> clazz2 = object2.getClass();
            method2 = clazz2.getMethod(method.getName(), classArray);
            if (kDebug != null && kDebug.isFinestEnabled()) {
                kDebug.finest("invoking on delegate: " + ReflectionUtil.getClassName(object2) + " - " + method2.getName() + "(" + GenericDelegator.toArgList(objectArray) + ")");
            }
            if (sdb.isFinestEnabled()) {
                sdb.finest("invoking on delegate: " + ReflectionUtil.getClassName(object2) + " - " + method2.getName() + "(" + GenericDelegator.toArgList(objectArray) + ")");
            }
            object3 = method2.invoke(object2, objectArray);
            if (kDebug != null && kDebug.isFinestEnabled()) {
                kDebug.finest("...returned: " + object3);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = GenericDelegator.getRootCause(invocationTargetException);
            throw throwable;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (sdb.on()) {
                sdb.println("Delegate of type: " + (object2 == null ? "null" : object2.getClass().getName()) + " may not implement method: " + ReflectionUtil.getSignatureString(method.getReturnType(), null, method.getName(), classArray, true, false));
            }
            throw illegalArgumentException;
        }
        return object3;
    }

    public void overridePreInvoke(Method method, Object[] objectArray) {
    }

    public Object overridePostInvoke(Method method, Object object) {
        return object;
    }

    private static String toString(Object object) {
        return object == null ? "null" : object.toString();
    }

    protected static String toArgList(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(GenericDelegator.toString(objectArray[0]));
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(GenericDelegator.toString(objectArray[i]));
        }
        return stringBuffer.toString();
    }

    protected static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        Throwable throwable3 = throwable;
        while (throwable2 != null) {
            throwable3 = throwable2;
            if (throwable3 instanceof ICTCException) {
                throwable2 = ((ICTCException)((Object)throwable3)).getTargetException();
                continue;
            }
            if (throwable3 instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable3).getTargetException();
                continue;
            }
            throwable2 = throwable3.getCause();
        }
        return throwable3;
    }

    protected static KDebug getSdb() {
        return sdb;
    }

    private static String getClassName(Object object) {
        return ReflectionUtil.getClassName(object);
    }

    public static void main(String[] stringArray) throws Throwable {
        System.out.println("*** GenericFooDelegator test...");
        Foo foo = FooGenericDelegator.getFooAdapter(true);
        Foo foo2 = foo.self();
        System.out.println("foo.self(): " + GenericDelegator.getClassName(foo2));
        System.out.println("foo.helloWorld: " + foo.helloWorld("goodbye"));
        try {
            foo.exceptionGenerator();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        System.out.println("");
        System.out.println("*** GenericFooDelegator (via factory) test...");
        Foo foo3 = FooGenericDelegator.getFooAdapterViaFactory();
        Foo foo4 = foo3.self();
        System.out.println("foo1.self(): " + GenericDelegator.getClassName(foo4));
        System.out.println("");
        System.out.println("*** GenericDelegator test...");
        Foo foo5 = FooGenericDelegator.getFooAdapter(false);
        try {
            Foo foo6 = foo5.self();
            System.out.println("plainfoo.self(): " + GenericDelegator.getClassName(foo6));
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            System.out.println("EXPECTED exception:");
            undeclaredThrowableException.printStackTrace(System.out);
        }
        System.out.println("plainfoo.helloWorld: " + foo5.helloWorld("goodbye"));
    }

    static class FooGenericDelegator
    extends GenericDelegator {
        private static Class[] proxyInterfaces = new Class[]{class$cerent$util$GenericDelegator$Foo == null ? (class$cerent$util$GenericDelegator$Foo = GenericDelegator.class$("cerent.util.GenericDelegator$Foo")) : class$cerent$util$GenericDelegator$Foo};

        public static Foo getFooAdapter(boolean bl) {
            Foo foo = (Foo)Proxy.newProxyInstance((class$cerent$util$GenericDelegator$Foo == null ? (class$cerent$util$GenericDelegator$Foo = GenericDelegator.class$("cerent.util.GenericDelegator$Foo")) : class$cerent$util$GenericDelegator$Foo).getClassLoader(), proxyInterfaces, (InvocationHandler)(bl ? new FooGenericDelegator(new FooImpl()) : new GenericDelegator(new FooImpl())));
            return foo;
        }

        public static Foo getFooAdapterViaFactory() throws CTCUserException {
            return (Foo)GenericDelegatorFactory.createGenericDelegator(new FooImpl(), (class$cerent$util$GenericDelegator$Foo == null ? (class$cerent$util$GenericDelegator$Foo = GenericDelegator.class$("cerent.util.GenericDelegator$Foo")) : class$cerent$util$GenericDelegator$Foo).getClassLoader(), proxyInterfaces, class$cerent$util$GenericDelegator$FooGenericDelegator == null ? (class$cerent$util$GenericDelegator$FooGenericDelegator = GenericDelegator.class$("cerent.util.GenericDelegator$FooGenericDelegator")) : class$cerent$util$GenericDelegator$FooGenericDelegator);
        }

        public Object invoke(Method method, Object[] objectArray) throws Throwable {
            if (!method.getName().equals("helloWorld")) {
                System.out.println("trapping-out invoke(" + method.getName() + ")...");
            }
            return super.invoke(method, objectArray);
        }

        public Foo self() {
            Object object = this.getProxy();
            return (Foo)object;
        }

        public FooGenericDelegator(Object object) {
            super(object);
        }
    }

    static class FooImpl
    implements SimpleFoo {
        FooImpl() {
        }

        public String helloWorld(String string) {
            return "FooImpl: '" + string + "'";
        }

        public void exceptionGenerator() throws Exception {
            throw new InvocationTargetException(new Exception("thrown from FooImpl.exceptionGenerator()"));
        }
    }

    static interface Foo
    extends SimpleFoo {
        public Foo self();
    }

    static interface SimpleFoo {
        public String helloWorld(String var1);

        public void exceptionGenerator() throws Exception;
    }
}

