/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.DebugManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class ComponentPrinter
implements Printable {
    private Component componentToBePrinted;

    public static void printComponent(Component component) {
        new ComponentPrinter(component).print();
    }

    public ComponentPrinter(Component component) {
        this.componentToBePrinted = component;
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                DebugManager.printStackTrace((Throwable)printerException);
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        if (n > 0) {
            return 1;
        }
        int n3 = this.componentToBePrinted.getWidth();
        if (n3 > (n2 = this.componentToBePrinted.getHeight())) {
            pageFormat.setOrientation(0);
        } else {
            pageFormat.setOrientation(1);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = this.getScaleFactor(pageFormat, this.componentToBePrinted);
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.setClip(0, 0, this.componentToBePrinted.getWidth() - 1, this.componentToBePrinted.getHeight() - 1);
        graphics2D.scale(d, d);
        this.componentToBePrinted.paintAll(graphics2D);
        return 0;
    }

    public double getScaleFactor(PageFormat pageFormat, Component component) {
        double d = 1.0;
        double d2 = pageFormat.getImageableHeight();
        double d3 = pageFormat.getImageableWidth();
        double d4 = component.getHeight();
        double d5 = component.getWidth();
        double d6 = 1.0;
        double d7 = 1.0;
        d6 = d3 / d5;
        d7 = d2 / d4;
        d = d6 < d7 ? d6 : d7;
        return d;
    }

    public static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }
}

