/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui.row;

import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowDataSourceListener;
import cerent.util.gui.row.TableUpdateLogic;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RowTableModel
extends AbstractTableModel
implements RowDataSourceListener,
TableCellRenderer {
    protected RowDataSource source;
    protected TableColumnModel colModel;
    protected ColumnRenderer[] colRenderers;
    protected HashMap minColumsWidthsMap;
    protected Class rowObjectClass;
    private static final JLabel emptyLabel = new JLabel();
    protected TableUpdateLogic updateLogic = new TableUpdateLogic();

    public RowTableModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray, Class clazz) {
        this.setDataSource(rowDataSource);
        this.rowObjectClass = clazz;
        this.setColumnRenderers(columnRendererArray);
    }

    public void setColumnRenderers(ColumnRenderer[] columnRendererArray) {
        this.colRenderers = columnRendererArray;
        this.minColumsWidthsMap = new HashMap(columnRendererArray.length);
        for (int i = 0; i < columnRendererArray.length; ++i) {
            this.minColumsWidthsMap.put(columnRendererArray[i].getName(), new Integer(columnRendererArray[i].getWidth()));
        }
        this.dataStructureChanged();
    }

    public RowTableModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray) {
        this(rowDataSource, columnRendererArray, rowDataSource.getClass());
    }

    public void release() {
        if (this.source != null) {
            this.source.removeRowDataSourceListener(this);
            this.source = null;
        }
        this.minColumsWidthsMap.clear();
    }

    public void setDataSource(RowDataSource rowDataSource) {
        if (rowDataSource != null) {
            if (this.source != null) {
                this.source.removeRowDataSourceListener(this);
            }
            this.source = rowDataSource;
            this.source.addRowDataSourceListener(this);
            this.dataSourceChanged();
        }
    }

    public RowDataSource getDataSource() {
        return this.source;
    }

    public void initTable(JTable jTable) {
        jTable.setDefaultRenderer(this.rowObjectClass, this);
        this.colModel = jTable.getColumnModel();
        int n = 10;
        for (int i = 0; i < this.colModel.getColumnCount(); ++i) {
            TableColumn tableColumn = this.colModel.getColumn(i);
            ColumnRenderer columnRenderer = this.getColumnRenderer(i);
            n = columnRenderer.getWidth();
            tableColumn.setResizable(columnRenderer.isResizable());
            if (!columnRenderer.isResizable()) {
                tableColumn.setMaxWidth(n);
            }
            tableColumn.setMinWidth((Integer)this.minColumsWidthsMap.get(columnRenderer.getName()));
            tableColumn.setPreferredWidth(n);
        }
    }

    protected ColumnRenderer getColumnRenderer(int n) {
        return this.colRenderers[n];
    }

    public Object getValueAt(int n, int n2) {
        if (this.source != null) {
            return this.source.getObjectAtRow(n);
        }
        return null;
    }

    public int getRowCount() {
        if (this.source != null) {
            return this.source.getRowCount();
        }
        return 0;
    }

    public int getColumnCount() {
        return this.colRenderers.length;
    }

    public String getColumnName(int n) {
        return this.colRenderers[n].getName();
    }

    public Class getColumnClass(int n) {
        return this.rowObjectClass;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return emptyLabel;
        }
        int n3 = this.colModel.getColumn(n2).getModelIndex();
        return this.getColumnRenderer(n3).getTableCellRendererComponent(jTable, object, bl, bl2, n, n3);
    }

    public void rowsAdded(int n, int n2) {
        this.fireTableRowsInserted(n, n2);
    }

    public void dataStructureChanged() {
        this.fireTableStructureChanged();
    }

    public void dataSourceChanged() {
        this.fireTableDataChanged();
    }

    public void rowsUpdated(int n, int n2) {
        this.fireTableRowsUpdated(n, n2);
    }

    public void rowsDeleted(int n, int n2) {
        this.fireTableRowsDeleted(n, n2);
        this.fireTableDataChanged();
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public void fireTableChanged(final TableModelEvent tableModelEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.fireTableChanged(tableModelEvent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RowTableModel.this.fireTableChanged(tableModelEvent);
                }
            });
        }
    }

    public void bulkRowAdded(int n, Object object) {
        this.updateLogic.rowAdded(n);
    }

    public void bulkRowUpdated(int n, Object object, Object object2) {
        this.updateLogic.rowUpdated(n);
    }

    public void bulkRowDeleted(int n, Object object) {
        this.updateLogic.rowRemoved(n);
    }

    public void bulkDataSourceChanged() {
        this.updateLogic.tableDataChanged();
    }

    public void bulkUpdateView() {
        this.updateLogic.updateView(this);
    }
}

