/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.id;

import cerent.util.id.ICompositeIdentity;
import cerent.util.id.IIdentity;
import cerent.util.id.IKeyNames;
import cerent.util.id.KeyNames;
import cerent.util.id.StringIdentity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractSimpleCompositeIdentity
implements ICompositeIdentity {
    public static final IIdentity[] IIdentityArrayTemplate = new IIdentity[0];
    public static final String SEP = ",";
    public static final String RELATE = "=";
    static final String CTYPE = "COMP_TYPE";
    static final String COMP_TYPE = "COMP_TYPE";
    static final int SEED = 17;
    static final int MULTIPLIER = 37;
    protected HashMap map = new HashMap();
    protected String ctypeval;
    protected KeyNames simpleKeyNames;

    public boolean isSimpleIdentityOnly() {
        return true;
    }

    protected AbstractSimpleCompositeIdentity() {
    }

    protected AbstractSimpleCompositeIdentity(String[] stringArray, IIdentity[] iIdentityArray) {
        this();
        this.addKeys(stringArray, iIdentityArray, false);
    }

    public static boolean isCtype(String string) {
        return "COMP_TYPE".equals(string);
    }

    public static String getCompositeTypeKey() {
        return "COMP_TYPE";
    }

    protected void createSimpleKeyNames(String string) {
        this.simpleKeyNames = new KeyNames(string, this.map.keySet());
    }

    protected String addKeys(String[] stringArray, IIdentity[] iIdentityArray, boolean bl) {
        if (stringArray == null) {
            return this.ctypeval;
        }
        if (iIdentityArray == null || stringArray.length != iIdentityArray.length) {
            throw new IllegalArgumentException("keys and values must be the same length");
        }
        int n = iIdentityArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            IIdentity iIdentity = iIdentityArray[i];
            if (AbstractSimpleCompositeIdentity.isCtype(string)) {
                if (this.ctypeval != null) {
                    throw new IllegalArgumentException("attempt to add duplicate key: " + string);
                }
                this.ctypeval = iIdentity.toString();
                continue;
            }
            if (iIdentity instanceof ICompositeIdentity) {
                if (bl) continue;
                throw new IllegalArgumentException("identity " + i + " was a composite id type...which is not permitted");
            }
            IIdentity iIdentity2 = this.map.put(string, iIdentity);
            if (iIdentity2 == null) continue;
            this.map.put(string, iIdentity2);
            throw new IllegalArgumentException("attempt to add duplicate key: " + string);
        }
        this.createSimpleKeyNames(null);
        return this.ctypeval;
    }

    public int getType() {
        return 2;
    }

    public String getCompositeType() {
        return this.ctypeval;
    }

    public int size() {
        return this.map.size();
    }

    public IKeyNames getKeyNames() {
        return this._getSimpleKeyNames();
    }

    protected KeyNames _getSimpleKeyNames() {
        return this.simpleKeyNames;
    }

    public IIdentity getId(String string) {
        IIdentity iIdentity = (IIdentity)this.map.get(string);
        return iIdentity;
    }

    public IIdentity[] getIds() {
        ArrayList arrayList = new ArrayList(this.map.values());
        return arrayList.toArray(IIdentityArrayTemplate);
    }

    public String toString() {
        return this.toString(this.getClass(), false);
    }

    protected String toString(Class clazz) {
        return this.toString(clazz, false);
    }

    protected String toString(Class clazz, boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.map.keySet().iterator();
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            string = this.getCompositeType();
            if (string == null && clazz != null) {
                string = clazz.getName();
            }
            if (string != null) {
                stringBuffer.append("COMP_TYPE");
                stringBuffer.append(RELATE);
                stringBuffer.append(new StringIdentity(string));
                n = 1;
            }
        }
        while (iterator.hasNext()) {
            bl2 = true;
            String string2 = (String)iterator.next();
            String string3 = this.map.get(string2).toString();
            if (n > 0) {
                stringBuffer.append(SEP);
            }
            stringBuffer.append(string2);
            stringBuffer.append(RELATE);
            stringBuffer.append(string3);
            ++n;
        }
        string = stringBuffer.toString();
        return string;
    }

    public int hashCode() {
        IKeyNames iKeyNames = this.getKeyNames();
        Collection collection = iKeyNames.getNames(null);
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        int n = 17;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AbstractSimpleCompositeIdentity.updateHash(n, string);
            IIdentity iIdentity = this.getId(string);
            AbstractSimpleCompositeIdentity.updateHash(n, iIdentity);
        }
        return n;
    }

    private static int updateHash(int n, Object object) {
        n *= 37;
        return n += object.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object != null && object instanceof ICompositeIdentity) {
            ICompositeIdentity iCompositeIdentity = (ICompositeIdentity)object;
            bl = this.getClass().equals(iCompositeIdentity.getClass()) && this.isEquivalent(iCompositeIdentity);
        }
        return bl;
    }

    public boolean isEquivalent(ICompositeIdentity iCompositeIdentity) {
        boolean bl = false;
        int n = this.size();
        if (n == iCompositeIdentity.size()) {
            KeyNames keyNames = (KeyNames)this.getKeyNames();
            HashSet hashSet = keyNames.names;
            Iterator iterator = hashSet.iterator();
            bl = true;
            while (iterator.hasNext() && bl) {
                IIdentity iIdentity;
                boolean bl2;
                String string = (String)iterator.next();
                if (string == null) {
                    bl = false;
                    break;
                }
                IIdentity iIdentity2 = this.getId(string);
                bl = bl2 = iIdentity2.equals(iIdentity = iCompositeIdentity.getId(string)) || iIdentity2.toString().equals(iIdentity.toString());
            }
        }
        return bl;
    }

    public String prettyString() {
        return this.prettyString(false);
    }

    public String prettyString(boolean bl) {
        IKeyNames iKeyNames = this.getKeyNames();
        Collection collection = iKeyNames.getNames(null);
        int n = collection.size();
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        if (!bl && this.ctypeval != null) {
            stringBuffer.append("COMP_TYPE");
            stringBuffer.append(RELATE);
            stringBuffer.append(this.ctypeval);
            ++n2;
        }
        while (iterator.hasNext()) {
            IIdentity iIdentity;
            String string = (String)iterator.next();
            if (n2 > 0) {
                stringBuffer.append(';');
            }
            if ((iIdentity = this.getId(string)) instanceof AbstractSimpleCompositeIdentity) {
                stringBuffer.append(((AbstractSimpleCompositeIdentity)iIdentity).prettyString(true));
            } else if (iIdentity instanceof ICompositeIdentity) {
                stringBuffer.append(((ICompositeIdentity)iIdentity).prettyString());
            } else {
                stringBuffer.append(string);
                stringBuffer.append(RELATE);
                stringBuffer.append(iIdentity.toString());
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

