/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.matcher;

import cerent.util.KDebug;
import cerent.util.ReflectionUtil;
import cerent.util.matcher.AbstractMatcher;
import cerent.util.matcher.StringFieldMatcher;

public class ClassMatcher
extends AbstractMatcher {
    private static final String BRACKETS = "[]";
    private static final String WILDCARD = "*";
    private static final String WILDLIST = "..*";
    private static final String WILDEXTEND = "+";
    private int numDimensions;
    private StringFieldMatcher smatcher;
    private boolean doAllowSubs;
    private static KDebug db = new KDebug("ClassMatcher");

    public ClassMatcher(String string, String string2) {
        super(string, 0);
        char c;
        if (db == null || db.on()) {
            this.println("ClassMatcher ctor: nameCrit: " + string2);
        }
        int n = 0;
        int n2 = string2.length();
        while ((n2 = string2.lastIndexOf(BRACKETS, n2 - 1)) >= 0) {
            ++this.numDimensions;
            n = n2;
        }
        if (this.numDimensions > 0) {
            string2 = string2.substring(0, n);
        }
        if (string2.endsWith(WILDEXTEND)) {
            this.doAllowSubs = true;
            string2 = string2.substring(0, string2.length() - WILDEXTEND.length());
        } else {
            n2 = string2.indexOf(WILDLIST);
            if (n2 >= 0) {
                string2 = string2.substring(0, n2) + WILDCARD + string2.substring(n2 + WILDLIST.length());
            }
        }
        if (string2.indexOf(WILDCARD) < 0 && string2.indexOf(".") < 0 && Character.isUpperCase(c = string2.charAt(0))) {
            try {
                Class<?> clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    String string3 = "java.lang." + string2;
                    Class<?> clazz = Class.forName(string3);
                    string2 = string3;
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
        }
        if (db == null || db.isFinerEnabled()) {
            this.finer("ClassMatcher ctor: nameCrit for matcher: " + string2);
        }
        this.smatcher = new StringFieldMatcher("", string2, 5, false, null, null);
    }

    public final boolean doesMatch(Object object) {
        boolean bl = object instanceof Class;
        if (bl) {
            bl = this.doesMatch((Class)object);
        }
        return bl;
    }

    public boolean doesMatch(Class clazz) {
        boolean bl = false;
        String string = ReflectionUtil.fromJvmClassname(clazz.getName());
        if (db == null || db.isFinestEnabled()) {
            this.finest("try match for type " + string);
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while ((n3 = string.lastIndexOf(BRACKETS, n3 - 1)) >= 0) {
            ++n;
            n2 = n3;
            clazz = clazz.getComponentType();
        }
        if (n < this.numDimensions) {
            if (db == null || db.isFinerEnabled()) {
                this.finer("doesn't match: type " + string + " has: " + n + " but is required to have at least: " + this.numDimensions);
            }
            return false;
        }
        if (n > 0) {
            string = string.substring(0, n2);
            if (db == null || db.isFinestEnabled()) {
                this.finest("try match for type " + string + " of dimensionality: " + n);
            }
        }
        if (this.doesTypeMatch(string)) {
            bl = true;
        } else if (this.doAllowSubs) {
            Class[] classArray = clazz.isInterface() ? ReflectionUtil.superinterfaces(clazz, null) : ReflectionUtil.superclasses(clazz, null);
            for (int i = 0; i < classArray.length && !bl; ++i) {
                Class clazz2 = classArray[i];
                string = ReflectionUtil.fromJvmClassname(clazz2.getName());
                bl = this.doesTypeMatch(string);
            }
            if (!bl && !clazz.isPrimitive() && this.smatcher.getOrigCriteria().equals("java.lang.Object")) {
                bl = true;
            }
        }
        return bl;
    }

    protected boolean doesTypeMatch(String string) {
        if (db == null || db.isFinestEnabled()) {
            this.finest("try regex match for type " + string + " against: " + this.smatcher.getOrigCriteria());
        }
        return this.smatcher.doesMatch(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getName() + " crit: '" + (this.doAllowSubs ? "extends " : "") + this.smatcher.getOrigCriteria());
        for (int i = 0; i < this.numDimensions; ++i) {
            stringBuffer.append(BRACKETS);
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    protected void println(String string) {
        if (db == null) {
            System.out.println(string);
        } else {
            db.println(string);
        }
    }

    protected void finer(String string) {
        if (db == null) {
            System.out.println(string);
        } else {
            db.finer(string);
        }
    }

    protected void finest(String string) {
        if (db == null) {
            System.out.println(string);
        } else {
            db.finest(string);
        }
    }

    public Object getCriteria() {
        return null;
    }

    public Object[] getMetadata() {
        return null;
    }
}

