/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.stats;

import java.text.SimpleDateFormat;
import java.util.Date;

public class HistoryEntry {
    private static final String DATEFORMAT = "HH:mm:ss";
    private static final SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
    private static final int E_TYPE_CV = 0;
    private static final int E_TYPE_NCV = 1;
    private static final int E_TYPE_UPD = 2;
    private static final String[] E_TYPES = new String[]{"C", "N", "U"};
    private static final int E_OP_GET = 0;
    private static final int E_OP_SET = 1;
    private static final int E_OP_UPD_BASE = 2;
    private static final int E_OP_DEL = 2;
    private static final int E_OP_CHG = 3;
    private static final int E_OP_ADD = 4;
    private static final int E_OP_REB = 5;
    private static final String[] E_OPS = new String[]{"G", "S", "DEL", "CHG", "ADD", "REB"};
    private static long cachedLocalTimeValue = 0L;
    private static String cachedLocalTime = "";
    private static Date _date = new Date();
    private static int nextIndex = 0;
    public String date = HistoryEntry.getNowTime();
    public String nodeName;
    public String name;
    public int entryType;
    public int entryOp;
    public long elapsed;
    public int index;
    public int uniqueId;
    public String status;

    public HistoryEntry(String string, String string2, boolean bl, boolean bl2) {
        this.nodeName = string;
        this.name = string2;
        this.entryType = bl ? 0 : 1;
        this.entryOp = bl2 ? 0 : 1;
        this.status = null;
        this.uniqueId = nextIndex++;
        this.elapsed = System.currentTimeMillis();
    }

    public HistoryEntry(String string, String string2, int n, int n2) {
        this.nodeName = string;
        this.name = string2;
        this.entryType = 2;
        this.entryOp = n + 2;
        this.status = null;
        this.index = n2;
        this.uniqueId = nextIndex++;
        this.elapsed = System.currentTimeMillis();
    }

    public boolean isCv() {
        return this.entryType == 0;
    }

    public boolean isUpdate() {
        return this.entryType == 2;
    }

    public String getType() {
        return E_TYPES[this.entryType];
    }

    public String getOp() {
        return E_OPS[this.entryOp];
    }

    public void finish(String string) {
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        this.status = string;
    }

    public static String getNowTime() {
        long l = System.currentTimeMillis();
        long l2 = l - cachedLocalTimeValue;
        if (l2 > 500L) {
            _date.setTime(l);
            cachedLocalTime = formatter.format(_date);
            cachedLocalTimeValue = l;
        }
        return cachedLocalTime;
    }
}

