/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.threadpool;

import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadPool;
import cerent.util.threadpool.IThreadWorker;
import cerent.util.threadpool.ThreadPoolQueue;
import cerent.util.threadpool.ThreadWorker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ThreadPool
implements IThreadPool {
    ArrayList threadWorkers = new ArrayList();
    ArrayList scheduledClients = new ArrayList();
    ThreadPoolQueue queue;
    int maxClients = 10;
    int maxThreads = 10;
    int maxQSize = 5000;
    int nextIndex = 0;
    Map twACMap = null;
    private static ThreadPool _instance = null;
    private static KDebug db;
    private static final String PREFS_PATH = "ctc.threadpool";
    private static final String PREFS_KEY_POOL = "threadCount";
    private static final String PREFS_KEY_QUEUE = "qSize";
    private int maxRunCount = 0;
    private long reuseCount = 0L;

    protected ThreadPool() {
        db = new KDebug("Thread Pool " + this.getClass().getClassLoader().toString());
        db.addCommand((Object)this, "dump", "Dump the status of all thread workers");
        db.addCommand((Object)this, "resetStats", "Reset stat counters");
        this.maxThreads = Preferences.instance().getInt(PREFS_PATH, PREFS_KEY_POOL, this.maxThreads);
        this.maxQSize = Preferences.instance().getInt(PREFS_PATH, PREFS_KEY_QUEUE, this.maxQSize);
        this.queue = new ThreadPoolQueue(this.maxQSize);
        for (int i = 0; i < this.maxThreads; ++i) {
            ThreadWorker threadWorker = new ThreadWorker(this, this.threadWorkers.size(), db);
            this.threadWorkers.add(threadWorker);
        }
        this.twACMap = new HashMap();
        db.info("Thread count inited to: " + this.maxThreads);
        db.info("ThreadPoolQueue size inited to: " + this.maxQSize);
    }

    public static synchronized ThreadPool instance() {
        if (null == _instance) {
            _instance = new ThreadPool();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerAC(ThreadWorker threadWorker, IActionClient iActionClient) {
        boolean bl = true;
        Map map = this.twACMap;
        synchronized (map) {
            ThreadWorker threadWorker2 = (ThreadWorker)this.twACMap.get(iActionClient);
            if (threadWorker2 != null) {
                this.reuseCount = this.reuseCount + 1L & 0xFFFFFFL;
                int n = threadWorker2.getRunCount() + 1;
                threadWorker2.setRunCount(n);
                if (n > this.maxRunCount) {
                    this.maxRunCount = n;
                }
                return false;
            }
            this.twACMap.put(iActionClient, threadWorker);
            threadWorker.setRunCount(1);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterAC(ThreadWorker threadWorker, IActionClient iActionClient) {
        Map map = this.twACMap;
        synchronized (map) {
            int n = threadWorker.getRunCount() - 1;
            threadWorker.setRunCount(n);
            if (n == 0) {
                this.twACMap.remove(iActionClient);
                return true;
            }
            return false;
        }
    }

    public void deleteClientFromQueue(IActionClient iActionClient) {
        this.queue.delete(iActionClient);
    }

    public IActionClient dequeueClient() {
        try {
            return (IActionClient)this.queue.remove();
        }
        catch (InterruptedException interruptedException) {
            db.println("dequeueClient: caught " + interruptedException);
            return null;
        }
    }

    public void enqueueClient(IActionClient iActionClient) {
        try {
            this.queue.add(iActionClient);
        }
        catch (InterruptedException interruptedException) {
            db.println("enqueueClient: caught " + interruptedException);
        }
    }

    public void killPeriodicClient(IActionClient iActionClient) {
        ScheduledClient scheduledClient;
        for (int i = 0; i < this.scheduledClients.size(); ++i) {
            Object e = this.scheduledClients.get(i);
            if (!(e instanceof ScheduledClient) || (scheduledClient = (ScheduledClient)e).getClient() != iActionClient) continue;
            scheduledClient.stop();
            this.scheduledClients.remove(i);
            this.queue.delete(iActionClient);
        }
        scheduledClient = null;
    }

    public void killPeriodicNonAwtClient(IActionClient iActionClient) {
        ScheduledNonAwtClient scheduledNonAwtClient;
        for (int i = 0; i < this.scheduledClients.size(); ++i) {
            Object e = this.scheduledClients.get(i);
            if (!(e instanceof ScheduledNonAwtClient) || (scheduledNonAwtClient = (ScheduledNonAwtClient)e).getClient() != iActionClient) continue;
            scheduledNonAwtClient.stop();
            this.scheduledClients.remove(i);
            this.queue.delete(iActionClient);
        }
        scheduledNonAwtClient = null;
    }

    public void enqueuePeriodicClient(IActionClient iActionClient, int n) {
        this.scheduledClients.add(new ScheduledClient(iActionClient, n));
    }

    public void enqueuePeriodicNonAwtClient(IActionClient iActionClient, int n) {
        this.scheduledClients.add(new ScheduledNonAwtClient(iActionClient, n));
    }

    public Collection getThreadWorkers() {
        return new ArrayList(this.threadWorkers);
    }

    public int getThreadCount() {
        return this.threadWorkers.size();
    }

    public void setThreadCount(int n) {
        if (n > this.maxThreads) {
            for (int i = 0; i < n - this.maxThreads; ++i) {
                ThreadWorker threadWorker = new ThreadWorker(this, this.threadWorkers.size(), db);
                this.threadWorkers.add(threadWorker);
            }
        } else {
            for (int i = this.maxThreads - 1; i > n - 1; --i) {
                IThreadWorker iThreadWorker = (IThreadWorker)this.threadWorkers.get(i);
                iThreadWorker.killThread();
                this.threadWorkers.remove(i);
            }
        }
        this.maxThreads = n;
        Preferences.instance().setInt(PREFS_PATH, PREFS_KEY_POOL, this.maxThreads);
    }

    public void dispose() {
        int n = this.threadWorkers.size();
        for (int i = 0; i < n; ++i) {
            IThreadWorker iThreadWorker = (IThreadWorker)this.threadWorkers.remove(0);
            iThreadWorker.killThread();
            if (!(iThreadWorker instanceof ThreadWorker)) continue;
            ((ThreadWorker)iThreadWorker).interrupt();
        }
    }

    public final void dump() {
        db.println("Max run count = " + this.maxRunCount);
        db.println("Thread worker reuse count (same action client)= " + this.reuseCount);
        for (int i = 0; i < this.maxThreads; ++i) {
            db.println(this.threadWorkers.get(i).toString());
        }
    }

    public final void resetStats() {
        this.maxRunCount = 0;
        this.reuseCount = 0L;
        this.dump();
    }

    private class ScheduledNonAwtClient
    extends TimerTask {
        Timer timer = null;
        IActionClient myClient = null;

        private ScheduledNonAwtClient(IActionClient iActionClient, int n) {
            this.myClient = iActionClient;
            this.timer = new Timer();
            this.timer.schedule((TimerTask)this, 0L, (long)(n * 1000));
        }

        public void run() {
            ThreadPool.this.enqueueClient(this.myClient);
        }

        public IActionClient getClient() {
            return this.myClient;
        }

        public void stop() {
            this.timer.cancel();
        }
    }

    private class ScheduledClient
    implements ActionListener {
        javax.swing.Timer timer = null;
        IActionClient myClient = null;

        private ScheduledClient(IActionClient iActionClient, int n) {
            this.myClient = iActionClient;
            this.timer = new javax.swing.Timer(n * 1000, this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ThreadPool.this.enqueueClient(this.myClient);
        }

        public IActionClient getClient() {
            return this.myClient;
        }

        public void stop() {
            this.timer.stop();
        }
    }
}

