/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.ICircuitType;
import cerent.util.AbstractEnumBehavior;

public class CircuitType
extends AbstractEnumBehavior
implements ICircuitType {
    protected static AbstractEnumBehavior.EnumRange Range = new AbstractEnumBehavior.EnumRange(CircuitType.class);
    public static int UNDEFINED_TYPE = -1;
    protected static int[] circuitTypeCategories = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    protected static int IS_SONET = 0;
    protected static int IS_SDH = 1;
    protected static int BOTH = 2;
    protected static int IS_DWDM = 3;
    protected static CircuitType[] CircuitTypes = new CircuitType[Range.getNumTypes()];
    public static final CircuitType STS_CIRCUIT_TYPE = new CircuitType(1, "STS", "STS", 0, IS_SONET);
    public static final CircuitType VT_CIRCUIT_TYPE = new CircuitType(2, "VT", "VT", 1, IS_SONET);
    public static final CircuitType VT_TUNNEL_TYPE = new CircuitType(3, "VT Tunnel", "VTT", 2, IS_SONET);
    public static final CircuitType VAP_CIRCUIT_TYPE = new CircuitType(7, "VT Aggregation Point", "VAP", 4, IS_SONET);
    public static final CircuitType STS_VCAT_CIRCUIT_TYPE = new CircuitType(10, "STS-V", "STS-V", 6, IS_SONET);
    public static final CircuitType VT_VCAT_CIRCUIT_TYPE = new CircuitType(11, "VT-V", "VT-V", 7, IS_SONET);
    public static final CircuitType VC_HO_PATH_CIRCUIT_TYPE = new CircuitType(4, "VC_HO_PATH_CIRCUIT", "HOP", 0, IS_SDH);
    public static final CircuitType VC_LO_PATH_CIRCUIT_TYPE = new CircuitType(5, "VC_LO_PATH_CIRCUIT", "LOP", 1, IS_SDH);
    public static final CircuitType VC_LO_PATH_TUNNEL_TYPE = new CircuitType(6, "VC_LO_PATH_TUNNEL", "VCT", 2, IS_SDH);
    public static final CircuitType VC_LO_PATH_AGGREGATION_TYPE = new CircuitType(8, "VC_LO_PATH_AGGREGATION", "VCA", 4, IS_SDH);
    public static final CircuitType VC_HO_VCAT_CIRCUIT_TYPE = new CircuitType(12, "VC_HO_PATH_VCAT_CIRCUIT", "HOP-V", 6, IS_SDH);
    public static final CircuitType VC_LO_VCAT_CIRCUIT_TYPE = new CircuitType(13, "VC_LO_PATH_VCAT_CIRCUIT", "LOP-V", 7, IS_SDH);
    public static final CircuitType ETHERNET_TYPE = new CircuitType(0, "", "", 3, BOTH);
    public static final CircuitType OCHNC_TYPE = new CircuitType(9, "OCHNC", "OCHNC", 5, IS_DWDM);
    public static final CircuitType OCHCC_TYPE = new CircuitType(14, "OCHCC", "OCHCC", 8, IS_DWDM);
    public static final CircuitType OCH_TRAIL_TUNNEL_TYPE = new CircuitType(15, "OCH-TRAIL", "OCH-TRAIL", 9, IS_DWDM);
    protected final String circuitTypeStr;
    protected final String circuitTypeShortStr;
    protected int circuitTypeCategory;
    protected int sonet_sdh_type;

    protected CircuitType(int n, String string, String string2, int n2, int n3) {
        super(CircuitTypes, n);
        this.circuitTypeStr = string;
        this.circuitTypeShortStr = string2;
        CircuitType.CircuitTypes[n] = this;
        this.circuitTypeCategory = n2;
        this.sonet_sdh_type = n3;
    }

    public String getProtocolIndepCktTypeStr() {
        return this.circuitTypeStr;
    }

    public String getProtocolIndepCktTypeShortStr() {
        return this.circuitTypeShortStr;
    }

    public String toString() {
        return this.getProtocolIndepCktTypeStr();
    }

    public static ICircuitType[] getAllCircuitTypes() {
        return CircuitTypes;
    }

    public static ICircuitType getCircuitType(int n) {
        CircuitType.CheckType(n, Range.getLoEnum(), Range.getHiEnum());
        return CircuitTypes[n];
    }

    public boolean isHoCircuitType() {
        return this.circuitTypeCategory == 0;
    }

    public boolean isLoCircuitType() {
        return this.circuitTypeCategory == 1;
    }

    public boolean isTunnelCircuitType() {
        return this.circuitTypeCategory == 2;
    }

    public boolean isEthernetCircuitType() {
        return this.circuitTypeCategory == 3;
    }

    public boolean isLAPCircuitType() {
        return this.circuitTypeCategory == 4;
    }

    public boolean isOchncType() {
        return this.circuitTypeCategory == 5;
    }

    public boolean isHoVcatCircuitType() {
        return this.circuitTypeCategory == 6;
    }

    public boolean isLoVcatCircuitType() {
        return this.circuitTypeCategory == 7;
    }

    public boolean isVcatCircuitType() {
        return this.circuitTypeCategory == 6 || this.circuitTypeCategory == 7;
    }

    public boolean isSonetType() {
        return this.sonet_sdh_type == IS_SONET;
    }

    public boolean isOchccCircuitType() {
        return this.circuitTypeCategory == 8;
    }

    public boolean isOchTrailTunnelCircuitType() {
        return this.circuitTypeCategory == 9;
    }

    public int compareTo(Object object) {
        if (object instanceof CircuitType) {
            CircuitType circuitType = (CircuitType)object;
            if (circuitType.isSonetType()) {
                if (this.isSonetType()) {
                    if (circuitType.getEnum() < this.getEnum()) {
                        return 1;
                    }
                    if (circuitType.getEnum() > this.getEnum()) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }
            if (this.isSonetType()) {
                return 1;
            }
            if (circuitType.getEnum() < this.getEnum()) {
                return 1;
            }
            if (circuitType.getEnum() > this.getEnum()) {
                return -1;
            }
            return 1;
        }
        throw new ClassCastException("Cannot cast to CircuitType");
    }

    public int value() {
        return this.enum;
    }

    public static CircuitType from_int(int n) {
        switch (n) {
            case 1: {
                return STS_CIRCUIT_TYPE;
            }
            case 2: {
                return VT_CIRCUIT_TYPE;
            }
            case 3: {
                return VT_TUNNEL_TYPE;
            }
            case 7: {
                return VAP_CIRCUIT_TYPE;
            }
            case 4: {
                return VC_HO_PATH_CIRCUIT_TYPE;
            }
            case 5: {
                return VC_LO_PATH_CIRCUIT_TYPE;
            }
            case 6: {
                return VC_LO_PATH_TUNNEL_TYPE;
            }
            case 8: {
                return VC_LO_PATH_AGGREGATION_TYPE;
            }
            case 0: {
                return ETHERNET_TYPE;
            }
            case 9: {
                return OCHNC_TYPE;
            }
            case 14: {
                return OCHCC_TYPE;
            }
            case 15: {
                return OCH_TRAIL_TUNNEL_TYPE;
            }
        }
        throw new IllegalArgumentException("" + n);
    }

    public static interface ICircuitTypeCategory {
        public static final int HO_CIRCUIT = 0;
        public static final int LO_CIRCUIT = 1;
        public static final int TUNNEL_CIRCUIT = 2;
        public static final int ETHERNET_CIRCUIT = 3;
        public static final int LAP_CIRCUIT = 4;
        public static final int OCHNC_CIRCUIT = 5;
        public static final int HO_VCAT_CIRCUIT = 6;
        public static final int LO_VCAT_CIRCUIT = 7;
        public static final int OCHCC_CIRCUIT = 8;
        public static final int OCH_TRAIL_TUNNEL_CIRCUIT = 9;
    }
}

