/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IFramingType;
import cerent.util.AbstractEnumBehavior;
import cerent.util.SDHTDMTerminology;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;
import java.util.Arrays;

public class FramingType
extends AbstractEnumBehavior
implements IFramingType {
    protected static AbstractEnumBehavior.EnumRange Range = new AbstractEnumBehavior.EnumRange(FramingType.class);
    protected static final int IS_SONET = 0;
    protected static final int IS_SDH = 1;
    protected static final int CKT_TYPES = 3;
    protected static FramingType[] FramingTypes = new FramingType[Range.getNumTypes()];
    protected static final ICircuitType[] supportedSonetCktTypes = new ICircuitType[]{CircuitType.getCircuitType(1), CircuitType.getCircuitType(2), CircuitType.getCircuitType(3), CircuitType.getCircuitType(7), CircuitType.getCircuitType(10), CircuitType.getCircuitType(11)};
    protected static final ICircuitType[] supportedSdhCktTypes = new ICircuitType[]{CircuitType.getCircuitType(4), CircuitType.getCircuitType(5), CircuitType.getCircuitType(6), CircuitType.getCircuitType(8), CircuitType.getCircuitType(12), CircuitType.getCircuitType(13)};
    public static final FramingType SONET = new FramingType(0, "SONET", supportedSonetCktTypes, 1, 1, 0, 1, 1, 1, 2, 3, 7, 10, 11, SONETTDMTerminology.instance());
    public static final FramingType SDH_AU4 = new FramingType(1, "SDH-AU4", supportedSdhCktTypes, 0, 9, 1, 3, 12, 4, 5, 6, 8, 12, 13, SDHTDMTerminology.instance());
    public static final FramingType SDH_AU3 = new FramingType(2, "SDH-AU3", supportedSdhCktTypes, 0, 9, 1, 1, 11, 4, 5, 6, 8, 12, 13, SDHTDMTerminology.instance());
    protected ICircuitType[] supportedCktTypes = null;
    protected int mediumType;
    protected int opticalPayloadType;
    protected int protocolType;
    protected int minimumHoPathWidth;
    protected int lotSize;
    protected int hoCircuitType;
    protected int loCircuitType;
    protected int tunnelCircuitType;
    protected int loAggCircuitType;
    protected int hoVcatCircuitType;
    protected int loVcatCircuitType;
    protected TDMTerminology terms;
    protected String framingTypeStr;

    protected FramingType(int n, String string, ICircuitType[] iCircuitTypeArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, TDMTerminology tDMTerminology) {
        super(FramingTypes, n);
        this.framingTypeStr = string;
        this.supportedCktTypes = iCircuitTypeArray;
        this.mediumType = n2;
        this.opticalPayloadType = n3;
        this.protocolType = n4;
        this.minimumHoPathWidth = n5;
        this.lotSize = n6;
        this.hoCircuitType = n7;
        this.loCircuitType = n8;
        this.tunnelCircuitType = n9;
        this.loAggCircuitType = n10;
        this.hoVcatCircuitType = n11;
        this.loVcatCircuitType = n12;
        this.terms = tDMTerminology;
        FramingType.FramingTypes[n] = this;
    }

    public static IFramingType getFramingType(int n) {
        FramingType.CheckType(n, Range);
        return FramingTypes[n];
    }

    public String getFramingTypeString() {
        return this.framingTypeStr;
    }

    public ICircuitType[] getSupportedCircuitTypes() {
        return this.supportedCktTypes;
    }

    public int getMediumType() {
        return this.mediumType;
    }

    public int getOpticalPayloadType() {
        return this.opticalPayloadType;
    }

    public static boolean isSonet(int n) {
        return FramingType.getFramingType(n).isSonet();
    }

    public boolean isSonet() {
        return this.protocolType == 0;
    }

    public boolean isSdh() {
        return this.protocolType == 1;
    }

    public int getMinimumHoPathWidth() {
        return this.minimumHoPathWidth;
    }

    public int getFramingTypeHoPathWidth(int n) {
        return n / this.minimumHoPathWidth;
    }

    public static boolean hasAu3(int[] nArray) {
        Arrays.sort(nArray);
        return Arrays.binarySearch(nArray, 2) >= 0;
    }

    public static boolean hasAu4(int[] nArray) {
        Arrays.sort(nArray);
        return Arrays.binarySearch(nArray, 1) >= 0;
    }

    public int getLoTunnelSize() {
        return this.lotSize;
    }

    public int getHoCircuitType() {
        return this.hoCircuitType;
    }

    public int getLoCircuitType() {
        return this.loCircuitType;
    }

    public int getTunnelCircuitType() {
        return this.tunnelCircuitType;
    }

    public int getAggCircuitType() {
        return this.loAggCircuitType;
    }

    public int getHoVcatCircuitType() {
        return this.hoVcatCircuitType;
    }

    public int getLoVcatCircuitType() {
        return this.loVcatCircuitType;
    }

    public TDMTerminology getTDMTerminology() {
        return this.terms;
    }
}

