/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.KDebug;
import cerent.util.StringIndex;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadPool;
import cerent.util.threadpool.IThreadWorker;
import cerent.util.threadpool.ThreadPool;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class AbstractHttpServer
implements Runnable,
IActionClient {
    private static final int UNKNOWN_RQST = 0;
    private static final int GET_RQST = 1;
    private static final int HEAD_RQST = 2;
    private static final byte[] NO_BYTES = new byte[0];
    private IThreadPool tpool = ThreadPool.instance();
    private ServerSocket server = null;
    private String pathRoot;
    private int port;
    private boolean doStop = false;
    protected static KDebug db = new KDebug("AbstractHttpServer");

    protected AbstractHttpServer(String string, int n) throws IOException {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.pathRoot = string;
        this.port = n;
        this.server = new ServerSocket(n);
        db.display("Starting CTC HTTP Server @ port: " + n);
        this.newListener();
    }

    protected abstract byte[] getBytes(String var1) throws Exception;

    protected abstract boolean doesPathExist(String var1);

    public void run() {
        this.doAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction() {
        Socket socket;
        try {
            socket = this.server.accept();
        }
        catch (IOException iOException) {
            if (db.on()) {
                db.println("Class Server died: " + iOException.getMessage());
                KDebug.printStackTrace((Throwable)iOException);
            }
            return;
        }
        if (this.doStop) {
            return;
        }
        this.newListener();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                StringIndex stringIndex = this.getPath(bufferedReader);
                String string = stringIndex.str;
                byte[] byArray = NO_BYTES;
                switch (stringIndex.index) {
                    case 1: {
                        byArray = this.getBytes(string);
                        break;
                    }
                    case 2: {
                        if (this.doesPathExist(string)) {
                            byArray = NO_BYTES;
                            break;
                        }
                        throw new Exception("resource: " + string + " not found");
                    }
                }
                try {
                    dataOutputStream.writeBytes("HTTP/1.0 200 OK\r\n");
                    dataOutputStream.writeBytes("Content-Length: " + byArray.length + "\r\n");
                    dataOutputStream.writeBytes("Content-Type: application/java\r\n\r\n");
                    dataOutputStream.write(byArray);
                    dataOutputStream.flush();
                }
                catch (IOException iOException) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Exception exception) {
                dataOutputStream.writeBytes("HTTP/1.0 400 " + exception.getMessage() + "\r\n");
                dataOutputStream.writeBytes("Content-Type: text/html\r\n\r\n");
                dataOutputStream.flush();
            }
        }
        catch (IOException iOException) {
            if (db.on()) {
                db.println("error writing response: " + iOException.getMessage());
                KDebug.printStackTrace((Throwable)iOException);
            }
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void newListener() {
        this.tpool.enqueueClient(this);
    }

    private StringIndex getPath(BufferedReader bufferedReader) throws IOException {
        int n;
        int n2 = 0;
        String string = bufferedReader.readLine();
        String string2 = "";
        if (string.startsWith("GET /")) {
            n2 = 1;
            if (db.isFinerEnabled()) {
                db.finer("RAW GET: '" + string + "'");
            }
            if ((n = (string2 = string.substring(4, string.length() - 1).trim()).indexOf(" ")) >= 0) {
                string2 = string2.substring(0, n);
            }
        } else if (string.startsWith("HEAD /")) {
            n2 = 2;
            if (db.isFinerEnabled()) {
                db.finer("RAW HEAD: '" + string + "'");
            }
            if ((n = (string2 = string.substring(5, string.length() - 1).trim()).indexOf(" ")) >= 0) {
                string2 = string2.substring(0, n);
            }
        }
        while ((string = bufferedReader.readLine()).length() != 0 && string.charAt(0) != '\r' && string.charAt(0) != '\n') {
        }
        if (string2.length() != 0) {
            return new StringIndex(this.pathRoot + string2, n2);
        }
        throw new IOException("Malformed Header");
    }

    public void failedAction(IThreadWorker iThreadWorker) {
    }

    public void dispose() {
        this.doStop = true;
    }
}

