/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.A_AOS;
import cerent.util.O_AOS;
import cerent.util.TestSizer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public abstract class AbstractObjectSizer {
    protected static final Class[] ClassArrayTemplate = new Class[0];
    public static final int A32_REF_SIZE = 4;
    public static final int A64_REF_SIZE = 8;
    protected static final int BOOLEAN_SIZE = 1;
    protected static final int CHAR_SIZE = 2;
    protected static final int OBJECT_OVERHEAD_SIZE = 8;
    protected int visitCount;
    protected IdentityHashMap visited = new IdentityHashMap();
    protected IdentityHashMap toBeVisited = new IdentityHashMap();
    protected IdentityHashMap rollups;
    protected IdentityHashMap instSizes;
    protected IdentityHashMap rollupSizes;
    protected HashMap classCounter = new HashMap();
    protected HashMap classSizeCounter = new HashMap();
    protected LinkedList ancestory = new LinkedList();
    final int refSize;
    protected int level;
    protected int doFollowCount;
    protected int didntFollowCount;
    private boolean doLogDetail;
    private boolean doReportClassCount;
    private int totalRollup;
    private int totalNumRollup;
    static final int NotHeap = 8;

    protected AbstractObjectSizer(int n, boolean bl, boolean bl2) {
        this.refSize = n;
        this.doLogDetail = bl;
        this.doReportClassCount = bl2;
    }

    protected AbstractObjectSizer() {
        this(8, true, true);
    }

    protected final int getLevel() {
        return this.level;
    }

    protected void countClass(Class clazz) {
        if (clazz.isInterface()) {
            return;
        }
        int n = clazz.getModifiers();
        if (!clazz.isPrimitive() && !clazz.isArray() && (n & 0x400) != 0) {
            return;
        }
        String string = clazz.getName();
        Integer n2 = (Integer)this.classCounter.get(string);
        int n3 = 1;
        if (n2 != null) {
            n3 = n2 + 1;
        }
        this.classCounter.put(string, new Integer(n3));
    }

    protected void countInstanceSize(Object object, Class clazz, int n) {
        String string;
        Integer n2;
        if (n == 0) {
            return;
        }
        if (object != null) {
            if (this.instSizes == null) {
                this.instSizes = new IdentityHashMap();
            }
            if (this.instSizes.get(object) != null) {
                return;
            }
            this.instSizes.put(object, new Integer(n));
        }
        int n3 = (n2 = (Integer)this.classSizeCounter.get(string = clazz.getName())) != null ? n2 + n : n;
        this.classSizeCounter.put(string, new Integer(n3));
    }

    protected final int getNumInstancesSized() {
        return this.instSizes == null ? 0 : this.instSizes.size();
    }

    protected final int getTotalInstanceSize() {
        int n = 0;
        Iterator iterator = this.classSizeCounter.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Integer n2 = (Integer)this.classSizeCounter.get(string);
            if (n2 == null) continue;
            n += n2.intValue();
        }
        return n;
    }

    protected void reportClassCount() {
        this.reportClassCount(this.doReportClassCount);
    }

    public void reportClassCount(boolean bl) {
        if (!bl) {
            return;
        }
        TreeSet treeSet = new TreeSet(this.classCounter.keySet());
        treeSet.addAll(this.classSizeCounter.keySet());
        Iterator iterator = treeSet.iterator();
        this.log("");
        this.log("CLASS BY CLASS BREAKDOWN...");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Integer n = (Integer)this.classSizeCounter.get(string);
            Integer n2 = (Integer)this.classCounter.get(string);
            int n3 = n2 == null ? 0 : n2;
            String string2 = "";
            if (n != null) {
                string2 = " (" + n + ")";
            }
            this.log(string + " - " + n3 + string2);
        }
        this.log("");
        this.log("SUMMARY OF MEMORY SIZING:");
        this.log("number of classes: " + this.classCounter.size());
        this.log("cumm. inst size (for " + this.getNumInstancesSized() + " objs.): " + this.getTotalInstanceSize());
        this.log("total rollup: " + this.totalNumRollup + " objs. (" + this.totalRollup + " bytes in total)");
        this.reportRollupTree();
    }

    public final void reportFollowCounts() {
        this.log("do follow count: " + this.doFollowCount);
        this.log("did not follow count: " + this.didntFollowCount);
    }

    protected void reportVisited() {
        int n = this.visited.size();
        this.log("visited size: " + n);
        Iterator iterator = this.visited.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.log("  " + k.getClass() + " 0x" + Integer.toHexString(System.identityHashCode(k)));
        }
    }

    protected static int sizeof(String string) {
        int n = AbstractObjectSizer.sizeofStringOverhead(string);
        int n2 = string == null ? 0 : string.length();
        char[] cArray = string.toCharArray();
        int n3 = n2;
        try {
            while (true) {
                char c = cArray[n3];
                ++n3;
            }
        }
        catch (Exception exception) {
            return n += n2 * 2 + (n3 - n2);
        }
    }

    protected static int sizeofOverhead(Object object) {
        return object == null ? 0 : 8;
    }

    protected static int sizeofArrayOverhead(Object object) {
        if (object == null) {
            return 0;
        }
        return 14;
    }

    protected static int sizeofPrimitiveArrayOverhead(Object object) {
        if (object == null) {
            return 0;
        }
        return 0;
    }

    protected static int sizeofStringOverhead(String string) {
        if (string == null) {
            return 0;
        }
        return 38;
    }

    protected static int sizeofStructOverhead(int n) {
        if (n == 0) {
            return 8;
        }
        if (n < 9) {
            return 8;
        }
        if (n < 17) {
            return 16;
        }
        if (n < 33) {
            return 32;
        }
        if (n < 49) {
            return 48;
        }
        return 56;
    }

    protected abstract boolean doFollow(Object var1);

    protected final boolean _doFollow(Object object) {
        boolean bl = false;
        if (object != null && !(object instanceof AbstractObjectSizer)) {
            bl = this.doFollow(object);
        }
        if (bl) {
            ++this.doFollowCount;
        } else {
            ++this.didntFollowCount;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int sizeOf(Object object) {
        int n = 0;
        try {
            if (object == null) {
                n = AbstractObjectSizer.sizeofOverhead(object);
            } else if (this.wasVisited(object)) {
                n = this.refSize;
            } else {
                int n2;
                if (!this.isToBeVisited(object)) {
                    this.toBeVisited.put(object, object);
                }
                Set set = this.toBeVisited.keySet();
                Object[] objectArray = set.toArray();
                Object object2 = objectArray[n2];
                for (n2 = 0; !(n2 >= objectArray.length || this.toBeVisited.size() <= 0 && this.wasVisited(object)); ++n2) {
                    if (this.doLogDetail) {
                        this.logDetail("visit # " + n2 + " - " + this.toBeVisited.size() + " remaining");
                    }
                    this.level = 0;
                    object2 = objectArray[n2];
                    if (!this.isToBeVisited(object2)) {
                        this.toBeVisited.put(object2, object2);
                    }
                    if (object2 != null && !this.wasVisited(object2)) {
                        ++this.level;
                        n += this.sizeof(object2, null, false);
                        this.visited.put(object2, object2);
                        --this.level;
                    } else {
                        n += this.refSize;
                    }
                    this.toBeVisited.remove(object2);
                }
            }
            this.reportClassCount();
        }
        finally {
            this.cleanupState();
        }
        return n;
    }

    public void cleanupState() {
        this.rawCleanupState();
    }

    protected final void rawCleanupState() {
        this.visitCount = 0;
        this.visited.clear();
        this.toBeVisited.clear();
        if (this.rollups != null) {
            this.rollups.clear();
        }
        if (this.instSizes != null) {
            this.instSizes.clear();
        }
        this.classCounter.clear();
        this.classSizeCounter.clear();
        this.ancestory.clear();
        this.level = 0;
        this.doFollowCount = 0;
        this.didntFollowCount = 0;
        this.totalRollup = 0;
        this.totalNumRollup = 0;
    }

    protected final int sizeof(Object object, String string) {
        return this.sizeof(object, string, true);
    }

    protected final boolean wasVisited(Object object) {
        return this.visited.containsKey(object);
    }

    protected final int getVisitedCount(Object object) {
        Integer n = object == null ? null : (Integer)this.visited.get(object);
        int n2 = n != null ? n : 0;
        return n2;
    }

    protected final boolean isToBeVisited(Object object) {
        return this.toBeVisited.containsKey(object);
    }

    protected final int sizeof(Object object, String string, boolean bl) {
        String string2 = this.doLogDetail ? this.displayFormat(object) : "";
        int n = 0;
        Class<?> clazz = null;
        boolean bl2 = false;
        if (object == null) {
            return 0;
        }
        if (bl) {
            if (this.wasVisited(object)) {
                return 0;
            }
            if (!this._doFollow(object)) {
                return 0;
            }
            if (this.level >= this.maxLevel()) {
                if (!this.isToBeVisited(object)) {
                    this.toBeVisited.put(object, object);
                }
                return n;
            }
        }
        if (!this.isToBeVisited(object)) {
            this.toBeVisited.put(object, object);
        }
        if (!this.wasVisited(object) || this.isToBeVisited(object)) {
            clazz = object.getClass();
            this.countClass(clazz);
            this.toBeVisited.remove(object);
            ++this.visitCount;
            this.visited.put(object, new Integer(this.visitCount));
            bl2 = this.doRollup(object, clazz);
            this.ancestory.addFirst(object);
            n = this._sizeof(object, string, clazz);
            this.ancestory.removeFirst();
        } else if (this.wasVisited(object)) {
            if (this.isToBeVisited(object)) {
                this.toBeVisited.remove(object);
            }
            n = 0;
        }
        Object object2 = this.getAncestor();
        String string3 = bl2 ? "ROLLUP " : "";
        String string4 = clazz.getName();
        if (string == null) {
            if (this.doLogDetail) {
                this.logDetail(string3 + "#" + this.getVisitedCount(object) + " " + string2 + " " + n + " bytes - " + string4);
            }
        } else if (string2 != null) {
            String string5 = " [" + string + "] " + string2 + " " + n + " bytes - " + string4;
            if (object2 == null) {
                if (this.doLogDetail) {
                    this.logDetail(string3 + "#" + this.getVisitedCount(object) + string5);
                }
            } else if (this.doLogDetail) {
                this.logDetail(string3 + "#" + this.getVisitedCount(object) + "/#" + this.getVisitedCount(object2) + string5);
            }
        }
        return n;
    }

    protected int _sizeof(Object object, String string, Class clazz) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "???";
        if (AbstractObjectSizer.isPrimitive(clazz)) {
            n = this.sizeofPrim(clazz);
            string2 = "sizeofPrim";
            bl = true;
        } else if (clazz.isArray()) {
            n = this.sizeofArray(object, clazz);
            string2 = "sizeofArray";
            bl2 = true;
        } else if (object instanceof String) {
            n = AbstractObjectSizer.sizeof((String)object);
            string2 = "sizeof(String)";
        } else if (AbstractObjectSizer.isPrimitiveWrapper(object)) {
            n = this.sizeofObjPrim(object);
            string2 = "sizeofObjPrim";
        } else if (clazz.equals(Object.class)) {
            string2 = "sizeofOverhead";
            n = AbstractObjectSizer.sizeofOverhead(object);
        } else {
            n = this.sizeofStruct(object, string);
            string2 = "sizeofStruct";
            bl2 = true;
        }
        if (this.doLogDetail) {
            this.logDetail("type " + clazz.getName() + " handled by method: " + string2);
        }
        if (!bl2 && !bl) {
            this.countInstanceSize(object, clazz, n);
            if (this.doRollup(object)) {
                this.totalRollup += n;
                ++this.totalNumRollup;
            }
        }
        return n;
    }

    protected Object getAncestor() {
        Object var1_1 = null;
        if (this.ancestory != null && this.ancestory.size() > 0) {
            var1_1 = this.ancestory.getFirst();
        }
        return var1_1;
    }

    protected int maxLevel() {
        return 100;
    }

    protected final int sizeofArray(Object object, Class clazz) {
        int n;
        Object object2;
        Class<?> clazz2 = clazz.getComponentType();
        boolean bl = this.doRollup(object, clazz);
        if (bl && clazz2.equals(Object.class) && this.ancestory.size() > 1 && (object2 = this.ancestory.get(1)).getClass().equals(Vector.class)) {
            bl = false;
        }
        if (object == null) {
            return AbstractObjectSizer.sizeofOverhead(object);
        }
        int n2 = Array.getLength(object);
        int n3 = 0;
        if (AbstractObjectSizer.isPrimitiveArray(object)) {
            n = n3 += n2 * this.sizeofPrim(clazz2);
        } else {
            n = n2 * this.refSize + AbstractObjectSizer.sizeofArrayOverhead(object);
            for (int i = 0; i < n2; ++i) {
                object2 = Array.get(object, i);
                Class<?> clazz3 = object2 == null ? clazz2 : object2.getClass();
                int n4 = this.sizeofItem(object2, Integer.toString(i), clazz3);
                if (this.doRollup(object2, clazz3)) {
                    this.accumRollupSize(object, this.getRollupSize(object2));
                }
                n3 += n4;
            }
            n3 += AbstractObjectSizer.sizeofArrayOverhead(object);
        }
        if (this.doLogDetail) {
            this.logDetail("array " + object + " of len: " + n2);
        }
        this.accumRollupSize(object, n);
        this.countInstanceSize(object, clazz, n);
        if (bl) {
            this.totalRollup += n;
            ++this.totalNumRollup;
        }
        return n3;
    }

    int sizeofStruct(Object object, String string) {
        Object object2;
        int n;
        Class<?> clazz = object.getClass();
        String string2 = clazz.getName();
        String string3 = string2 + "(0x" + Integer.toHexString(object.hashCode()) + ")";
        String string4 = "";
        if (AbstractObjectSizer.isCollectionOrMap(object)) {
            string4 = " " + this.numOfCollItems(object) + " items";
        }
        if (this.doLogDetail) {
            this.logDetail("==>" + string4);
        }
        int n2 = 0;
        int n3 = 0;
        Class[] classArray = new Class[]{clazz};
        classArray = AbstractObjectSizer.superclasses(clazz);
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < classArray.length; ++n) {
            int n6;
            object2 = classArray[n];
            String string5 = ((Class)object2).getName();
            Field[] fieldArray = ((Class)object2).getDeclaredFields();
            if (!string5.startsWith("java.util.")) {
                n6 = this.countConsidered(fieldArray);
                if (!object2.equals(clazz) && n6 > 0 && this.doLogDetail) {
                    this.logDetail(" super: " + string5 + " of " + string2);
                }
            }
            for (n6 = 0; n6 < fieldArray.length; ++n6) {
                ++n4;
                Field field = fieldArray[n6];
                if (!this.doConsiderField(field)) continue;
                ++n5;
                Class<?> clazz2 = field.getType();
                String string6 = field.getName();
                field.setAccessible(true);
                try {
                    Object object3 = field.get(object);
                    int n7 = this.sizeofItem(object3, string6, clazz2);
                    if (this.doRollup(object3, clazz2)) {
                        this.accumRollupSize(object, this.getRollupSize(object3));
                    }
                    n2 += n7;
                    n3 += AbstractObjectSizer.isPrimitive(clazz2) ? this.sizeofPrim(clazz2) : this.refSize;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
        }
        n = AbstractObjectSizer.sizeofStructOverhead(n4);
        n2 += n;
        n3 += n;
        if (this.doLogDetail) {
            object2 = n > 0 ? " bytes (w/ " + n + " bytes overhead/" + n5 + " sized fields)" : " bytes";
            object2 = (String)object2 + " <" + (n3 + n) + ">";
            if (string == null) {
                this.logDetail("<== " + string3 + " " + n2 + (String)object2);
            } else {
                this.logDetail("<== [" + string + "] " + string3 + " " + n2 + (String)object2);
            }
        }
        this.accumRollupSize(object, n3);
        this.countInstanceSize(object, clazz, n3);
        if (this.doRollup(object)) {
            this.totalRollup += n3;
            ++this.totalNumRollup;
        }
        return n2;
    }

    private int numOfCollItems(Object object) {
        int n = 0;
        if (object instanceof Map) {
            n = ((Map)object).size();
        } else if (object instanceof Vector) {
            n = ((Vector)object).size();
        } else if (object instanceof Collection) {
            n = ((Collection)object).size();
        }
        return n;
    }

    protected boolean doConsiderField(Field field) {
        int n = field.getModifiers();
        return (n & 8) == 0;
    }

    protected final int countConsidered(Field[] fieldArray) {
        int n = 0;
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!this.doConsiderField(field)) continue;
            ++n;
        }
        return n;
    }

    protected final int sizeofItem(Object object, String string, Class clazz) {
        int n = 0;
        if (object == null) {
            return this.refSize;
        }
        ++this.level;
        n = AbstractObjectSizer.isPrimitive(clazz) ? this.sizeofPrim(clazz, string) : this.refSize + this.sizeof(object, string);
        --this.level;
        return n;
    }

    protected final boolean doRollup(Object object) {
        return this.doRollup(object, object.getClass());
    }

    protected final boolean doRollup(Object object, Class clazz) {
        return this.doRollup(this.getAncestor(), object, clazz);
    }

    protected boolean doRollup(Object object, Object object2, Class clazz) {
        Class clazz2;
        Class clazz3 = clazz2 = object2 != null ? object2.getClass() : clazz;
        if (object2 == null || object == null) {
            return false;
        }
        if (this.rollups != null) {
            Boolean bl = (Boolean)this.rollups.get(object2);
            if (bl != null) {
                return bl;
            }
            bl = (Boolean)this.rollups.get(object);
            if (bl != null && bl.booleanValue()) {
                Class clazz4 = clazz2;
                if (clazz4.isArray()) {
                    clazz4 = AbstractObjectSizer.getUltimateComponentType(clazz4);
                }
                if (AbstractObjectSizer.isJavaUtilComponent(clazz4) && !AbstractObjectSizer.isCollectionOrMap(clazz4)) {
                    return this.cacheRollup(object2, true);
                }
            }
        }
        boolean bl = AbstractObjectSizer.isPrimitive(clazz2) || AbstractObjectSizer.isPrimitiveWrapper(object2) || AbstractObjectSizer.isPrimitiveArray(object2) || AbstractObjectSizer.isCollectionOrMap(object2) || clazz2.equals(Object.class) || AbstractObjectSizer.isObjectArray(clazz2) || clazz2.equals(String.class);
        return this.cacheRollup(object2, bl);
    }

    private boolean cacheRollup(Object object, boolean bl) {
        if (object != null) {
            if (this.rollups == null) {
                this.rollups = new IdentityHashMap();
            }
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.rollups.put(object, bl2);
        }
        return bl;
    }

    protected final Integer _getRollupSize(Object object) {
        Integer n;
        if (object == null) {
            n = null;
        } else {
            n = this.rollupSizes != null ? (Integer)this.rollupSizes.get(object) : null;
            if (n == null && this.instSizes != null) {
                n = (Integer)this.instSizes.get(object);
            }
        }
        return n;
    }

    protected final int getRollupSize(Object object) {
        Integer n = this._getRollupSize(object);
        return n == null ? 0 : n;
    }

    protected final void accumRollupSize(Object object, int n) {
        Integer n2;
        if (n == 0) {
            return;
        }
        if (this.rollupSizes == null) {
            this.rollupSizes = new IdentityHashMap();
        }
        int n3 = (n2 = (Integer)this.rollupSizes.get(object)) != null ? n2 : 0;
        this.rollupSizes.put(object, new Integer(n3 += n));
    }

    protected final void reportRollupTree() {
        if (this.rollups == null) {
            return;
        }
        Iterator iterator = this.rollups.keySet().iterator();
        this.log("");
        this.log("ROLLED-UP OBJ SIZING:");
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Boolean bl = (Boolean)this.rollups.get(k);
            if (bl != null && bl.booleanValue()) continue;
            this.log("  aggr. obj \"" + k + "\" size: " + this.getRollupSize(k));
        }
    }

    protected static final boolean isCollectionOrMap(Object object) {
        return object instanceof Collection || object instanceof Map || object instanceof Vector;
    }

    protected static final boolean isCollectionOrMap(Class clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Vector.class.isAssignableFrom(clazz);
    }

    protected static final boolean isJavaUtilComponent(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Class) {
            return AbstractObjectSizer.isJavaUtilComponent((Class)object);
        }
        return AbstractObjectSizer.isJavaUtilComponent(object.getClass());
    }

    protected static final boolean isJavaUtilComponent(Class clazz) {
        String string = clazz.getName();
        boolean bl = string.startsWith("java.util.");
        return bl;
    }

    protected static final boolean isPrimitiveArray(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Class) {
            return AbstractObjectSizer.isPrimitiveArray((Class)object);
        }
        return AbstractObjectSizer.isPrimitiveArray(object.getClass());
    }

    protected static final boolean isObjectArray(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Class) {
            return AbstractObjectSizer.isObjectArray((Class)object);
        }
        return AbstractObjectSizer.isObjectArray(object.getClass());
    }

    protected static final boolean isPrimitiveArray(Class clazz) {
        boolean bl = false;
        if (clazz != null && clazz.isArray()) {
            Class clazz2 = AbstractObjectSizer.getUltimateComponentType(clazz);
            bl = AbstractObjectSizer.isPrimitive(clazz2);
        }
        return bl;
    }

    protected static final boolean isObjectArray(Class clazz) {
        boolean bl = false;
        if (clazz != null && clazz.isArray()) {
            Class clazz2 = AbstractObjectSizer.getUltimateComponentType(clazz);
            bl = clazz2.equals(Object.class);
        }
        return bl;
    }

    protected static final Class getUltimateComponentType(Class clazz) {
        Class<?> clazz2;
        Class<?> clazz3 = clazz2 = clazz.getComponentType();
        while (clazz2.isArray()) {
            clazz3 = clazz2;
            clazz2 = clazz2.getComponentType();
        }
        return clazz3;
    }

    protected static final boolean isPrimitiveWrapper(Object object) {
        return object instanceof Number || object instanceof Character || object instanceof Boolean;
    }

    protected static final boolean isPrimitive(Object object) {
        return object == null ? false : (object instanceof Class ? AbstractObjectSizer.isPrimitive((Class)object) : AbstractObjectSizer.isPrimitive(object.getClass()));
    }

    protected static final boolean isPrimitive(Class clazz) {
        boolean bl = clazz.equals(Byte.TYPE) || clazz.equals(Boolean.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Character.TYPE) || clazz.equals(Integer.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Double.TYPE);
        return bl;
    }

    protected final int sizeofObjPrim(Object object) {
        int n = 0;
        Class<?> clazz = object.getClass();
        n = clazz.equals(Byte.class) ? (n += 16) : (clazz.equals(Boolean.class) ? (n += 16) : (clazz.equals(Short.class) ? (n += 16) : (clazz.equals(Character.class) ? (n += 16) : (clazz.equals(Integer.class) ? (n += 16) : (clazz.equals(Float.class) ? (n += 16) : (clazz.equals(Long.class) ? (n += 16) : (clazz.equals(Double.class) ? (n += 16) : (clazz.equals(BigDecimal.class) ? (n += 16) : (clazz.equals(BigInteger.class) ? (n += 40) : (n += this.sizeofUnknown(clazz)))))))))));
        return n;
    }

    protected final int sizeofPrim(Class clazz, String string) {
        int n = this.sizeofPrim(clazz);
        String string2 = clazz.getName();
        if (this.doLogDetail) {
            if (string == null) {
                this.logDetail("  " + string2 + " " + n + " bytes");
            } else if (string2 != null) {
                this.logDetail("  <" + string + "> " + string2 + " " + n + " bytes");
            }
        }
        return n;
    }

    protected final int sizeofPrim(Class clazz) {
        int n = 0;
        n = clazz.equals(Byte.TYPE) ? 1 : (clazz.equals(Boolean.TYPE) ? 1 : (clazz.equals(Short.TYPE) ? 2 : (clazz.equals(Character.TYPE) ? 2 : (clazz.equals(Integer.TYPE) ? 4 : (clazz.equals(Float.TYPE) ? 4 : (clazz.equals(Long.TYPE) ? 8 : (clazz.equals(Double.TYPE) ? 8 : 0)))))));
        return n;
    }

    protected int sizeofUnknown(Class clazz) {
        this.log("unknown type: " + clazz.getName() + " encountered");
        return 0;
    }

    protected String displayFormat(Object object) {
        String string = object == null ? "null" : object.toString();
        return string;
    }

    protected abstract void log(String var1);

    protected final void log(int n) {
        this.log("" + n);
    }

    protected final void logDetail(String string) {
        if (this.doLogDetail) {
            this.log(string);
        }
    }

    protected static final Class[] superclasses(Class clazz) {
        if (clazz == null) {
            Class[] classArray = new Class[]{clazz};
            return classArray;
        }
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz; clazz2 != null && !clazz2.equals(class$java$lang$Object == null ? AbstractObjectSizer.class$("java.lang.Object") : class$java$lang$Object); clazz2 = clazz2.getSuperclass()) {
            arrayList.add(clazz2);
        }
        return arrayList.toArray(ClassArrayTemplate);
    }

    private static void attemptGarbageCollection() {
        System.gc();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length > 0 && stringArray[0].equals("-verbose")) {
            bl = true;
        }
        TestSizer testSizer = new TestSizer(bl);
        AbstractObjectSizer.attemptGarbageCollection();
        AbstractObjectSizer.attemptGarbageCollection();
        long l = AbstractObjectSizer.getUsedMemory();
        int n = 1000;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new A_AOS();
        }
        AbstractObjectSizer.attemptGarbageCollection();
        long l2 = AbstractObjectSizer.getUsedMemory();
        long l3 = Math.round((l2 - l) / (long)n);
        System.out.println("*** average size of memory used: " + l3);
        AbstractObjectSizer.attemptGarbageCollection();
        AbstractObjectSizer.attemptGarbageCollection();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = null;
        }
        objectArray = null;
        AbstractObjectSizer.attemptGarbageCollection();
        AbstractObjectSizer.attemptGarbageCollection();
        long l4 = AbstractObjectSizer.getUsedMemory();
        long l5 = Math.round((l2 - l4) / (long)n);
        System.out.println("*** average size of memory freed: " + l5);
        A_AOS a_AOS = new A_AOS();
        testSizer.enableLogging(false);
        int n2 = testSizer.sizeOf(a_AOS);
        testSizer.enableLogging(true);
        System.out.println("");
        System.out.println("********************************");
        System.out.println("*** size of A_AOS inst. case ***");
        System.out.println("********************************");
        n2 = testSizer.sizeOf(a_AOS);
        System.out.println("");
        System.out.println("*** size of " + a_AOS.getClass().getName() + ":  " + n2);
        testSizer.cleanupState();
        O_AOS o_AOS = new O_AOS();
        System.out.println("");
        System.out.println("********************************");
        System.out.println("*** size of O_AOS inst. case ***");
        System.out.println("********************************");
        n2 = testSizer.sizeOf(o_AOS);
        System.out.println("");
        System.out.println("*** size of complex rollup " + o_AOS.getClass().getName() + ": " + n2);
        testSizer.cleanupState();
    }
}

