/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.KDebug;
import cerent.util.Preferences;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public abstract class UObservable
extends Observable
implements IObservable {
    private boolean changed = false;
    private Set observers = Collections.synchronizedSet(new HashSet());
    private static final KDebug db = new KDebug("UObservable");
    private static final KDebug memLeaks = new UObservableMemoryLeaks("UObservableMemoryLeaks");
    private static final ReferenceQueue leaks = new ReferenceQueue();

    public void addObserver(Observer observer) {
        this.preamble(observer, "addObserver");
        if (observer != null) {
            this.observers.add(new WeakObserverHolder(observer, this.getClass(), leaks));
        }
        this.postscript("addObserver");
    }

    public void addObserver(IObserver iObserver) {
        this.preamble(iObserver, "addObserver");
        if (iObserver != null) {
            this.observers.add(new WeakObserverHolder(iObserver, this.getClass(), leaks));
        }
        this.postscript("addObserver");
    }

    public static final void addObserver(Object object, Object object2, String string) {
        String string2;
        String string3 = string2 = string == null ? "unknown" : string;
        if (object instanceof IObservable && object2 instanceof IObserver) {
            ((IObservable)object).addObserver((IObserver)object2);
        } else if (object instanceof Observable && object2 instanceof Observer) {
            ((Observable)object).addObserver((Observer)object2);
        } else {
            throw new IllegalArgumentException(string2 + " observer: " + (object2 == null ? "null" : object2.getClass().getName()) + " must be of type: IObserver or Observer; observable: " + (object == null ? "null" : object.getClass().getName()) + " must be of type: IObservable or Observable");
        }
    }

    public void deleteObserver(Observer observer) {
        this.preamble(observer, "deleteObserver");
        if (observer != null) {
            this.observers.remove(new WeakObserverHolder(observer, this.getClass(), leaks));
        }
        this.postscript("deleteObserver");
    }

    public void deleteObserver(IObserver iObserver) {
        this.preamble(iObserver, "deleteObserver");
        if (iObserver != null) {
            this.observers.remove(new WeakObserverHolder(iObserver, this.getClass(), leaks));
        }
        this.postscript("deleteObserver");
    }

    public static final void deleteObserver(Object object, Object object2, String string) {
        String string2;
        String string3 = string2 = string == null ? "unknown" : string;
        if (object instanceof IObservable && object2 instanceof IObserver) {
            ((IObservable)object).deleteObserver((IObserver)object2);
        } else if (object instanceof Observable && object2 instanceof Observer) {
            ((Observable)object).deleteObserver((Observer)object2);
        } else {
            throw new IllegalArgumentException(string2 + " observer: " + (object2 == null ? "null" : object2.getClass().getName()) + " must be of type: IObserver or Observer; observable: " + (object == null ? "null" : object.getClass().getName()) + " must be of type: IObservable or Observable");
        }
    }

    public void notifyObservers() {
        this.preamble(null, "notifyObservers()");
        this.notifyObservers(null);
        this.postscript("notifyObservers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object object) {
        this.preamble(object, "notifyObservers(Object)");
        if (!this.changed) {
            return;
        }
        this.changed = false;
        ArrayList<WeakObserverHolder> arrayList = new ArrayList<WeakObserverHolder>();
        Iterator iterator = null;
        WeakObserverHolder weakObserverHolder = null;
        Set set = this.observers;
        synchronized (set) {
            iterator = this.observers.iterator();
            while (iterator.hasNext()) {
                weakObserverHolder = (WeakObserverHolder)iterator.next();
                if (weakObserverHolder.get() == null) {
                    iterator.remove();
                    continue;
                }
                arrayList.add(weakObserverHolder);
            }
        }
        iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            weakObserverHolder = (WeakObserverHolder)iterator.next();
            if (weakObserverHolder instanceof Observer) {
                this.sendUpdate(weakObserverHolder, object, ++n);
                continue;
            }
            this.sendUpdate(weakObserverHolder, object, ++n);
        }
        this.postscript("notifyObservers");
    }

    protected void sendUpdate(Object object, Object object2, int n) {
        try {
            Object object3 = this.getObservable();
            if (object instanceof Observer && object3 instanceof Observable) {
                ((Observer)object).update((Observable)object3, object2);
            } else if (object instanceof IObserver && object3 instanceof IObservable) {
                ((IObserver)object).update((IObservable)object3, object2);
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable, object, object2);
        }
    }

    protected Object getObservable() {
        return this;
    }

    protected void sendUpdate(Observer observer, Object object, int n) {
        this.sendUpdate((Object)observer, object, n);
    }

    public void deleteObservers() {
        this.preamble(null, "deleteObservers");
        this.observers.clear();
        this.postscript("deleteObservers");
    }

    public void setChanged() {
        this.preamble(null, "setChanged");
        this.changed = true;
        this.postscript("setChanged");
    }

    public void changed() {
        this.setChanged();
    }

    public void clearChanged() {
        this.preamble(null, "clearChanged");
        this.changed = false;
        this.postscript("clearChanged");
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public int countObservers() {
        return this.observers.size();
    }

    protected void handleException(Throwable throwable, Object object, Object object2) {
        block2: {
            db.println("Throwable Exception in UObservable::notifyObservers " + throwable);
            try {
                db.println("Observable  : " + this);
                db.println("(I)Observer : " + object);
                db.println("Object (arg): " + object2);
            }
            catch (Throwable throwable2) {
                db.println("Throwable/Exception in handleException :" + throwable2);
                if (!db.on()) break block2;
                KDebug.printStackTrace((Throwable)throwable2);
            }
        }
        KDebug.printStackTrace((Throwable)throwable);
    }

    private void preamble(Object object, String string) {
        if (db.on()) {
            String string2;
            try {
                string2 = object == null ? "" : " arg=" + object + ";";
            }
            catch (Exception exception) {
                db.println("UObservable." + string + "() failed to convert a " + object.getClass().getName() + " to a string: " + exception);
                string2 = "";
            }
            db.println(string + " this=" + this + "(" + this.getClass().getName() + ");" + string2 + " size=" + this.observers.size() + "; changed=" + this.changed);
        }
    }

    private void postscript(String string) {
    }

    public Collection getObservers() {
        return this.observers;
    }

    public void printObservers() {
        Iterator iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            db.println(iterator.next().toString());
        }
    }

    public void printStackTrace(Exception exception) {
        KDebug.printStackTrace((Throwable)exception);
    }

    protected String getRealObserverClassName(Observer observer) {
        return this.getRealObserverClassName((Object)observer);
    }

    protected String getRealObserverClassName(Object object) {
        if (object instanceof WeakObserverHolder) {
            return ((WeakObserverHolder)object).getReferentClass().getName();
        }
        return "WeakObserverHolder";
    }

    public static class UObservableMemoryLeaks
    extends KDebug {
        public static final String HaboutUObservableMemoryLeaks = "A no op...this debug key can assist in locating observers that neglect to unregister themselves from those they observe.  Although UObservable.java now uses weak references and a memory leak will no longer result, it is still possible for disposed objects to receive updates if the garbage collector has not reclaimed the object (so try and be tidy!).";
        private static final String PREF_PATH = "ctc";
        private static final String PREF_EXC_SYSOUT = "memoryleaks.stacktrace";
        static FindLeaks leaks;
        static boolean gatherStackTrace;
        public static final String HstartUObservableMemoryLeakThread = "This command will spin off a thread which checks the reference queue for untidy observers and, if UObservableMemoryLeaks is set, prints the results. The reference queue may be populated when the garbage collector is run.";
        public static final String HstopUObservableMemoryLeakThread = "stops the the thread which checks the reference queue. It is possible for one more leak to print before the thread truly dies.";
        public static final String HrequestGarbageCollection = "Ask the JVM to please run the garbage collector.";
        public static final String HdeactivateStackTrace = "Stop printing out stack trace information.";
        public static final String HactivateStackTrace = "If ctc.memoryleaks.stacktrace=true then, if invoked, the stack trace informationshowing where the observer registered to observe the UObservable will be displayed.By default stack trace information will not be shown.";

        public final void aboutUObservableMemoryLeaks() {
        }

        public UObservableMemoryLeaks(String string) {
            super(string);
        }

        public final void startUObservableMemoryLeakThread() {
            if (leaks == null || !leaks.isAlive()) {
                leaks = new FindLeaks();
            }
        }

        public final void stopUObservableMemoryLeakThread() {
            if (leaks != null) {
                leaks.stopMe();
                leaks = null;
            }
        }

        public final void requestGarbageCollection() {
            System.gc();
        }

        public final void deactivateStackTrace() {
            FindLeaks.setStackTracePrintingState(false);
        }

        public final void activateStackTrace() {
            FindLeaks.setStackTracePrintingState(true);
        }

        static {
            gatherStackTrace = Preferences.instance().getBoolean(PREF_PATH, PREF_EXC_SYSOUT, false);
        }
    }

    private static final class FindLeaks
    extends Thread {
        private volatile boolean keepGoing = true;
        private static volatile boolean stackTrace = false;

        FindLeaks() {
            if (memLeaks.on()) {
                memLeaks.println("The leak inspector thread will start.");
            }
            this.start();
        }

        public void run() {
            WeakObserverHolder weakObserverHolder = null;
            Exception exception = null;
            while (this.keepGoing) {
                try {
                    weakObserverHolder = (WeakObserverHolder)leaks.remove();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!memLeaks.on()) continue;
                memLeaks.print("A " + weakObserverHolder.getReferentClass().getName() + " forgot to unregister!");
                memLeaks.print("  It was tied to class loader " + weakObserverHolder.getReferentClass().getClassLoader());
                memLeaks.println(".  The observable was " + weakObserverHolder.getObservableClass() + ",  on classloader " + weakObserverHolder.getObservableClass().getClassLoader());
                if (!stackTrace) continue;
                exception = weakObserverHolder.getStackTrace();
                if (exception != null) {
                    memLeaks;
                    KDebug.printStackTrace((Throwable)exception);
                    continue;
                }
                memLeaks.println("There is no stack trace information.");
            }
        }

        public static void setStackTracePrintingState(boolean bl) {
            stackTrace = bl;
        }

        public void stopMe() {
            this.keepGoing = false;
            if (memLeaks.on()) {
                memLeaks.println("Memory leak thread will stop after the next iteration.");
            }
        }
    }

    private static class WeakObserverHolder
    extends WeakReference
    implements Observer,
    IObserver {
        private Class referentClass;
        private Class observableClass;
        private Exception forStackTrace;

        WeakObserverHolder(Observer observer, Class clazz) {
            super(observer);
            if (UObservableMemoryLeaks.gatherStackTrace) {
                this.forStackTrace = new RuntimeException("This RuntimeException was created to assist in finding where the referent adds itself as an observer.");
            }
            this.referentClass = observer.getClass();
            this.observableClass = clazz;
        }

        WeakObserverHolder(IObserver iObserver, Class clazz) {
            super(iObserver);
            if (UObservableMemoryLeaks.gatherStackTrace) {
                this.forStackTrace = new RuntimeException("This RuntimeException was created to assist in finding where the referent adds itself as an observer.");
            }
            this.referentClass = iObserver.getClass();
            this.observableClass = clazz;
        }

        WeakObserverHolder(Observer observer, Class clazz, ReferenceQueue referenceQueue) {
            super(observer, referenceQueue);
            if (UObservableMemoryLeaks.gatherStackTrace) {
                this.forStackTrace = new RuntimeException("This RuntimeException was created to assist in finding where the referent adds itself as an observer.");
            }
            this.referentClass = observer.getClass();
            this.observableClass = clazz;
        }

        WeakObserverHolder(IObserver iObserver, Class clazz, ReferenceQueue referenceQueue) {
            super(iObserver, referenceQueue);
            if (UObservableMemoryLeaks.gatherStackTrace) {
                this.forStackTrace = new RuntimeException("This RuntimeException was created to assist in finding where the referent adds itself as an observer.");
            }
            this.referentClass = iObserver.getClass();
            this.observableClass = clazz;
        }

        Class getReferentClass() {
            return this.referentClass;
        }

        Class getObservableClass() {
            return this.observableClass;
        }

        Exception getStackTrace() {
            return this.forStackTrace;
        }

        public void update(Observable observable, Object object) {
            WeakObserverHolder._update(this.get(), observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            WeakObserverHolder._update(this.get(), iObservable, object);
        }

        private static void _update(Object object, Object object2, Object object3) {
            if (object instanceof IObserver && object2 instanceof IObservable) {
                ((IObserver)object).update((IObservable)object2, object3);
            } else if (object instanceof Observer && object2 instanceof Observable) {
                ((Observer)object).update((Observable)object2, object3);
            }
        }

        public int hashCode() {
            Object t = this.get();
            if (t != null) {
                return t.hashCode();
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object instanceof WeakObserverHolder) {
                Object t = this.get();
                Object t2 = ((Reference)object).get();
                if (t != null) {
                    return t.equals(t2);
                }
            }
            return false;
        }

        public String toString() {
            if (this.get() != null) {
                return this.get().toString();
            }
            return "NULL referent in WeakReference";
        }
    }
}

